/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.operate.webapi;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.property.ComboProp;
import kd.bos.form.operate.webapi.ApiPropConverter;
import kd.bos.form.operate.webapi.RowMapper;

class ApiComboPropConverter
extends ApiPropConverter {
    private Set<String> validValues = new HashSet<String>();
    private static final String BOS_FORM_METADATA = "bos-form-metadata";

    ApiComboPropConverter() {
    }

    @Override
    protected void execSetValue(RowMapper rowMapper, DynamicObject activeRow, Object value) {
        ArrayList<String> invalidValues = new ArrayList<String>();
        if (this.checkImportValue(value, invalidValues)) {
            super.execSetValue(rowMapper, activeRow, value);
        } else if (invalidValues.isEmpty()) {
            String errMsg = ResManager.loadKDString((String)"%1$s\u8f93\u5165\u4e86\u672a\u77e5\u7684\u679a\u4e3e\u503c\uff1a%2$s", (String)"ApiComboPropConverter_0", (String)BOS_FORM_METADATA, (Object[])new Object[0]);
            this.getContext().addErrorInfo(rowMapper.getExcelRowIndex(), String.format(errMsg, this.getProp().getDisplayName().toString(), value));
        } else {
            String errMsg = ResManager.loadKDString((String)"%1$s\u8f93\u5165\u4e86\u672a\u77e5\u7684\u679a\u4e3e\u503c\uff1a%2$s", (String)"ApiComboPropConverter_0", (String)BOS_FORM_METADATA, (Object[])new Object[0]);
            this.getContext().addErrorInfo(rowMapper.getExcelRowIndex(), String.format(errMsg, this.getProp().getDisplayName().toString(), StringUtils.join((Object[])invalidValues.toArray(), (String)",")));
        }
    }

    private boolean checkImportValue(Object value, List<String> invalidValues) {
        String[] itemValues;
        if (StringUtils.isBlank((Object)value)) {
            return true;
        }
        ComboProp comboProp = (ComboProp)this.getProp();
        if (comboProp.isEditable()) {
            return true;
        }
        if (comboProp.isEmptyItems()) {
            return true;
        }
        for (String itemValue : itemValues = value.toString().split(",")) {
            if (StringUtils.isBlank((CharSequence)itemValue) || this.validValues.contains(itemValue)) continue;
            if (comboProp.isExistItem(itemValue)) {
                this.validValues.add(itemValue);
                continue;
            }
            invalidValues.add(itemValue);
        }
        return invalidValues.isEmpty();
    }
}

