/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.operate.webapi;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.ISimpleProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityType;
import kd.bos.entity.EntryType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.property.SubEntryProp;
import kd.bos.form.operate.webapi.ApiPropConvertItem;
import kd.bos.form.operate.webapi.ApiPropConvertSeq;
import kd.bos.form.operate.webapi.ApiPropConverter;
import kd.bos.form.operate.webapi.EntyRowMatchStyle;
import kd.bos.form.operate.webapi.RowMapper;

class ApiEntryPropConverter
extends ApiPropConverter {
    private static final String KEY_ENTRYID = "id";
    private static final String KEY_ENTRYROWINDEX = "rk";
    private static final String BOS_FORM_METADATA = "bos-form-metadata";

    ApiEntryPropConverter() {
    }

    public EntryProp getEntryProp() {
        return (EntryProp)super.getProp();
    }

    public EntryType getEntryType() {
        return (EntryType)this.getEntryProp().getItemType();
    }

    @Override
    public int getConvertSeq() {
        return ApiPropConvertSeq.EntryProp.getValue();
    }

    @Override
    public void setValue(RowMapper rowMapper, DynamicObject activeRow, Object value) {
        if (value == null) {
            return;
        }
        if (!this.hasFieldWriteControl()) {
            this.getContext().addErrorInfo(rowMapper.getExcelRowIndex(), String.format(ResManager.loadKDString((String)"\u201c%s\u201d\u65e0\u5b57\u6bb5\u5bfc\u5165\u6743\u9650", (String)"ApiEntryPropConverter_0", (String)BOS_FORM_METADATA, (Object[])new Object[0]), this.getProp().getDisplayName().toString()));
            return;
        }
        this.execSetValue(rowMapper, activeRow, value);
    }

    @Override
    public void beginParseValue(RowMapper rowMapper, Object value) {
        List<RowMapper> mappers = this.buildSubRowMapper(rowMapper, value);
        if (mappers == null || mappers.isEmpty()) {
            return;
        }
        for (RowMapper subRowMapper : mappers) {
            this.getContext().getModel().setEntryCurrentRowIndex(this.getProp().getName(), subRowMapper.getRowIndex());
            List<ApiPropConvertItem> fieldItems = this.getContext().sortPropConverters((EntityType)this.getEntryType(), subRowMapper.getSourceObj());
            for (ApiPropConvertItem fieldItem : fieldItems) {
                fieldItem.getPropConverter().beginParseValue(subRowMapper, fieldItem.getValue());
            }
        }
    }

    @Override
    protected void execSetValue(RowMapper rowMapper, DynamicObject activeRow, Object value) {
        List<RowMapper> mappers = this.buildSubRowMapper(rowMapper, value);
        if (mappers == null || mappers.isEmpty()) {
            return;
        }
        for (RowMapper subRowMapper : mappers) {
            this.getContext().getModel().setEntryCurrentRowIndex(this.getProp().getName(), subRowMapper.getRowIndex());
            List<ApiPropConvertItem> fieldItems = this.getContext().sortPropConverters((EntityType)this.getEntryType(), subRowMapper.getSourceObj());
            for (ApiPropConvertItem fieldItem : fieldItems) {
                fieldItem.getPropConverter().setValue(subRowMapper, subRowMapper.getTargetObj(), fieldItem.getValue());
            }
        }
    }

    private List<RowMapper> buildSubRowMapper(RowMapper rowMapper, Object value) {
        List<Object> mappers = new ArrayList();
        List sourceRows = (List)value;
        EntryType entity = this.getEntryType();
        mappers = !this.getContext().isModify() || this.getContext().getEntyRowMatchStyle() == EntyRowMatchStyle.Postion ? this.getEntryRowMapByPostion(entity, sourceRows, rowMapper) : (this.getContext().getEntyRowMatchStyle() == EntyRowMatchStyle.PrimaryKey ? this.getEntryRowMapByPrimaryKey(entity, sourceRows, rowMapper) : (this.getContext().getEntyRowMatchStyle() == EntyRowMatchStyle.NewPostion ? this.getEntryRowMapByListPostion(entity, sourceRows, rowMapper) : this.getEntryRowMapBySeq(entity, sourceRows, rowMapper)));
        return mappers;
    }

    private List<RowMapper> getEntryRowMapByPrimaryKey(EntryType entity, List<Map<String, Object>> sourceRows, RowMapper parent) {
        boolean isNullParentPk;
        IDataModel model = this.getContext().getModel();
        model.setEntryCurrentRowIndex(parent.getTargetObj().getDataEntityType().getName(), parent.getRowIndex());
        DynamicObjectCollection targetRows = model.getEntryEntity(entity.getName());
        HashMap<String, DynamicObject> entryRows = new HashMap<String, DynamicObject>();
        HashMap<String, Integer> entryRowIndex = new HashMap<String, Integer>();
        Object parentPk = parent.getTargetObj().getPkValue();
        boolean bl = parentPk instanceof Long ? Long.compare(0L, (Long)parentPk) == 0 : (isNullParentPk = StringUtils.isBlank((Object)parentPk));
        if (!isNullParentPk) {
            DynamicObject row = null;
            int size = targetRows.size();
            for (int i = 0; i < size; ++i) {
                row = (DynamicObject)targetRows.get(i);
                entryRows.put(row.get(KEY_ENTRYID).toString(), row);
                entryRowIndex.put(row.get(KEY_ENTRYID).toString(), i);
            }
        }
        boolean errorOccur = false;
        ArrayList<RowMapper> mappers = new ArrayList<RowMapper>(sourceRows.size());
        ArrayList<Integer> newRowIndexes = new ArrayList<Integer>();
        HashMap<Object, Integer> pkSet = new HashMap<Object, Integer>();
        for (int i = 0; i < sourceRows.size(); ++i) {
            Map<String, Object> row = sourceRows.get(i);
            Object pk = row.get(KEY_ENTRYID);
            if (row.containsKey(KEY_ENTRYROWINDEX)) {
                int rk = (Integer)row.get(KEY_ENTRYROWINDEX);
                mappers.add(new RowMapper(row, (DynamicObject)targetRows.get(rk), parent, rk));
            } else if (StringUtils.isBlank((Object)pk) || isNullParentPk) {
                newRowIndexes.add(i);
            } else if (entryRowIndex.get(pk.toString()) == null) {
                if (parent.getSourceObj().containsKey("isCheckEntryId") && "false".equals(parent.getSourceObj().get("isCheckEntryId"))) {
                    newRowIndexes.add(i);
                } else {
                    this.addPkNotExistError(parent, entity, row, pk, i);
                    errorOccur = true;
                }
            } else {
                mappers.add(new RowMapper(sourceRows.get(i), (DynamicObject)entryRows.get(pk.toString()), parent, (Integer)entryRowIndex.get(pk.toString()) + targetRows.getStartRowIndex()));
            }
            if (!StringUtils.isNotBlank((Object)pk)) continue;
            Object r = pkSet.get(pk);
            if (r != null) {
                this.addPkRepeatError(parent, entity, row, pk, r, i);
                errorOccur = true;
            }
            pkSet.put(pk, (Integer)row.getOrDefault("rowNum", i) + 1);
        }
        if (errorOccur) {
            return null;
        }
        if (!newRowIndexes.isEmpty()) {
            if (isNullParentPk) {
                model.deleteEntryData(entity.getName());
            }
            int[] newRows = model.batchCreateNewEntryRow(entity.getName(), newRowIndexes.size());
            int targetStartRk = targetRows.size() - newRowIndexes.size();
            for (int i = 0; i < newRowIndexes.size(); ++i) {
                Map<String, Object> row = sourceRows.get((Integer)newRowIndexes.get(i));
                row.put(KEY_ENTRYROWINDEX, targetStartRk + i);
                mappers.add(new RowMapper(row, (DynamicObject)targetRows.get(targetStartRk + i), parent, newRows[i]));
            }
        }
        return mappers;
    }

    private void addPkRepeatError(RowMapper parent, EntryType entity, Map<String, Object> row, Object pk, Object r, int i) {
        if (row.containsKey("rowNum")) {
            this.getContext().addErrorInfo((Integer)row.get("rowNum"), String.format(ResManager.loadKDString((String)"\u5206\u5f55%1$s\u7684\u5185\u7801\u4e0e\u7b2c%2$s\u884c\u91cd\u590d\uff1aid=%3$s", (String)"ApiEntryPropConverter_1", (String)BOS_FORM_METADATA, (Object[])new Object[0]), entity.getDisplayName(), r, pk));
        } else {
            String msg = "";
            msg = this.getEntryProp() instanceof SubEntryProp ? String.format(ResManager.loadKDString((String)"\u5206\u5f55%1$s\u7684\u7b2c%2$s\u884c\u5b50\u5206\u5f55%3$s\u7684\u7b2c%4$s\u884c\u7684\u5185\u7801\u4e0e\u7b2c%5$s\u884c\u91cd\u590d\uff1aid=%6$s", (String)"ApiEntryPropConverter_2", (String)BOS_FORM_METADATA, (Object[])new Object[0]), entity.getParent().getDisplayName(), parent.getRowIndex(), entity.getDisplayName(), i + 1, r, pk) : String.format(ResManager.loadKDString((String)"\u5206\u5f55%1$s\u7684\u7b2c%2$s\u884c\u7684\u5185\u7801\u4e0e\u7b2c%3$s\u884c\u91cd\u590d\uff1aid=%4$s", (String)"ApiEntryPropConverter_3", (String)BOS_FORM_METADATA, (Object[])new Object[0]), entity.getDisplayName(), i + 1, r, pk);
            this.getContext().addErrorInfo(msg);
        }
    }

    private void addPkNotExistError(RowMapper parent, EntryType entity, Map<String, Object> row, Object pk, int i) {
        if (row.containsKey("rowNum")) {
            this.getContext().addErrorInfo((Integer)row.get("rowNum"), String.format(ResManager.loadKDString((String)"\u5206\u5f55%1$s\u7684\u5185\u7801\u5728\u7cfb\u7edf\u4e2d\u4e0d\u5b58\u5728\uff1aid=%2$s", (String)"ApiEntryPropConverter_5", (String)BOS_FORM_METADATA, (Object[])new Object[0]), entity.getDisplayName(), pk));
        } else {
            String msg = "";
            msg = this.getEntryProp() instanceof SubEntryProp ? String.format(ResManager.loadKDString((String)"\u5206\u5f55%1$s\u7684\u7b2c%2$s\u884c\u5b50\u5206\u5f55%3$s\u7684\u7b2c%4$s\u884c\u7684\u5185\u7801\u5728\u7cfb\u7edf\u4e2d\u4e0d\u5b58\u5728\uff1aid=%5$s", (String)"ApiEntryPropConverter_4", (String)BOS_FORM_METADATA, (Object[])new Object[0]), entity.getParent().getDisplayName(), parent.getRowIndex(), entity.getDisplayName(), i + 1, pk) : String.format(ResManager.loadKDString((String)"\u5206\u5f55%1$s\u7684\u7b2c%2$s\u884c\u7684\u5185\u7801\u5728\u7cfb\u7edf\u4e2d\u4e0d\u5b58\u5728\uff1aid=%3$s", (String)"ApiEntryPropConverter_6", (String)BOS_FORM_METADATA, (Object[])new Object[0]), entity.getDisplayName(), i + 1, pk);
            this.getContext().addErrorInfo(msg);
        }
    }

    private List<RowMapper> getEntryRowMapBySeq(EntryType entity, List<Map<String, Object>> sourceRows, RowMapper parent) {
        return this.getEntryRowMapByPrimaryKey(entity, sourceRows, parent);
    }

    private List<RowMapper> getEntryRowMapByPostion(EntryType entity, List<Map<String, Object>> sourceRows, RowMapper parent) {
        this.getContext().getModel().deleteEntryData(entity.getName());
        if (sourceRows.size() > 0) {
            this.getContext().getModel().batchCreateNewEntryRow(entity.getName(), sourceRows.size() + 1);
            this.getContext().getModel().deleteEntryRow(entity.getName(), 0);
        }
        DynamicObjectCollection targetRows = this.getContext().getModel().getEntryEntity(entity.getName());
        ArrayList<RowMapper> mappers = new ArrayList<RowMapper>(sourceRows.size());
        for (int i = 0; i < sourceRows.size(); ++i) {
            RowMapper rowMapper = new RowMapper(sourceRows.get(i), (DynamicObject)targetRows.get(i), parent, i + targetRows.getStartRowIndex());
            mappers.add(rowMapper);
        }
        return mappers;
    }

    private List<RowMapper> getEntryRowMapByListPostion(EntryType entity, List<Map<String, Object>> sourceRows, RowMapper parent) {
        DynamicObjectCollection targetRows = this.getContext().getModel().getEntryEntity(entity.getName());
        int rowCount = targetRows.size();
        int sourceCount = sourceRows.size();
        int[] rowIndex = new int[rowCount];
        int len = Math.min(sourceCount, rowCount);
        int targetIndex = 0;
        DynamicObjectCollection newTargetRows = new DynamicObjectCollection();
        ArrayList<Integer> lstDelRows = new ArrayList<Integer>();
        for (int j = 0; j < len && targetIndex < rowCount; ++j) {
            Map<String, Object> sourcerow;
            DynamicObject dy = (DynamicObject)targetRows.get(targetIndex);
            ISimpleProperty pkProp = dy.getDataEntityType().getPrimaryKey();
            if (pkProp != null && (sourcerow = sourceRows.get(j)) != null && dy.get((IDataEntityProperty)pkProp) != null) {
                if (!sourcerow.containsKey(pkProp.getName())) {
                    Object pkValue = dy.get((IDataEntityProperty)pkProp);
                    sourcerow.put(pkProp.getName(), pkValue);
                    this.getContext().getModel().deleteEntryRow(entity.getName(), targetIndex);
                    this.getContext().getModel().insertEntryRow(entity.getName(), targetIndex);
                } else {
                    List lstdTarget = targetRows.stream().filter(tRow -> tRow.get(pkProp.getName()).toString().equals(sourcerow.get(pkProp.getName()).toString())).collect(Collectors.toList());
                    if (!lstdTarget.isEmpty()) {
                        targetIndex = ((DynamicObject)lstdTarget.get(0)).getInt("seq") - 1;
                        ((DynamicObject)targetRows.get(targetIndex)).set(pkProp.getName(), sourcerow.get(pkProp.getName()));
                        ((DynamicObject)targetRows.get(targetIndex)).set("seq", (Object)(j + 1));
                    } else {
                        targetIndex = rowCount;
                    }
                }
                if (targetIndex < rowCount) {
                    newTargetRows.add(targetRows.get(targetIndex));
                }
            }
            if (j > 0) {
                if (targetIndex != rowIndex[j - 1] + 1) {
                    lstDelRows.addAll(lstDelRows.size(), this.getDeleteRow(rowIndex[j - 1] + 1, targetIndex));
                }
            } else if (targetIndex > 0) {
                lstDelRows.addAll(this.getDeleteRow(0, targetIndex));
            }
            rowIndex[j] = targetIndex++;
        }
        if (!lstDelRows.isEmpty()) {
            this.getContext().getModel().deleteEntryRows(entity.getName(), lstDelRows.stream().mapToInt(i -> i).toArray());
        }
        int curRows = this.getContext().getModel().getEntryRowCount(entity.getName());
        if (sourceRows.size() < curRows) {
            int[] delRows = this.getDeleteRow(sourceRows.size(), curRows).stream().mapToInt(i -> i).toArray();
            this.getContext().getModel().deleteEntryRows(entity.getName(), delRows);
        }
        ArrayList<RowMapper> mappers = new ArrayList<RowMapper>(sourceRows.size());
        len = Math.min(sourceRows.size(), newTargetRows.size());
        for (int i2 = 0; i2 < len; ++i2) {
            RowMapper rowMapper = new RowMapper(sourceRows.get(i2), (DynamicObject)newTargetRows.get(i2), parent, i2 + newTargetRows.getStartRowIndex());
            mappers.add(rowMapper);
        }
        if (sourceRows.size() > newTargetRows.size()) {
            if (sourceRows.size() > this.getContext().getModel().getEntryRowCount(entity.getName())) {
                this.getContext().getModel().batchCreateNewEntryRow(entity.getName(), sourceRows.size() - this.getContext().getModel().getEntryRowCount(entity.getName()));
            }
            DynamicObjectCollection targetRows1 = this.getContext().getModel().getEntryEntity(entity.getName());
            for (int i3 = len; i3 < sourceRows.size(); ++i3) {
                Map<String, Object> row = sourceRows.get(i3);
                row.put(KEY_ENTRYROWINDEX, i3);
                mappers.add(new RowMapper(sourceRows.get(i3), (DynamicObject)targetRows1.get(i3), parent, i3 + targetRows1.getStartRowIndex()));
            }
        }
        return mappers;
    }

    private List<Integer> getDeleteRow(int beginIndex, int endIndex) {
        ArrayList<Integer> lst = new ArrayList<Integer>();
        IntStream.range(beginIndex, endIndex).forEach(lst::add);
        return lst;
    }
}

