/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.operate.webapi;

import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BasedataEntityType;
import kd.bos.exception.KDBizException;
import kd.bos.form.operate.webapi.ApiOrgPropConverter;
import kd.bos.form.operate.webapi.ApiPropConvertSeq;
import kd.bos.form.operate.webapi.RowMapper;
import kd.bos.permission.api.HasPermDimObjResult;

class ApiMainOrgPropConverter
extends ApiOrgPropConverter {
    private static final String BOS_FORM_METADATA = "bos-form-metadata";

    ApiMainOrgPropConverter() {
    }

    @Override
    public int getConvertSeq() {
        return ApiPropConvertSeq.MainOrgProp.getValue();
    }

    @Override
    public void beginParseValue(RowMapper rowMapper, Object value) {
        List orgs;
        boolean valueExist = true;
        if (value == null) {
            valueExist = false;
        } else if (value instanceof Map) {
            Map valueMap = (Map)value;
            String importprop = (String)valueMap.get("importprop");
            if (StringUtils.isBlank((CharSequence)importprop)) {
                importprop = valueMap.containsKey("number") ? "number" : "name";
                BasedataEntityType refPropType = (BasedataEntityType)this.getBasedataProp().getComplexType();
                importprop = this.convertDefaultImportProp(refPropType, importprop);
            }
            if (!valueMap.containsKey("id") && StringUtils.isBlank(valueMap.get(importprop))) {
                valueExist = false;
            }
        }
        if (!valueExist) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"%s\u4e0d\u5141\u8bb8\u4e3a\u7a7a", (String)"ApiMainOrgPropConverter_0", (String)BOS_FORM_METADATA, (Object[])new Object[0]), this.getPropDisplayName()));
        }
        super.beginParseValue(rowMapper, value);
        Map mainOrgVal = (Map)value;
        Long mainOrgId = 0L;
        if (mainOrgVal != null && mainOrgVal.containsKey("id")) {
            Object id = mainOrgVal.get("id");
            if (id instanceof Long) {
                mainOrgId = (Long)id;
            } else if (id != null) {
                mainOrgId = Long.valueOf(id.toString());
            }
        }
        this.getContext().setMainOrgId(mainOrgId);
        HasPermDimObjResult hasPermResult = this.getContext().getHasPermResult();
        if (mainOrgId != 0L && !hasPermResult.hasAllDimObjPerm() && !(orgs = hasPermResult.getHasPermDimObjs()).contains(mainOrgId)) {
            LocaleString disp = this.getProp().getDisplayName();
            String inputVal = (String)mainOrgVal.get(mainOrgVal.getOrDefault("importprop", "number"));
            String errmsg = String.format(ResManager.loadKDString((String)"%1$s\u7f16\u7801\uff1a%2$s\uff0c\u5f53\u524d\u7528\u6237\u6ca1\u6709\u8be5\u7ec4\u7ec7\u7684\u4f7f\u7528\u6743\u9650\uff0c\u8bf7\u68c0\u67e5\u6570\u636e\uff0c\u6216\u8054\u7cfb\u7ba1\u7406\u5458\u6388\u6743\u3002", (String)"ApiMainOrgPropConverter_1", (String)BOS_FORM_METADATA, (Object[])new Object[0]), StringUtils.isNotBlank((Object)disp) ? disp.toString() : this.getProp().getName(), inputVal);
            this.getContext().addErrorInfo(rowMapper.getExcelRowIndex(), errmsg);
        }
    }
}

