/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.operate.webapi;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.FlexEntityType;
import kd.bos.entity.flex.FlexEntityMetaUtils;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.FlexProp;
import kd.bos.flex.FlexService;
import kd.bos.form.operate.webapi.FlexPropInfo;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public class FlexEntityTypeReader {
    private static Log log = LogFactory.getLog(FlexEntityTypeReader.class);
    private Map<FlexPropInfo, FlexEntityType> flexTypes = new LinkedHashMap<FlexPropInfo, FlexEntityType>(1000, 0.75f, true){
        private static final long serialVersionUID = 1L;

        @Override
        protected boolean removeEldestEntry(Map.Entry<FlexPropInfo, FlexEntityType> pEldest) {
            return this.size() > 2000;
        }

        @Override
        public boolean containsKey(Object key) {
            this.get(key);
            return super.containsKey(key);
        }
    };
    private String billEntityNumber;

    public FlexEntityTypeReader(String billEntityNumber) {
        this.billEntityNumber = billEntityNumber;
    }

    public FlexEntityType read(FlexProp flexProp, BasedataProp refBaseProp, DynamicObject refBaseObj) {
        FlexPropInfo item = new FlexPropInfo(flexProp.getName(), refBaseProp.getName(), refBaseObj.getPkValue());
        if (this.flexTypes.containsKey(item)) {
            log.info("----flexEntityTypeReader.read--use cache-- flexTypes.containsKey(" + flexProp.getName() + ", " + refBaseProp.getName() + ", " + refBaseObj.getPkValue() + ")--");
            return this.flexTypes.get(item);
        }
        Object baseId = refBaseObj.getPkValue();
        BasedataEntityType baseEntityType = (BasedataEntityType)refBaseProp.getComplexType();
        String relateBDEntityNumber = baseEntityType.getName();
        String relateBDFlexPropertyKey = baseEntityType.getFlexProperty();
        if (StringUtils.isBlank((CharSequence)relateBDFlexPropertyKey) && baseEntityType.getMasteridType() == 2) {
            BasedataProp masterProp = (BasedataProp)baseEntityType.getProperty(baseEntityType.getMasteridPropName());
            relateBDFlexPropertyKey = ((BasedataEntityType)masterProp.getComplexType()).getFlexProperty();
            relateBDEntityNumber = masterProp.getBaseEntityId();
            DynamicObject refBDMasterVal = refBaseObj.getDynamicObject(baseEntityType.getMasteridPropName());
            if (refBDMasterVal != null) {
                baseId = refBDMasterVal.getPkValue();
            }
        }
        List flexPropertyIds = FlexService.getBaseUseFlexProperties((String)relateBDEntityNumber, (Object)baseId, (String)relateBDFlexPropertyKey, (boolean)false);
        log.info("----FlexService.getBaseUseFlexProperties(" + relateBDEntityNumber + ", " + baseId + ", " + relateBDFlexPropertyKey + ", true)--" + flexPropertyIds);
        FlexEntityType flexEntityType = FlexEntityMetaUtils.getBasedataPropFlexEntityType((String)this.billEntityNumber, (String)flexProp.getName(), (int)flexProp.getFlexTypeId(), (List)flexPropertyIds);
        if (flexEntityType != null && flexEntityType.getFlexProperties().size() != flexPropertyIds.size()) {
            log.info(String.format(ResManager.loadKDString((String)"----FlexEntityMetaUtils.getBasedataPropFlexEntityType(%1$s, %2$s, %3$s, flexPropertyIds)----\u6839\u636eflexPropertyIds\u6784\u9020\u7684FlexEntityType\u7684\u7ef4\u5ea6\u4e0d\u4e00\u81f4", (String)"FlexEntityTypeReader_0", (String)"bos-form-metadata", (Object[])new Object[0]), this.billEntityNumber, flexProp.getName(), flexProp.getFlexTypeId()));
        }
        this.flexTypes.put(item, flexEntityType);
        return flexEntityType;
    }

    public Map<Object, FlexEntityType> read(FlexProp flexProp, BasedataProp refBaseProp, DynamicObject[] refBaseObjs) {
        boolean isMaster;
        HashMap<Object, FlexEntityType> basedataFlexEntityTypes = new HashMap<Object, FlexEntityType>(refBaseObjs.length);
        HashMap<Object, DynamicObject> tempBaseObjects = new HashMap<Object, DynamicObject>();
        for (DynamicObject refBaseObj : refBaseObjs) {
            if (refBaseObj == null) continue;
            Object pk = refBaseObj.getPkValue();
            FlexPropInfo item = new FlexPropInfo(flexProp.getName(), refBaseProp.getName(), pk);
            if (this.flexTypes.containsKey(item)) {
                FlexEntityType fet = this.flexTypes.get(item);
                basedataFlexEntityTypes.put(pk, fet);
                continue;
            }
            tempBaseObjects.put(pk, refBaseObj);
        }
        BasedataEntityType baseEntityType = (BasedataEntityType)refBaseProp.getComplexType();
        String relateBDEntityNumber = baseEntityType.getName();
        String relateBDFlexPropertyKey = baseEntityType.getFlexProperty();
        boolean bl = isMaster = StringUtils.isBlank((CharSequence)relateBDFlexPropertyKey) && baseEntityType.getMasteridType() == 2;
        if (isMaster) {
            BasedataProp masterProp = (BasedataProp)baseEntityType.getProperty(baseEntityType.getMasteridPropName());
            relateBDFlexPropertyKey = ((BasedataEntityType)masterProp.getComplexType()).getFlexProperty();
            relateBDEntityNumber = masterProp.getBaseEntityId();
        }
        Object[] baseIds = new Object[tempBaseObjects.size()];
        int idx = 0;
        for (Map.Entry entry : tempBaseObjects.entrySet()) {
            baseIds[idx++] = this.getBaseObjectId((DynamicObject)entry.getValue(), baseEntityType, isMaster);
        }
        Map flexPropertyIds = baseIds.length > 0 ? FlexService.getBaseUseFlexProperties((String)relateBDEntityNumber, (String)relateBDFlexPropertyKey, (Object[])baseIds) : new HashMap();
        for (Map.Entry entry : tempBaseObjects.entrySet()) {
            Object baseId = this.getBaseObjectId((DynamicObject)entry.getValue(), baseEntityType, isMaster);
            List properties = (List)flexPropertyIds.get(this.getBaseObjectId((DynamicObject)entry.getValue(), baseEntityType, isMaster));
            FlexEntityType flexEntityType = null;
            if (properties != null && !properties.isEmpty()) {
                flexEntityType = FlexEntityMetaUtils.getBasedataPropFlexEntityType((String)this.billEntityNumber, (String)flexProp.getName(), (int)flexProp.getFlexTypeId(), (List)properties);
            }
            basedataFlexEntityTypes.put(baseId, flexEntityType);
            FlexPropInfo item = new FlexPropInfo(flexProp.getName(), refBaseProp.getName(), baseId);
            this.flexTypes.put(item, flexEntityType);
        }
        return basedataFlexEntityTypes;
    }

    public FlexEntityType read(FlexProp flexProp, BasedataProp refBaseProp, Map<String, Object> refBaseValue) {
        Object baseId = refBaseValue.get("id");
        FlexPropInfo item = new FlexPropInfo(flexProp.getName(), refBaseProp.getName(), baseId);
        if (this.flexTypes.containsKey(item)) {
            return this.flexTypes.get(item);
        }
        BasedataEntityType baseEntityType = (BasedataEntityType)refBaseProp.getComplexType();
        String relateBDEntityNumber = baseEntityType.getName();
        String relateBDFlexPropertyKey = baseEntityType.getFlexProperty();
        if (StringUtils.isBlank((CharSequence)baseEntityType.getFlexProperty()) && baseEntityType.getMasteridType() == 2) {
            BasedataProp masterProp = (BasedataProp)baseEntityType.getProperty(baseEntityType.getMasteridPropName());
            relateBDFlexPropertyKey = ((BasedataEntityType)masterProp.getComplexType()).getFlexProperty();
            relateBDEntityNumber = masterProp.getBaseEntityId();
            Map refBDMasterVal = (Map)refBaseValue.get(baseEntityType.getMasteridPropName());
            if (refBDMasterVal != null) {
                baseId = refBDMasterVal.get("id");
            }
        }
        List flexPropertyIds = FlexService.getBaseUseFlexProperties((String)relateBDEntityNumber, (Object)baseId, (String)relateBDFlexPropertyKey);
        FlexEntityType flexEntityType = FlexEntityMetaUtils.getBasedataPropFlexEntityType((String)this.billEntityNumber, (String)flexProp.getName(), (int)flexProp.getFlexTypeId(), (List)flexPropertyIds);
        this.flexTypes.put(item, flexEntityType);
        return flexEntityType;
    }

    private Object getBaseObjectId(DynamicObject dynamicObject, BasedataEntityType baseEntityType, boolean isMaster) {
        DynamicObject refBDMasterVal;
        Object baseId = dynamicObject.getPkValue();
        if (isMaster && (refBDMasterVal = dynamicObject.getDynamicObject(baseEntityType.getMasteridPropName())) != null) {
            baseId = refBDMasterVal.getPkValue();
        }
        return baseId;
    }
}

