/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.operate.webapi;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import kd.bos.data.BusinessDataReader;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.FlexEntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.BasedataItem;
import kd.bos.entity.flex.FlexEntireData;
import kd.bos.entity.property.AssistantProp;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.FlexProp;
import kd.bos.entity.property.LongProp;
import kd.bos.entity.property.MainOrgProp;
import kd.bos.entity.property.OrgProp;
import kd.bos.entity.property.TextProp;
import kd.bos.exception.KDBizException;
import kd.bos.flex.FlexService;
import kd.bos.form.operate.webapi.ApiPropConvertContext;
import kd.bos.form.operate.webapi.FlexPropCtrlStrategyTypeEnum;
import kd.bos.form.operate.webapi.FlexValueCacheKey;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.org.api.IOrgService;
import kd.bos.orm.query.QFilter;
import kd.bos.service.IAssistantDataService;
import kd.bos.service.IBaseDataService;
import kd.bos.service.ServiceFactory;

public class FlexValueReader {
    private static final String BOS_FORM_METADATA = "bos-form-metadata";
    private static Log log = LogFactory.getLog(FlexValueReader.class);
    public static final String CTRLSTRATEGY = "ctrlstrategy";
    public static final String BOS_ASSISTANTDATAGROUP = "bos_assistantdatagroup";
    public static final String CREATEORG = "createorg";
    private static final String DEFAULT_ORGFUNCID = "16";
    private ApiPropConvertContext context;
    private Map<FlexValueCacheKey, Object> cacheFlexValues = new HashMap<FlexValueCacheKey, Object>();
    private Map<FlexValueCacheKey, String> cacheFlexValueErrors = new HashMap<FlexValueCacheKey, String>();
    private Map<String, String> idsearchValue = new HashMap<String, String>();

    public FlexValueReader(ApiPropConvertContext context) {
        this.context = context;
    }

    @Deprecated
    public Object getFlexValue(BasedataProp batadataProp, FlexProp flexProp, FlexEntityType flexEntityType, Map<String, Object> flexValue) {
        return this.getFlexValue(batadataProp, flexProp, flexEntityType, flexValue, 0);
    }

    public Object getFlexValue(BasedataProp batadataProp, FlexProp flexProp, FlexEntityType flexEntityType, Map<String, Object> flexValue, Object basePk) {
        FlexValueCacheKey cacheKey = FlexValueCacheKey.create(batadataProp, flexProp, flexEntityType, flexValue, basePk);
        if (cacheKey.getFlexItems().isEmpty()) {
            return null;
        }
        if (this.cacheFlexValues.containsKey(cacheKey)) {
            JSONObject jsonData = new JSONObject();
            jsonData.put("id", this.cacheFlexValues.get(cacheKey));
            log.info("----find flexdata from cache--cacheFlexValues.containsKey(" + batadataProp.getName() + ", " + flexProp.getName() + ", " + basePk + ")");
            return jsonData;
        }
        String error = this.cacheFlexValueErrors.get(cacheKey);
        if (StringUtils.isNotBlank((CharSequence)error)) {
            throw new KDBizException(error);
        }
        log.info("kd.bos.form.operate.webapi.FlexValueReader.getFlexValue----flexdata\u7f13\u5b58\u65e0\u6548\uff01\uff01");
        DynamicObject flexObject = new DynamicObject((DynamicObjectType)flexEntityType);
        Long mainOrgId = this.context.getMainOrgId();
        for (int i = 0; i < cacheKey.getFlexItems().size(); ++i) {
            String itemPropName = cacheKey.getFlexItems().get(i);
            IDataEntityProperty flexItemProp = flexEntityType.findProperty(itemPropName);
            if (flexItemProp instanceof TextProp) {
                flexObject.set(flexItemProp, cacheKey.getFlexItemValues().get(i));
                continue;
            }
            if (!(flexItemProp instanceof BasedataProp)) continue;
            String[] fv = StringUtils.split((String)((String)cacheKey.getFlexItemValues().get(i)), (String)":=");
            if (fv == null) {
                fv = new String[]{"", ""};
            }
            if (fv != null && fv.length == 1) {
                String temp = fv[0];
                fv = new String[]{temp, ""};
            }
            BasedataProp flexItemBaseProp = (BasedataProp)flexItemProp;
            BasedataItem basedataItem = new BasedataItem(flexItemProp.getName(), flexItemBaseProp.getBaseEntityId(), (BasedataEntityType)flexItemBaseProp.getComplexType(), mainOrgId, fv[0], fv[1]);
            BasedataEntityType type = (BasedataEntityType)flexItemBaseProp.getComplexType();
            String forbidStatusKey = type.getForbidStatus();
            Object flexItemId = null;
            if ("id".equals(fv[0])) {
                flexItemId = type.getPrimaryKey() instanceof LongProp ? Long.valueOf(Long.parseLong(fv[1])) : fv[1];
            } else if (this.context.getBasePKs().containsKey(basedataItem)) {
                flexItemId = this.context.getBasePKs().get(basedataItem);
            } else {
                DynamicObject idObject;
                DynamicObject[] objectArr;
                String entityName = basedataItem.getEntityNumber();
                String selectProperties = "id";
                IBaseDataService baseDataService = (IBaseDataService)this.context.getModel().getService(IBaseDataService.class);
                ArrayList<QFilter> filters = new ArrayList<QFilter>(3);
                filters.add(new QFilter(basedataItem.getSearchKey(), "=", (Object)basedataItem.getSearchValue()));
                if (mainOrgId != null && mainOrgId != 0L) {
                    if (flexItemProp instanceof AssistantProp) {
                        AssistantProp assistantProp = (AssistantProp)flexItemProp;
                        IAssistantDataService assistantDataService = (IAssistantDataService)ServiceFactory.getService(IAssistantDataService.class);
                        QFilter filter = assistantDataService.getAssistantDataFilter(Long.valueOf(Long.parseLong(assistantProp.getAsstTypeId())), mainOrgId);
                        filters.add(filter);
                    } else {
                        filters.add(baseDataService.getBaseDataFilter(entityName, mainOrgId));
                    }
                }
                if (StringUtils.isNotBlank((CharSequence)forbidStatusKey) && !type.getProperty(forbidStatusKey).isDbIgnore()) {
                    filters.add(new QFilter(forbidStatusKey, "!=", (Object)"0"));
                }
                if (baseDataService.checkBaseDataCtrl(entityName).booleanValue()) {
                    if (mainOrgId != null && mainOrgId != 0L) {
                        QFilter filter = (QFilter)filters.get(0);
                        for (int j = 1; j < filters.size(); ++j) {
                            filter.and((QFilter)filters.get(j));
                        }
                        DynamicObjectCollection collection = baseDataService.queryBaseData(entityName, mainOrgId, filter, selectProperties);
                        IDSet idSet = new IDSet();
                        collection.forEach(dynamicObject -> idSet.add(dynamicObject.get("id")));
                        objectArr = BusinessDataReader.load((Object[])idSet.toArray(), (DynamicObjectType)FlexValueReader.getSubEntityType(entityName, selectProperties), (Boolean)true);
                    } else {
                        objectArr = this.load(entityName, selectProperties, filters.toArray(new QFilter[0]));
                    }
                } else {
                    if (flexItemProp instanceof AssistantProp) {
                        AssistantProp assistantProp = (AssistantProp)flexItemProp;
                        filters.add(new QFilter("group", "=", (Object)Long.parseLong(assistantProp.getAsstTypeId())));
                        basedataItem.setBizTag(assistantProp.getAsstTypeId());
                    }
                    objectArr = this.load(entityName, selectProperties, filters.toArray(new QFilter[0]));
                }
                if (objectArr == null || objectArr.length == 0) {
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5f39\u6027\u57df\u5c5e\u6027\u201c%1$s.%2$s\u201d\u627e\u4e0d\u5230\u542f\u7528\u7684\u6570\u636e\uff1a[%3$s]", (String)"FlexValueReader_0", (String)BOS_FORM_METADATA, (Object[])new Object[0]), flexProp.getDisplayName(), flexItemBaseProp.getDisplayName().toString(), fv[1]));
                }
                if (objectArr.length > 1) {
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5f39\u6027\u57df\u5c5e\u6027\u201c%1$s.%2$s\u201d, \u6839\u636e%3$s=%4$s\u627e\u5230\u591a\u6761\u8bb0\u5f55", (String)"FlexValueReader_1", (String)BOS_FORM_METADATA, (Object[])new Object[0]), flexProp.getDisplayName(), flexItemBaseProp.getDisplayName().toString(), basedataItem.getSearchKey(), basedataItem.getSearchValue()));
                }
                DynamicObject dynamicObject2 = idObject = objectArr != null && objectArr.length > 0 ? objectArr[0] : null;
                if (idObject != null) {
                    flexItemId = idObject.getPkValue();
                    this.context.getBasePKs().put(basedataItem, flexItemId);
                }
            }
            if (!StringUtils.isNotBlank((Object)flexItemId)) continue;
            Map rets = BusinessDataReader.loadFromCache((Object[])new Object[]{flexItemId}, (DynamicObjectType)type);
            DynamicObject flexItemObj = (DynamicObject)rets.get(flexItemId);
            if (flexItemObj != null && (StringUtils.isBlank((CharSequence)forbidStatusKey) || !"0".equals(flexItemObj.getString(forbidStatusKey)))) {
                flexObject.set(flexItemProp, (Object)flexItemObj);
                flexObject.set(flexItemProp.getName() + "_id", flexItemObj.getPkValue());
                this.validataAssistantPropWithOrgFilter(flexItemProp, flexItemObj, flexProp, flexItemBaseProp, fv);
                continue;
            }
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5f39\u6027\u57df\u5c5e\u6027\u201c%1$s.%2$s\u201d\u6570\u636e\u4e0d\u5b58\u5728\uff1a%3$s", (String)"FlexValueReader_2", (String)BOS_FORM_METADATA, (Object[])new Object[0]), flexProp.getDisplayName(), flexItemBaseProp.getDisplayName().toString(), fv[1]));
        }
        Long flexId = FlexService.save((MainEntityType)flexEntityType, (DynamicObject)flexObject);
        this.cacheFlexValues.put(cacheKey, flexId);
        JSONObject jsonData = new JSONObject();
        jsonData.put("id", (Object)flexId);
        log.info("----no cache found, save flexdata into db--(" + batadataProp.getName() + ", " + flexProp.getName() + ", " + basePk + ")--" + jsonData);
        return jsonData;
    }

    public void getBaseValues(Map<String, Map<Object, DynamicObject>> baseObjMap, String entityName, String searchKey, QFilter[] filters) {
        String searchProperties = "id, " + searchKey;
        if ("bos_assistantdata_detail".equals(entityName)) {
            MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)entityName);
            searchProperties = searchProperties + ", " + dataEntityType.getMainOrg();
            searchProperties = searchProperties + ",ctrlstrategy ";
        }
        DynamicObject[] objectArr = this.load(entityName, searchProperties, filters);
        Map<Object, DynamicObject> searchObject = baseObjMap.get(entityName);
        if (searchObject == null) {
            searchObject = new HashMap<Object, DynamicObject>(16);
            baseObjMap.put(entityName, searchObject);
        }
        for (DynamicObject obj : objectArr) {
            Object searchValue = obj.get(searchKey);
            if (searchValue instanceof OrmLocaleValue) {
                searchValue = searchValue.toString();
            }
            if (searchObject.containsKey(searchValue)) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5f39\u6027\u57df\u5c5e\u6027%1$s=%2$s\u627e\u5230\u591a\u6761\u8bb0\u5f55", (String)"FlexValueReader_3", (String)BOS_FORM_METADATA, (Object[])new Object[0]), searchKey, searchValue));
            }
            searchObject.put(searchValue, obj);
            this.idsearchValue.put(obj.getPkValue().toString(), searchValue.toString());
        }
    }

    public void getAssistBaseValues(Map<String, Map<Object, DynamicObject>> baseObjMap, String entityName, String searchKey, String asstTypeId, QFilter[] filters) {
        String searchProperties = "id, " + searchKey;
        if ("bos_assistantdata_detail".equals(entityName)) {
            MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)entityName);
            searchProperties = searchProperties + ", " + dataEntityType.getMainOrg();
            searchProperties = searchProperties + ",ctrlstrategy ";
        }
        DynamicObject[] objectArr = this.load(entityName, searchProperties, filters);
        Map<Object, DynamicObject> searchObject = baseObjMap.get(entityName);
        if (searchObject == null) {
            searchObject = new HashMap<Object, DynamicObject>(16);
            baseObjMap.put(entityName, searchObject);
        }
        for (DynamicObject obj : objectArr) {
            String searchValueKey;
            Object searchValue = obj.get(searchKey);
            if (searchValue instanceof OrmLocaleValue) {
                searchValue = searchValue.toString();
            }
            if (searchObject.containsKey(searchValueKey = String.format("%s.%s", asstTypeId, searchValue))) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5f39\u6027\u57df\u5c5e\u6027%1$s=%2$s\u627e\u5230\u591a\u6761\u8bb0\u5f55", (String)"FlexValueReader_3", (String)BOS_FORM_METADATA, (Object[])new Object[0]), searchKey, searchValueKey));
            }
            searchObject.put(searchValueKey, obj);
        }
    }

    public void getFlexValues(Map<String, Map<Object, DynamicObject>> baseObjMap, Set<FlexValueCacheKey> fvCacheKeySet) {
        Long mainOrgId = this.context.getMainOrgId();
        HashMap<FlexEntityType, ArrayList<DynamicObject>> flexObjs = new HashMap<FlexEntityType, ArrayList<DynamicObject>>(16);
        HashMap<DynamicObject, FlexValueCacheKey> cacheKeyObjMap = new HashMap<DynamicObject, FlexValueCacheKey>(16);
        for (FlexValueCacheKey flexValueCacheKey : fvCacheKeySet) {
            ArrayList<DynamicObject> list;
            if (this.cacheFlexValues.containsKey(flexValueCacheKey) || this.cacheFlexValueErrors.containsKey(flexValueCacheKey)) continue;
            FlexEntityType flexEntityType = flexValueCacheKey.getflexType();
            DynamicObject flexObject = new DynamicObject((DynamicObjectType)flexEntityType);
            StringBuilder errBuilder = new StringBuilder();
            for (int i = 0; i < flexValueCacheKey.getFlexItems().size(); ++i) {
                String itemPropName = flexValueCacheKey.getFlexItems().get(i);
                IDataEntityProperty iDataEntityProperty = flexEntityType.findProperty(itemPropName);
                if (iDataEntityProperty instanceof TextProp) {
                    if (flexObject == null) continue;
                    flexObject.set(iDataEntityProperty, flexValueCacheKey.getFlexItemValues().get(i));
                    continue;
                }
                if (!(iDataEntityProperty instanceof BasedataProp)) continue;
                String[] fv = StringUtils.split((String)((String)flexValueCacheKey.getFlexItemValues().get(i)), (String)":=");
                if (fv == null) {
                    fv = new String[]{"", ""};
                }
                if (fv != null && fv.length == 1) {
                    String temp = fv[0];
                    fv = new String[]{temp, ""};
                }
                BasedataProp flexItemBaseProp = (BasedataProp)iDataEntityProperty;
                BasedataItem basedataItem = new BasedataItem(iDataEntityProperty.getName(), flexItemBaseProp.getBaseEntityId(), (BasedataEntityType)flexItemBaseProp.getComplexType(), mainOrgId, fv[0], fv[1]);
                Object flexItemId = null;
                DynamicObject flexDataEntity = null;
                boolean hasId = "id".equals(fv[0]);
                if (hasId) {
                    BasedataEntityType type = (BasedataEntityType)flexItemBaseProp.getComplexType();
                    flexItemId = type.getPrimaryKey() instanceof LongProp ? Long.valueOf(Long.parseLong(fv[1])) : fv[1];
                    Map searchObject = baseObjMap.getOrDefault(flexItemBaseProp.getBaseEntityId(), new HashMap(1));
                    flexDataEntity = (DynamicObject)searchObject.get(flexItemId);
                } else if (this.context.getBasePKs().containsKey(basedataItem)) {
                    flexItemId = this.context.getBasePKs().get(basedataItem);
                    flexDataEntity = (DynamicObject)this.context.getBaseObjs().computeIfAbsent(basedataItem.getEntityNumber(), x -> new HashMap(1)).get(flexItemId);
                } else {
                    Map<Object, DynamicObject> searchObject = baseObjMap.get(flexItemBaseProp.getBaseEntityId());
                    String searchValueKey = basedataItem.getSearchValue();
                    if (iDataEntityProperty instanceof AssistantProp) {
                        basedataItem.setBizTag(((AssistantProp)iDataEntityProperty).getAsstTypeId());
                        searchValueKey = String.format("%s.%s", ((AssistantProp)iDataEntityProperty).getAsstTypeId(), basedataItem.getSearchValue());
                    }
                    DynamicObject obj = searchObject.get(searchValueKey);
                    String error = null;
                    if (obj == null) {
                        error = String.format(ResManager.loadKDString((String)"\u5f39\u6027\u57df\u5c5e\u6027[%1$s]\u627e\u4e0d\u5230\u542f\u7528\u7684\u6570\u636e\uff1a[%2$s]", (String)"FlexValueReader_4", (String)BOS_FORM_METADATA, (Object[])new Object[0]), flexItemBaseProp.getDisplayName().toString(), fv[1]);
                    } else {
                        error = this.validataAssistantPropWithOrgFilter(iDataEntityProperty, obj, flexItemBaseProp, fv);
                        if (StringUtils.isBlank((CharSequence)error)) {
                            error = this.checkOrgFunction(iDataEntityProperty, obj, flexItemBaseProp, fv);
                        }
                    }
                    if (StringUtils.isNotBlank((CharSequence)error)) {
                        errBuilder.append(error).append("\uff0c");
                        flexObject = null;
                        continue;
                    }
                    if (obj != null) {
                        flexItemId = obj.getPkValue();
                        flexDataEntity = obj;
                    }
                    this.context.getBasePKs().put(basedataItem, flexItemId);
                    this.context.getBaseObjs().computeIfAbsent(basedataItem.getEntityNumber(), x -> new HashMap(1)).putIfAbsent(flexItemId, flexDataEntity);
                }
                if (flexObject == null) continue;
                String key = iDataEntityProperty.getName() + "_id";
                flexObject.set(key, flexItemId);
                if (flexDataEntity == null) {
                    if (hasId) continue;
                    String errorMsg = String.format(ResManager.loadKDString((String)"\u627e\u4e0d\u5230\u5f39\u6027\u57df\u7ef4\u5ea6\u5185\u57fa\u7840\u8d44\u6599\u6570\u636e\u5305\uff0cID\u4e3a\uff1a%1$s\uff0c\u57fa\u7840\u8d44\u6599\u7c7b\u578b\u4e3a\uff1a%2$s", (String)"FlexValueReader_0", (String)"bos-import", (Object[])new Object[0]), flexItemId, flexItemBaseProp.getBaseEntityId());
                    log.warn(errorMsg);
                    continue;
                }
                flexObject.set(flexItemBaseProp.getName(), (Object)flexDataEntity);
            }
            if (errBuilder.length() > 0) {
                this.cacheFlexValueErrors.put(flexValueCacheKey, errBuilder.substring(0, errBuilder.length() - 1));
            }
            if ((list = (ArrayList<DynamicObject>)flexObjs.get(flexEntityType)) == null) {
                list = new ArrayList<DynamicObject>();
                flexObjs.put(flexEntityType, list);
            }
            if (flexObject == null) continue;
            list.add(flexObject);
            cacheKeyObjMap.put(flexObject, flexValueCacheKey);
        }
        for (Map.Entry entry : flexObjs.entrySet()) {
            FlexEntityType fet = (FlexEntityType)entry.getKey();
            List list = (List)entry.getValue();
            ArrayList<FlexEntireData> flexEntireDatas = new ArrayList<FlexEntireData>(10);
            HashMap<FlexValueCacheKey, FlexEntireData> map = new HashMap<FlexValueCacheKey, FlexEntireData>(16);
            for (DynamicObject dynamicObject : list) {
                FlexValueCacheKey fvc = (FlexValueCacheKey)cacheKeyObjMap.get(dynamicObject);
                FlexEntireData flexEntireData = new FlexEntireData();
                flexEntireData.setFlexData((MainEntityType)fet, dynamicObject);
                flexEntireDatas.add(flexEntireData);
                map.put(fvc, flexEntireData);
            }
            FlexService.batchSaveFlexData((MainEntityType)fet, flexEntireDatas);
            for (Map.Entry entry2 : map.entrySet()) {
                this.cacheFlexValues.put((FlexValueCacheKey)entry2.getKey(), ((FlexEntireData)entry2.getValue()).getId());
            }
        }
    }

    private void setFlexObjectBaseRefObj(Map<String, Map<Object, DynamicObject>> baseObjMap, DynamicObject flexObject, BasedataProp flexItemBaseProp, Object flexItemId) {
        if (!(flexItemBaseProp instanceof AssistantProp)) {
            String searchValue = this.idsearchValue.get(flexItemId.toString());
            Map searchObject = baseObjMap.getOrDefault(flexItemBaseProp.getBaseEntityId(), new HashMap());
            DynamicObject obj = (DynamicObject)searchObject.get(searchValue);
            if (obj == null) {
                String selectProperties = "id";
                DynamicObjectType type = FlexValueReader.getSubEntityType(flexItemBaseProp.getBaseEntityId(), selectProperties);
                obj = BusinessDataReader.loadSingle((Object)flexItemId, (DynamicObjectType)type, (Boolean)true);
            }
            flexObject.set(flexItemBaseProp.getName(), (Object)obj);
        }
    }

    private List<QFilter> getFilter(BasedataProp flexItemProp) {
        BasedataEntityType type = (BasedataEntityType)flexItemProp.getComplexType();
        String forbidStatusKey = type.getForbidStatus();
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        if (StringUtils.isNotBlank((CharSequence)forbidStatusKey) && !type.getProperty(forbidStatusKey).isDbIgnore()) {
            filters.add(new QFilter(forbidStatusKey, "!=", (Object)"0"));
        }
        if (flexItemProp instanceof AssistantProp) {
            AssistantProp assistantProp = (AssistantProp)flexItemProp;
            filters.add(new QFilter("group", "=", (Object)Long.parseLong(assistantProp.getAsstTypeId())));
        }
        return filters;
    }

    private boolean validateAssistantPropByOrg(IDataEntityProperty flexItemProp, DynamicObject flexItemObj, Long mainOrgId, Optional<List<Long>> mainOrgSuperiorOrgs) {
        MainEntityType flexEntityType = (MainEntityType)((AssistantProp)flexItemProp).getComplexType();
        boolean flag = true;
        String flexItemCtrlStrategy = flexItemObj.getString(CTRLSTRATEGY);
        if (StringUtils.isEmpty((CharSequence)flexItemCtrlStrategy)) {
            flexItemCtrlStrategy = FlexPropCtrlStrategyTypeEnum.CREATORORG_AND_SUBORDINATE.getType();
        }
        if (flexItemCtrlStrategy.equals(FlexPropCtrlStrategyTypeEnum.CLASSORG_AND_SUBORDINATE.getType())) {
            flag = this.validateAssitantPropByOrgForCLassOrg((AssistantProp)flexItemProp, mainOrgId, mainOrgSuperiorOrgs);
        }
        if (flexItemCtrlStrategy.equals(FlexPropCtrlStrategyTypeEnum.CREATORORG_AND_SUBORDINATE.getType())) {
            flag = this.validateAssitantPropByOrgForCreator(flexItemObj, flexEntityType, mainOrgId, mainOrgSuperiorOrgs);
        }
        if (flexItemCtrlStrategy.equals(FlexPropCtrlStrategyTypeEnum.PRIVATE.getType())) {
            flag = this.validateAssitantPropByOrgForPrivate(flexItemObj, flexEntityType, mainOrgId);
        }
        return flag;
    }

    private boolean validateAssitantPropByOrgForPrivate(DynamicObject flexItemObj, MainEntityType flexEntityType, Long mainOrgId) {
        Object value = flexEntityType.getProperty(flexEntityType.getMainOrg()).getValue((Object)flexItemObj);
        Long flexPropOrgId = (Long)((DynamicObject)value).getPkValue();
        return mainOrgId.equals(flexPropOrgId);
    }

    private boolean validateAssitantPropByOrgForCreator(DynamicObject flexItemObj, MainEntityType flexEntityType, Long mainOrgId, Optional<List<Long>> mainOrgSuperiorOrgs) {
        Object value = flexEntityType.getProperty(flexEntityType.getMainOrg()).getValue((Object)flexItemObj);
        Long flexPropOrgId = (Long)((DynamicObject)value).getPkValue();
        return mainOrgId.equals(flexPropOrgId) || mainOrgSuperiorOrgs.orElseGet(() -> new ArrayList(0)).contains(flexPropOrgId);
    }

    private boolean validateAssitantPropByOrgForCLassOrg(AssistantProp flexItemProp, Long mainOrgId, Optional<List<Long>> mainOrgSuperiorOrgs) {
        Long asstTypeId = Long.parseLong(flexItemProp.getAsstTypeId());
        DynamicObjectType type = FlexValueReader.getSubEntityType(BOS_ASSISTANTDATAGROUP, CREATEORG);
        Map data = BusinessDataReader.loadFromCache((Object[])new Object[]{asstTypeId}, (DynamicObjectType)type);
        DynamicObject groupDynamicObject = (DynamicObject)data.get(asstTypeId);
        Long flexPropOrgId = (Long)((DynamicObject)groupDynamicObject.get(CREATEORG)).getPkValue();
        return mainOrgId.equals(flexPropOrgId) || mainOrgSuperiorOrgs.orElseGet(() -> new ArrayList(0)).contains(flexPropOrgId);
    }

    public void validataAssistantPropWithOrgFilter(IDataEntityProperty flexItemProp, DynamicObject flexItemObj, FlexProp flexProp, BasedataProp flexItemBaseProp, String[] fv) {
        boolean validated;
        if (flexItemProp instanceof AssistantProp && !(validated = this.checkAssistantData(flexItemProp, flexItemObj))) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5f39\u6027\u57df\u5c5e\u6027\u201c%1$s.%2$s\u201d\u6570\u636e\u4e0d\u5b58\u5728\uff1a%3$s", (String)"FlexValueReader_2", (String)BOS_FORM_METADATA, (Object[])new Object[0]), flexProp.getDisplayName(), flexItemBaseProp.getDisplayName().toString(), fv[1]));
        }
    }

    private String checkOrgFunction(IDataEntityProperty flexItemProp, DynamicObject flexItemObj, BasedataProp flexItemBaseProp, String[] fv) {
        String error = null;
        if (flexItemProp instanceof OrgProp) {
            IOrgService orgService = (IOrgService)ServiceFactory.getService(IOrgService.class);
            ArrayList<Long> list = new ArrayList<Long>();
            Long orgId = (Long)flexItemObj.getPkValue();
            list.add(orgId);
            List orgIdList = orgService.filterOrgDuty(list, ((OrgProp)flexItemProp).getOrgFunc());
            if (orgIdList != null && !orgIdList.contains(orgId)) {
                error = String.format(ResManager.loadKDString((String)"\u5f39\u6027\u57df\u5c5e\u6027[%1$s]\u627e\u4e0d\u5230\u7ec4\u7ec7\u804c\u80fd\uff1a[%2$s]", (String)"FlexValueReader_6", (String)BOS_FORM_METADATA, (Object[])new Object[0]), flexItemBaseProp.getDisplayName().toString(), fv[1]);
            }
        }
        return error;
    }

    public String validataAssistantPropWithOrgFilter(IDataEntityProperty flexItemProp, DynamicObject flexItemObj, BasedataProp flexItemBaseProp, String[] fv) {
        boolean validated;
        String error = null;
        if (flexItemProp instanceof AssistantProp && !(validated = this.checkAssistantData(flexItemProp, flexItemObj))) {
            error = String.format(ResManager.loadKDString((String)"\u5f39\u6027\u57df\u5c5e\u6027[%1$s]\u627e\u4e0d\u5230\u542f\u7528\u7684\u6570\u636e\uff1a[%2$s]", (String)"FlexValueReader_4", (String)BOS_FORM_METADATA, (Object[])new Object[0]), flexItemBaseProp.getDisplayName().toString(), fv[1]);
        }
        return error;
    }

    private boolean checkAssistantData(IDataEntityProperty flexItemProp, DynamicObject flexItemObj) {
        Long mainOrgId = null;
        if (!StringUtils.isBlank((CharSequence)this.context.getModel().getDataEntityType().getMainOrg())) {
            DynamicObject mainOrg = (DynamicObject)this.context.getModel().getValue(this.context.getModel().getDataEntityType().getMainOrg());
            if (mainOrg != null) {
                mainOrgId = (Long)mainOrg.getPkValue();
            }
        } else {
            mainOrgId = this.context.getMainOrgId();
        }
        if (mainOrgId == null) {
            return true;
        }
        IAssistantDataService iAssistantDataService = (IAssistantDataService)ServiceFactory.getService((String)"IAssistantDataService");
        if (!this.context.isCacheMainOrgSuperiorOrgs()) {
            String viewId = iAssistantDataService.getAssistantDataCtrlView(Long.valueOf(Long.parseLong(((AssistantProp)flexItemProp).getAsstTypeId())));
            IOrgService orgService = (IOrgService)ServiceFactory.getService(IOrgService.class);
            List allSuperiorOrgs = orgService.getAllSuperiorOrgs(viewId, mainOrgId.longValue());
            this.context.setCacheMainOrgSuperiorOrgs(true);
            this.context.setMainOrgSuperiorOrgs(Optional.ofNullable(allSuperiorOrgs));
        }
        Optional<List<Long>> mainOrgSuperiorOrgs = this.context.getMainOrgSuperiorOrgs();
        return this.validateAssistantPropByOrg(flexItemProp, flexItemObj, mainOrgId, mainOrgSuperiorOrgs);
    }

    private long getFlexPropOrgId(IDataEntityProperty flexItemProp, DynamicObject flexItemObj) {
        MainEntityType flexEntityType = (MainEntityType)((AssistantProp)flexItemProp).getComplexType();
        Object value = flexEntityType.getProperty(flexEntityType.getMainOrg()).getValue((Object)flexItemObj);
        return (Long)((DynamicObject)value).getPkValue();
    }

    private String getOrgFuncId(MainEntityType mainEntityType) {
        if (StringUtils.isBlank((CharSequence)mainEntityType.getMainOrg())) {
            return DEFAULT_ORGFUNCID;
        }
        MainOrgProp org = (MainOrgProp)mainEntityType.getProperty(mainEntityType.getMainOrg());
        if (org == null) {
            return DEFAULT_ORGFUNCID;
        }
        String orgfuncid = org.getOrgFunc();
        return StringUtils.isBlank((CharSequence)orgfuncid) ? DEFAULT_ORGFUNCID : orgfuncid;
    }

    private static DynamicObjectType getSubEntityType(String entityName, String selectProperties) {
        String[] properties = selectProperties.split(",");
        HashSet<String> select = new HashSet<String>(properties.length);
        for (String prop : properties) {
            select.add(prop.trim());
        }
        DynamicObjectType type = EntityMetadataCache.getSubDataEntityType((String)entityName, select);
        return type;
    }

    public DynamicObject[] load(String entityName, String selectProperties, QFilter[] filters) {
        return BusinessDataReader.loadFromCache((String)entityName, (String)selectProperties, (QFilter[])filters).values().toArray(new DynamicObject[0]);
    }

    private static class IDSet {
        private final Set<Object> sameSet = new HashSet<Object>(16);
        private final List<Object> idList = new ArrayList<Object>(10);

        private IDSet() {
        }

        void add(Object obj) {
            if (this.sameSet.add(obj)) {
                this.idList.add(obj);
            }
        }

        Object[] toArray() {
            return this.idList.toArray();
        }
    }
}

