/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.plugin;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.db.SqlBuilder;
import kd.bos.db.SqlParameter;
import kd.bos.entity.AppInfo;
import kd.bos.entity.AppMetadataCache;
import kd.bos.instance.Instance;
import kd.sdk.kingscript.config.ConfigurableItem;
import kd.sdk.kingscript.lib.ScriptInfo;
import kd.sdk.kingscript.lib.store.ScriptStore;
import kd.sdk.kingscript.log.Logs;
import org.slf4j.Logger;

public class KingScriptStore
implements ScriptStore {
    private static final Logger logger = Logs.getLogger();
    private static final SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
    @ConfigurableItem(desc="Cloud Associated with the Cangqiong BOS Node")
    private static final String KINGSCRIPT_IDE_CLOUD_NAMES = "kingscript.ide.cloud.names";
    @ConfigurableItem(desc="Split Application of the Original Cloud Associated with the Cangqiong BOS Node")
    private static final String KINGSCRIPT_IDE_APP_NAMES = "kingscript.ide.app.names";

    public int exists(String ... strings) {
        RequestContext rc = RequestContext.get();
        if (rc == null || rc.getUserId() == null) {
            return -1;
        }
        if (strings == null || strings.length <= 0) {
            return -1;
        }
        SqlBuilder sql = new SqlBuilder();
        sql.append("select fid,fclassname from t_meta_pluginscript where ", new Object[0]).appendIn("fclassname", (Object[])strings);
        List scriptList = (List)DB.query((DBRoute)DBRoute.meta, (SqlBuilder)sql, rs -> {
            ArrayList<String> list = new ArrayList<String>(10);
            while (rs.next()) {
                String className = rs.getString("fclassname");
                list.add(className);
            }
            return list;
        });
        for (int i = 0; i < strings.length; ++i) {
            String path = strings[i];
            if (!scriptList.contains(path)) continue;
            return i;
        }
        return -1;
    }

    public ScriptInfo load(String s) {
        RequestContext rc = RequestContext.get();
        if (rc == null || rc.getUserId() == null) {
            return null;
        }
        if (StringUtils.isBlank((CharSequence)s)) {
            return null;
        }
        String sql = "select fid,fscriptcontext_tag,fclassname,fmodifydate, fisv from t_meta_pluginscript where fclassname = ? ";
        Object[] params = new SqlParameter[]{new SqlParameter(":fclassname", 12, (Object)s)};
        return (ScriptInfo)DB.query((DBRoute)DBRoute.meta, (String)sql, (Object[])params, (ResultSetHandler)new ResultSetHandler<ScriptInfo>(){

            public ScriptInfo handle(ResultSet rs) throws SQLException {
                if (rs.next()) {
                    String script = rs.getString("fscriptcontext_tag");
                    String isv = rs.getString("fisv");
                    Timestamp modifyDate = rs.getTimestamp("fmodifydate");
                    long version = System.currentTimeMillis();
                    if (modifyDate != null) {
                        try {
                            version = dateFormat.parse(dateFormat.format(modifyDate)).getTime();
                        }
                        catch (ParseException e) {
                            throw new RuntimeException(e);
                        }
                    }
                    return new ScriptInfo(script, String.valueOf(version), isv);
                }
                return null;
            }
        });
    }

    public Map<String, List<String>> listModuleTypes(String ... modules) {
        if (RequestContext.get() == null) {
            return Collections.emptyMap();
        }
        Map<String, List<String>> moduleTypesByBOSCloud = this.getModuleTypesByBOSCloud();
        Map<String, List<String>> moduleTypesByBOSApp = this.getModuleTypesByBOSApp();
        Map<String, List<String>> moduleTypesByBIZApp = this.getModuleTypesByBIZApp();
        HashMap<String, Set> result = new HashMap<String, Set>();
        for (Map.Entry<String, List<String>> entry : moduleTypesByBOSCloud.entrySet()) {
            result.computeIfAbsent(entry.getKey(), s -> new HashSet(((List)entry.getValue()).size())).addAll((Collection)entry.getValue());
        }
        for (Map.Entry<String, List<String>> entry : moduleTypesByBOSApp.entrySet()) {
            result.computeIfAbsent(entry.getKey(), s -> new HashSet(((List)entry.getValue()).size())).addAll((Collection)entry.getValue());
        }
        for (Map.Entry<String, List<String>> entry : moduleTypesByBIZApp.entrySet()) {
            result.computeIfAbsent(entry.getKey(), s -> new HashSet(((List)entry.getValue()).size())).addAll((Collection)entry.getValue());
        }
        return result.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, x -> new ArrayList((Collection)x.getValue())));
    }

    private Map<String, List<String>> getModuleTypesByBOSCloud() {
        String bosClouds = System.getProperty(KINGSCRIPT_IDE_CLOUD_NAMES, "dev,sys,wfs,DEV,SYS,WFS");
        String[] bosCloudArr = bosClouds.split(",");
        String[] bosCloudModulesArr = (String[])Arrays.stream(bosCloudArr).map(x -> "@cosmic/" + x).toArray(value -> new String[bosCloudArr.length]);
        String sql = "select fid,fscriptcontext_tag,fclassname,fmodifydate,fscriptmodule from t_meta_pluginscript where fenginetype = ? and fscriptmodule in (%s)";
        SqlParameter[] params = new SqlParameter[bosCloudModulesArr.length + 1];
        ArrayList<String> list = new ArrayList<String>(bosCloudModulesArr.length);
        params[0] = new SqlParameter(":fenginetype", 12, (Object)Character.valueOf('1'));
        for (int i = 0; i < bosCloudModulesArr.length; ++i) {
            params[i + 1] = new SqlParameter(":fscriptmodule", 12, (Object)bosCloudModulesArr[i]);
            list.add("?");
        }
        sql = String.format(sql, StringUtils.join((Object[])list.toArray(), (String)","));
        return this.selectScriptGroupByModule(sql, params);
    }

    private Map<String, List<String>> getModuleTypesByBOSApp() {
        String bosAppNumbers = System.getProperty(KINGSCRIPT_IDE_APP_NAMES, "base,cts,secm,customize,open,sbd,mpdm,gmc");
        String[] bosAppNumberArr = bosAppNumbers.split(",");
        ArrayList<String> errorAppNumbers = new ArrayList<String>(16);
        ArrayList<String> bosAppIds = new ArrayList<String>(bosAppNumberArr.length);
        for (String bosAppNumber : bosAppNumberArr) {
            AppInfo bosAppInfo = null;
            try {
                bosAppInfo = AppMetadataCache.getAppInfoByNumber((String)bosAppNumber);
            }
            catch (Exception e) {
                errorAppNumbers.add(bosAppNumber);
            }
            if (bosAppInfo == null) continue;
            bosAppIds.add(bosAppInfo.getId());
        }
        logger.info(String.format("KingScriptStore.getModuleTypesByBOSApp error appnumber is %s", ((Object)errorAppNumbers).toString()));
        String[] bosAppIdArr = bosAppIds.toArray(new String[0]);
        String sql = "select fid,fscriptcontext_tag,fclassname,fmodifydate,fscriptmodule from t_meta_pluginscript where fenginetype = ? and fbizappid in (%s)";
        SqlParameter[] params = new SqlParameter[bosAppIdArr.length + 1];
        ArrayList<String> list = new ArrayList<String>(bosAppIdArr.length);
        params[0] = new SqlParameter(":fenginetype", 12, (Object)Character.valueOf('1'));
        for (int i = 0; i < bosAppIdArr.length; ++i) {
            params[i + 1] = new SqlParameter(":fbizappid", 12, (Object)bosAppIdArr[i]);
            list.add("?");
        }
        sql = String.format(sql, StringUtils.join((Object[])list.toArray(), (String)","));
        return this.selectScriptGroupByModule(sql, params);
    }

    private Map<String, List<String>> getModuleTypesByBIZApp() {
        String[] bizAppNumbers = Instance.getAppIds();
        if (bizAppNumbers == null || bizAppNumbers.length == 0) {
            return Collections.emptyMap();
        }
        ArrayList<String> bizAppIds = new ArrayList<String>(bizAppNumbers.length);
        ArrayList<String> errorAppNumbers = new ArrayList<String>(16);
        for (String bosAppNumber : bizAppNumbers) {
            AppInfo bosAppInfo = null;
            try {
                bosAppInfo = AppMetadataCache.getAppInfoByNumber((String)bosAppNumber);
            }
            catch (Exception e) {
                errorAppNumbers.add(bosAppNumber);
            }
            if (bosAppInfo == null) continue;
            bizAppIds.add(bosAppInfo.getId());
        }
        logger.info(String.format("KingScriptStore.getModuleTypesByBIZApp error appnumber is %s", ((Object)errorAppNumbers).toString()));
        String[] bizAppIdArr = bizAppIds.toArray(new String[0]);
        String sql = "select fid,fscriptcontext_tag,fclassname,fmodifydate,fscriptmodule from t_meta_pluginscript where fenginetype = ? and fbizappid in (%s)";
        SqlParameter[] params = new SqlParameter[bizAppIdArr.length + 1];
        ArrayList<String> list = new ArrayList<String>(bizAppIdArr.length);
        params[0] = new SqlParameter(":fenginetype", 12, (Object)Character.valueOf('1'));
        for (int i = 0; i < bizAppIdArr.length; ++i) {
            params[i + 1] = new SqlParameter(":fbizappid", 12, (Object)bizAppIdArr[i]);
            list.add("?");
        }
        sql = String.format(sql, StringUtils.join((Object[])list.toArray(), (String)","));
        return this.selectScriptGroupByModule(sql, params);
    }

    private Map<String, List<String>> selectScriptGroupByModule(String sql, SqlParameter[] params) {
        return (Map)DB.query((DBRoute)DBRoute.meta, (String)sql, (Object[])params, rs -> {
            HashMap<String, List> result = new HashMap<String, List>();
            while (rs.next()) {
                String module = rs.getString("fscriptmodule");
                String className = rs.getString("fclassname");
                Timestamp modifyDate = rs.getTimestamp("fmodifydate");
                if (modifyDate != null) {
                    long version = modifyDate.getTime();
                    className = String.format("%s&v=%s", className, version);
                }
                result.computeIfAbsent(module, s -> new ArrayList(1024)).add(className);
            }
            return result;
        });
    }
}

