/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.rule;

import java.security.InvalidKeyException;
import java.security.KeyPair;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeCacheHAPolicy;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.dlock.DLock;
import kd.bos.encrypt.impl.RSAEncrypterUtil;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.form.control.FormDesigner;
import kd.bos.form.control.ProFormDesigner;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.CollectionUtils;

public final class DecodeRulesHandle {
    private static final String ENCODE_HEADER_AES = "&#kdencrypt#&";
    private static final String ENCODE_HEADER_RSA = "&#kdrsaencrypt#&";
    private static final String PUBLIC_KEY = "Rsa:publicKey";
    private static final String PRIVATE_KEY = "Rsa:privateKey";
    private static final String BOS_FORM_METADATA = "bos-form-metadata";
    private static final String RSA_ECB_OAEP_PADDING = "RSA/ECB/OAEPPadding";
    private static KeyPair keyPair;
    private static final String DEFAULT_TIMEOUT_KEY = "redis.genKeyPair.defaulttimeout";

    private DecodeRulesHandle() {
    }

    @Deprecated
    public static void decodeRules(String propertyName, Map<String, Object> param) {
        if ("Rules".equals(propertyName) || "ClientRules".equals(propertyName)) {
            List ruleList = (List)param.get("value");
            ArrayList actionList = new ArrayList(10);
            if (!CollectionUtils.isEmpty((Collection)ruleList)) {
                for (Map map : ruleList) {
                    if (StringUtils.isNotBlank(map.get("Description"))) {
                        map.put("Description", DecodeRulesHandle.parseContent(String.valueOf(map.get("Description"))));
                    }
                    if (StringUtils.isNotBlank(map.get("PreDescription"))) {
                        map.put("PreDescription", DecodeRulesHandle.parseContent(String.valueOf(map.get("PreDescription"))));
                    }
                    if (StringUtils.isNotBlank(map.get("PreCondition"))) {
                        map.put("PreCondition", DecodeRulesHandle.parseContent(String.valueOf(map.get("PreCondition"))));
                    }
                    actionList.add(map.get("TrueActions"));
                    actionList.add(map.get("FalseActions"));
                }
                if (!CollectionUtils.isEmpty(actionList)) {
                    for (Object action : actionList) {
                        DecodeRulesHandle.decodeActionRules(action);
                    }
                }
            }
        }
    }

    @Deprecated
    public static void decodeRules(Map<String, Object> value, FormDesigner control) {
        Map formmeta = (Map)value.get("formmeta");
        Map entitymeta = (Map)value.get("entitymeta");
        Map listmeta = (Map)value.get("listmeta");
        if (formmeta != null) {
            if (control instanceof ProFormDesigner) {
                entitymeta = (Map)formmeta.get("entitymeta");
                formmeta = (Map)formmeta.get("formmeta");
            }
            DecodeRulesHandle.toDecode(formmeta);
        }
        if (entitymeta != null) {
            DecodeRulesHandle.toDecode(entitymeta);
        }
        if (listmeta != null) {
            if (control instanceof ProFormDesigner) {
                listmeta = (Map)listmeta.get("formmeta");
            }
            DecodeRulesHandle.toDecode(listmeta);
        }
    }

    @Deprecated
    public static void decodeRules(Map<String, Object> value) {
        Map entitymeta = (Map)value.get("entitymeta");
        DecodeRulesHandle.toDecode(entitymeta);
    }

    @Deprecated
    public static void decodeActionRules(Object actions) {
        List list;
        if (actions != null && !CollectionUtils.isEmpty((Collection)(list = (List)actions))) {
            for (Map stringObjectMap : list) {
                Object description = stringObjectMap.get("Description");
                Object expression = stringObjectMap.get("Expression");
                if (StringUtils.isNotBlank(description)) {
                    stringObjectMap.put("Description", DecodeRulesHandle.parseContent(String.valueOf(description)));
                }
                if (!(expression instanceof String) || !StringUtils.isNotBlank(expression)) continue;
                stringObjectMap.put("Expression", DecodeRulesHandle.parseContent(String.valueOf(expression)));
            }
        }
    }

    @Deprecated
    public static void toDecode(Map<String, Object> metaData) {
        List metaList;
        if (metaData != null && !CollectionUtils.isEmpty((Collection)(metaList = (List)metaData.get("Items")))) {
            for (Map ruleMap : metaList) {
                if (ruleMap == null) continue;
                Object rules = ruleMap.get("Rules");
                DecodeRulesHandle.decodeRulesDescription(rules);
                Object clientRules = ruleMap.get("ClientRules");
                DecodeRulesHandle.decodeRulesDescription(clientRules);
                Map mobListMeta = (Map)ruleMap.get("MobListMeta");
                DecodeRulesHandle.toDecode(mobListMeta);
                Map mobMeta = (Map)ruleMap.get("MobMeta");
                DecodeRulesHandle.toDecode(mobMeta);
                Map listMeta = (Map)ruleMap.get("ListMeta");
                DecodeRulesHandle.toDecode(listMeta);
            }
        }
    }

    @Deprecated
    public static void decodeRulesDescription(Object rules) {
        if (rules != null) {
            List list = (List)rules;
            ArrayList actionList = new ArrayList(10);
            if (!CollectionUtils.isEmpty((Collection)list)) {
                for (Map map : list) {
                    if (StringUtils.isNotBlank(map.get("Description"))) {
                        map.put("Description", DecodeRulesHandle.parseContent(String.valueOf(map.get("Description"))));
                    }
                    if (StringUtils.isNotBlank(map.get("PreDescription"))) {
                        map.put("PreDescription", DecodeRulesHandle.parseContent(String.valueOf(map.get("PreDescription"))));
                    }
                    if (StringUtils.isNotBlank(map.get("PreCondition"))) {
                        map.put("PreCondition", DecodeRulesHandle.parseContent(String.valueOf(map.get("PreCondition"))));
                    }
                    Object trueActions = map.get("TrueActions");
                    actionList.add(trueActions);
                    Object falseActions = map.get("FalseActions");
                    actionList.add(falseActions);
                }
                if (!CollectionUtils.isEmpty(actionList)) {
                    for (Object action : actionList) {
                        DecodeRulesHandle.decodeActionRules(action);
                    }
                }
            }
        }
    }

    @Deprecated
    public static Object decodeVaue(String key, Object value) {
        if ("textareafield".equals(key) || "conditiondescript".equals(key) || "description".equals(key)) {
            return DecodeRulesHandle.parseContent(value);
        }
        return value;
    }

    @Deprecated
    public static Object parseContent(Object content) {
        if (content instanceof String && StringUtils.isNotBlank((Object)content) && content.toString().startsWith(ENCODE_HEADER_AES)) {
            content = content.toString().replaceFirst(ENCODE_HEADER_AES, "");
            return content;
        }
        return content;
    }

    public static Object decryptRsaContent(Object content) {
        if (content instanceof String && StringUtils.isNotBlank((Object)content) && content.toString().startsWith(ENCODE_HEADER_RSA)) {
            DistributeSessionlessCache cache = DecodeRulesHandle.getCache();
            Log logger = DecodeRulesHandle.getLogger();
            String privateKeyString = (String)cache.get(PRIVATE_KEY);
            if (StringUtils.isBlank((CharSequence)privateKeyString)) {
                logger.warn("\u4ece\u7f13\u5b58\u4e2d\u83b7\u53d6RSA\u79c1\u94a5\u5931\u8d25\uff0c\u79c1\u94a5\u4e3a\u7a7a\uff01");
                throw new KDException(BosErrorCode.nullError, new Object[]{ResManager.loadKDString((String)"\u83b7\u53d6RSA\u79c1\u94a5\u5931\u8d25\uff0c\u79c1\u94a5\u4e3a\u7a7a\uff01", (String)"DecodeRulesHandle_0", (String)BOS_FORM_METADATA, (Object[])new Object[0])});
            }
            PrivateKey privateKey = null;
            try {
                privateKey = RSAEncrypterUtil.getPrivateKey((String)privateKeyString);
            }
            catch (Exception e) {
                logger.warn("\u83b7\u53d6\u79c1\u94a5\u5b9e\u4f8b\u5931\u8d25\uff01");
                throw new KDException(BosErrorCode.paramError, new Object[]{ResManager.loadKDString((String)"\u83b7\u53d6\u79c1\u94a5\u5b9e\u4f8b\u5931\u8d25\uff01", (String)"DecodeRulesHandle_4", (String)BOS_FORM_METADATA, (Object[])new Object[0])});
            }
            StringBuilder contentBuilder = new StringBuilder();
            String[] contentArray = content.toString().split(ENCODE_HEADER_RSA);
            for (int i = 1; i < contentArray.length; ++i) {
                contentBuilder.append(DecodeRulesHandle.decryptBase64String(contentArray[i], privateKey));
            }
            return contentBuilder.toString();
        }
        return content;
    }

    private static String decryptBase64String(String content, PrivateKey privateKey) {
        byte[] decode = Base64.getDecoder().decode(content);
        return new String(DecodeRulesHandle.decrypt(decode, privateKey));
    }

    private static byte[] decrypt(byte[] content, PrivateKey privateKey) {
        Log logger = DecodeRulesHandle.getLogger();
        Cipher cipher = null;
        byte[] bytes = null;
        try {
            cipher = Cipher.getInstance(RSA_ECB_OAEP_PADDING);
            cipher.init(2, privateKey);
            bytes = cipher.doFinal(content);
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException e) {
            logger.error("RSA\u89e3\u5bc6\u5185\u5bb9\u5931\u8d25\uff01");
            throw new KDException(BosErrorCode.bOS, new Object[]{ResManager.loadKDString((String)"RSA\u89e3\u5bc6\u5185\u5bb9\u5931\u8d25\uff01", (String)"DecodeRulesHandle_1", (String)BOS_FORM_METADATA, (Object[])new Object[0])});
        }
        return bytes;
    }

    private static byte[] encrypt(byte[] content, PublicKey publicKey) {
        Log logger = DecodeRulesHandle.getLogger();
        Cipher cipher = null;
        byte[] bytes = null;
        try {
            cipher = Cipher.getInstance(RSA_ECB_OAEP_PADDING);
            cipher.init(1, publicKey);
            bytes = cipher.doFinal(content);
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException e) {
            logger.error("RSA\u52a0\u5bc6\u5185\u5bb9\u5931\u8d25\uff01");
            throw new KDException(BosErrorCode.bOS, new Object[]{ResManager.loadKDString((String)"RSA\u52a0\u5bc6\u5185\u5bb9\u5931\u8d25\uff01", (String)"DecodeRulesHandle_2", (String)BOS_FORM_METADATA, (Object[])new Object[0])});
        }
        return bytes;
    }

    private static String encryptString(String content, PublicKey publicKey) {
        byte[] encrypt = DecodeRulesHandle.encrypt(content.getBytes(), publicKey);
        return Base64.getEncoder().encodeToString(encrypt);
    }

    public static String getRsaPublicKey() {
        return DecodeRulesHandle.getRsaPublicKey(false);
    }

    public static String getRsaPublicKey(boolean isForceGet) {
        DistributeSessionlessCache cache = DecodeRulesHandle.getCache();
        String publicKeyString = (String)cache.get(PUBLIC_KEY);
        String timeout = System.getProperty(DEFAULT_TIMEOUT_KEY, String.valueOf(86400));
        if (StringUtils.isBlank((CharSequence)publicKeyString) || isForceGet) {
            if (keyPair == null) {
                keyPair = DecodeRulesHandle.genKeyPair(2048, isForceGet);
            }
            if (keyPair != null) {
                PublicKey aPublic = keyPair.getPublic();
                publicKeyString = Base64.getEncoder().encodeToString(aPublic.getEncoded());
                PrivateKey aPrivate = keyPair.getPrivate();
                String privateKeyString = Base64.getEncoder().encodeToString(aPrivate.getEncoded());
                cache.put(PUBLIC_KEY, (Object)publicKeyString, Integer.parseInt(timeout));
                cache.put(PRIVATE_KEY, (Object)privateKeyString, Integer.parseInt(timeout));
            } else {
                publicKeyString = null;
            }
        }
        return publicKeyString;
    }

    private static KeyPair genKeyPair(int keyLength) {
        return DecodeRulesHandle.genKeyPair(keyLength, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static KeyPair genKeyPair(int keyLength, boolean isForceGet) {
        Log logger = DecodeRulesHandle.getLogger();
        DLock lock = DLock.create((String)"genKeyPairLock");
        boolean tryLock = lock.tryLock();
        try {
            if (tryLock) {
                String publicKeyString = (String)DecodeRulesHandle.getCache().get(PUBLIC_KEY);
                if (StringUtils.isBlank((CharSequence)publicKeyString) || isForceGet) {
                    keyPair = RSAEncrypterUtil.genKeyPair((int)keyLength);
                }
            } else {
                logger.warn("\u83b7\u53d6\u5206\u5e03\u5f0f\u9501\u5931\u8d25\uff01");
                keyPair = null;
            }
        }
        catch (Exception e) {
            logger.error("\u751f\u6210RSA\u5bc6\u94a5\u5bf9\u5931\u8d25\uff01", (Throwable)e);
            KeyPair keyPair = null;
            return keyPair;
        }
        finally {
            lock.unlock();
        }
        return keyPair;
    }

    private static DistributeSessionlessCache getCache() {
        return CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("DecodeRulesHandle", new DistributeCacheHAPolicy());
    }

    private static Log getLogger() {
        return LogFactory.getLog(DecodeRulesHandle.class);
    }

    static {
        try {
            keyPair = DecodeRulesHandle.genKeyPair(2048);
        }
        catch (Exception e) {
            DecodeRulesHandle.getLogger().error(ResManager.loadKDString((String)"\u521d\u59cb\u5316\u65f6\u751f\u6210\u5bc6\u94a5\u5bf9\u5931\u8d25\uff01", (String)"DecodeRulesHandle_5", (String)BOS_FORM_METADATA, (Object[])new Object[0]), (Throwable)e);
        }
    }
}

