/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.list;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.bill.MobileFormPosition;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.ComplexPropertyAttribute;
import kd.bos.dataentity.entity.SimplePropertyAttribute;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.SelectedDisplayField;
import kd.bos.entity.plugin.Plugin;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.form.FormConfig;
import kd.bos.form.FormMetadataCache;
import kd.bos.form.dynplugin.FormDynamicProxyPluginFactory;
import kd.bos.form.dynplugin.KingScriptFormDynamicProxyPlugin;
import kd.bos.form.dynplugin.KingScriptFormDynamicProxyPluginFactory;
import kd.bos.list.ListShowParameter;
import kd.bos.script.annotations.KSMethod;
import kd.bos.script.annotations.KSObject;
import kd.sdk.annotation.SdkInternal;
import kd.sdk.annotation.SdkPublic;

@KSObject
@SdkPublic
public class MobileListShowParameter
extends ListShowParameter {
    private static final long serialVersionUID = -8746351261927203361L;
    private static final String METAS = "metas";
    public static final String MobileListTemplateId = "766c473d000001ac";
    @SdkInternal
    public static final String MobileListBillListApId = "1DRUs1sCNW";
    private SelectedDisplayField selectedDisplayField;
    MobileFormPosition position = MobileFormPosition.Default;
    private String height;

    @Override
    protected String getViewClass() {
        return "kd.bos.mvc.list.MobileListView";
    }

    public MobileListShowParameter() {
        this.setMultiSelect(false);
    }

    @Override
    @SimplePropertyAttribute(name="MultiSelect")
    @KSMethod
    public boolean isMultiSelect() {
        return this.multiSelect;
    }

    @ComplexPropertyAttribute
    public SelectedDisplayField getSelectedDisplayField() {
        return this.selectedDisplayField;
    }

    public void setSelectedDisplayField(SelectedDisplayField selectedDisplayField) {
        this.selectedDisplayField = selectedDisplayField;
    }

    @Override
    public String getServiceAppId() {
        String serviceAppId = (String)this.getCustomParam("ServiceAppId");
        if (StringUtils.isBlank((CharSequence)serviceAppId)) {
            if (!StringUtils.isBlank((CharSequence)this.billFormId)) {
                if (FormMetadataCache.getMobListFormConfig(this.billFormId) == null) {
                    throw new KDBizException(BosErrorCode.bOS, new Object[]{ResManager.loadKDString((String)"\u8bf7\u5728\u8bbe\u8ba1\u5668\u4e2d\u4fdd\u5b58\u4e4b\u540e\u518d\u9884\u89c8\u3002", (String)"MobileListShowParameter_0", (String)"bos-form-metadata", (Object[])new Object[0])});
                }
                return this.convertBOSAppId(FormMetadataCache.getMobListFormConfig(this.billFormId).getAppId());
            }
            return super.getServiceAppId();
        }
        return this.convertBOSAppId(serviceAppId);
    }

    @Override
    protected Map<String, Object> setClientCfg(Map<String, Object> clientCfg) {
        return clientCfg;
    }

    @Override
    public Map<String, Object> createClientConfig(Map<String, Object> setting) {
        FormConfig fConfig;
        Map<String, Object> config = this.getClientConfig(setting);
        config.put("clienttype", "mobile");
        config.put("position", (Object)this.getPosition());
        config.put("height", this.getHeight());
        HashMap<String, Object> metas = (HashMap<String, Object>)config.get(METAS);
        if (metas == null) {
            metas = new HashMap<String, Object>();
            config.put(METAS, metas);
        }
        if ((fConfig = FormMetadataCache.getMobListFormConfig(this.billFormId)) != null) {
            Map<String, Object> menu = fConfig.getMenu();
            metas.put("menu", menu);
        }
        ArrayList list = new ArrayList();
        if (!this.isMultiSelect()) {
            HashMap<String, Object> ctl = new HashMap<String, Object>();
            ctl.put("id", "billlistap");
            ctl.put("ismul", false);
            list.add(ctl);
        }
        metas.put("items", list);
        config.put(METAS, metas);
        if (this.isLookUp()) {
            config.put("status", OperationStatus.EDIT.getValue());
        }
        return config;
    }

    @Override
    protected void getFormConfigFromMeta() {
        FormConfig listConfig = FormMetadataCache.getMobListFormConfig(this.billFormId);
        if (listConfig != null) {
            if (StringUtils.isBlank((CharSequence)this.getFormId())) {
                this.setFormId(listConfig.getListFormId());
            }
            this.queryListUserOption(listConfig);
        } else if (StringUtils.isBlank((CharSequence)this.getFormId())) {
            this.setFormId("bos_moblist");
        }
        if (listConfig == null) {
            throw new KDException(BosErrorCode.bOS, new Object[]{ResManager.loadKDString((String)"\u6b64\u5355\u636e\u4e0d\u5b58\u5728\u5217\u8868\uff0c\u8bf7\u68c0\u67e5", (String)"MobileListShowParameter_1", (String)"bos-form-metadata", (Object[])new Object[0])});
        }
        FormConfig config = FormMetadataCache.getFormConfig(this.getFormId());
        config.getPlugins().addAll(listConfig.getPlugins());
        config.setCaption(listConfig.getCaption());
        config.setListFormId(listConfig.getListFormId());
        config.setShowTitle(listConfig.isShowTitle());
        this.setFormConfig(config);
    }

    @KSMethod
    public void setPosition(MobileFormPosition value) {
        this.position = value;
    }

    @KSMethod
    public MobileFormPosition getPosition() {
        return this.position;
    }

    @KSMethod
    public void setHeight(String value) {
        this.height = value;
    }

    @KSMethod
    public String getHeight() {
        return this.height;
    }

    @Override
    protected void addListToolbar(List<Map<String, Object>> list) {
    }

    @Override
    public String getSettingKey() {
        return this.getBillFormId() + ".MListSetting";
    }

    @Override
    @SdkInternal
    public Plugin getDynProxyPlugin() {
        return FormDynamicProxyPluginFactory.getProxyPlugin("3", "2", this.formConfig.getPlugins().size() + 1);
    }

    @Override
    protected void registerKingScriptDynamicPlugin() {
        KingScriptFormDynamicProxyPlugin proxyPlugin = KingScriptFormDynamicProxyPluginFactory.create(KingScriptFormDynamicProxyPluginFactory.PluginObject.createListPluginProxy(this.formConfig.getPlugins(), this.getBillFormId(), true));
        proxyPlugin.register();
    }
}

