/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.script;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.sdk.kingscript.engine.KingScriptEngine;
import kd.sdk.kingscript.exception.ScriptException;

public class ProjectInitializerManager {
    private static Log log = LogFactory.getLog(ProjectInitializerManager.class);

    public static void initialize(String project) {
        try {
            Method initialize = Class.forName("kd.sdk.bos.launch.ProjectInitializer").getMethod("initialize", String.class, String[].class);
            initialize.invoke(null, project, null);
        }
        catch (Throwable e) {
            ProjectInitializerManager.dealException("initialize", e, false);
        }
    }

    public static KingScriptEngine getEngine(boolean debug) {
        try {
            Method getEngine = Class.forName("kd.sdk.bos.launch.ProjectInitializer").getMethod("getEngine", Boolean.TYPE);
            return (KingScriptEngine)getEngine.invoke(null, debug);
        }
        catch (Throwable e) {
            ProjectInitializerManager.dealException("getEngine", e, true);
            return null;
        }
    }

    public static KingScriptEngine getEngineAutoDebug(String scriptPath) {
        try {
            Method getEngine = Class.forName("kd.sdk.bos.launch.ProjectInitializer").getMethod("getEngineAutoDebug", String.class);
            return (KingScriptEngine)getEngine.invoke(null, scriptPath);
        }
        catch (Throwable e) {
            ProjectInitializerManager.dealException("getEngine", e, true);
            return null;
        }
    }

    private static void dealException(String action, Throwable e, boolean throwIt) {
        if (e instanceof InvocationTargetException) {
            e = ((InvocationTargetException)e).getTargetException();
        }
        log.error(String.format("KingScript engine " + action + " error: %s", ProjectInitializerManager.getExceptionStackTraceMessage(e)));
        if (e instanceof ScriptException) {
            throw (ScriptException)e;
        }
        throw new KDException(e, BosErrorCode.bOS, new Object[]{String.format("KingScript engine " + action + " error: %s", e.getMessage())});
    }

    private static String getExceptionStackTraceMessage(Throwable e) {
        StringWriter sw = new StringWriter();
        e.printStackTrace(new PrintWriter(sw));
        return sw.toString();
    }
}

