/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.TypesContainer;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.PermissionControlType;
import kd.bos.entity.RuntimeMetaType;
import kd.bos.entity.rule.AbstractRule;
import kd.bos.entity.rule.EntityBR;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.form.BinderMap;
import kd.bos.form.ControlTypes;
import kd.bos.form.FormConfig;
import kd.bos.form.FormMetadataLocalCache;
import kd.bos.form.FormOperateTypes;
import kd.bos.form.IFormMetadataProvide;
import kd.bos.form.container.FormRoot;
import kd.bos.form.control.Control;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.operate.webapi.AbstractOperateWebApi;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.ServiceFactory;
import kd.bos.service.metadata.RuntimeMetadataShareService;
import kd.bos.session.SystemPropertyUtils;

public class FormMetadataShareProvider
implements IFormMetadataProvide {
    private static final String TOOL_BAR = "ToolBar";
    private static final String FILTER = "filter";
    private static final Log log = LogFactory.getLog(FormMetadataShareProvider.class);
    private static final String CONFIG = "Config";
    private static final String QINGVIEW = "qingview";
    private static final String LIST = "List";
    private static final String BOS_SHAREMETADATA_PROVIDER = "bos-sharemetadata-provider";
    private static String[] guestFormWhiteList = new String[]{"srm_portal", "bos_portal_setlayout", "bos_assistantdata_detail", "bd_admindivision", "bos_admindivisionf7", "bd_country", "bd_taxrate", "bd_invoicetype", "bos_templatetreelistf7", "bd_settlementtype", "bd_paycondition", "bd_taxcategory", "bd_bebank", "bd_resinlistf7", "bos_list", "bos_org", "bos_orgtreelistf7", "bd_currency", "bos_listf7", "bos_moblist", "bos_moblistmodalf7", "rebm_announcement", "resp_registered", "resp_org_alias", "bd_suppliergroup", "bd_datagrouptreelistf7", "resp_message", "resm_suppliernaturef7"};
    private RuntimeMetadataShareService metadataService = (RuntimeMetadataShareService)ServiceFactory.getService(RuntimeMetadataShareService.class);

    public FormConfig getFormConfig(String formId) {
        String strConfig = FormMetadataLocalCache.getFormConfig((String)formId);
        if (strConfig == null) {
            strConfig = this.metadataService.loadFormRuntimeMeta(formId, RuntimeMetaType.Config.getValue(), formId);
        }
        if (StringUtils.isEmpty((CharSequence)strConfig)) {
            throw new KDException(BosErrorCode.metaNotFound, new Object[]{String.format(ResManager.loadKDString((String)"%s\u8fd0\u884c\u671f\u5143\u6570\u636e\u4e0d\u5b58\u5728", (String)"FormMetadataShareProvider_0", (String)BOS_SHAREMETADATA_PROVIDER, (Object[])new Object[0]), formId)});
        }
        try {
            PermissionControlType permControlType;
            FormConfig formConfig = (FormConfig)this.toFormConfig(strConfig);
            if (!(RequestContext.get().getCurrUserId() != -1L || this.isGuestWhiteList(formId) || (permControlType = EntityMetadataCache.getPermissionControlType((String)formConfig.getEntityTypeId())) != null && permControlType.isAnonymousUserControl())) {
                throw new KDBizException(BosErrorCode.oAuthSecurity, new Object[]{ResManager.loadKDString((String)"guest\u7528\u6237\u6ca1\u6709\u8bbf\u95ee\u6743\u9650\uff0c\u8bf7\u5148\u767b\u5f55\u3002", (String)"FormMetadataShareProvider_1", (String)BOS_SHAREMETADATA_PROVIDER, (Object[])new Object[0])});
            }
            String version = this.metadataService.getRuntimeMetadataVersion(formId);
            if (!version.equals(formConfig.getVersion())) {
                this.metadataService.removeCache(formId);
                strConfig = this.metadataService.loadFormRuntimeMeta(formId, RuntimeMetaType.Config.getValue(), formId);
                formConfig = (FormConfig)this.toFormConfig(strConfig);
            }
            FormMetadataLocalCache.putFormConfig((String)formId, (String)strConfig);
            return formConfig;
        }
        catch (KDBizException e) {
            log.error((Throwable)e);
            throw new KDBizException(e.getMessage());
        }
        catch (Exception e) {
            log.error((Throwable)e);
            String msg = String.format("error:%s,formid:%s,formconfig:%s", e.getMessage(), formId, strConfig);
            throw new KDException(BosErrorCode.metaNotFound, new Object[]{msg});
        }
    }

    private boolean isGuestWhiteList(String formId) {
        for (String form : guestFormWhiteList) {
            if (!form.equals(formId)) continue;
            return true;
        }
        String tenantId = RequestContext.get().getTenantId();
        String guestForms = SystemPropertyUtils.getProptyByTenant((String)"security.meta.guestwhitelist", (String)tenantId);
        log.info(String.format("isGuestWhiteList0-formId : %s ,isGuestWhiteList1 : %s, isGuestWhiteList2: %s", formId, tenantId, guestForms));
        if (StringUtils.isNotBlank((CharSequence)guestForms)) {
            String[] guestFormArray;
            for (String form : guestFormArray = guestForms.split(",")) {
                if (!form.equals(formId)) continue;
                return true;
            }
        }
        return false;
    }

    private <T> T toFormConfig(String json) {
        Object o;
        try {
            o = ControlTypes.fromJsonStringToObj((String)json);
        }
        catch (Exception e) {
            o = SerializationUtils.fromJsonString((String)json, FormConfig.class);
        }
        return (T)o;
    }

    private String getFormRuntimeMeta(String formId, RuntimeMetaType type, String key) {
        return this.getFormRuntimeMeta(formId, type, key, false);
    }

    private String getFormRuntimeMeta(String formId, RuntimeMetaType type, String key, boolean nullCacheKey) {
        String formMetaStr = (String)FormMetadataLocalCache.getRuntimeMetaTypeMeta((String)formId, (RuntimeMetaType)type, (String)(nullCacheKey ? null : key));
        if (StringUtils.isBlank((CharSequence)formMetaStr)) {
            formMetaStr = this.metadataService.loadFormRuntimeMeta(formId, type.getValue(), key);
            if (StringUtils.isBlank((CharSequence)formMetaStr)) {
                return formMetaStr;
            }
            FormMetadataLocalCache.cacheRuntimeMetaTypeMeta((String)formId, (RuntimeMetaType)type, (String)(nullCacheKey ? null : key), (Object)formMetaStr);
        }
        return formMetaStr;
    }

    public FormRoot getRootControl(String formId) {
        String formMetaStr = this.getFormRuntimeMeta(formId, RuntimeMetaType.Form, formId);
        if (formMetaStr == null) {
            throw new KDException(BosErrorCode.metaNotFound, new Object[]{String.format(ResManager.loadKDString((String)"%s\u8fd0\u884c\u671f\u5143\u6570\u636e\u4e0d\u5b58\u5728", (String)"FormMetadataShareProvider_0", (String)BOS_SHAREMETADATA_PROVIDER, (Object[])new Object[0]), formId)});
        }
        if (StringUtils.isBlank((CharSequence)formMetaStr)) {
            throw new KDException(BosErrorCode.metaNotFound, new Object[]{String.format(ResManager.loadKDString((String)"%s\u8fd0\u884c\u671f\u5143\u6570\u636e\u7f13\u5b58\u88ab\u7834\u574f", (String)"FormMetadataShareProvider_2", (String)BOS_SHAREMETADATA_PROVIDER, (Object[])new Object[0]), formId)});
        }
        return (FormRoot)ControlTypes.fromJsonString((String)formMetaStr);
    }

    public <T extends Control> T getControl(String formId, String key) {
        String formMetaStr = this.metadataService.loadFormRuntimeMeta(formId, RuntimeMetaType.Control.getValue(), key);
        return (T)ControlTypes.fromJsonString((String)formMetaStr);
    }

    public List<String> getHeadDecimalFields(String formId) {
        String formMetaStr = this.getFormRuntimeMeta(formId, RuntimeMetaType.DecimalFields, formId);
        if (StringUtils.isBlank((CharSequence)formMetaStr)) {
            return new ArrayList<String>(0);
        }
        return SerializationUtils.fromJsonStringToList((String)formMetaStr, String.class);
    }

    public List<String> getHeadDateTimeFields(String formId) {
        String formMetaStr = this.getFormRuntimeMeta(formId, RuntimeMetaType.DateTimeFields, formId);
        if (StringUtils.isBlank((CharSequence)formMetaStr)) {
            return new ArrayList<String>(0);
        }
        return SerializationUtils.fromJsonStringToList((String)formMetaStr, String.class);
    }

    public Map<String, List<AbstractRule>> getAllEntityRules(String formId) {
        String formRulesStr = this.getFormRuntimeMeta(formId, RuntimeMetaType.Rule, "_formrules", true);
        HashMap<String, List<AbstractRule>> mapRules = new HashMap<String, List<AbstractRule>>();
        if (StringUtils.isNotBlank((CharSequence)formRulesStr)) {
            List list = SerializationUtils.fromJsonStringToList((String)formRulesStr, EntityBR.class);
            for (EntityBR ebr : list) {
                ArrayList rules = new ArrayList();
                rules.addAll(ebr.getRules());
                mapRules.put(ebr.getKey(), rules);
            }
        }
        return mapRules;
    }

    public FormOperate getFormOperation(String entityId, String operationKey) {
        HashMap<String, Object> op;
        String operateStr = this.metadataService.loadEntityRuntimeMeta(entityId, (int)RuntimeMetaType.Operate.getValue(), operationKey);
        if (!StringUtils.isEmpty((CharSequence)operateStr)) {
            op = (HashMap<String, Object>)SerializationUtils.fromJsonString((String)operateStr, Map.class);
        } else {
            op = new HashMap<String, Object>(16);
            op.put("type", operationKey.toLowerCase());
            op.put("key", operationKey.toLowerCase());
            HashMap<String, String> name = new HashMap<String, String>(16);
            name.put(Locale.getDefault().toString(), operationKey.toLowerCase());
            op.put("name", name);
        }
        return (FormOperate)FormOperateTypes.createFormOperate(op);
    }

    public String getFormPluginScripts(String formId, String key) {
        return this.metadataService.loadFormPluginScriptMeta(formId, key);
    }

    public Map<String, Object> getListMeta(String formId) {
        String formRuntimeMeta = this.getFormRuntimeMeta(formId, RuntimeMetaType.List, LIST);
        if (!StringUtils.isEmpty((CharSequence)formRuntimeMeta)) {
            return (Map)SerializationUtils.fromJsonString((String)formRuntimeMeta, Map.class);
        }
        return new HashMap<String, Object>(16);
    }

    public Map<String, Object> getMobListMeta(String formId) {
        String formRuntimeMeta = this.getFormRuntimeMeta(formId, RuntimeMetaType.MobList, LIST);
        if (!StringUtils.isEmpty((CharSequence)formRuntimeMeta)) {
            return (Map)SerializationUtils.fromJsonString((String)formRuntimeMeta, Map.class);
        }
        return new HashMap<String, Object>(16);
    }

    public Map<String, Object> getMobFilterMeta(String formId) {
        String formRuntimeMeta = this.getFormRuntimeMeta(formId, RuntimeMetaType.MobList, FILTER);
        if (!StringUtils.isEmpty((CharSequence)formRuntimeMeta)) {
            return (Map)SerializationUtils.fromJsonString((String)formRuntimeMeta, Map.class);
        }
        return new HashMap<String, Object>(16);
    }

    public Map<String, Object> getListToolBar(String formId) {
        String formRuntimeMeta = this.getFormRuntimeMeta(formId, RuntimeMetaType.List, TOOL_BAR);
        if (!StringUtils.isEmpty((CharSequence)formRuntimeMeta)) {
            return (Map)SerializationUtils.fromJsonString((String)formRuntimeMeta, Map.class);
        }
        return new HashMap<String, Object>(16);
    }

    public FormConfig getListFormConfig(String formId) {
        String formRuntimeMeta = this.getFormRuntimeMeta(formId, RuntimeMetaType.List, CONFIG);
        if (!StringUtils.isEmpty((CharSequence)formRuntimeMeta)) {
            return (FormConfig)this.toFormConfig(formRuntimeMeta);
        }
        return null;
    }

    public FormConfig getMobListFormConfig(String formId) {
        String formRuntimeMeta = this.getFormRuntimeMeta(formId, RuntimeMetaType.MobList, CONFIG);
        if (!StringUtils.isEmpty((CharSequence)formRuntimeMeta)) {
            return (FormConfig)SerializationUtils.fromJsonString((String)formRuntimeMeta, FormConfig.class);
        }
        return null;
    }

    public Map<String, Object> getFilterMeta(String formId) {
        String formRuntimeMeta = this.getFormRuntimeMeta(formId, RuntimeMetaType.List, FILTER);
        if (!StringUtils.isEmpty((CharSequence)formRuntimeMeta)) {
            return (Map)SerializationUtils.fromJsonString((String)formRuntimeMeta, Map.class);
        }
        return new HashMap<String, Object>(16);
    }

    public Object getListQingView(String billFormId) {
        String formRuntimeMeta = this.getFormRuntimeMeta(billFormId, RuntimeMetaType.List, QINGVIEW);
        if (!StringUtils.isEmpty((CharSequence)formRuntimeMeta)) {
            return ControlTypes.fromJsonString((String)formRuntimeMeta);
        }
        return null;
    }

    public BinderMap getBinderMap(String formId) {
        String formMetaStr = this.metadataService.loadFormRuntimeMeta(formId, RuntimeMetaType.Control.getValue(), "_bindermap_");
        if (StringUtils.isBlank((CharSequence)formMetaStr)) {
            return null;
        }
        return (BinderMap)ControlTypes.fromJsonString((String)formMetaStr);
    }

    public AbstractOperateWebApi getFormOperationApi(String entityId, String operationKey) {
        HashMap<String, String> op;
        String operateStr = this.metadataService.loadEntityRuntimeMeta(entityId, (int)RuntimeMetaType.Operate.getValue(), operationKey);
        if (!StringUtils.isEmpty((CharSequence)operateStr)) {
            op = (HashMap<String, String>)SerializationUtils.fromJsonString((String)operateStr, Map.class);
        } else {
            op = new HashMap<String, String>(16);
            op.put("webapi", operationKey);
        }
        String api = (String)op.get("webapi");
        if (api == null) {
            api = "kd.bos.entity.operate.webapi.DefaultOperate";
        }
        AbstractOperateWebApi operate = (AbstractOperateWebApi)TypesContainer.createInstance((String)api);
        operate.setOperationNumber(operationKey);
        return operate;
    }
}

