/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.metadata.dao;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import kd.bos.dataentity.SqlParameter;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.metadata.AbstractMetadata;
import kd.bos.metadata.ShareMetaBuildContext;
import kd.bos.metadata.ShareMetaBuildContextHolder;
import kd.bos.metadata.dao.ExtMetadataNode;
import kd.bos.metadata.dao.MetadataNode;
import kd.bos.metadata.dao.MetadataReader;
import kd.bos.metadata.dao.MetadataSerializer;
import kd.bos.metadata.dao.MetadataTree;
import kd.bos.service.ServiceFactory;
import kd.bos.service.metadata.ShareMetaAppConfigService;

public abstract class ShareMetadataBuilder {
    private static final String SQL_PARENTID = "select FId,FParentID, FDATA, FVERSION from %s where FID in('%s') ";
    private static final String SQL_INHERITPATH = "select FId,FInheritPath from %s where FID  = ? ";
    private String appGroup;

    public String getAppGroup() {
        return this.appGroup;
    }

    public void setAppGroup(String appGroup) {
        this.appGroup = appGroup;
    }

    protected boolean isGrayDeploy() {
        return StringUtils.isNotBlank((CharSequence)this.getAppGroup()) && !"defaultGroup".equals(this.getAppGroup());
    }

    protected abstract String getAllMetaSql();

    protected abstract AbstractMetadata readBaseMeta(String var1);

    protected abstract String getNumberById(String var1);

    public static String getMetaBizAppId(String bizAppId) {
        ShareMetaAppConfigService service = (ShareMetaAppConfigService)ServiceFactory.getService(ShareMetaAppConfigService.class);
        return service.getExtAppId(bizAppId);
    }

    public ShareMetaBuildContextHolder buildRuntimeMetaList(String masterId, String currentMetaId) {
        String sql = this.getAllMetaSql();
        Object[] sqlParameters = new SqlParameter[]{new SqlParameter(":FMasterID", 12, (Object)masterId), new SqlParameter(":FID", 12, (Object)masterId)};
        List listAll = (List)DB.query((DBRoute)DBRoute.meta, (String)sql, (Object[])sqlParameters, rs -> {
            ArrayList<ExtMetadataNode> metadataList = new ArrayList<ExtMetadataNode>(rs.getRow());
            while (rs.next()) {
                ExtMetadataNode childMeta = new ExtMetadataNode(rs.getString("FMasterID"), rs.getString("FID"), rs.getString("FParentID"), rs.getString("FData"));
                childMeta.setIsv(rs.getString("FISV"));
                childMeta.setBizappId(rs.getString("FBizAppId"));
                childMeta.setDevType(rs.getString("FType"));
                metadataList.add(childMeta);
            }
            return metadataList;
        });
        AbstractMetadata metadata = this.readBaseMeta(currentMetaId);
        if (metadata == null) {
            return new ShareMetaBuildContextHolder();
        }
        HashMap<String, List<ExtMetadataNode>> mapExt = new HashMap<String, List<ExtMetadataNode>>();
        listAll.forEach(o -> mapExt.computeIfAbsent(o.getParentId(), k -> new ArrayList()).add(o));
        HashMap<String, List<ExtMetadataNode>> mapListAll = new HashMap<String, List<ExtMetadataNode>>();
        Optional<ExtMetadataNode> first = listAll.stream().filter(o -> o.getId().equals(currentMetaId)).findFirst();
        ExtMetadataNode parentNode = null;
        if (!first.isPresent()) {
            throw new KDException(BosErrorCode.bOS, new Object[]{ResManager.loadKDString((String)"\u5143\u6570\u636e\u5f02\u5e38\uff0c\u672a\u627e\u5230\u5f53\u524d\u5143\u6570\u636e\u3002", (String)"ShareMetadataBuilder_0", (String)"bos-sharemetadata-provider", (Object[])new Object[0])});
        }
        parentNode = first.get();
        String key = this.getExtMetaKey(parentNode);
        ArrayList<ExtMetadataNode> listParent = new ArrayList<ExtMetadataNode>();
        listParent.add(parentNode);
        mapListAll.put(key, listParent);
        this.fillShareExtend(parentNode, mapExt, mapListAll);
        MetadataSerializer serializer = new MetadataSerializer(metadata.getModelType());
        MetadataReader reader = new MetadataReader();
        String number = this.getNumberById(masterId);
        ShareMetaBuildContextHolder holder = new ShareMetaBuildContextHolder();
        List<MetadataNode> templateRootNodes = this.getParentNodes(masterId);
        for (Map.Entry entry : mapListAll.entrySet()) {
            List<MetadataNode> rootNodes = this.getParentNodesList(listAll, parentNode.clone());
            templateRootNodes.addAll(rootNodes);
            MetadataTree tree = new MetadataTree(templateRootNodes);
            tree.fillExtends(this.cloneList((List)entry.getValue()));
            AbstractMetadata formAllMeta = reader.buildMetadata(serializer.getBinder(), tree);
            ShareMetaBuildContext context = this.getShareMetaBuildContext(number, (List)entry.getValue(), formAllMeta);
            formAllMeta.setId(masterId);
            holder.put(formAllMeta, context);
        }
        return holder;
    }

    protected abstract IDataEntityType getDesignerMetaType();

    private List<MetadataNode> getParentNodes(String masterId) {
        IDataEntityType designerMetaType = this.getDesignerMetaType();
        String tableName = designerMetaType.getAlias();
        String sqlInherit = String.format(SQL_INHERITPATH, tableName);
        Object[] params = new SqlParameter[]{new SqlParameter(":FID", 12, (Object)masterId)};
        String path = (String)DB.query((DBRoute)this.getDbRoute(designerMetaType), (String)sqlInherit, (Object[])params, rs -> {
            if (rs.next()) {
                return rs.getString("FInheritPath");
            }
            return "";
        });
        String sql = String.format(SQL_PARENTID, tableName, path.replace(",", "','"));
        params = new SqlParameter[]{};
        ResultSetHandler<List<MetadataNode>> action = new ResultSetHandler<List<MetadataNode>>(){

            public List<MetadataNode> handle(ResultSet rs) throws Exception {
                ArrayList<MetadataNode> list = new ArrayList<MetadataNode>(10);
                while (rs.next()) {
                    String id = rs.getString("FId");
                    String parentId = rs.getString("FParentID");
                    String version = rs.getString("FVERSION");
                    MetadataNode node = new MetadataNode(id, parentId, rs.getString("FDATA"), true);
                    node.setVersion(version);
                    list.add(node);
                }
                return list;
            }
        };
        return (List)DB.query((DBRoute)this.getDbRoute(designerMetaType), (String)sql, (Object[])params, (ResultSetHandler)action);
    }

    private DBRoute getDbRoute(IDataEntityType metaType) {
        String dbRouteKey = metaType.getDBRouteKey();
        return StringUtils.isBlank((CharSequence)dbRouteKey) ? DBRoute.meta : DBRoute.of((String)dbRouteKey);
    }

    private List<MetadataNode> getParentNodesList(List<ExtMetadataNode> listAll, ExtMetadataNode parentNode) {
        ArrayList<MetadataNode> nodes = new ArrayList<MetadataNode>();
        HashMap mapNodes = new HashMap();
        listAll.forEach(o -> mapNodes.computeIfAbsent(o.getId(), k -> o));
        nodes.add((MetadataNode)parentNode.clone());
        while (StringUtils.isNotBlank((CharSequence)parentNode.getParentId())) {
            ExtMetadataNode temp = (ExtMetadataNode)mapNodes.get(parentNode.getParentId());
            if (temp != null) {
                parentNode = temp;
                nodes.add((MetadataNode)parentNode.clone());
                continue;
            }
            parentNode.setParentId("");
            break;
        }
        return nodes;
    }

    protected void setShareMetaBuildContext(String metaNumber, AbstractMetadata formAllMeta, ShareMetaBuildContext context) {
    }

    private ShareMetaBuildContext getShareMetaBuildContext(String metaNumber, List<ExtMetadataNode> nodeList, AbstractMetadata formAllMeta) {
        ShareMetaBuildContext shareMetaBuildContext = new ShareMetaBuildContext();
        shareMetaBuildContext.setId(formAllMeta.getId());
        if (nodeList.isEmpty()) {
            shareMetaBuildContext.setLastId(formAllMeta.getId());
            shareMetaBuildContext.setExtAppId(formAllMeta.getBizappId());
            shareMetaBuildContext.setIsv(formAllMeta.getIsv());
            shareMetaBuildContext.setDevType(formAllMeta.getDevType());
        } else {
            ExtMetadataNode lastMeta = nodeList.get(nodeList.size() - 1);
            shareMetaBuildContext.setLastId(lastMeta.getId());
            shareMetaBuildContext.setExtAppId(lastMeta.getBizappId());
            shareMetaBuildContext.setIsv(lastMeta.getIsv());
            shareMetaBuildContext.setDevType(lastMeta.getDevType());
        }
        this.setShareMetaBuildContext(metaNumber, formAllMeta, shareMetaBuildContext);
        return shareMetaBuildContext;
    }

    private List<ExtMetadataNode> cloneList(List<ExtMetadataNode> list) {
        ArrayList<ExtMetadataNode> cloneList = new ArrayList<ExtMetadataNode>(list.size());
        for (ExtMetadataNode extMetadataNode : list) {
            cloneList.add(extMetadataNode.clone());
        }
        return cloneList;
    }

    private void fillShareExtend(ExtMetadataNode currentNodeId, Map<String, List<ExtMetadataNode>> mapExt, Map<String, List<ExtMetadataNode>> mapListAll) {
        if (!mapExt.containsKey(currentNodeId.getId())) {
            return;
        }
        for (ExtMetadataNode child : mapExt.get(currentNodeId.getId())) {
            String key = this.getExtMetaKey(child);
            List list = mapListAll.computeIfAbsent(key, k -> {
                ArrayList newList = new ArrayList();
                if (mapListAll.containsKey(this.getExtMetaKey(currentNodeId))) {
                    newList.addAll((Collection)mapListAll.get(this.getExtMetaKey(currentNodeId)));
                }
                return newList;
            });
            list.add(child);
            if (!mapExt.containsKey(child.getId())) continue;
            this.fillShareExtend(child, mapExt, mapListAll);
        }
    }

    private String getExtMetaKey(ExtMetadataNode child) {
        String key = this.isKingdee(child.getIsv()) ? "kingdee" : child.getBizappId();
        return key;
    }

    private boolean isKingdee(String isv) {
        return "kingdee".equals(isv) || StringUtils.isEmpty((CharSequence)isv);
    }
}

