/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.service;

import java.io.Serializable;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.service.TimeService;
import kd.sdk.annotation.SdkInternal;
import kd.sdk.annotation.SdkPublic;

@SdkPublic
public class InteTimeZone
implements Serializable {
    private static final long serialVersionUID = 1L;
    private TimeZone timeZone;
    private DynamicObject info;
    private String timeArea;

    public InteTimeZone() {
    }

    public InteTimeZone(DynamicObject info) {
        this.setInfo1(info);
    }

    public TimeZone getTimeZone() {
        if (this.timeZone == null) {
            this.timeZone = TimeZone.getTimeZone("Asia/Shanghai");
        }
        return this.timeZone;
    }

    public void setTimeZone(TimeZone timeZone) {
        this.timeZone = timeZone;
    }

    public String getTimeArea() {
        return this.timeArea;
    }

    public DynamicObject getInfo() {
        return this.info;
    }

    public void setInfo(DynamicObject info) {
        this.setInfo1(info);
    }

    private void setInfo1(DynamicObject info) {
        this.info = info;
        if (info != null) {
            this.timeArea = info.getString("number");
            this.setTimeZone(TimeZone.getTimeZone(this.timeArea));
        }
    }

    public String getTimeZoneDesc() {
        return this.info != null ? this.info.getLocaleString("simplecode").toString() : new LocaleString(ResManager.loadKDString((String)"\u5317\u4eac", (String)"InteTimeZone_0", (String)"bos-core-api", (Object[])new Object[0])).toString();
    }

    public String format(Date datetime) {
        return this.format(datetime, null);
    }

    public String format(Date datetime, DateFormat format) {
        DateFormat newFormat = format;
        if (datetime == null) {
            return null;
        }
        if (format == null) {
            newFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        }
        newFormat.setTimeZone(this.getTimeZone());
        return newFormat.format(datetime);
    }

    public Date parse(String datetime) throws ParseException {
        return this.parse(datetime, null);
    }

    public Date parse(String datetime, DateFormat format) throws ParseException {
        DateFormat newDataeFormat = format;
        if (newDataeFormat == null) {
            newDataeFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        }
        newDataeFormat.setTimeZone(this.getTimeZone());
        return newDataeFormat.parse(datetime);
    }

    public Date parseDate(String date) throws ParseException {
        return this.parseDate(date, null);
    }

    public Date parseDate(String date, DateFormat format) throws ParseException {
        DateFormat newDataeFormat = format;
        if (newDataeFormat == null) {
            newDataeFormat = new SimpleDateFormat("yyyy-MM-dd");
        }
        newDataeFormat.setTimeZone(this.getTimeZone());
        return newDataeFormat.parse(date);
    }

    public static InteTimeZone getUserTimeZone(long userId) {
        return new TimeService().getUserTimeZone(userId);
    }

    public static InteTimeZone getOrgTimeZone(Long orgId) {
        return new TimeService().getOrgTimeZone(orgId);
    }

    public static InteTimeZone getSysTimeZone() {
        return new TimeService().getSysTimeZone();
    }

    @Deprecated
    @SdkInternal
    public static enum TransType {
        SysTimeZone(0),
        UserTimeZone(1),
        OrgTimeZone(2);

        int value;

        public int getValue() {
            return this.value;
        }

        private TransType(int value) {
            this.value = value;
        }

        public static TransType get(int value) {
            switch (value) {
                case 1: {
                    return UserTimeZone;
                }
                case 2: {
                    return OrgTimeZone;
                }
            }
            return SysTimeZone;
        }
    }
}

