/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.service;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.DayOfWeek;
import java.time.LocalDate;
import java.time.Month;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAdjusters;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.inte.api.IInteService;
import kd.bos.service.InteTimeZone;
import kd.bos.service.KDDateFormatUtils;
import kd.bos.service.ServiceFactory;
import kd.sdk.annotation.SdkPublic;
import org.apache.commons.lang3.time.DateUtils;

@SdkPublic
public class KDDateUtils {
    private static final String KD_DATE_UTILS_0 = "KDDateUtils_0";
    private static final String BOS_CORE_API = "bos-core-api";
    private static final String NUMBER = "number";

    private KDDateUtils() {
    }

    public static Date parseDate(String dateString) {
        try {
            return KDDateFormatUtils.getDateFormat().parse(dateString);
        }
        catch (ParseException e) {
            throw new KDBizException(BosErrorCode.filterSqlBuilder, String.format(ResManager.loadKDString((String)"%s\u4e0d\u662f\u6709\u6548\u7684\u5f53\u524d\u65f6\u533a\u65f6\u95f4\u683c\u5f0f", (String)KD_DATE_UTILS_0, (String)BOS_CORE_API, (Object[])new Object[0]), dateString));
        }
    }

    public static Date parseDateTime(String dateTimeString) {
        try {
            return KDDateFormatUtils.getDateTimeFormat().parse(dateTimeString);
        }
        catch (ParseException e) {
            throw new KDBizException(BosErrorCode.filterSqlBuilder, String.format(ResManager.loadKDString((String)"%s\u4e0d\u662f\u6709\u6548\u7684\u5f53\u524d\u65f6\u533a\u65f6\u95f4\u683c\u5f0f", (String)KD_DATE_UTILS_0, (String)BOS_CORE_API, (Object[])new Object[0]), dateTimeString));
        }
    }

    public static Date parseToSystemTimeZoneDateTime(String dateTimeString) {
        try {
            return KDDateFormatUtils.getSystemTimeZoneDateFormat().parse(dateTimeString);
        }
        catch (ParseException e) {
            throw new KDBizException(BosErrorCode.filterSqlBuilder, String.format(ResManager.loadKDString((String)"%s\u4e0d\u662f\u6709\u6548\u7684\u5f53\u524d\u65f6\u533a\u65f6\u95f4\u683c\u5f0f", (String)KD_DATE_UTILS_0, (String)BOS_CORE_API, (Object[])new Object[0]), dateTimeString));
        }
    }

    public static Date parseToSystemTimeZoneDate(String dateTimeString) {
        try {
            return KDDateFormatUtils.getDateFormat(KDDateUtils.getSysTimeZone()).parse(dateTimeString);
        }
        catch (ParseException e) {
            throw new KDBizException(BosErrorCode.filterSqlBuilder, String.format(ResManager.loadKDString((String)"%s\u4e0d\u662f\u6709\u6548\u7684\u5f53\u524d\u65f6\u533a\u65f6\u95f4\u683c\u5f0f", (String)KD_DATE_UTILS_0, (String)BOS_CORE_API, (Object[])new Object[0]), dateTimeString));
        }
    }

    public static TimeZone getOrgTimeZone(Long orgId) {
        IInteService service = ServiceFactory.getService(IInteService.class);
        DynamicObject orgTimezoneMeta = service.getOrgTimezone(orgId);
        if (orgTimezoneMeta != null) {
            String timeArea = orgTimezoneMeta.getString(NUMBER);
            return TimeZone.getTimeZone(timeArea);
        }
        return KDDateUtils.getSysTimeZone();
    }

    public static TimeZone getUserTimeZone() {
        long userId;
        IInteService service = ServiceFactory.getService(IInteService.class);
        DynamicObject userTimezoneMeta = service.getUserTimezone(userId = Long.parseLong(RequestContext.get().getUserId()));
        if (userTimezoneMeta != null) {
            String timeArea = userTimezoneMeta.getString(NUMBER);
            return TimeZone.getTimeZone(timeArea);
        }
        return KDDateUtils.getSysTimeZone();
    }

    public static TimeZone getSysTimeZone() {
        IInteService service = ServiceFactory.getService(IInteService.class);
        DynamicObject sysTimezoneMeta = service.getSysTimezone();
        String timeArea = sysTimezoneMeta.getString(NUMBER);
        return TimeZone.getTimeZone(timeArea);
    }

    public static InteTimeZone getInteSysTimeZone() {
        IInteService service = ServiceFactory.getService(IInteService.class);
        DynamicObject sysTimezoneObj = service.getSysTimezone();
        return new InteTimeZone(sysTimezoneObj);
    }

    public static TimeZone getTimeZone() {
        boolean isNeedTimeTransfer;
        long date = new Date().getTime();
        TimeZone userTimeZone = KDDateUtils.getUserTimeZone();
        TimeZone sysTimeZone = KDDateUtils.getSysTimeZone();
        boolean bl = isNeedTimeTransfer = userTimeZone.getOffset(date) - sysTimeZone.getOffset(date) != 0;
        if (isNeedTimeTransfer) {
            return userTimeZone;
        }
        return sysTimeZone;
    }

    public static Date userTimeZoneToSystemTimeZoneToday() {
        ZoneId userZoneId = KDDateUtils.getUserTimeZone().toZoneId();
        ZonedDateTime userInSys = ZonedDateTime.now(userZoneId);
        ZonedDateTime midNightInSys = userInSys.toLocalDate().atStartOfDay(userZoneId);
        ZonedDateTime sysInUser = midNightInSys.withZoneSameInstant(KDDateUtils.getSysTimeZone().toZoneId());
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss z");
        sdf.setTimeZone(KDDateUtils.getSysTimeZone());
        try {
            return sdf.parse(sysInUser.format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss z")));
        }
        catch (ParseException e) {
            throw new KDBizException(BosErrorCode.filterSqlBuilder, String.format(ResManager.loadKDString((String)"%s\u4e0d\u662f\u6709\u6548\u7684\u5f53\u524d\u65f6\u533a\u65f6\u95f4\u683c\u5f0f", (String)KD_DATE_UTILS_0, (String)BOS_CORE_API, (Object[])new Object[0]), "yyyy-MM-dd HH:mm:ss"));
        }
    }

    public static Date today() {
        return DateUtils.truncate((Date)KDDateUtils.now(), (int)5);
    }

    public static Date now() {
        DateFormat systemTimeZoneDateFormat = KDDateFormatUtils.getSystemTimeZoneDateFormat();
        DateFormat userZoneDateFormat = KDDateFormatUtils.getUserZoneDateFormat();
        String format = userZoneDateFormat.format(new Date());
        try {
            return systemTimeZoneDateFormat.parse(format);
        }
        catch (ParseException e) {
            throw new KDBizException(BosErrorCode.filterSqlBuilder, String.format(ResManager.loadKDString((String)"%s\u4e0d\u662f\u6709\u6548\u7684\u5f53\u524d\u65f6\u533a\u65f6\u95f4\u683c\u5f0f", (String)KD_DATE_UTILS_0, (String)BOS_CORE_API, (Object[])new Object[0]), "yyyy-MM-dd HH:mm:ss"));
        }
    }

    public static Date addYears(Date date, int amount) {
        return KDDateUtils.add(date, 1, amount);
    }

    public static Date addMonths(Date date, int amount) {
        return KDDateUtils.add(date, 2, amount);
    }

    public static Date addWeeks(Date date, int amount) {
        return KDDateUtils.add(date, 7, amount * 7);
    }

    public static Date addDays(Date date, int amount) {
        return KDDateUtils.add(date, 5, amount);
    }

    public static Date addHours(Date date, int amount) {
        return KDDateUtils.add(date, 11, amount);
    }

    public static Date addMinutes(Date date, int amount) {
        return KDDateUtils.add(date, 12, amount);
    }

    public static Date addSeconds(Date date, int amount) {
        return KDDateUtils.add(date, 13, amount);
    }

    public static Date addMilliseconds(Date date, int amount) {
        return KDDateUtils.add(date, 14, amount);
    }

    public static Date add(Date time, int calendarField, int amount) {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(time);
        ((Calendar)calendar).add(calendarField, amount);
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        simpleDateFormat.setTimeZone(KDDateUtils.getSysTimeZone());
        String formatDateTime = simpleDateFormat.format(calendar.getTime());
        return KDDateUtils.parseDateTime(formatDateTime);
    }

    public static Date getTheWeekStart(int amount) {
        return KDDateUtils.getTheWeekStart(amount, KDDateUtils.today());
    }

    public static Date getTheWeekStart(int amount, Date baseDate) {
        Calendar cal = KDDateUtils.getFirstDayOfWeekByDate(baseDate, 2);
        return DateUtils.addDays((Date)cal.getTime(), (int)(0 + amount * 7));
    }

    public static Date getTheWeekStart(int amount, int firstDayOfWeek) {
        return KDDateUtils.getTheWeekStart(amount, KDDateUtils.today(), firstDayOfWeek);
    }

    public static Date getTheWeekStart(int amount, TimeZone userTimeZone, DayOfWeek dayOfWeek) {
        ZoneId zoneIdUser = userTimeZone.toZoneId();
        ZoneId zoneIdSys = KDDateUtils.getSysTimeZone().toZoneId();
        ZonedDateTime nowInUser = ZonedDateTime.now(zoneIdUser);
        ZonedDateTime startOfWeekUser = nowInUser.with(TemporalAdjusters.previousOrSame(dayOfWeek)).toLocalDate().atStartOfDay(zoneIdUser).plusWeeks(amount);
        ZonedDateTime startOfWeekInSys = startOfWeekUser.withZoneSameInstant(zoneIdSys);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss z");
        sdf.setTimeZone(KDDateUtils.getSysTimeZone());
        try {
            return sdf.parse(startOfWeekInSys.format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss z")));
        }
        catch (ParseException e) {
            throw new KDBizException(BosErrorCode.filterSqlBuilder, String.format(ResManager.loadKDString((String)"%s\u4e0d\u662f\u6709\u6548\u7684\u5f53\u524d\u65f6\u533a\u65f6\u95f4\u683c\u5f0f", (String)KD_DATE_UTILS_0, (String)BOS_CORE_API, (Object[])new Object[0]), "yyyy-MM-dd HH:mm:ss"));
        }
    }

    public static Date getTheWeekEnd(Date firstDayOfWeek) {
        return DateUtils.addDays((Date)firstDayOfWeek, (int)7);
    }

    public static Date getTheMonthStart(int amount, TimeZone userTimeZone) {
        return KDDateUtils.getTheMonthStart(amount, userTimeZone, KDDateUtils.getSysTimeZone());
    }

    public static Date getTheMonthStart(int amount, TimeZone userTimeZone, TimeZone sysTimeZone) {
        ZoneId zoneIdUser = userTimeZone.toZoneId();
        ZoneId zoneIdSys = sysTimeZone.toZoneId();
        ZonedDateTime nowInUser = ZonedDateTime.now(zoneIdUser);
        ZonedDateTime startOfMonthUser = nowInUser.with(TemporalAdjusters.firstDayOfMonth()).toLocalDate().atStartOfDay(zoneIdUser).plusMonths(amount);
        ZonedDateTime startOfMonthInSys = startOfMonthUser.withZoneSameInstant(zoneIdSys);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss z");
        sdf.setTimeZone(sysTimeZone);
        try {
            return sdf.parse(startOfMonthInSys.format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss z")));
        }
        catch (ParseException e) {
            throw new KDBizException(BosErrorCode.filterSqlBuilder, String.format(ResManager.loadKDString((String)"%s\u4e0d\u662f\u6709\u6548\u7684\u5f53\u524d\u65f6\u533a\u65f6\u95f4\u683c\u5f0f", (String)KD_DATE_UTILS_0, (String)BOS_CORE_API, (Object[])new Object[0]), "yyyy-MM-dd HH:mm:ss"));
        }
    }

    public static Date getTheMonthEnd(int amount, TimeZone userTimeZone) {
        return KDDateUtils.getTheMonthEnd(amount, userTimeZone, KDDateUtils.getSysTimeZone());
    }

    public static Date getTheMonthEnd(int amount, TimeZone userTimeZone, TimeZone sysTimeZone) {
        ZoneId zoneIdUser = userTimeZone.toZoneId();
        ZoneId zoneIdSys = sysTimeZone.toZoneId();
        ZonedDateTime nowInUser = ZonedDateTime.now(zoneIdUser);
        ZonedDateTime startOfMonthUser = nowInUser.plusMonths(amount).with(TemporalAdjusters.lastDayOfMonth()).toLocalDate().atStartOfDay(zoneIdUser).plusDays(1L);
        ZonedDateTime endOfMonthInSys = startOfMonthUser.withZoneSameInstant(zoneIdSys);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss z");
        sdf.setTimeZone(sysTimeZone);
        try {
            return sdf.parse(endOfMonthInSys.format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss z")));
        }
        catch (ParseException e) {
            throw new KDBizException(BosErrorCode.filterSqlBuilder, String.format(ResManager.loadKDString((String)"%s\u4e0d\u662f\u6709\u6548\u7684\u5f53\u524d\u65f6\u533a\u65f6\u95f4\u683c\u5f0f", (String)KD_DATE_UTILS_0, (String)BOS_CORE_API, (Object[])new Object[0]), "yyyy-MM-dd HH:mm:ss"));
        }
    }

    public static Date getTheWeekStart(int amount, Date baseDate, int firstDayOfWeek) {
        Calendar cal = KDDateUtils.getFirstDayOfWeekByDate(baseDate, firstDayOfWeek);
        return DateUtils.addDays((Date)cal.getTime(), (int)(amount * 7));
    }

    private static Calendar getFirstDayOfWeekByDate(Date baseDate, int firstDayOfWeek) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(baseDate);
        cal.setFirstDayOfWeek(firstDayOfWeek);
        int dayWeek = cal.get(7);
        if (firstDayOfWeek < dayWeek + 1) {
            cal.add(5, firstDayOfWeek - dayWeek);
        } else {
            cal.add(5, -dayWeek - (7 - firstDayOfWeek));
        }
        return cal;
    }

    public static Date getTheWeekEnd(int amount) {
        return KDDateUtils.getTheWeekEnd(amount, KDDateUtils.today());
    }

    public static Date getTheWeekEnd(int amount, Date baseDate) {
        Calendar cal = KDDateUtils.getFirstDayOfWeekByDate(baseDate, 2);
        return DateUtils.addDays((Date)cal.getTime(), (int)(7 + amount * 7));
    }

    public static Date getTheWeekEnd(int amount, int firstDayOfWeek) {
        return KDDateUtils.getTheWeekEnd(amount, KDDateUtils.today(), firstDayOfWeek);
    }

    public static Date getTheWeekEnd(int amount, Date baseDate, int firstDayOfWeek) {
        Calendar cal = KDDateUtils.getFirstDayOfWeekByDate(baseDate, firstDayOfWeek);
        return DateUtils.addDays((Date)cal.getTime(), (int)(7 + amount * 7));
    }

    public static Date getTheMonthStart(int amount) {
        return KDDateUtils.getTheMonthStart(amount, KDDateUtils.today());
    }

    public static Date getTheMonthStart(int amount, Date baseDate) {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(baseDate);
        ((Calendar)calendar).add(2, amount);
        calendar.set(5, ((Calendar)calendar).getActualMinimum(5));
        return DateUtils.addDays((Date)calendar.getTime(), (int)0);
    }

    public static Date getTheMonthEnd(int amount) {
        return KDDateUtils.getTheMonthEnd(amount, KDDateUtils.today());
    }

    public static Date getTheMonthEnd(int amount, Date baseDate) {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(baseDate);
        ((Calendar)calendar).add(2, amount);
        calendar.set(5, ((Calendar)calendar).getActualMaximum(5));
        return DateUtils.addDays((Date)calendar.getTime(), (int)1);
    }

    public static Date getTheQuarterStart(TimeZone userTimeZone, int amout) {
        return KDDateUtils.getTheQuarterStart(userTimeZone, KDDateUtils.getSysTimeZone(), amout);
    }

    public static Date getTheQuarterStart(TimeZone userTimeZone, TimeZone sysTimeZone, int amout) {
        ZoneId zoneIdUser = userTimeZone.toZoneId();
        ZoneId zoneIdSys = sysTimeZone.toZoneId();
        ZonedDateTime nowInUser = ZonedDateTime.now(zoneIdUser);
        ZonedDateTime nowInSys = nowInUser.withZoneSameInstant(zoneIdSys);
        int currentMonth = nowInUser.getMonthValue();
        int currentQuarter = (currentMonth - 1) / 3 + 1;
        int previousQuarter = currentQuarter + amout;
        int previousQuarterYear = nowInSys.getYear();
        if (previousQuarter == 0) {
            previousQuarter = 4;
            --previousQuarterYear;
        } else if (previousQuarter > 4) {
            previousQuarter = 1;
            ++previousQuarterYear;
        }
        Month firstMonthOfQuarter = Month.of((previousQuarter - 1) * 3 + 1);
        LocalDate firstDayOfQuarter = LocalDate.of(previousQuarterYear, firstMonthOfQuarter, 1);
        ZonedDateTime startOfQuarterInSys = firstDayOfQuarter.atStartOfDay(zoneIdUser).withZoneSameInstant(zoneIdSys);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss z");
        sdf.setTimeZone(sysTimeZone);
        try {
            return sdf.parse(startOfQuarterInSys.format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss z")));
        }
        catch (ParseException e) {
            throw new KDBizException(BosErrorCode.filterSqlBuilder, String.format(ResManager.loadKDString((String)"%s\u4e0d\u662f\u6709\u6548\u7684\u5f53\u524d\u65f6\u533a\u65f6\u95f4\u683c\u5f0f", (String)KD_DATE_UTILS_0, (String)BOS_CORE_API, (Object[])new Object[0]), "yyyy-MM-dd HH:mm:ss"));
        }
    }

    public static Date getTheQuarterEnd(TimeZone userTimeZone, int amout) {
        return KDDateUtils.getTheQuarterEnd(userTimeZone, KDDateUtils.getSysTimeZone(), amout);
    }

    public static Date getTheQuarterEnd(TimeZone userTimeZone, TimeZone sysTimeZone, int amout) {
        ZoneId zoneIdUser = userTimeZone.toZoneId();
        ZoneId zoneIdSys = sysTimeZone.toZoneId();
        ZonedDateTime nowInGMT9 = ZonedDateTime.now(zoneIdUser);
        ZonedDateTime nowInGMT8 = nowInGMT9.withZoneSameInstant(zoneIdSys);
        int currentMonth = nowInGMT9.getMonthValue();
        int currentQuarter = (currentMonth - 1) / 3 + 1;
        int previousQuarter = currentQuarter + amout;
        int previousQuarterYear = nowInGMT8.getYear();
        if (previousQuarter == 0) {
            previousQuarter = 4;
            --previousQuarterYear;
        } else if (previousQuarter > 4) {
            previousQuarter = 1;
            ++previousQuarterYear;
        }
        Month firstMonthOfQuarter = Month.of((previousQuarter - 1) * 3 + 1);
        Month lastMonthOfQuarter = firstMonthOfQuarter.plus(2L);
        LocalDate lastDayOfQuarter = LocalDate.of(previousQuarterYear, lastMonthOfQuarter, lastMonthOfQuarter.length(nowInGMT9.toLocalDate().isLeapYear()));
        ZonedDateTime endOfQuarterInSys = lastDayOfQuarter.atStartOfDay().atZone(zoneIdUser).plusDays(1L).withZoneSameInstant(zoneIdSys);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss z");
        sdf.setTimeZone(sysTimeZone);
        try {
            return sdf.parse(endOfQuarterInSys.format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss z")));
        }
        catch (ParseException e) {
            throw new KDBizException(BosErrorCode.filterSqlBuilder, String.format(ResManager.loadKDString((String)"%s\u4e0d\u662f\u6709\u6548\u7684\u5f53\u524d\u65f6\u533a\u65f6\u95f4\u683c\u5f0f", (String)KD_DATE_UTILS_0, (String)BOS_CORE_API, (Object[])new Object[0]), "yyyy-MM-dd HH:mm:ss"));
        }
    }

    public static Date getTheQuarterStart(int amount) {
        return KDDateUtils.getTheQuarterStart(amount, KDDateUtils.today());
    }

    public static Date getTheQuarterStart(int amount, Date baseDate) {
        Calendar calendar = KDDateUtils.getBasicQuarterDate(amount, baseDate);
        int quarter = KDDateUtils.getQuarter(calendar);
        return KDDateUtils.getTheQuarterStart(calendar, quarter);
    }

    public static Date getTheQuarterEnd(int amount) {
        return KDDateUtils.getTheQuarterEnd(amount, KDDateUtils.today());
    }

    public static Date getTheQuarterEnd(int amount, Date baseDate) {
        Calendar calendar = KDDateUtils.getBasicQuarterDate(amount, baseDate);
        int quarter = KDDateUtils.getQuarter(calendar);
        return KDDateUtils.getTheQuarterEnd(calendar, quarter);
    }

    private static Calendar getBasicQuarterDate(int amount, Date baseDate) {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(baseDate);
        ((Calendar)calendar).add(2, amount * 3);
        return calendar;
    }

    private static int getQuarter(Calendar c) {
        int month = c.get(2) + 1;
        int quarter = 0;
        quarter = month >= 1 && month <= 3 ? 1 : (month >= 4 && month <= 6 ? 2 : (month >= 7 && month <= 9 ? 3 : 4));
        return quarter;
    }

    private static Date getTheQuarterStart(Calendar quarterCalendar, int amount) {
        switch (amount) {
            case 1: {
                quarterCalendar.set(2, 0);
                quarterCalendar.set(5, quarterCalendar.getActualMinimum(5));
                return DateUtils.addDays((Date)quarterCalendar.getTime(), (int)0);
            }
            case 2: {
                quarterCalendar.set(2, 3);
                quarterCalendar.set(5, quarterCalendar.getActualMinimum(5));
                return DateUtils.addDays((Date)quarterCalendar.getTime(), (int)0);
            }
            case 3: {
                quarterCalendar.set(2, 6);
                quarterCalendar.set(5, quarterCalendar.getActualMinimum(5));
                return DateUtils.addDays((Date)quarterCalendar.getTime(), (int)0);
            }
            case 4: {
                quarterCalendar.set(2, 9);
                quarterCalendar.set(5, quarterCalendar.getActualMinimum(5));
                return DateUtils.addDays((Date)quarterCalendar.getTime(), (int)0);
            }
        }
        throw new KDBizException(String.format(ResManager.loadKDString((String)"\u4f20\u5165\u4e86\u4e0d\u6b63\u786e\u7684\u5b63\u5ea6\u503c%s", (String)"KDDateUtils_1", (String)BOS_CORE_API, (Object[])new Object[0]), amount));
    }

    private static Date getTheQuarterEnd(Calendar quarterCalendar, int amount) {
        switch (amount) {
            case 1: {
                quarterCalendar.set(2, 2);
                quarterCalendar.set(5, quarterCalendar.getActualMaximum(5));
                return DateUtils.addDays((Date)quarterCalendar.getTime(), (int)1);
            }
            case 2: {
                quarterCalendar.set(2, 5);
                quarterCalendar.set(5, quarterCalendar.getActualMaximum(5));
                return DateUtils.addDays((Date)quarterCalendar.getTime(), (int)1);
            }
            case 3: {
                quarterCalendar.set(2, 8);
                quarterCalendar.set(5, quarterCalendar.getActualMaximum(5));
                return DateUtils.addDays((Date)quarterCalendar.getTime(), (int)1);
            }
            case 4: {
                quarterCalendar.set(2, 11);
                quarterCalendar.set(5, quarterCalendar.getActualMaximum(5));
                return DateUtils.addDays((Date)quarterCalendar.getTime(), (int)1);
            }
        }
        throw new KDBizException(String.format(ResManager.loadKDString((String)"\u4f20\u5165\u4e86\u4e0d\u6b63\u786e\u7684\u5b63\u5ea6\u503c%s", (String)"KDDateUtils_1", (String)BOS_CORE_API, (Object[])new Object[0]), amount));
    }

    public static Date getTheYearStart(TimeZone userTimeZone, int amount) {
        ZoneId zoneIdUser = userTimeZone.toZoneId();
        ZoneId zoneIdSys = KDDateUtils.getSysTimeZone().toZoneId();
        ZonedDateTime nowInUser = ZonedDateTime.now(zoneIdUser);
        int previousYear = nowInUser.getYear() + amount;
        LocalDate firstDayOfPreviousYear = LocalDate.of(previousYear, Month.JANUARY, 1);
        ZonedDateTime startOfPreviousYearInUser = firstDayOfPreviousYear.atStartOfDay(zoneIdUser);
        ZonedDateTime startOfQuarterInSys = startOfPreviousYearInUser.withZoneSameInstant(zoneIdSys);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss z");
        sdf.setTimeZone(KDDateUtils.getSysTimeZone());
        try {
            return sdf.parse(startOfQuarterInSys.format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss z")));
        }
        catch (ParseException e) {
            throw new KDBizException(BosErrorCode.filterSqlBuilder, String.format(ResManager.loadKDString((String)"%s\u4e0d\u662f\u6709\u6548\u7684\u5f53\u524d\u65f6\u533a\u65f6\u95f4\u683c\u5f0f", (String)KD_DATE_UTILS_0, (String)BOS_CORE_API, (Object[])new Object[0]), "yyyy-MM-dd HH:mm:ss"));
        }
    }

    public static Date getTheYearEnd(TimeZone userTimeZone, int amount) {
        ZoneId zoneIdUser = userTimeZone.toZoneId();
        ZoneId zoneIdSys = KDDateUtils.getSysTimeZone().toZoneId();
        ZonedDateTime nowInUser = ZonedDateTime.now(zoneIdUser);
        int previousYear = nowInUser.getYear() + amount;
        LocalDate lastDayOfPreviousYear = LocalDate.of(previousYear, Month.DECEMBER, 31);
        ZonedDateTime endOfPreviousYearInUser = lastDayOfPreviousYear.atStartOfDay().atZone(zoneIdUser).plusDays(1L);
        ZonedDateTime endOfYearInSys = endOfPreviousYearInUser.withZoneSameInstant(zoneIdSys);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss z");
        sdf.setTimeZone(KDDateUtils.getSysTimeZone());
        try {
            return sdf.parse(endOfYearInSys.format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss z")));
        }
        catch (ParseException e) {
            throw new KDBizException(BosErrorCode.filterSqlBuilder, String.format(ResManager.loadKDString((String)"%s\u4e0d\u662f\u6709\u6548\u7684\u5f53\u524d\u65f6\u533a\u65f6\u95f4\u683c\u5f0f", (String)KD_DATE_UTILS_0, (String)BOS_CORE_API, (Object[])new Object[0]), "yyyy-MM-dd HH:mm:ss"));
        }
    }

    public static Date getTheYearStart(int amount) {
        return KDDateUtils.getTheYearStart(amount, KDDateUtils.today());
    }

    public static Date getTheYearStart(int amount, Date baseDate) {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(baseDate);
        ((Calendar)calendar).add(1, amount);
        calendar.set(6, ((Calendar)calendar).getActualMinimum(6));
        return DateUtils.addDays((Date)calendar.getTime(), (int)0);
    }

    public static Date getTheYearEnd(int amount) {
        return KDDateUtils.getTheYearEnd(amount, KDDateUtils.today());
    }

    public static Date getTheYearEnd(int amount, Date baseDate) {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(baseDate);
        ((Calendar)calendar).add(1, amount);
        calendar.set(6, ((Calendar)calendar).getActualMaximum(6));
        return DateUtils.addDays((Date)calendar.getTime(), (int)1);
    }
}

