/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.formula.platform.api;

import java.util.List;
import kd.bos.formula.platform.api.IFormulaGrammarVerifier;
import kd.bos.formula.platform.api.KScriptFormulaParser;
import kd.bos.kscript.ParserException;
import kd.bos.kscript.dom.expr.BinaryOpExpr;
import kd.bos.kscript.dom.expr.BoolExpr;
import kd.bos.kscript.dom.expr.CodeExpr;
import kd.bos.kscript.dom.expr.DoubleExpr;
import kd.bos.kscript.dom.expr.FloatExpr;
import kd.bos.kscript.dom.expr.IdentifierExpr;
import kd.bos.kscript.dom.expr.IntExpr;
import kd.bos.kscript.dom.expr.LongExpr;
import kd.bos.kscript.dom.expr.MethodInvokeExpr;
import kd.bos.kscript.dom.expr.NullExpr;
import kd.bos.kscript.dom.expr.ObjectCreateExpr;
import kd.bos.kscript.dom.expr.PropertyExpr;
import kd.bos.kscript.dom.expr.StringExpr;
import kd.bos.kscript.dom.stmt.BlockStmt;
import kd.bos.kscript.dom.stmt.CodeStmt;
import kd.bos.kscript.dom.stmt.DoStmt;
import kd.bos.kscript.dom.stmt.ElseIfItem;
import kd.bos.kscript.dom.stmt.ExprStmt;
import kd.bos.kscript.dom.stmt.ForStmt;
import kd.bos.kscript.dom.stmt.IfStmt;
import kd.bos.kscript.dom.stmt.ReturnStmt;
import kd.bos.kscript.dom.stmt.VarDeclStmt;
import kd.bos.kscript.dom.stmt.WhileStmt;
import kd.bos.kscript.parser.KScriptParser;

class FormulaGrammarVerifier
implements IFormulaGrammarVerifier {
    FormulaGrammarVerifier() {
    }

    @Override
    public boolean isCompatibleWithKScript(String formulaStr) {
        if (formulaStr == null) {
            return false;
        }
        try {
            KScriptFormulaParser.parseFormulaStr(formulaStr);
            return true;
        }
        catch (ParserException e) {
            return false;
        }
        catch (Exception ee) {
            return false;
        }
    }

    @Override
    public boolean isCompatibleWithBOSFormula(String formulaStr) {
        if (formulaStr == null) {
            return false;
        }
        try {
            KScriptParser parser = KScriptFormulaParser.parseFormulaStr(formulaStr);
            if (parser == null) {
                return false;
            }
            List stmtList = parser.stmtList;
            for (int i = 0; i < stmtList.size(); ++i) {
                CodeStmt codeStmt = (CodeStmt)stmtList.get(i);
                if (!this.isStmtInvalid(codeStmt)) continue;
                return false;
            }
            return true;
        }
        catch (ParserException e) {
            return false;
        }
    }

    @Override
    public boolean hasSetFormulaResult(String formulaStr) {
        if (formulaStr == null) {
            return false;
        }
        try {
            KScriptParser parser = KScriptFormulaParser.parseFormulaStr(formulaStr);
            if (parser == null) {
                return false;
            }
            List stmtList = parser.stmtList;
            return this.isStmtListSetResult(stmtList);
        }
        catch (ParserException e) {
            return false;
        }
    }

    private boolean isStmtListSetResult(List stmtList) {
        if (stmtList == null) {
            return false;
        }
        for (int i = 0; i < stmtList.size(); ++i) {
            CodeStmt codeStmt = (CodeStmt)stmtList.get(i);
            if (!(codeStmt instanceof ExprStmt ? this.isExprSetResult(((ExprStmt)codeStmt).expr) : (codeStmt instanceof IfStmt ? this.isIfStmtSetResult((IfStmt)codeStmt) : codeStmt instanceof BlockStmt && this.isStmtListSetResult(((BlockStmt)codeStmt).stmtList)))) continue;
            return true;
        }
        return false;
    }

    private boolean isIfStmtSetResult(IfStmt ifStmt) {
        List elseStmtList = ifStmt.elseStmtList;
        List trueStmtList = ifStmt.trueStmtList;
        List elseIfList = ifStmt.elseIfList;
        if (this.isStmtListSetResult(trueStmtList)) {
            return true;
        }
        if (this.isStmtListSetResult(elseStmtList)) {
            return true;
        }
        for (int i = 0; i < elseIfList.size(); ++i) {
            ElseIfItem elseIfItem = (ElseIfItem)elseIfList.get(i);
            if (!this.isStmtListSetResult(elseIfItem.stmtList)) continue;
            return true;
        }
        return false;
    }

    private boolean isExprSetResult(CodeExpr codeExpr) {
        if (codeExpr == null) {
            return false;
        }
        if (codeExpr instanceof BinaryOpExpr) {
            IdentifierExpr idExpr;
            BinaryOpExpr bopExpr = (BinaryOpExpr)codeExpr;
            CodeExpr lExpr = bopExpr.left;
            CodeExpr rExpr = bopExpr.right;
            if (lExpr != null && rExpr != null && bopExpr.operator == 2 && lExpr instanceof IdentifierExpr && "formula_result".equals((idExpr = (IdentifierExpr)lExpr).toString())) {
                return true;
            }
        }
        return false;
    }

    private boolean isStmtInvalid(CodeStmt codeStmt) {
        if (codeStmt instanceof VarDeclStmt) {
            return false;
        }
        if (codeStmt instanceof ExprStmt) {
            ExprStmt exprStmt = (ExprStmt)codeStmt;
            return this.isExprInvalid(exprStmt.expr);
        }
        if (codeStmt instanceof IfStmt) {
            int i;
            IfStmt ifStmt = (IfStmt)codeStmt;
            CodeExpr testExpr = ifStmt.testExpr;
            List elseStmtList = ifStmt.elseStmtList;
            List trueStmtList = ifStmt.trueStmtList;
            List elseIfList = ifStmt.elseIfList;
            if (this.isExprInvalid(testExpr)) {
                return true;
            }
            for (i = 0; i < trueStmtList.size(); ++i) {
                CodeStmt trueStmt = (CodeStmt)trueStmtList.get(i);
                if (!this.isStmtInvalid(trueStmt)) continue;
                return true;
            }
            for (i = 0; i < elseIfList.size(); ++i) {
                ElseIfItem elseIfItem = (ElseIfItem)elseIfList.get(i);
                if (this.isExprInvalid(elseIfItem.testExpr)) {
                    return true;
                }
                for (int k = 0; k < elseIfItem.stmtList.size(); ++k) {
                    CodeStmt elseIfStmt = (CodeStmt)elseIfItem.stmtList.get(k);
                    if (!this.isStmtInvalid(elseIfStmt)) continue;
                    return true;
                }
            }
            for (i = 0; i < elseStmtList.size(); ++i) {
                CodeStmt elseStmt = (CodeStmt)elseStmtList.get(i);
                if (!this.isStmtInvalid(elseStmt)) continue;
                return true;
            }
        } else {
            if (codeStmt instanceof ReturnStmt) {
                ReturnStmt returnStmt = (ReturnStmt)codeStmt;
                return this.isExprInvalid(returnStmt.expr);
            }
            if (codeStmt instanceof BlockStmt) {
                List stmtList = ((BlockStmt)codeStmt).stmtList;
                if (stmtList != null) {
                    for (int i = 0; i < stmtList.size(); ++i) {
                        CodeStmt currStmt = (CodeStmt)stmtList.get(i);
                        if (!this.isStmtInvalid(currStmt)) continue;
                        return true;
                    }
                }
            } else {
                return !(codeStmt instanceof WhileStmt) && !(codeStmt instanceof ForStmt) && !(codeStmt instanceof DoStmt);
            }
        }
        return false;
    }

    private boolean isExprInvalid(CodeExpr codeExpr) {
        if (codeExpr instanceof BinaryOpExpr) {
            BinaryOpExpr bopExpr = (BinaryOpExpr)codeExpr;
            CodeExpr lExpr = bopExpr.left;
            CodeExpr rExpr = bopExpr.right;
            if (lExpr != null && this.isExprInvalid(lExpr)) {
                return true;
            }
            if (rExpr != null && this.isExprInvalid(rExpr)) {
                return true;
            }
        } else {
            if (codeExpr instanceof PropertyExpr) {
                return false;
            }
            if (codeExpr instanceof MethodInvokeExpr) {
                MethodInvokeExpr mthdExpr = (MethodInvokeExpr)codeExpr;
                for (int i = 0; i < mthdExpr.paramList.size(); ++i) {
                    CodeExpr paramExpr = (CodeExpr)mthdExpr.paramList.get(i);
                    if (!this.isExprInvalid(paramExpr)) continue;
                    return true;
                }
            } else {
                if (codeExpr instanceof IdentifierExpr) {
                    return false;
                }
                if (codeExpr instanceof ObjectCreateExpr) {
                    return false;
                }
                return !(codeExpr instanceof IntExpr) && !(codeExpr instanceof DoubleExpr) && !(codeExpr instanceof LongExpr) && !(codeExpr instanceof FloatExpr) && !(codeExpr instanceof StringExpr) && !(codeExpr instanceof NullExpr) && !(codeExpr instanceof BoolExpr);
            }
        }
        return false;
    }
}

