/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.formula.platform.api;

import java.io.IOException;
import java.io.LineNumberReader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import kd.bos.formula.platform.api.IFormulaVarInfos;
import kd.bos.formula.platform.api.IVarInfo;
import kd.bos.formula.platform.api.KScriptFormulaParser;
import kd.bos.formula.platform.api.VarInfo;
import kd.bos.kscript.ParserException;
import kd.bos.kscript.dom.stmt.CodeStmt;
import kd.bos.kscript.dom.stmt.VarDeclItem;
import kd.bos.kscript.dom.stmt.VarDeclStmt;
import kd.bos.kscript.parser.KScriptParser;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

class FormulaVarInfoParser
implements IFormulaVarInfos {
    private static final Log logger = LogFactory.getLog(FormulaVarInfoParser.class);
    private static Hashtable parsedFormulas = new Hashtable();

    FormulaVarInfoParser() {
    }

    @Override
    public IVarInfo[] getFormulaVars(String formulaStr) {
        if (formulaStr == null) {
            return null;
        }
        Object obj = parsedFormulas.get(formulaStr);
        if (obj instanceof IVarInfo[]) {
            return (IVarInfo[])obj;
        }
        ArrayList<IVarInfo> vars = new ArrayList<IVarInfo>(10);
        LineNumberReader lnr = new LineNumberReader(new StringReader(formulaStr));
        String line = null;
        try {
            line = lnr.readLine();
        }
        catch (IOException ioe) {
            logger.debug(ioe.getMessage());
        }
        while (line != null) {
            IVarInfo varInfo = IVarInfo.get(line);
            if (varInfo != null) {
                vars.add(varInfo);
            }
            try {
                line = null;
                line = lnr.readLine();
            }
            catch (IOException ioe) {
                logger.debug(ioe.getMessage());
            }
        }
        try {
            KScriptParser parser = KScriptFormulaParser.parseFormulaStr(formulaStr);
            if (parser == null) {
                logger.warn("script is illegal ,parser is null");
                return null;
            }
            List stmtList = parser.stmtList;
            for (int i = 0; i < stmtList.size(); ++i) {
                CodeStmt currStmt = (CodeStmt)stmtList.get(i);
                if (!(currStmt instanceof VarDeclStmt)) continue;
                VarDeclStmt vdStmt = (VarDeclStmt)currStmt;
                for (int k = 0; k < vdStmt.varDeclList.size(); ++k) {
                    VarDeclItem vdItem = (VarDeclItem)vdStmt.varDeclList.get(k);
                    boolean exists = false;
                    for (int m = 0; m < vars.size(); ++m) {
                        if (!((IVarInfo)vars.get(m)).getVarName().equals(vdItem.name)) continue;
                        ((VarInfo)vars.get(m)).setVarInitval(KScriptFormulaParser.getConstantExprStr(vdItem.initExpr));
                        exists = true;
                        break;
                    }
                    if (exists) continue;
                    vars.add(new VarInfo(vdItem.name, "", "", KScriptFormulaParser.getConstantExprStr(vdItem.initExpr), "local", ""));
                }
            }
        }
        catch (ParserException pe) {
            logger.error("parse formula error", (Throwable)pe);
            return null;
        }
        IVarInfo[] varArr = new VarInfo[vars.size()];
        for (int i = 0; i < vars.size(); ++i) {
            varArr[i] = (VarInfo)vars.get(i);
        }
        parsedFormulas.put(formulaStr, varArr);
        return varArr;
    }

    @Override
    public String genVarsDefBlock(Iterable vars) {
        StringBuilder varsBlock = new StringBuilder();
        for (Object varInfo : vars) {
            if (!(varInfo instanceof IVarInfo)) continue;
            String varLine = IVarInfo.genVarStr((IVarInfo)varInfo);
            varsBlock.append(varLine).append("\n\r");
        }
        return varsBlock.toString();
    }

    @Override
    public String getDisplayString(String formulaStr) {
        StringBuilder sb = new StringBuilder();
        LineNumberReader lnr = new LineNumberReader(new StringReader(formulaStr));
        String line = null;
        try {
            line = lnr.readLine();
        }
        catch (IOException ioe) {
            logger.debug(ioe.getMessage());
        }
        while (line != null) {
            int epos = line.indexOf("//bizenum");
            int vpos = line.indexOf("//{bos_formula_comments_var");
            if (epos < 0 && vpos < 0) {
                int index = line.indexOf("return formula_result;");
                if (index > -1) {
                    line = line.substring(0, index);
                }
                if (!line.equals("")) {
                    sb.append(line).append("\n");
                }
            }
            try {
                line = null;
                line = lnr.readLine();
            }
            catch (IOException ioe) {
                logger.debug(ioe.getMessage());
            }
        }
        return sb.toString();
    }
}

