/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.formula.platform.builder;

import java.util.LinkedHashMap;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.tree.TreeNode;
import kd.bos.formula.platform.builder.EntityCategory;
import kd.bos.formula.platform.builder.EntityPropInfo;

class EntityCategories {
    private Map<String, EntityCategory> categories = new LinkedHashMap<String, EntityCategory>();

    EntityCategories() {
    }

    public Map<String, EntityCategory> getCategories() {
        return this.categories;
    }

    public void setCategories(Map<String, EntityCategory> categories) {
        this.categories = categories;
    }

    public void add(EntityCategory category) {
        this.categories.put(category.getName(), category);
    }

    public String toString() {
        return ResManager.loadKDString((String)"\u5b9e\u4f53", (String)"EntityCategories_0", (String)"bos-formula-platform", (Object[])new Object[0]);
    }

    public EntityCategory findCategory(String category) {
        return this.categories.get(category);
    }

    public EntityPropInfo findEntityProp(String fullPropName) {
        for (Map.Entry<String, EntityCategory> item : this.categories.entrySet()) {
            EntityPropInfo propInfo = item.getValue().findEntityProp(fullPropName);
            if (propInfo == null) continue;
            return propInfo;
        }
        return null;
    }

    public TreeNode buildEntityTree(TreeNode parent) {
        TreeNode selfNode = new TreeNode();
        selfNode.setParentid(parent == null ? "" : parent.getId());
        selfNode.setId("entitytreenode");
        selfNode.setIsOpened(true);
        selfNode.setText(this.toString());
        for (Map.Entry<String, EntityCategory> item : this.categories.entrySet()) {
            TreeNode node = item.getValue().buildEntityTree(selfNode);
            selfNode.addChild(node);
        }
        return selfNode;
    }
}

