/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.formula.platform.builder;

import java.util.LinkedHashMap;
import java.util.Map;
import kd.bos.entity.tree.TreeNode;

class EntityPropInfo {
    private boolean virtualProp = false;
    private String propName;
    private String fullPropName;
    private String propCaption;
    private String fullPropCaption;
    private Map<String, EntityPropInfo> props = new LinkedHashMap<String, EntityPropInfo>();

    EntityPropInfo() {
    }

    public boolean isVirtualProp() {
        return this.virtualProp;
    }

    public void setVirtualProp(boolean virtualProp) {
        this.virtualProp = virtualProp;
    }

    public String getPropName() {
        return this.propName;
    }

    public void setPropName(String propName) {
        this.propName = propName;
    }

    public String getFullPropName() {
        return this.fullPropName;
    }

    public void setFullPropName(String fullPropName) {
        this.fullPropName = fullPropName;
    }

    public String getPropCaption() {
        return this.propCaption;
    }

    public void setPropCaption(String propCaption) {
        this.propCaption = propCaption;
    }

    public String getFullPropCaption() {
        return this.fullPropCaption;
    }

    public void setFullPropCaption(String fullPropCaption) {
        this.fullPropCaption = fullPropCaption;
    }

    public Map<String, EntityPropInfo> getProps() {
        return this.props;
    }

    public void setProps(Map<String, EntityPropInfo> props) {
        this.props = props;
    }

    public void add(EntityPropInfo propInfo) {
        this.props.put(propInfo.getFullPropName(), propInfo);
    }

    public EntityPropInfo findEntityProp(String propFullName) {
        if (this.props.containsKey(propFullName)) {
            return this.props.get(propFullName);
        }
        for (EntityPropInfo item : this.props.values()) {
            EntityPropInfo prop = item.findEntityProp(propFullName);
            if (prop == null) continue;
            return prop;
        }
        return null;
    }

    public TreeNode buildEntityTree(TreeNode parent) {
        TreeNode selfNode = new TreeNode();
        selfNode.setParentid(parent == null ? "" : parent.getId());
        selfNode.setId(this.getFullPropName());
        selfNode.setIsOpened(false);
        selfNode.setText(this.getPropCaption());
        for (Map.Entry<String, EntityPropInfo> item : this.props.entrySet()) {
            TreeNode childNode = item.getValue().buildEntityTree(selfNode);
            selfNode.addChild(childNode);
        }
        return selfNode;
    }

    public String toString() {
        return this.fullPropCaption;
    }
}

