/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.formula.platform.engine;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicCollectionProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicComplexProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityType;
import kd.bos.formula.platform.api.BizEnumInfo;
import kd.bos.formula.platform.api.BizEnumValueInfo;
import kd.bos.formula.platform.api.BizEnumValueType;
import kd.bos.formula.platform.api.IBizEnumInfo;
import kd.bos.formula.platform.api.IVarInfo;
import kd.bos.kscript.ParserException;
import kd.bos.kscript.parser.Lexer;
import kd.bos.kscript.parser.Token;
import kd.bos.kscript.parser.TokenList;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

class BOSObjectTransformerHelper {
    private static Log logger = LogFactory.getLog(BOSObjectTransformerHelper.class);
    public static final String TYPE_VARINFO = "varinfo";
    public static final String TYPE_PROPERTY = "property";
    public static final String TYPE_METHOD = "method";
    public static final String TYPE_OTHER = "other";
    public static final String TYPE_CONSTANT = "constant";
    public static final String TYPE_ENUM = "enum";
    private HashMap<String, EntityType> boMap;
    private TokenList tokenlist;
    private Vector<IVarInfo> varList;
    private Vector<IBizEnumInfo> enumList;
    private List<String> analyseList = new ArrayList<String>();
    private HashMap<String, IBizEnumInfo> enumItem2Enum = new HashMap();

    public BOSObjectTransformerHelper(HashMap<String, EntityType> bos, Vector<IVarInfo> vars, Vector<IBizEnumInfo> enums, TokenList tokens) {
        this.boMap = bos;
        this.varList = vars;
        this.enumList = enums;
        this.tokenlist = tokens;
        try {
            this.analyse();
        }
        catch (ParserException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    private void analyse() throws ParserException {
        Token token;
        if (this.tokenlist == null) {
            return;
        }
        this.analyseList.clear();
        int index = 0;
        while ((token = this.tokenlist.lookup(index)) != null && token.type != 12) {
            if (this.isVarinfo(token)) {
                this.analyseList.add(TYPE_VARINFO);
            } else if (this.isEnum(index)) {
                this.analyseList.add(TYPE_ENUM);
            } else if (this.isProperty(index)) {
                this.analyseList.add(TYPE_PROPERTY);
            } else if (this.isMethod(index)) {
                this.analyseList.add(TYPE_METHOD);
            } else if (this.isConstant(index)) {
                this.analyseList.add(TYPE_CONSTANT);
            } else {
                this.analyseList.add(TYPE_OTHER);
            }
            ++index;
        }
    }

    private boolean isVarinfo(Token token) {
        if (this.varList != null && token != null) {
            for (IVarInfo varinfo : this.varList) {
                String alias = varinfo.getVarAlias();
                if (!alias.equals(token.value)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isProperty(int index) throws ParserException {
        if (this.tokenlist != null && index > 0) {
            Token beforeToken = this.tokenlist.lookup(index - 1);
            Token self = this.tokenlist.lookup(index);
            Token nextToken = this.tokenlist.lookup(index + 1);
            if (self != null && self.type != 1) {
                return false;
            }
            if (beforeToken.value != null && beforeToken.value.equals(".") && (nextToken == null || nextToken.type == 12 || Token.PeriodToken.equals(nextToken) || 4 == nextToken.type || nextToken.value.equals(";") || 5 == nextToken.type && !Token.OpenBraceToken.equals(nextToken))) {
                return true;
            }
        }
        return false;
    }

    private boolean isMethod(int index) throws ParserException {
        if (this.tokenlist != null && index > 0) {
            Token self = this.tokenlist.lookup(index);
            Token nextToken = this.tokenlist.lookup(index + 1);
            Token beforeToken = this.tokenlist.lookup(index - 1);
            if (1 == self.type && 5 == nextToken.type && Token.OpenBraceToken.equals(nextToken) && beforeToken.value != null && beforeToken.value.equals(".")) {
                return true;
            }
        }
        return false;
    }

    private boolean isNew(int index) throws ParserException {
        if (this.tokenlist != null && index >= 0) {
            Token self = this.tokenlist.lookup(index);
            if (self.value.equals("new")) {
                return true;
            }
        }
        return false;
    }

    private boolean isConstant(int index) throws ParserException {
        if (index < 1) {
            return false;
        }
        Token token = this.tokenlist.lookup(index);
        return 6 == token.type;
    }

    private boolean isEnum(int index) throws ParserException {
        if (index < 0 || this.enumList == null) {
            return false;
        }
        Token token = this.tokenlist.lookup(index);
        String ei = token.value;
        int size = this.enumList.size();
        for (int i = 0; i < size; ++i) {
            BizEnumInfo enumInfo = (BizEnumInfo)this.enumList.get(i);
            for (BizEnumValueInfo ev : enumInfo.getEnumValues()) {
                if (ev.getAlias() == null || !ev.getAlias().toString().equals(ei)) continue;
                this.enumItem2Enum.put(ei, enumInfo);
                return true;
            }
        }
        return false;
    }

    private IVarInfo getVarinfoByAlias(String varAlias) {
        if (this.varList != null) {
            for (IVarInfo varinfo : this.varList) {
                String alias = varinfo.getVarAlias();
                if (!alias.equals(varAlias)) continue;
                return varinfo;
            }
        }
        return null;
    }

    public TokenList getScriptTokenList() throws ParserException {
        Token token;
        StringBuilder scriptsb = new StringBuilder();
        int index = 0;
        while ((token = this.tokenlist.lookup(index)) != null && token.type != 12) {
            if (this.isVarinfo(token)) {
                IVarInfo var = this.getVarinfoByAlias(token.value);
                if (var != null) {
                    scriptsb.append(var.getVarName());
                }
            } else if (this.isEnum(index)) {
                String value = token.value;
                BizEnumInfo enumInfo = (BizEnumInfo)this.enumItem2Enum.get(value);
                BizEnumValueType vt = enumInfo.getDataType();
                boolean isStr = false;
                if (vt == BizEnumValueType.String) {
                    isStr = true;
                }
                for (BizEnumValueInfo ev : enumInfo.getEnumValues()) {
                    if (ev.getAlias() == null || !ev.getAlias().equals((Object)value)) continue;
                    Object obj = ev.getValue();
                    scriptsb.append(" ");
                    if (isStr) {
                        scriptsb.append("\"");
                    }
                    scriptsb.append(obj.toString());
                    if (isStr) {
                        scriptsb.append("\"");
                    }
                    scriptsb.append(" ");
                    break;
                }
            } else if (this.isProperty(index)) {
                EntityType parent = this.getPropertyOrMethodBO(index);
                boolean find = false;
                if (parent != null) {
                    for (IDataEntityProperty prop : parent.getProperties()) {
                        if (prop.getDisplayName() == null || !StringUtils.equals((CharSequence)prop.getDisplayName().toString(), (CharSequence)token.value)) continue;
                        scriptsb.append(prop.getName());
                        find = true;
                        break;
                    }
                }
                if (!find) {
                    if (StringUtils.equals((CharSequence)token.value, (CharSequence)ResManager.loadKDString((String)"\u5185\u7801", (String)"BOSObjectTransformerHelper_0", (String)"bos-formula-platform", (Object[])new Object[0]))) {
                        scriptsb.append("id");
                    } else {
                        scriptsb.append(token.value);
                    }
                }
            } else if (this.isMethod(index)) {
                scriptsb.append(token.value);
            } else if (this.isConstant(index)) {
                scriptsb.append("\"");
                scriptsb.append(token.value);
                scriptsb.append("\"");
            } else if (this.isNew(index)) {
                scriptsb.append(" new ");
            } else {
                if (6 == token.type) {
                    scriptsb.append("\"").append(token.value).append("\"");
                } else {
                    scriptsb.append(token.value);
                }
                if (token.value.equals("if") || token.value.equals("else")) {
                    scriptsb.append(" ");
                }
            }
            ++index;
        }
        Lexer _lexer = new Lexer(scriptsb.toString());
        TokenList _tokenList = new TokenList(_lexer);
        return _tokenList;
    }

    private EntityType getPropertyOrMethodBO(int index) throws ParserException {
        block9: {
            EntityType parent;
            String type;
            Token beforToken;
            block10: {
                block8: {
                    String varName;
                    if (index < 2) {
                        return null;
                    }
                    beforToken = this.tokenlist.lookup(index - 2);
                    type = this.analyseList.get(index - 2);
                    while (!(TYPE_VARINFO.equals(type) || TYPE_PROPERTY.equals(type) || TYPE_METHOD.equals(type) || --index < 0)) {
                        beforToken = this.tokenlist.lookup(index);
                        type = this.analyseList.get(index);
                    }
                    if (!TYPE_VARINFO.equals(type)) break block8;
                    IVarInfo var = this.getVarinfoByAlias(beforToken.value);
                    if (var != null && this.boMap.containsKey(varName = var.getVarName())) {
                        return this.boMap.get(varName);
                    }
                    break block9;
                }
                if (!TYPE_PROPERTY.equals(type)) break block10;
                EntityType parent2 = this.getPropertyOrMethodBO(index - 2);
                if (parent2 == null) break block9;
                for (IDataEntityProperty prop : parent2.getProperties()) {
                    if (prop.getDisplayName() == null || !StringUtils.equals((CharSequence)prop.getDisplayName().toString(), (CharSequence)beforToken.value)) continue;
                    if (prop instanceof DynamicCollectionProperty) {
                        return (EntityType)((DynamicCollectionProperty)prop).getItemType();
                    }
                    if (!(prop instanceof DynamicComplexProperty)) continue;
                    return (EntityType)((DynamicComplexProperty)prop).getComplexType();
                }
                break block9;
            }
            if (TYPE_METHOD.equals(type) && (parent = this.getPropertyOrMethodBO(index - 2)) != null) {
                for (IDataEntityProperty prop : parent.getProperties()) {
                    if (prop.getDisplayName() == null || !StringUtils.equals((CharSequence)prop.getDisplayName().toString(), (CharSequence)beforToken.value)) continue;
                    if (prop instanceof DynamicCollectionProperty) {
                        return (EntityType)((DynamicCollectionProperty)prop).getItemType();
                    }
                    if (!(prop instanceof DynamicComplexProperty)) continue;
                    return (EntityType)((DynamicComplexProperty)prop).getComplexType();
                }
            }
        }
        return null;
    }
}

