/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.privacy.strategy;

import kd.bos.privacy.model.PrivacyEncryptModel;
import kd.bos.privacy.strategy.AbstractDesensitizeStrategy;
import kd.bos.util.StringUtils;

public class RegularDesenStrategy
extends AbstractDesensitizeStrategy {
    private String matchRules;
    private String replacement;

    public RegularDesenStrategy(String matchRules, String replacement) {
        this.matchRules = matchRules;
        this.replacement = replacement;
    }

    @Override
    protected String desensitizeInternal(PrivacyEncryptModel model, Object value) {
        String valStr = String.valueOf(value);
        if (value != null && StringUtils.isNotEmpty((String)valStr)) {
            return valStr.replaceAll(this.matchRules, this.replacement);
        }
        return this.getDefaultValue();
    }

    @Override
    public String getStrategyName() {
        return "regular";
    }
}

