var entryKey = "fields";
var plugin=new FormPlugin({
	initialize:function() {
		this.addClickListeners("btnok");
	},
	afterCreateNewData:function (e) {
		var p=this.getView().getFormShowParameter().getCustomParams();
		
		var data = p.get("context");
		var itemId =p.get("itemId");
	
		var fields = this.getFields(data, itemId);
	
		var model=this.getModel();
		if (fields.length > 0) {
			var count = model.getEntryRowCount(entryKey);
			if (fields.length > count) {
				model.batchCreateNewEntryRow(entryKey, fields.length - count);
			}
			for (var i = 0; i < fields.length; i++) {
				var field = fields[i];
				model.setValue("fid", field.get("Id"), i);
				model.setValue("fkey", field.get("Key"), i);
				model.setValue("fname", field.get("Name"), i);
			}
		}
	},
	click:function(e) {
		this.returnData();
	},
	getFields:function(context, itemId) {
	
		var items = context.get(1);
		var entityitems = context.get(0);
		var fields = [];
		if (items != null && itemId != null) {
			var itemMap = {};
			for (var i = 0; i < items.size(); i++) {
				var item = items.get(i);
				itemMap[item.get("Id")] = item;
			}
			var entityId = getEntityId(itemId, itemMap);
			if (entityId != null) {
	
				for (var i = 0; i < entityitems.size(); i++) {
					var entityitem = entityitems.get(i);
					if (entityId == entityitem.get("ParentId")) {
						fields.push(entityitem);
					}
				}
			}
		}
		return fields;
	},
	getEntityId:function(id, itemMap) {
	
		var item = itemMap[id];
		if (item == null) {
			return null;
		}
		var parentId = item.get("ParentId");
		if (parentId == null) {
			return null;
		}
		var parentItem = itemMap[parentId];
		if (parentItem == null) {
			return null;
		}
		if ("CardEntryAp" == parentItem.get("_Type_")) {
			return parentItem.get("EntryId");
		} else {
			return getEntityId(parentItem.get("Id"), itemMap);
		}
	},
	returnData:function() {
		var row = this.getCurrentSelector();
		if (row != null) {
			var p=this.getView().getFormShowParameter().getCustomParams();
			var para = {
				itemId : p.get("itemId"),
				metaType : p.get("metaType"),
				propertyName : p.get("propertyName"),
				value : row.id,
				alias : row.name
			};
			this.getView().returnDataToParent(para);
			this.getView().close();
		}
	},
	getCurrentSelector:function() {
		var ret = {};
		var grid = this.getView().getControl(entryKey);
		var row = grid.getEntryState().getFocusRow();
		if (row != null) {
			var model=this.getModel();
			ret.id = model.getValue("fid", row);
			ret.name = model.getValue("fname", row);
		} else {
			return null;
		}
	
		return ret;
	}
});