/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.servicehelper;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.regex.Pattern;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.cache.CacheConfigInfo;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeCacheHAPolicy;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.cache.LocalMemoryCache;
import kd.bos.context.RequestContext;
import kd.bos.data.BusinessDataReader;
import kd.bos.data.BusinessDataWriter;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.trace.EntityTraceSpan;
import kd.bos.dataentity.trace.EntityTracer;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.dtx.DTXServiceHelper;
import kd.bos.dtx.XidInfo;
import kd.bos.dtx.util.Configuration;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.datamanager.DataEntityCacheManager;
import kd.bos.orm.datamanager.DataManagerUtils;
import kd.bos.orm.datamanager.IDataManager;
import kd.bos.orm.datamanager.LoadReferenceObjectManager;
import kd.bos.orm.query.Distinctable;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.query.QFilterUtil;
import kd.bos.orm.query.WithEntityEntryDistinctable;
import kd.bos.permission.api.PermissionService;
import kd.bos.script.annotations.KSMethod;
import kd.bos.script.annotations.KSObject;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.util.DynamicObjectSerializeUtil;
import kd.bos.session.SystemPropertyUtils;
import kd.sdk.annotation.SdkInternal;
import kd.sdk.annotation.SdkService;

@KSObject
@SdkService(name="\u4e1a\u52a1\u6570\u636e\u670d\u52a1")
public class BusinessDataServiceHelper {
    private static final String TYPE_NAME = "BusinessDataServiceHelper";
    private static final String METHOD_LOAD_SINGLE = "loadSingle";
    private static final String METHOD_LOAD = "load";
    private static final String METHOD_LOAD_SINGLE_FROM_CACHE = "loadSingleFromCache";
    private static final String METHOD_LOAD_FROM_CACHE = "loadFromCache";
    private static final String PARAM_ENTITYNAME = "entityname";
    private static final String PARAM_PKID = "pkid";
    private static final String PARAM_SELECTFIELDS = "selectFields";
    private static final String PARAM_FILTERS = "filters";
    private static final String PARAM_ORDERBY = "orderBy";
    private static final String PARAM_IDS = "ids";
    private static final String PARAM_IDS_SIZE = "ids.size";
    private static final String PARAM_RESULT = "result";
    private static final String BUSINESS_DATA_SERVICE_HELPER_LOAD = "BusinessDataServiceHelper.load";
    private static Log log = LogFactory.getLog(SaveServiceHelper.class);
    private static final DynamicObject[] emptyObjects = new DynamicObject[0];

    @KSMethod
    public static DynamicObject newDynamicObject(String entityName) {
        MainEntityType type = EntityMetadataCache.getDataEntityType((String)entityName);
        return (DynamicObject)type.createInstance();
    }

    public static DynamicObject newDynamicObject(String entityName, boolean fillDefVal, OperateOption option) {
        MainEntityType type = EntityMetadataCache.getDataEntityType((String)entityName);
        if (!fillDefVal) {
            return (DynamicObject)type.createInstance();
        }
        InnerDataModel model = BusinessDataServiceHelper.createDataModel(entityName);
        model.beginInit();
        model.createNewData();
        model.clearNoDataRow();
        model.endInit();
        return model.getDataEntity();
    }

    private static InnerDataModel createDataModel(String entityNumber) {
        HashMap services = new HashMap();
        String pageId = UUID.randomUUID().toString();
        return new InnerDataModel(entityNumber, pageId, services);
    }

    @KSMethod
    public static DynamicObject loadHead(Object pk, DynamicObjectType type) {
        try (EntityTraceSpan span = EntityTracer.create((String)TYPE_NAME, (String)"loadHead");){
            if (span.isRealtime()) {
                span.addTag(PARAM_ENTITYNAME, type.getName());
                span.addTag(PARAM_PKID, String.valueOf(pk));
            }
            DynamicObject dynamicObject = BusinessDataReader.loadHead((Object)pk, (DynamicObjectType)type);
            return dynamicObject;
        }
    }

    @KSMethod
    public static DynamicObject loadSingle(Object pk, DynamicObjectType type) {
        try (EntityTraceSpan span = EntityTracer.create((String)TYPE_NAME, (String)METHOD_LOAD_SINGLE);){
            if (span.isRealtime()) {
                span.addTag(PARAM_ENTITYNAME, type.getName());
                span.addTag(PARAM_PKID, String.valueOf(pk));
            }
            DynamicObject dynamicObject = BusinessDataReader.loadSingle((Object)pk, (DynamicObjectType)type);
            return dynamicObject;
        }
    }

    @KSMethod
    public static DynamicObject loadSingle(Object pk, DynamicObjectType type, int start, int limit) {
        try (EntityTraceSpan span = EntityTracer.create((String)TYPE_NAME, (String)METHOD_LOAD_SINGLE);){
            if (span.isRealtime()) {
                span.addTag(PARAM_ENTITYNAME, type.getName());
                span.addTag(PARAM_PKID, String.valueOf(pk));
            }
            DynamicObject dynamicObject = BusinessDataReader.loadSingle((Object)pk, (DynamicObjectType)type, (int)start, (int)limit);
            return dynamicObject;
        }
    }

    @KSMethod
    public static DynamicObject loadSingle(Object pk, String entityName) {
        try (EntityTraceSpan span = EntityTracer.create((String)TYPE_NAME, (String)METHOD_LOAD_SINGLE);){
            if (span.isRealtime()) {
                span.addTag(PARAM_ENTITYNAME, entityName);
                span.addTag(PARAM_PKID, String.valueOf(pk));
            }
            MainEntityType type = EntityMetadataCache.getDataEntityType((String)entityName);
            DynamicObject dynamicObject = BusinessDataReader.loadSingle((Object)pk, (DynamicObjectType)type);
            return dynamicObject;
        }
    }

    @KSMethod
    public static DynamicObject loadSingle(Object pk, String entityName, String selectProperties) {
        try (EntityTraceSpan span = EntityTracer.create((String)TYPE_NAME, (String)METHOD_LOAD_SINGLE);){
            if (span.isRealtime()) {
                span.addTag(PARAM_ENTITYNAME, entityName);
                span.addTag(PARAM_PKID, String.valueOf(pk));
                span.addTag(PARAM_SELECTFIELDS, selectProperties);
            }
            DynamicObjectType type = BusinessDataServiceHelper.getSubEntityType(entityName, selectProperties);
            DynamicObject dynamicObject = BusinessDataReader.loadSingle((Object)pk, (DynamicObjectType)type);
            return dynamicObject;
        }
    }

    public static DynamicObject loadSingle(String entityName, QFilter[] filters) {
        try (EntityTraceSpan span = EntityTracer.create((String)TYPE_NAME, (String)METHOD_LOAD_SINGLE);){
            DynamicObject dynamicObject;
            if (span.isRealtime()) {
                span.addTag(PARAM_ENTITYNAME, entityName);
                span.addLocaleTag(PARAM_FILTERS, (Object)filters);
            }
            ArrayList<Object> idList = new ArrayList<Object>(1);
            try (DataSet ds = ORM.create().queryDataSet(BUSINESS_DATA_SERVICE_HELPER_LOAD, entityName, "id", filters, null, 1, (Distinctable)WithEntityEntryDistinctable.get());){
                if (ds.hasNext()) {
                    Row row = ds.next();
                    idList.add(row.get(0));
                }
            }
            if (span.isRealtime()) {
                span.addLocaleTag(PARAM_IDS_SIZE, (Object)idList.size());
                span.addLocaleTag(PARAM_IDS, idList);
            }
            if (idList.isEmpty()) {
                dynamicObject = null;
                return dynamicObject;
            }
            dynamicObject = BusinessDataServiceHelper.loadSingle(idList.get(0), entityName);
            return dynamicObject;
        }
    }

    public static DynamicObject loadSingle(String entityName, String selectProperties, QFilter[] filters) {
        try (EntityTraceSpan span = EntityTracer.create((String)TYPE_NAME, (String)METHOD_LOAD_SINGLE);){
            DynamicObject dynamicObject;
            if (span.isRealtime()) {
                span.addTag(PARAM_ENTITYNAME, entityName);
                span.addTag(PARAM_SELECTFIELDS, selectProperties);
                span.addLocaleTag(PARAM_FILTERS, (Object)filters);
            }
            ArrayList<Object> idList = new ArrayList<Object>(1);
            try (DataSet ds = ORM.create().queryDataSet(BUSINESS_DATA_SERVICE_HELPER_LOAD, entityName, "id", filters, null, 1, (Distinctable)WithEntityEntryDistinctable.get());){
                if (ds.hasNext()) {
                    Row row = ds.next();
                    idList.add(row.get(0));
                }
            }
            if (span.isRealtime()) {
                span.addLocaleTag(PARAM_IDS_SIZE, (Object)idList.size());
                span.addLocaleTag(PARAM_IDS, idList);
            }
            if (idList.isEmpty()) {
                dynamicObject = null;
                return dynamicObject;
            }
            dynamicObject = BusinessDataServiceHelper.loadSingle(idList.get(0), entityName, selectProperties);
            return dynamicObject;
        }
    }

    public static DynamicObject loadSingleFromCache(Object pk, String entityName) {
        try (EntityTraceSpan span = EntityTracer.create((String)TYPE_NAME, (String)METHOD_LOAD_SINGLE_FROM_CACHE);){
            if (span.isRealtime()) {
                span.addTag(PARAM_ENTITYNAME, entityName);
                span.addTag(PARAM_PKID, String.valueOf(pk));
            }
            MainEntityType type = EntityMetadataCache.getDataEntityType((String)entityName);
            DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingleFromCache(pk, (DynamicObjectType)type);
            return dynamicObject;
        }
    }

    @KSMethod
    public static DynamicObject loadSingleFromCache(Object pk, String entityName, String selectProperties) {
        try (EntityTraceSpan span = EntityTracer.create((String)TYPE_NAME, (String)METHOD_LOAD_SINGLE_FROM_CACHE);){
            if (span.isRealtime()) {
                span.addTag(PARAM_ENTITYNAME, entityName);
                span.addTag(PARAM_PKID, String.valueOf(pk));
                span.addTag(PARAM_SELECTFIELDS, selectProperties);
            }
            DynamicObjectType type = BusinessDataServiceHelper.getSubEntityType(entityName, selectProperties);
            DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingleFromCache(pk, type);
            return dynamicObject;
        }
    }

    public static DynamicObject loadSingleFromCache(String entityName, QFilter[] filters) {
        try (EntityTraceSpan span = EntityTracer.create((String)TYPE_NAME, (String)METHOD_LOAD_SINGLE_FROM_CACHE);){
            if (span.isRealtime()) {
                span.addTag(PARAM_ENTITYNAME, entityName);
                span.addLocaleTag(PARAM_FILTERS, (Object)filters);
            }
            MainEntityType type = EntityMetadataCache.getDataEntityType((String)entityName);
            DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingleFromCache(filters, (DynamicObjectType)type);
            return dynamicObject;
        }
    }

    @KSMethod
    public static DynamicObject loadSingleFromCache(String entityName, String selectProperties, QFilter[] filters) {
        try (EntityTraceSpan span = EntityTracer.create((String)TYPE_NAME, (String)METHOD_LOAD_SINGLE_FROM_CACHE);){
            if (span.isRealtime()) {
                span.addTag(PARAM_ENTITYNAME, entityName);
                span.addTag(PARAM_SELECTFIELDS, selectProperties);
                span.addLocaleTag(PARAM_FILTERS, (Object)filters);
            }
            DynamicObjectType type = BusinessDataServiceHelper.getSubEntityType(entityName, selectProperties);
            DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingleFromCache(filters, type);
            return dynamicObject;
        }
    }

    private static DynamicObject loadSingleFromCache(QFilter[] filters, DynamicObjectType type) {
        DataEntityCacheManager cacheManager = new DataEntityCacheManager((IDataEntityType)type);
        Object[] pks = cacheManager.getCachePks(filters);
        boolean cacheData = true;
        if (pks == null) {
            try (DataSet ds = ORM.create().queryDataSet("BusinessDataServiceHelper.LoadFromCache", type.getName(), "id", filters, null, -1, (Distinctable)WithEntityEntryDistinctable.get());){
                pks = ds.hasNext() ? new Object[]{ds.next().get(0)} : new Object[]{};
                if (ds.hasNext()) {
                    cacheData = false;
                }
            }
            if (cacheData) {
                cacheManager.putCachePks(filters, pks);
            }
        }
        if (pks.length == 0) {
            return null;
        }
        Map mapObject = BusinessDataReader.loadFromCache((Object[])pks, (DynamicObjectType)type);
        return mapObject.size() > 0 ? (DynamicObject)mapObject.values().toArray()[0] : null;
    }

    @KSMethod
    public static DynamicObject loadSingleFromCache(Object pk, DynamicObjectType type) {
        try (EntityTraceSpan span = EntityTracer.create((String)TYPE_NAME, (String)METHOD_LOAD_SINGLE_FROM_CACHE);){
            if (span.isRealtime()) {
                span.addTag(PARAM_ENTITYNAME, type.getName());
                span.addTag(PARAM_PKID, String.valueOf(pk));
            }
            Map rets = BusinessDataReader.loadFromCache((Object[])new Object[]{pk}, (DynamicObjectType)type);
            DynamicObject dynamicObject = (DynamicObject)rets.get(pk);
            return dynamicObject;
        }
    }

    @KSMethod
    public static Object[] load(Object[] pkArray, IDataEntityType type) {
        try (EntityTraceSpan span = EntityTracer.create((String)TYPE_NAME, (String)METHOD_LOAD);){
            if (span.isRealtime()) {
                span.addTag(PARAM_ENTITYNAME, type.getName());
                span.addLocaleTag(PARAM_PKID, (Object)pkArray);
            }
            IDataManager dataManager = DataManagerUtils.getDataManager((IDataEntityType)type);
            Object[] array = dataManager.read(pkArray);
            LoadReferenceObjectManager manager = new LoadReferenceObjectManager(type, false);
            manager.Load(array);
            if (span.isRealtime()) {
                span.addLocaleTag("result.size", (Object)array.length);
                span.addLocaleTag(PARAM_RESULT, (Object)array);
            }
            Object[] objectArray = array;
            return objectArray;
        }
    }

    @KSMethod
    public static DynamicObject[] load(Object[] pkArray, DynamicObjectType type) {
        try (EntityTraceSpan span = EntityTracer.create((String)TYPE_NAME, (String)METHOD_LOAD);){
            if (span.isRealtime()) {
                span.addTag(PARAM_ENTITYNAME, type.getName());
                span.addLocaleTag(PARAM_PKID, (Object)pkArray);
            }
            DynamicObject[] dynamicObjectArray = BusinessDataReader.load((Object[])pkArray, (DynamicObjectType)type, (Boolean)Boolean.TRUE);
            return dynamicObjectArray;
        }
    }

    @KSMethod
    public static DynamicObject[] load(String entityName, String selectProperties, QFilter[] filters) {
        return BusinessDataServiceHelper.load(entityName, selectProperties, filters, null, -1);
    }

    @KSMethod
    public static DynamicObject[] load(String entityName, String selectProperties, QFilter[] filters, String orderBy) {
        return BusinessDataServiceHelper.load(entityName, selectProperties, filters, orderBy, -1);
    }

    @KSMethod
    public static DynamicObject[] load(String entityName, String selectProperties, QFilter[] filters, String orderBy, int top) {
        try (EntityTraceSpan span = EntityTracer.create((String)TYPE_NAME, (String)METHOD_LOAD);){
            DynamicObject[] dynamicObjectArray;
            IDSet idSet;
            DynamicObjectType type;
            block48: {
                if (span.isRealtime()) {
                    span.addTag(PARAM_ENTITYNAME, entityName);
                    span.addTag(PARAM_SELECTFIELDS, selectProperties);
                    span.addTag(PARAM_ORDERBY, orderBy);
                    span.addTag("top", String.valueOf(top));
                    span.addLocaleTag(PARAM_FILTERS, (Object)filters);
                }
                if (top == 0) {
                    DynamicObject[] dynamicObjectArray2 = emptyObjects;
                    return dynamicObjectArray2;
                }
                type = BusinessDataServiceHelper.getSubEntityType(entityName, selectProperties);
                if (StringUtils.isBlank((CharSequence)orderBy)) {
                    IDSet idSet2 = new IDSet();
                    try (DynamicObject[] ds = ORM.create().queryDataSet(BUSINESS_DATA_SERVICE_HELPER_LOAD, entityName, "id", filters, null, top, (Distinctable)WithEntityEntryDistinctable.get());){
                        ds.forEach(row -> idSet2.add(row.get(0)));
                    }
                    ds = BusinessDataReader.load((Object[])idSet2.idList.toArray(), (DynamicObjectType)type, (Boolean)Boolean.TRUE);
                    return ds;
                }
                idSet = new IDSet();
                String selectFields = "id";
                selectFields = Pattern.compile("(^id$)|(^id[ ,]+)|([ ,]+id[ ,]+)|([ ,]+id$)").matcher(orderBy).find() ? orderBy.toLowerCase().replaceAll(" asc", "").replaceAll(" desc", "") : selectFields + "," + orderBy.toLowerCase().replaceAll(" asc", "").replaceAll(" desc", "");
                dynamicObjectArray = null;
                try (DataSet ds = ORM.create().queryDataSet(BUSINESS_DATA_SERVICE_HELPER_LOAD, entityName, selectFields, filters, orderBy, -1);){
                    if (top < 0) {
                        ds.forEach(row -> idSet.add(row.get("id")));
                        break block48;
                    }
                    while (ds.hasNext()) {
                        idSet.add(ds.next().get("id"));
                        if (idSet.idList.size() != top) continue;
                        break;
                    }
                }
                catch (Throwable object) {
                    dynamicObjectArray = object;
                    throw object;
                }
            }
            DynamicObject[] objs = BusinessDataReader.load((Object[])idSet.idList.toArray(), (DynamicObjectType)type, (Boolean)Boolean.TRUE);
            dynamicObjectArray = BusinessDataServiceHelper.orderBy(objs, idSet.idList, orderBy);
            return dynamicObjectArray;
        }
    }

    @KSMethod
    public static DynamicObject[] loadWithPermission(String entityName, String selectProperties, QFilter[] filters, String orderBy, int top, String appId) {
        try (EntityTraceSpan span = EntityTracer.create((String)TYPE_NAME, (String)"loadWithPermission");){
            if (span.isRealtime()) {
                span.addTag(PARAM_ENTITYNAME, entityName);
                span.addTag(PARAM_SELECTFIELDS, selectProperties);
                span.addTag(PARAM_ORDERBY, orderBy);
                span.addTag("top", String.valueOf(top));
                span.addTag("appId", appId);
                span.addLocaleTag(PARAM_FILTERS, (Object)filters);
            }
            if (top == 0) {
                DynamicObject[] dynamicObjectArray = emptyObjects;
                return dynamicObjectArray;
            }
            PermissionService permissionService = (PermissionService)ServiceFactory.getService(PermissionService.class);
            Long userId = RequestContext.get().getCurrUserId();
            QFilter filter = permissionService.getViewPermFilter(userId, appId, entityName);
            ArrayList<QFilter> list = new ArrayList<QFilter>();
            Collections.addAll(list, filters);
            list.add(filter);
            DynamicObject[] dynamicObjectArray = BusinessDataServiceHelper.load(entityName, selectProperties, list.toArray(new QFilter[list.size()]), orderBy, top);
            return dynamicObjectArray;
        }
    }

    @KSMethod
    public static DynamicObject[] load(String entityName, String selectProperties, QFilter[] filters, String orderBy, int pageIndex, int pagesize) {
        try (EntityTraceSpan span = EntityTracer.create((String)TYPE_NAME, (String)METHOD_LOAD);){
            DynamicObject[] dynamicObjectArray;
            IDSet idSet;
            DynamicObjectType type;
            block57: {
                if (span.isRealtime()) {
                    span.addTag(PARAM_ENTITYNAME, entityName);
                    span.addTag(PARAM_SELECTFIELDS, selectProperties);
                    span.addTag(PARAM_ORDERBY, orderBy);
                    span.addTag("pageIndex", String.valueOf(pageIndex));
                    span.addTag("pagesize", String.valueOf(pagesize));
                    span.addLocaleTag(PARAM_FILTERS, (Object)filters);
                }
                if (pageIndex < 0 || pagesize <= 0) {
                    DynamicObject[] dynamicObjectArray2 = emptyObjects;
                    return dynamicObjectArray2;
                }
                type = BusinessDataServiceHelper.getSubEntityType(entityName, selectProperties);
                if (StringUtils.isBlank((CharSequence)orderBy)) {
                    IDSet idSet2 = new IDSet();
                    try (DynamicObject[] ds = ORM.create().queryDataSet(BUSINESS_DATA_SERVICE_HELPER_LOAD, entityName, "id", filters, null, pageIndex * pagesize, pagesize, (Distinctable)WithEntityEntryDistinctable.get());){
                        ds.forEach(row -> idSet2.add(row.get(0)));
                    }
                    ds = BusinessDataReader.load((Object[])idSet2.idList.toArray(), (DynamicObjectType)type, (Boolean)Boolean.TRUE);
                    return ds;
                }
                idSet = new IDSet();
                String selectFields = "id";
                selectFields = Pattern.compile("(^id$)|(^id[ ,]+)|([ ,]+id[ ,]+)|([ ,]+id$)").matcher(orderBy).find() ? orderBy.toLowerCase().replaceAll(" asc", "").replaceAll(" desc", "") : selectFields + "," + orderBy.toLowerCase().replaceAll(" asc", "").replaceAll(" desc", "");
                dynamicObjectArray = null;
                try (DataSet ds = ORM.create().queryDataSet(BUSINESS_DATA_SERVICE_HELPER_LOAD, entityName, selectFields, filters, orderBy, -1);){
                    int skipN = pageIndex * pagesize;
                    if (skipN > 0) {
                        IDSet skipIdSet = new IDSet();
                        int i = 0;
                        while (ds.hasNext()) {
                            skipIdSet.add(ds.next().get("id"));
                            if (++i < skipN || skipIdSet.idList.size() != skipN) continue;
                        }
                        if (skipIdSet.idList.size() < skipN) {
                            DynamicObject[] dynamicObjectArray3 = emptyObjects;
                            return dynamicObjectArray3;
                        }
                        while (ds.hasNext()) {
                            Object id = ds.next().get("id");
                            if (skipIdSet.has(id)) continue;
                            idSet.add(id);
                            if (idSet.idList.size() != pagesize) continue;
                            break block57;
                        }
                        break block57;
                    }
                    int i = 0;
                    while (ds.hasNext()) {
                        idSet.add(ds.next().get("id"));
                        if (++i < pagesize || idSet.idList.size() != pagesize) continue;
                        break;
                    }
                }
                catch (Throwable object) {
                    dynamicObjectArray = object;
                    throw object;
                }
            }
            DynamicObject[] objs = BusinessDataReader.load((Object[])idSet.idList.toArray(), (DynamicObjectType)type, (Boolean)Boolean.TRUE);
            dynamicObjectArray = BusinessDataServiceHelper.orderBy(objs, idSet.idList, orderBy);
            return dynamicObjectArray;
        }
    }

    private static DynamicObject[] orderBy(DynamicObject[] objs, List<Object> idList, String orderBy) {
        if (StringUtils.isBlank((CharSequence)orderBy) || idList.size() <= 1) {
            return objs;
        }
        HashMap<Object, DynamicObject> maps = new HashMap<Object, DynamicObject>(objs.length);
        for (DynamicObject o : objs) {
            maps.put(o.getPkValue(), o);
        }
        ArrayList<DynamicObject> listDyn = new ArrayList<DynamicObject>(objs.length);
        for (Object id : idList) {
            DynamicObject o;
            o = (DynamicObject)maps.get(id);
            if (o == null) continue;
            listDyn.add(o);
        }
        return listDyn.toArray(new DynamicObject[listDyn.size()]);
    }

    private static DynamicObjectType getSubEntityType(String entityName, String selectProperties) {
        String[] properties = selectProperties.split(",");
        HashSet<String> select = new HashSet<String>(properties.length);
        for (String prop : properties) {
            select.add(prop.trim());
        }
        return EntityMetadataCache.getSubDataEntityType((String)entityName, select);
    }

    @KSMethod
    public static Map<Object, DynamicObject> loadFromCache(Object[] pkArray, DynamicObjectType type) {
        try (EntityTraceSpan span = EntityTracer.create((String)TYPE_NAME, (String)METHOD_LOAD_FROM_CACHE);){
            if (span.isRealtime()) {
                span.addTag(PARAM_ENTITYNAME, type.getName());
                span.addLocaleTag(PARAM_PKID, (Object)pkArray);
            }
            Map map = BusinessDataReader.loadFromCache((Object[])pkArray, (DynamicObjectType)type);
            return map;
        }
    }

    public static Map<Object, DynamicObject> loadFromCache(Object[] pkArray, String entityName) {
        MainEntityType type = EntityMetadataCache.getDataEntityType((String)entityName);
        return BusinessDataServiceHelper.loadFromCache(pkArray, (DynamicObjectType)type);
    }

    @KSMethod
    public static Map<Object, DynamicObject> loadFromCache(String entityName, String selectProperties, QFilter[] filters) {
        try (EntityTraceSpan span = EntityTracer.create((String)TYPE_NAME, (String)METHOD_LOAD_FROM_CACHE);){
            if (span.isRealtime()) {
                span.addTag(PARAM_ENTITYNAME, entityName);
                span.addTag(PARAM_SELECTFIELDS, selectProperties);
                span.addLocaleTag(PARAM_FILTERS, (Object)filters);
            }
            DynamicObjectType type = BusinessDataServiceHelper.getSubEntityType(entityName, selectProperties);
            Map<Object, DynamicObject> map = BusinessDataServiceHelper.loadFromCache(type, filters);
            return map;
        }
    }

    @KSMethod
    public static Map<Object, DynamicObject> loadFromCache(String entityName, String selectProperties, QFilter[] filters, String orderBy) {
        try (EntityTraceSpan span = EntityTracer.create((String)TYPE_NAME, (String)METHOD_LOAD_FROM_CACHE);){
            IDSet idSet;
            List idList;
            if (span.isRealtime()) {
                span.addTag(PARAM_ENTITYNAME, entityName);
                span.addTag(PARAM_SELECTFIELDS, selectProperties);
                span.addTag(PARAM_ORDERBY, orderBy);
                span.addLocaleTag(PARAM_FILTERS, (Object)filters);
            }
            DynamicObjectType type = BusinessDataServiceHelper.getSubEntityType(entityName, selectProperties);
            if (StringUtils.isBlank((CharSequence)orderBy)) {
                idList = new ArrayList();
                idSet = new IDSet();
                try (DataSet ds = ORM.create().queryDataSet(BUSINESS_DATA_SERVICE_HELPER_LOAD, entityName, "id", filters, null, -1, (Distinctable)WithEntityEntryDistinctable.get());){
                    ds.forEach(row -> idSet.add(row.get(0)));
                }
                idList.addAll(idSet.idList);
            } else {
                idSet = new IDSet();
                String selectFields = "id";
                selectFields = Pattern.compile("(^id$)|(^id[ ,]+)|([ ,]+id[ ,]+)|([ ,]+id$)").matcher(orderBy).find() ? orderBy.toLowerCase().replaceAll(" asc", "").replaceAll(" desc", "") : selectFields + "," + orderBy.toLowerCase().replaceAll(" asc", "").replaceAll(" desc", "");
                try (DataSet ds = ORM.create().queryDataSet(BUSINESS_DATA_SERVICE_HELPER_LOAD, entityName, selectFields, filters, orderBy, -1);){
                    ds.forEach(row -> idSet.add(row.get("id")));
                }
                idList = idSet.idList;
            }
            Map fromCache = BusinessDataReader.loadFromCache((Object[])idList.toArray(), (DynamicObjectType)type);
            LinkedHashMap listObjs = new LinkedHashMap();
            for (Object id : idList) {
                DynamicObject tObj = (DynamicObject)fromCache.get(id);
                if (null == tObj) continue;
                listObjs.put(id, tObj);
            }
            LinkedHashMap linkedHashMap = listObjs;
            return linkedHashMap;
        }
    }

    public static Map<Object, DynamicObject> loadFromCache(String entityName, QFilter[] filters) {
        MainEntityType type = EntityMetadataCache.getDataEntityType((String)entityName);
        return BusinessDataServiceHelper.loadFromCache((DynamicObjectType)type, filters);
    }

    @KSMethod
    public static Map<Object, DynamicObject> loadFromCache(DynamicObjectType type, QFilter[] filters) {
        try (EntityTraceSpan span = EntityTracer.create((String)TYPE_NAME, (String)METHOD_LOAD_FROM_CACHE);){
            boolean filtersNotNull;
            if (span.isRealtime()) {
                span.addTag(PARAM_ENTITYNAME, type.getName());
                span.addLocaleTag(PARAM_FILTERS, (Object)filters);
            }
            ArrayList idList = new ArrayList();
            Object[] pks = null;
            boolean bl = filtersNotNull = filters != null && filters.length == 1 && filters[0] != null && filters[0].getProperty().equals("id") && filters[0].getNests(false).isEmpty();
            if (filtersNotNull) {
                if ("in".equals(filters[0].getCP()) && !filters[0].isExpressValue()) {
                    pks = QFilterUtil.getWithoutDuplicateInValues((Object)filters[0].getValue());
                } else if ("=".equals(filters[0].getCP()) && !filters[0].isExpressValue()) {
                    pks = new Object[]{filters[0].getValue()};
                }
            }
            if (pks == null) {
                DataEntityCacheManager cacheManager = new DataEntityCacheManager((IDataEntityType)type);
                pks = cacheManager.getCachePks(filters);
                if (pks == null) {
                    try (DataSet ds = ORM.create().queryDataSet("BusinessDataServiceHelper.LoadFromCache", type.getName(), "id", filters, null, -1, (Distinctable)WithEntityEntryDistinctable.get());){
                        ds.forEach(row -> idList.add(row.get(0)));
                    }
                    pks = idList.toArray();
                    cacheManager.putCachePks(filters, pks);
                }
                BusinessDataServiceHelper.outDebugLog(type, filters, pks);
            }
            Map map = BusinessDataReader.loadFromCache(pks, (DynamicObjectType)type);
            return map;
        }
    }

    private static void outDebugLog(DynamicObjectType type, QFilter[] filters, Object[] pks) {
        String loadCacheEnable = SystemPropertyUtils.getProptyByTenant((String)"businessdatareader.loadfromcache.log", (String)RequestContext.get().getTenantId());
        if ("true".equalsIgnoreCase(loadCacheEnable)) {
            int i;
            StringBuilder sb = new StringBuilder(32);
            sb.append("loadfromcache.log:");
            sb.append(" type.getExtendName():").append(type.getExtendName());
            sb.append(" | type.getProperties().size():").append(type.getProperties().size());
            StringBuilder filterKey = new StringBuilder(16);
            if (filters == null || filters.length == 0) {
                filterKey.append("null");
            } else {
                for (i = 0; i < filters.length; ++i) {
                    if (filters[0] == null) continue;
                    filterKey.append(filters[i]).append(',');
                }
                if (filterKey.length() > 1) {
                    filterKey.deleteCharAt(filterKey.length() - 1);
                }
            }
            sb.append(" | filterlocalcachekey: ").append((CharSequence)filterKey);
            sb.append(" | pks[10]:");
            i = 1;
            for (Object pk : pks) {
                if (i > 10) break;
                sb.append(pk.toString()).append(",");
                ++i;
            }
            String rootType = type.getAlias().toLowerCase();
            DistributeSessionlessCache cache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache(null, new DistributeCacheHAPolicy());
            RequestContext context = RequestContext.get();
            String rootCacheKey = context.getAccountId() + "." + rootType.toLowerCase();
            Map subTypes = cache.getAll(rootCacheKey);
            sb.append(" | subtype keys: ");
            for (String key : subTypes.keySet()) {
                sb.append(key).append(",");
            }
            CacheConfigInfo info = new CacheConfigInfo();
            info.setTimeout(3600);
            info.setMaxMemSize(300);
            LocalMemoryCache rootCache = CacheFactory.getCommonCacheFactory().$getOrCreateLocalMemoryCache(RequestContext.get().getAccountId(), "bd", info);
            String rootFilterType = rootType + ".filter";
            Map filterCache = (Map)rootCache.get(rootFilterType);
            sb.append(" | localcacheKey(rootTYpe) - ").append(rootFilterType).append(":");
            if (filterCache != null) {
                i = 0;
                for (Object pk : pks) {
                    if (i > 10) break;
                    sb.append(pk.toString()).append("-").append(filterCache.get(pk));
                    ++i;
                }
            }
            rootFilterType = type.getExtendName() + ".filter";
            filterCache = (Map)rootCache.get(rootFilterType);
            sb.append(" | localcacheKey(subType) - ").append(rootFilterType).append(":");
            if (filterCache != null) {
                for (Object pk : pks) {
                    if (i > 10) break;
                    sb.append(pk.toString()).append("-").append(filterCache.get(pk));
                }
            }
            sb.append("check rootType and subType are the same");
            log.error(sb.toString());
        }
    }

    public static void removeCache(DynamicObjectType type) {
        DataEntityCacheManager cacheManager = new DataEntityCacheManager((IDataEntityType)type);
        cacheManager.removeByDt();
    }

    @KSMethod
    public static void loadRefence(Object[] dataEntitys, IDataEntityType type) {
        BusinessDataReader.loadRefence((Object[])dataEntitys, (IDataEntityType)type);
    }

    @Deprecated
    @SdkInternal
    public static void delete(IDataEntityType type, Object[] pks) {
        try (EntityTraceSpan span = EntityTracer.create((String)TYPE_NAME, (String)"delete");){
            String dbkey;
            XidInfo xidInfo;
            if (span.isRealtime()) {
                span.addTag(PARAM_ENTITYNAME, type.getName());
                span.addLocaleTag(PARAM_PKID, (Object)pks);
            }
            if ((xidInfo = DTXServiceHelper.prepareXid((String)(dbkey = type.getDBRouteKey()))) != null && xidInfo.getState() == 1) {
                log.info("the delete operation has been process before,return");
                return;
            }
            try (TXHandle h = TX.beginRequired();){
                try {
                    BusinessDataWriter.delete((IDataEntityType)type, (Object[])pks);
                    if (Configuration.isEnable()) {
                        DTXServiceHelper.confirmXid((String)dbkey, null);
                    }
                }
                catch (Throwable e) {
                    h.markRollback();
                    throw e;
                }
            }
        }
    }

    @Deprecated
    @SdkInternal
    public static Object[] save(IDataEntityType type, Object[] dataEntities) {
        String dbkey = type.getDBRouteKey();
        XidInfo xidInfo = DTXServiceHelper.prepareXid((String)dbkey);
        if (xidInfo != null && xidInfo.getState() == 1) {
            log.info("the save operation has been process before,return");
            String op = xidInfo.getOperationResult();
            Object[] result = null;
            if (op != null) {
                result = dataEntities != null && dataEntities.length != 0 && dataEntities[0] instanceof DynamicObject ? DynamicObjectSerializeUtil.deserialize(op, ((DynamicObject)dataEntities[0]).getDynamicObjectType()) : (Object[])JSON.parseObject((String)op, Object[].class);
            }
            return result;
        }
        Throwable throwable = null;
        try (TXHandle h = TX.required();){
            Object[] result = BusinessDataWriter.save((IDataEntityType)type, (Object[])dataEntities);
            if (Configuration.isEnable()) {
                if (dataEntities != null && dataEntities.length != 0 && dataEntities[0] instanceof DynamicObject) {
                    DTXServiceHelper.confirmXid((String)dbkey, result != null ? DynamicObjectSerializeUtil.serialize(result, ((DynamicObject)dataEntities[0]).getDynamicObjectType()) : null);
                } else {
                    DTXServiceHelper.confirmXid((String)dbkey, (String)(result != null ? JSON.toJSONString((Object)result) : null));
                }
            }
            Object[] objectArray = result;
            return objectArray;
        }
        catch (Throwable e) {
            try {
                h.markRollback();
                throw e;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }

    static class InnerDataModel
    extends AbstractFormDataModel {
        public InnerDataModel(String entityNumber, String pageId, Map<Class<?>, Object> services) {
            super(entityNumber, pageId, services);
        }

        public void fillReferenceData(Object[] dataEntities, IDataEntityType dataEntityType) {
            BusinessDataReader.loadRefence((Object[])dataEntities, (IDataEntityType)dataEntityType);
        }

        protected DynamicObject loadFromCache() {
            throw new RuntimeException("not implements!!!");
        }

        public void create() {
            throw new RuntimeException("not implements!!!");
        }

        public DynamicObject loadReferenceData(DynamicObjectType dt, Object pkValue) {
            return this.loadReferenceDataBatch(dt, new Object[]{pkValue}).get(pkValue);
        }

        public Map<Object, DynamicObject> loadReferenceDataBatch(DynamicObjectType dt, Object[] pkValues) {
            return BusinessDataReader.loadFromCache((Object[])pkValues, (DynamicObjectType)dt);
        }

        public Map<Object, DynamicObject> loadReferenceDataBatch(DynamicObjectType dt, List<QFilter> qFilters) {
            ArrayList listIds = new ArrayList();
            try (DataSet ds = ORM.create().queryDataSet("BusinessDataServiceHelper.LoadFromCache", dt.getName(), "id", qFilters.toArray(new QFilter[0]));){
                ds.forEach(row -> listIds.add(row.get(0)));
            }
            return BusinessDataReader.loadFromCache((Object[])listIds.toArray(new Object[listIds.size()]), (DynamicObjectType)dt);
        }
    }

    private static class IDSet {
        private final Set<Object> sameSet = new HashSet<Object>();
        private final List<Object> idList = new ArrayList<Object>();

        private IDSet() {
        }

        void add(Object obj) {
            if (this.sameSet.contains(obj)) {
                return;
            }
            this.sameSet.add(obj);
            this.idList.add(obj);
        }

        boolean has(Object obj) {
            return this.sameSet.contains(obj);
        }
    }
}

