/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.servicehelper;

import java.util.ArrayList;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.metadata.database.DbMetadataTable;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.encrypt.Encrypters;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.metadata.dao.AlterTableUtil;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.entity.BillEntity;
import kd.bos.metadata.entity.Entity;
import kd.bos.metadata.entity.EntityItem;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.metadata.entity.EntryEntity;
import kd.bos.metadata.entity.commonfield.Field;
import kd.bos.metadata.entity.commonfield.MuliLangTextField;

public class EncryptDataServiceHelper {
    public static void repairEncrptyData(String entityNumber, String fieldKey) {
        if (StringUtils.isBlank((CharSequence)entityNumber) || StringUtils.isBlank((CharSequence)fieldKey)) {
            return;
        }
        String entityId = MetadataDao.getIdByNumber((String)entityNumber, (MetaCategory)MetaCategory.Entity);
        EntityMetadata entityMetadata = (EntityMetadata)MetadataDao.readRuntimeMeta((String)entityId, (MetaCategory)MetaCategory.Entity);
        List entitys = entityMetadata.getEntitys();
        String tableName = "";
        String encryptFieldName = "";
        String fidName = "";
        Field field = entityMetadata.getFieldByKey(fieldKey);
        if (field.isEncrypt()) {
            encryptFieldName = field.getEncryptFieldName();
        }
        boolean isMultiLangField = field instanceof MuliLangTextField;
        boolean isGlField = field instanceof MuliLangTextField && ((MuliLangTextField)field).isGL();
        ArrayList<RepairTask> tasks = new ArrayList<RepairTask>(2);
        block0: for (Entity entity : entitys) {
            List items = entity.getItems();
            for (EntityItem item : items) {
                if (!item.getKey().equalsIgnoreCase(fieldKey)) continue;
                tableName = entityMetadata.getFieldByKey(fieldKey).getTableName(entity);
                if (entity instanceof BillEntity) {
                    fidName = ((BillEntity)entity).getPkFieldName();
                } else if (entity instanceof EntryEntity) {
                    fidName = ((EntryEntity)entity).getEntryPkFieldName();
                }
                DbMetadataTable dbMetadataTable = AlterTableUtil.getTableSchema((String)entityMetadata.getDBRouteKey(), (String)tableName);
                if (isMultiLangField) {
                    String mulLangTableName = tableName + "_L";
                    DbMetadataTable langTableSchema = AlterTableUtil.getTableSchema((String)entityMetadata.getDBRouteKey(), (String)mulLangTableName);
                    tasks.add(new RepairTask(DBRoute.of((String)entityMetadata.getDBRouteKey()), mulLangTableName, langTableSchema, "fpkid", field, encryptFieldName));
                    if (!isGlField) continue block0;
                }
                tasks.add(new RepairTask(DBRoute.of((String)entityMetadata.getDBRouteKey()), tableName, dbMetadataTable, fidName, field, encryptFieldName));
                continue block0;
            }
        }
        EncryptDataServiceHelper.updateData(tasks);
    }

    private static void updateData(List<RepairTask> tasks) {
        for (RepairTask task : tasks) {
            EncryptDataServiceHelper.updateData(task.getRoute(), task.getTableName(), task.getTbMeta(), task.getFid(), task.getPropertyType().getFieldName(), task.getEncryptField());
        }
    }

    private static void updateData(DBRoute dbRoute, String tableName, DbMetadataTable dbMeta, String fidFieldName, String fieldName, String encryptFieldName) {
        String algoKey = "encryptdatarepair";
        String fidName = null;
        if (dbMeta != null && dbMeta.getPrimaryKey() != null) {
            fidName = dbMeta.getPrimaryKey().getName();
        } else if (StringUtils.isNotBlank((CharSequence)fidFieldName)) {
            fidName = fidFieldName;
        } else {
            throw new KDException(new ErrorCode("encrypterror", String.format(ResManager.loadKDString((String)"\u672a\u627e\u5230 %s \u7684\u4e3b\u952e", (String)"EncryptDataServiceHelper_0", (String)"bos-servicehelper", (Object[])new Object[0]), tableName)), new Object[]{String.format(ResManager.loadKDString((String)"\u672a\u627e\u5230 %s \u7684\u4e3b\u952e", (String)"EncryptDataServiceHelper_0", (String)"bos-servicehelper", (Object[])new Object[0]), tableName)});
        }
        String sql = String.format("select %s , %s  from %s where %s is null and %s is not null", fidName, fieldName, tableName, encryptFieldName, fieldName);
        try (DataSet ds = DB.queryDataSet((String)algoKey, (DBRoute)dbRoute, (String)sql);){
            ArrayList<Object[]> paramsList = new ArrayList<Object[]>(1000);
            while (ds.hasNext()) {
                Row row = ds.next();
                Object id = row.get(0);
                Object f1 = row.get(1);
                String f2 = Encrypters.encode((String)String.valueOf(f1));
                Object[] objects = new Object[]{f2, id};
                paramsList.add(objects);
                if (paramsList.size() != 1000) continue;
                DB.executeBatch((DBRoute)dbRoute, (String)String.format("update %s set %s =? where %s =?", tableName, encryptFieldName, fidName), paramsList);
                paramsList.clear();
            }
            if (!paramsList.isEmpty()) {
                DB.executeBatch((DBRoute)dbRoute, (String)String.format("update %s set %s =? where %s=?", tableName, encryptFieldName, fidName), paramsList);
            }
        }
    }

    static class RepairTask {
        private DBRoute route;
        private String tableName;
        private DbMetadataTable tbMeta;
        private String fid;
        private Field<?> propertyType;
        private String encryptField;

        public RepairTask(DBRoute route, String tableName, DbMetadataTable tbMeta, String fid, Field<?> field, String encryptField) {
            this.route = route;
            this.tableName = tableName;
            this.tbMeta = tbMeta;
            this.fid = fid;
            this.propertyType = field;
            this.encryptField = encryptField;
        }

        public DBRoute getRoute() {
            return this.route;
        }

        public void setRoute(DBRoute route) {
            this.route = route;
        }

        public String getTableName() {
            return this.tableName;
        }

        public void setTableName(String tableName) {
            this.tableName = tableName;
        }

        public DbMetadataTable getTbMeta() {
            return this.tbMeta;
        }

        public void setTbMeta(DbMetadataTable tbMeta) {
            this.tbMeta = tbMeta;
        }

        public String getFid() {
            return this.fid;
        }

        public void setFid(String fid) {
            this.fid = fid;
        }

        public Field<?> getPropertyType() {
            return this.propertyType;
        }

        public void setPropertyType(Field<?> propertyType) {
            this.propertyType = propertyType;
        }

        public String getEncryptField() {
            return this.encryptField;
        }

        public void setEncryptField(String encryptField) {
            this.encryptField = encryptField;
        }
    }
}

