/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.servicehelper;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.ISimpleProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.trace.EntityTraceSpan;
import kd.bos.dataentity.trace.EntityTracer;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.db.SqlBuilder;
import kd.bos.db.SqlParameter;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.SubEntryType;
import kd.bos.entity.SummaryToField;
import kd.bos.entity.list.SummaryType;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.DecimalProp;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;

public class EntrySummaryServiceHelper {
    private static Log log = LogFactory.getLog(EntrySummaryServiceHelper.class);
    private static final String TRACETYPE_ENTRYSUMMARY = "entrysummary";
    private static final String TRACE_NULL_VALUE = "null";
    private static final String PARAM_ENTITYNUMBER = "pk";
    private static final String PARAM_PKID = "pkIdSet";
    private static final String PARAM_SUMMARYTOFIELDLIST = "summaryToFieldList";
    private static final String BD_CURRENCY = "bd_currency";
    private static final String BD_MEASUREUNITS = "bd_measureunits";
    private static final String CURRENCY_AMTPRECISION = "amtprecision";
    private static final String MEASUREUNITS_PRECISION = "precision";

    public static void updateSummaryToField(String entityNumber, Set<Object> pkIdSet) {
        EntrySummaryServiceHelper.updateSummaryToField(entityNumber, pkIdSet, new ArrayList<String>(1));
    }

    public static void updateSummaryToField(String entityNumber, Set<Object> pkIdSet, List<String> summaryToFieldList) {
        try (EntityTraceSpan span = EntityTracer.create((String)TRACETYPE_ENTRYSUMMARY, (String)"updateSummaryToField");){
            if (span.isRealtime()) {
                span.addTag(PARAM_ENTITYNUMBER, entityNumber);
                span.addTag(PARAM_PKID, CollectionUtils.isEmpty(pkIdSet) ? TRACE_NULL_VALUE : pkIdSet.toString());
                span.addTag(PARAM_SUMMARYTOFIELDLIST, CollectionUtils.isEmpty(summaryToFieldList) ? TRACE_NULL_VALUE : summaryToFieldList.toString());
            }
            if (CollectionUtils.isEmpty(pkIdSet)) {
                return;
            }
            if (StringUtils.isBlank((CharSequence)entityNumber)) {
                return;
            }
            MainEntityType mainType = EntityMetadataCache.getDataEntityType((String)entityNumber);
            if (mainType == null) {
                return;
            }
            Map allEntities = mainType.getAllEntities();
            for (EntityType entityType : allEntities.values()) {
                if (!(entityType instanceof EntryType) || entityType instanceof SubEntryType) continue;
                EntrySummaryServiceHelper.updateSummaryToFieldByEntrySum(mainType, (EntryType)entityType, pkIdSet, summaryToFieldList);
            }
        }
    }

    private static void updateSummaryToFieldByEntrySum(MainEntityType mainType, EntryType entryType, Set<Object> pkIdSet, List<String> summaryToFieldList) {
        ISimpleProperty primaryKey = mainType.getPrimaryKey();
        if (primaryKey == null) {
            return;
        }
        HashMap<String, List<ISimpleProperty>> mainSummaryColumnMap = new HashMap<String, List<ISimpleProperty>>();
        HashMap<String, List<Tuple<String, String>>> entrySummaryColumnMap = new HashMap<String, List<Tuple<String, String>>>();
        HashMap<String, List<Tuple<DynamicProperty, BasedataProp>>> controlColumnMap = new HashMap<String, List<Tuple<DynamicProperty, BasedataProp>>>();
        EntrySummaryServiceHelper.getSummaryColumnMap(mainType, entryType, summaryToFieldList, mainSummaryColumnMap, entrySummaryColumnMap, controlColumnMap);
        if (CollectionUtils.isEmpty(entrySummaryColumnMap) || CollectionUtils.isEmpty(mainSummaryColumnMap)) {
            return;
        }
        HashMap<Object, Map<String, Object>> queryResultDataMap = new HashMap<Object, Map<String, Object>>();
        for (Map.Entry<String, List<Tuple<String, String>>> entry : entrySummaryColumnMap.entrySet()) {
            EntrySummaryServiceHelper.queryEntryData(mainType, entryType, pkIdSet, entry, queryResultDataMap);
        }
        HashMap<Object, Map<String, List>> queryPrecisionResultDataMap = new HashMap<Object, Map<String, List>>();
        for (Map.Entry<String, List<Tuple<DynamicProperty, BasedataProp>>> entry : controlColumnMap.entrySet()) {
            EntrySummaryServiceHelper.queryPrecisionData(mainType, pkIdSet, entry, queryPrecisionResultDataMap);
        }
        if (!CollectionUtils.isEmpty(queryPrecisionResultDataMap)) {
            EntrySummaryServiceHelper.ensurePrecision(queryResultDataMap, queryPrecisionResultDataMap);
        }
        if (!CollectionUtils.isEmpty(queryResultDataMap)) {
            for (Map.Entry<String, List<ISimpleProperty>> entry : mainSummaryColumnMap.entrySet()) {
                EntrySummaryServiceHelper.updateMainData(mainType, entry, queryResultDataMap);
            }
        }
    }

    private static void queryEntryData(MainEntityType mainType, EntryType entryType, Set<Object> pkIdSet, Map.Entry<String, List<Tuple<String, String>>> entrySummaryColumn, final Map<Object, Map<String, Object>> queryResultDataMap) {
        String tableGroupStr = entrySummaryColumn.getKey();
        String entrytablename = entryType.getAlias();
        if (StringUtils.isEmpty((CharSequence)entrytablename)) {
            return;
        }
        ISimpleProperty primaryKey = mainType.getPrimaryKey();
        final String pkColumn = primaryKey.getAlias();
        final List<Tuple<String, String>> summaryColumnList = entrySummaryColumn.getValue();
        if (StringUtils.isNotBlank((CharSequence)tableGroupStr)) {
            entrytablename = entrytablename + "_" + tableGroupStr;
        }
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append("select ", new Object[0]).append(pkColumn, new Object[0]).append(", ", new Object[0]);
        for (int i = 0; i < summaryColumnList.size(); ++i) {
            Tuple<String, String> columnTuple = summaryColumnList.get(i);
            sqlBuilder.append("sum(", new Object[0]).append((String)columnTuple.item2, new Object[0]).append(") ", new Object[0]).append((String)columnTuple.item1, new Object[0]).append(" ", new Object[0]);
            if (summaryColumnList.size() - 1 == i) continue;
            sqlBuilder.append(",", new Object[0]);
        }
        sqlBuilder.append("from ", new Object[0]).append(entrytablename, new Object[0]).append(" ", new Object[0]);
        sqlBuilder.append("where ", new Object[0]);
        sqlBuilder.appendIn(pkColumn, pkIdSet.toArray());
        sqlBuilder.append("group by ", new Object[0]).append(pkColumn, new Object[0]);
        EntrySummaryServiceHelper.initQueryResultDataMap(pkIdSet, queryResultDataMap, summaryColumnList);
        DB.query((DBRoute)new DBRoute(entryType.getDBRouteKey()), (SqlBuilder)sqlBuilder, (ResultSetHandler)new ResultSetHandler<Boolean>(){

            public Boolean handle(ResultSet rs) throws SQLException {
                Map<Object, Object> dataMap = null;
                while (rs.next()) {
                    Object pkVal = rs.getObject(pkColumn);
                    if (queryResultDataMap.get(pkVal) == null) {
                        dataMap = new HashMap(16);
                        queryResultDataMap.put(pkVal, dataMap);
                    } else {
                        dataMap = (Map)queryResultDataMap.get(pkVal);
                    }
                    for (Tuple tuple : summaryColumnList) {
                        dataMap.put(tuple.item1, rs.getObject((String)tuple.item1));
                    }
                }
                return true;
            }
        });
    }

    private static void queryPrecisionData(MainEntityType mainType, Set<Object> pkIdSet, Map.Entry<String, List<Tuple<DynamicProperty, BasedataProp>>> controlColumn, final Map<Object, Map<String, List>> queryPrecisionResultDataMap) {
        String tableGroupStr = controlColumn.getKey();
        String maintablename = mainType.getAlias();
        ISimpleProperty primaryKey = mainType.getPrimaryKey();
        final String pkColumn = primaryKey.getAlias();
        final List<Tuple<DynamicProperty, BasedataProp>> controlColumnList = controlColumn.getValue();
        if (StringUtils.isNotBlank((CharSequence)tableGroupStr)) {
            maintablename = maintablename + "_" + tableGroupStr;
        }
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append("select ", new Object[0]).append(pkColumn, new Object[0]).append(",", new Object[0]);
        for (int i = 0; i < controlColumnList.size(); ++i) {
            Tuple<DynamicProperty, BasedataProp> columnTuple = controlColumnList.get(i);
            sqlBuilder.append(((BasedataProp)columnTuple.item2).getAlias(), new Object[0]).append(" ", new Object[0]).append(((DynamicProperty)columnTuple.item1).getAlias(), new Object[0]).append(" ", new Object[0]);
            if (controlColumnList.size() - 1 == i) continue;
            sqlBuilder.append(",", new Object[0]);
        }
        sqlBuilder.append("from ", new Object[0]).append(maintablename, new Object[0]).append(" ", new Object[0]);
        sqlBuilder.append("where ", new Object[0]);
        sqlBuilder.appendIn(pkColumn, pkIdSet.toArray());
        DB.query((DBRoute)new DBRoute(mainType.getDBRouteKey()), (SqlBuilder)sqlBuilder, (ResultSetHandler)new ResultSetHandler<Boolean>(){

            public Boolean handle(ResultSet rs) throws SQLException {
                Map dataMap = null;
                while (rs.next()) {
                    Object pkVal = rs.getObject(pkColumn);
                    if (queryPrecisionResultDataMap.get(pkVal) == null) {
                        dataMap = new HashMap();
                        queryPrecisionResultDataMap.put(pkVal, dataMap);
                    } else {
                        dataMap = (Map)queryPrecisionResultDataMap.get(pkVal);
                    }
                    for (Tuple tuple : controlColumnList) {
                        Object val = rs.getObject(((DynamicProperty)tuple.item1).getAlias());
                        if ((!(val instanceof Long) || Long.compare(0L, (Long)val) == 0) && (!(val instanceof String) || !StringUtils.isNotEmpty((CharSequence)((String)val)))) continue;
                        ArrayList<Object> valList = new ArrayList<Object>();
                        valList.add(((BasedataProp)tuple.item2).getBaseEntityId());
                        valList.add(val);
                        dataMap.put(((DynamicProperty)tuple.item1).getAlias(), valList);
                    }
                }
                return true;
            }
        });
    }

    private static void updateMainData(MainEntityType mainType, Map.Entry<String, List<ISimpleProperty>> mainSummaryColumn, Map<Object, Map<String, Object>> queryResultDataMap) {
        ISimpleProperty primaryKey = mainType.getPrimaryKey();
        String pkColumn = primaryKey.getAlias();
        List<ISimpleProperty> summaryColumnList = mainSummaryColumn.getValue();
        String maintablename = mainType.getAlias();
        if (StringUtils.isNotBlank((CharSequence)mainSummaryColumn.getKey())) {
            maintablename = maintablename + "_" + mainSummaryColumn.getKey();
        }
        StringBuilder sqlBuilder = new StringBuilder();
        sqlBuilder.append("update ").append(maintablename).append(" ");
        sqlBuilder.append("set ");
        for (int i = 0; i < summaryColumnList.size(); ++i) {
            ISimpleProperty columnProperty = summaryColumnList.get(i);
            sqlBuilder.append(columnProperty.getAlias()).append(" = ? ");
            if (summaryColumnList.size() - 1 == i) continue;
            sqlBuilder.append(",");
        }
        sqlBuilder.append("where ").append(pkColumn).append(" = ?");
        ArrayList<SqlParameter[]> paramList = new ArrayList<SqlParameter[]>(queryResultDataMap.size());
        SqlParameter[] params = null;
        for (Map.Entry<Object, Map<String, Object>> resultDataMap : queryResultDataMap.entrySet()) {
            Map<String, Object> resultData = resultDataMap.getValue();
            Object pkVal = resultDataMap.getKey();
            params = new SqlParameter[summaryColumnList.size() + 1];
            int j = 0;
            for (ISimpleProperty columnProperty : summaryColumnList) {
                params[j] = EntrySummaryServiceHelper.getSqlParameter(columnProperty.getAlias(), columnProperty.getDbType(), resultData.get(columnProperty.getAlias()) == null ? "0" : resultData.get(columnProperty.getAlias()).toString());
                ++j;
            }
            params[j] = EntrySummaryServiceHelper.getSqlParameter(primaryKey.getAlias(), primaryKey.getDbType(), pkVal == null ? "0" : pkVal.toString());
            paramList.add(params);
        }
        DB.executeBatch((DBRoute)new DBRoute(mainType.getDBRouteKey()), (String)sqlBuilder.toString(), paramList);
    }

    private static void getSummaryColumnMap(MainEntityType mainType, EntryType entryType, List<String> summaryToFieldList, Map<String, List<ISimpleProperty>> mainSummaryColumnMap, Map<String, List<Tuple<String, String>>> entrySummaryColumnMap, Map<String, List<Tuple<DynamicProperty, BasedataProp>>> controlColumnMap) {
        Map fields = entryType.getFields();
        for (IDataEntityProperty property : fields.values()) {
            String controlTableGroup;
            DynamicProperty controlProp;
            String mainTableGroup;
            String entryTableGroup;
            String fieldKey;
            SummaryToField summaryToField;
            if (!(property instanceof DecimalProp) || !CollectionUtils.isEmpty(summaryToFieldList) && !summaryToFieldList.contains(property.getName()) || (summaryToField = ((DecimalProp)property).getSummaryToField()) == null || summaryToField.getSumType() != SummaryType.SUM.getValue() || !StringUtils.isNotBlank((CharSequence)summaryToField.getFieldKey()) || !StringUtils.isNotBlank((CharSequence)(fieldKey = summaryToField.getFieldKey())) || mainType.getProperty(fieldKey) == null) continue;
            DynamicProperty mainProperty = mainType.getProperty(fieldKey);
            String string = entryTableGroup = property.getTableGroup() == null ? "" : property.getTableGroup();
            if (entrySummaryColumnMap.get(entryTableGroup) == null) {
                entrySummaryColumnMap.put(entryTableGroup, new ArrayList(16));
            }
            if (StringUtils.isEmpty((CharSequence)mainProperty.getAlias()) || StringUtils.isEmpty((CharSequence)property.getAlias())) continue;
            entrySummaryColumnMap.get(entryTableGroup).add((Tuple<String, String>)new Tuple((Object)mainProperty.getAlias(), (Object)property.getAlias()));
            String string2 = mainTableGroup = mainProperty.getTableGroup() == null ? "" : mainProperty.getTableGroup();
            if (mainSummaryColumnMap.get(mainTableGroup) == null) {
                mainSummaryColumnMap.put(mainTableGroup, new ArrayList(16));
            }
            mainSummaryColumnMap.get(mainTableGroup).add((ISimpleProperty)mainProperty);
            String controlPropName = ((DecimalProp)mainProperty).getControlPropName();
            if (!StringUtils.isNotBlank((CharSequence)controlPropName) || !((controlProp = mainType.getProperty(controlPropName)) instanceof BasedataProp) || StringUtils.isEmpty((CharSequence)controlProp.getAlias())) continue;
            String string3 = controlTableGroup = controlProp.getTableGroup() == null ? "" : controlProp.getTableGroup();
            if (controlColumnMap.get(controlTableGroup) == null) {
                controlColumnMap.put(controlTableGroup, new ArrayList(16));
            }
            controlColumnMap.get(controlTableGroup).add((Tuple<DynamicProperty, BasedataProp>)new Tuple((Object)mainProperty, (Object)((BasedataProp)controlProp)));
        }
    }

    private static void initQueryResultDataMap(Set<Object> pkIdSet, Map<Object, Map<String, Object>> queryResultDataMap, List<Tuple<String, String>> summaryColumnList) {
        Map<Object, Object> dataMap = null;
        for (Object objId : pkIdSet) {
            if (queryResultDataMap.get(objId) == null) {
                dataMap = new HashMap(16);
                queryResultDataMap.put(objId, dataMap);
            } else {
                dataMap = queryResultDataMap.get(objId);
            }
            for (Tuple<String, String> tuple : summaryColumnList) {
                dataMap.put(tuple.item1, "0");
            }
        }
    }

    private static SqlParameter getSqlParameter(String field, int sqlType, String value) {
        SqlParameter sqlParam = null;
        sqlParam = sqlType == 5 ? new SqlParameter(field, sqlType, (Object)Short.parseShort(value)) : (sqlType == -6 ? new SqlParameter(field, sqlType, (Object)Byte.parseByte(value)) : (sqlType == 4 ? new SqlParameter(field, sqlType, (Object)Integer.parseInt(value)) : (sqlType == -5 ? new SqlParameter(field, sqlType, (Object)Long.parseLong(value)) : (sqlType == 7 ? new SqlParameter(field, sqlType, (Object)Float.valueOf(Float.parseFloat(value))) : (sqlType == 6 || sqlType == 8 ? new SqlParameter(field, sqlType, (Object)Double.parseDouble(value)) : (sqlType == 3 || sqlType == 2 ? new SqlParameter(field, sqlType, (Object)BigDecimal.valueOf(Double.parseDouble(value))) : (sqlType == -7 ? new SqlParameter(field, sqlType, (Object)Boolean.parseBoolean(value)) : new SqlParameter(field, sqlType, (Object)value))))))));
        return sqlParam;
    }

    private static void ensurePrecision(Map<Object, Map<String, Object>> queryResultDataMap, Map<Object, Map<String, List>> queryPrecisionResultDataMap) {
        EntrySummaryServiceHelper.getEnsureScale(queryPrecisionResultDataMap);
        for (Map.Entry<Object, Map<String, Object>> resultDataMap : queryResultDataMap.entrySet()) {
            Map<String, Object> resultData = resultDataMap.getValue();
            Map<String, List> precisionResultDataMap = queryPrecisionResultDataMap.get(resultDataMap.getKey());
            if (CollectionUtils.isEmpty(precisionResultDataMap)) continue;
            Set<Map.Entry<String, Object>> entries = resultData.entrySet();
            for (Map.Entry<String, Object> obj : entries) {
                String key = obj.getKey();
                Object value = obj.getValue();
                if (!(value instanceof BigDecimal)) continue;
                BigDecimal v = (BigDecimal)value;
                List precisionResultDataList = precisionResultDataMap.get(key);
                if (precisionResultDataList == null || precisionResultDataList.size() < 3) continue;
                int scale = (Integer)precisionResultDataList.get(2);
                if (v.scale() == scale) continue;
                obj.setValue(v.setScale(scale, 4));
            }
        }
    }

    private static void getEnsureScale(Map<Object, Map<String, List>> queryPrecisionResultDataMap) {
        HashSet currencyIds = new HashSet();
        HashSet measureunitsIds = new HashSet();
        for (Map.Entry<Object, Map<String, List>> entries : queryPrecisionResultDataMap.entrySet()) {
            Map<String, List> value = entries.getValue();
            for (Map.Entry<String, List> columnMap : value.entrySet()) {
                List columnList = columnMap.getValue();
                if (BD_CURRENCY.equals(columnList.get(0))) {
                    currencyIds.add(columnList.get(1));
                    continue;
                }
                if (!BD_MEASUREUNITS.equals(columnList.get(0))) continue;
                measureunitsIds.add(columnList.get(1));
            }
        }
        Map<Object, Object> currencyPrecisionDataMap = new HashMap();
        if (!CollectionUtils.isEmpty(currencyIds)) {
            currencyPrecisionDataMap = EntrySummaryServiceHelper.getPrecisionDataMap(BD_CURRENCY, CURRENCY_AMTPRECISION, currencyIds);
        }
        Map<Object, Object> measureunitsPrecisionDataMap = new HashMap();
        if (!CollectionUtils.isEmpty(measureunitsIds)) {
            measureunitsPrecisionDataMap = EntrySummaryServiceHelper.getPrecisionDataMap(BD_MEASUREUNITS, MEASUREUNITS_PRECISION, measureunitsIds);
        }
        for (Map.Entry<Object, Map<String, List>> entries : queryPrecisionResultDataMap.entrySet()) {
            Map<String, List> value = entries.getValue();
            for (Map.Entry<String, List> columnMap : value.entrySet()) {
                List valList = columnMap.getValue();
                if (BD_CURRENCY.equals(valList.get(0))) {
                    if (currencyPrecisionDataMap.get(valList.get(1)) == null) continue;
                    valList.add(currencyPrecisionDataMap.get(valList.get(1)));
                    continue;
                }
                if (!BD_MEASUREUNITS.equals(valList.get(0)) || measureunitsPrecisionDataMap.get(valList.get(1)) == null) continue;
                valList.add(measureunitsPrecisionDataMap.get(valList.get(1)));
            }
        }
    }

    private static Map<Object, Object> getPrecisionDataMap(String entityName, String precisionColumn, Set ids) {
        DynamicObject[] fromDb;
        HashMap<Object, Object> precisionDataMap = new HashMap<Object, Object>();
        String pkPropName = "id";
        QFilter[] filters = new QFilter[]{new QFilter(pkPropName, "in", (Object)ids.toArray())};
        StringBuilder selectProperties = new StringBuilder().append(pkPropName).append(",").append(precisionColumn);
        for (DynamicObject dbData : fromDb = BusinessDataServiceHelper.load(entityName, selectProperties.toString(), filters)) {
            Object val = dbData.get(precisionColumn);
            if (val == null) continue;
            precisionDataMap.put(dbData.get(pkPropName), val);
        }
        return precisionDataMap;
    }
}

