/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.servicehelper;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.data.BusinessDataReader;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityInfo;
import kd.bos.entity.MainEntityInfoQuery;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.MuliLangTextProp;
import kd.bos.fulltext.BatchValue;
import kd.bos.fulltext.FTStatuEnum;
import kd.bos.fulltext.FullTextFactory;
import kd.bos.fulltext.FullTextUpdater;
import kd.bos.fulltext.MatchProperty;
import kd.bos.fulltext.MonitorValue;
import kd.bos.fulltext.PropertyValue;
import kd.bos.fulltext.common.util.CommonUtil;
import kd.bos.lang.Lang;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.fulltext.FullTextIndex;
import kd.bos.orm.query.fulltext.FullTextIndexWriter;
import kd.bos.service.ITimeService;
import kd.bos.threads.ThreadPools;

public class FullTextIndexHelper {
    private static final String BOS_SERVICEHELPER = "bos-servicehelper";

    private FullTextIndexHelper() {
    }

    private static List<MainEntityInfo> getMainEntityInfoList(List<String> entityNumbers, Lang lang) {
        MainEntityInfoQuery mainEntityInfoQuery = new MainEntityInfoQuery();
        return mainEntityInfoQuery.getMainEntityInfoList(entityNumbers.toArray(new String[0]), lang);
    }

    private static FullTextIndex getFullTextIndex(List<FullTextIndex> fullTextIndexs, String entityNumber) {
        FullTextIndex findFullTextIndex = null;
        for (FullTextIndex fullTextIndex : fullTextIndexs) {
            if (!entityNumber.equalsIgnoreCase(fullTextIndex.getEntityNumber())) continue;
            findFullTextIndex = fullTextIndex;
            break;
        }
        return findFullTextIndex;
    }

    private static FullTextIndex getOrCreateFullTextIndex(List<FullTextIndex> fullTextIndexs, String entityNumber) {
        FullTextIndex findFullTextIndex = FullTextIndexHelper.getFullTextIndex(fullTextIndexs, entityNumber);
        if (findFullTextIndex == null) {
            findFullTextIndex = new FullTextIndex();
            findFullTextIndex.setEntityNumber(entityNumber);
        }
        return findFullTextIndex;
    }

    private static List<MatchProperty> createMatchProperties(MainEntityType mainEntityType, String fieldName) {
        ArrayList<MatchProperty> matchProperties = new ArrayList<MatchProperty>(10);
        if (StringUtils.isNotBlank((CharSequence)fieldName)) {
            DynamicProperty dataEntityProperty = mainEntityType.getProperty(fieldName);
            if (dataEntityProperty instanceof MuliLangTextProp) {
                for (Lang lang : Lang.values()) {
                    MatchProperty nameMatchProperty = lang == Lang.zh_CN ? new MatchProperty(fieldName, lang, true) : new MatchProperty(fieldName, lang, false);
                    matchProperties.add(nameMatchProperty);
                }
            } else {
                matchProperties.add(new MatchProperty(fieldName, null, false));
            }
        }
        return matchProperties;
    }

    private static void putErrorInfo(Map<String, String> errorInfo, String key, String value) {
        if (errorInfo.get(key) != null) {
            String oldValue = errorInfo.get(key);
            errorInfo.put(key, oldValue + "\r\n " + value);
        } else {
            errorInfo.put(key, value);
        }
    }

    public static List<FullTextIndex> initOrCreateIndexes(List<FullTextIndex> fullTextIndexs, List<String> successInfo, List<String> errorInfo, Map<String, String> errorInfoMap, Map<String, MainEntityType> mainEntityTypeMap) {
        ArrayList<FullTextIndex> newFullTextIndexs = new ArrayList<FullTextIndex>(10);
        FullTextUpdater ftu = FullTextFactory.getFullTextUpdater();
        for (Map.Entry<String, MainEntityType> entry : mainEntityTypeMap.entrySet()) {
            MainEntityType mainEntityType = entry.getValue();
            ArrayList<String> propertyNames = new ArrayList<String>(10);
            if (!(mainEntityType instanceof BillEntityType) && !(mainEntityType instanceof BasedataEntityType)) continue;
            if (mainEntityType instanceof BillEntityType && !(mainEntityType instanceof BasedataEntityType)) {
                String billNo = ((BillEntityType)mainEntityType).getBillNo();
                if (StringUtils.isNotBlank((CharSequence)billNo)) {
                    MatchProperty billNoMatchProperty = new MatchProperty(billNo, null, false);
                    MatchProperty[] billNoProperties = new MatchProperty[]{billNoMatchProperty};
                    ftu.addProperty(entry.getKey(), billNoProperties);
                    successInfo.add(entry.getKey());
                    propertyNames.add(billNo);
                } else {
                    FullTextIndexHelper.putErrorInfo(errorInfoMap, ResManager.loadKDString((String)"\u5355\u636e\u7f16\u7801\u4e3a\u7a7a", (String)"FullTextIndexHelper_0", (String)BOS_SERVICEHELPER, (Object[])new Object[0]), entry.getKey());
                }
            } else {
                String number = ((BasedataEntityType)mainEntityType).getNumberProperty();
                String name = ((BasedataEntityType)mainEntityType).getNameProperty();
                ArrayList<MatchProperty> matchProperties = new ArrayList<MatchProperty>(10);
                if (StringUtils.isNotBlank((CharSequence)number)) {
                    if (mainEntityType != null) {
                        matchProperties.addAll(FullTextIndexHelper.createMatchProperties(mainEntityType, number));
                        propertyNames.add(number);
                    }
                } else {
                    FullTextIndexHelper.putErrorInfo(errorInfoMap, ResManager.loadKDString((String)"\u57fa\u7840\u8d44\u6599\u7f16\u7801\u4e3a\u7a7a", (String)"FullTextIndexHelper_1", (String)BOS_SERVICEHELPER, (Object[])new Object[0]), entry.getKey());
                }
                if (StringUtils.isNotBlank((CharSequence)name)) {
                    if (mainEntityType != null) {
                        matchProperties.addAll(FullTextIndexHelper.createMatchProperties(mainEntityType, name));
                        propertyNames.add(name);
                    }
                } else {
                    FullTextIndexHelper.putErrorInfo(errorInfoMap, ResManager.loadKDString((String)"\u57fa\u7840\u8d44\u6599\u540d\u79f0\u4e3a\u7a7a", (String)"FullTextIndexHelper_2", (String)BOS_SERVICEHELPER, (Object[])new Object[0]), entry.getKey());
                }
                if (!propertyNames.isEmpty()) {
                    ftu.addProperty(entry.getKey(), matchProperties.toArray(new MatchProperty[0]));
                    successInfo.add(entry.getKey());
                }
            }
            if (propertyNames.isEmpty()) continue;
            FullTextIndex findFullTextIndex = FullTextIndexHelper.getOrCreateFullTextIndex(fullTextIndexs, entry.getKey());
            for (String propertyName : propertyNames) {
                if (StringUtils.isEmpty((CharSequence)findFullTextIndex.getFieldName())) {
                    findFullTextIndex.setFieldName(propertyName);
                    continue;
                }
                findFullTextIndex.setSyncTime(null);
                if (findFullTextIndex.getFieldName().contains(propertyName)) continue;
                findFullTextIndex.setFieldName(findFullTextIndex.getFieldName() + "," + propertyName);
            }
            newFullTextIndexs.add(findFullTextIndex);
        }
        for (Map.Entry<String, MainEntityType> entry : mainEntityTypeMap.entrySet()) {
            if (successInfo.contains(entry.getKey())) continue;
            errorInfo.add(entry.getKey());
        }
        return newFullTextIndexs;
    }

    private static MainEntityInfo findMainEntityInfoByEntityNumber(List<MainEntityInfo> mainEntityInfos, String entityNumber) {
        for (MainEntityInfo mainEntityInfo : mainEntityInfos) {
            if (!entityNumber.equalsIgnoreCase(mainEntityInfo.getId())) continue;
            return mainEntityInfo;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<BatchValue> getBatchValues(MainEntityType mainEntityType, MainEntityInfo mainEntityInfo, List<BatchValue> billNoMatchProperties, Map<String, String> errorInfo, String entityNumber, String selectField, Map<String, List<MonitorValue>> monitorValueMap, int start, int limit, boolean hasMuliLang) {
        ArrayList<BatchValue> batchValues = new ArrayList<BatchValue>(10);
        try {
            ORM orm = ORM.create();
            try (DataSet ds = orm.queryDataSet("QueryServiceHelper." + entityNumber, entityNumber, selectField, null, null, start, limit);){
                try {
                    for (Row row : ds) {
                        ArrayList<PropertyValue> propertyValues = new ArrayList<PropertyValue>(10);
                        ArrayList<PropertyValue> billNoPropertyValues = new ArrayList<PropertyValue>(10);
                        DynamicObject baseDataDynamicObject = null;
                        if (hasMuliLang) {
                            Object[] pkValues = new Object[]{row.get(0)};
                            Map loadFromCache = BusinessDataReader.loadFromCache((Object[])pkValues, (DynamicObjectType)mainEntityType, (boolean)false);
                            baseDataDynamicObject = (DynamicObject)loadFromCache.get(row.get(0));
                        }
                        for (String propertyName : selectField.split(",")) {
                            if ("id".equalsIgnoreCase(propertyName)) continue;
                            IDataEntityProperty dataEntityProperty = (IDataEntityProperty)mainEntityType.getProperties().get((Object)propertyName);
                            if (dataEntityProperty instanceof MuliLangTextProp) {
                                for (Lang lang : Lang.values()) {
                                    if (FullTextIndexHelper.isIndexCreated(entityNumber, CommonUtil.getLangPN((String)propertyName, (Lang)lang), monitorValueMap)) {
                                        Object value;
                                        if (baseDataDynamicObject == null || (value = baseDataDynamicObject.getLocaleString(propertyName).getItem(lang.toString())) == null) continue;
                                        propertyValues.add(new PropertyValue(propertyName, lang, value.toString(), lang == Lang.zh_CN));
                                        continue;
                                    }
                                    FullTextIndexHelper.putErrorInfo(errorInfo, ResManager.loadKDString((String)"\u5b57\u6bb5\u7d22\u5f15\u521b\u5efa\u72b6\u6001\u4e0d\u4e3a\u5df2\u5b8c\u6210", (String)"FullTextIndexHelper_3", (String)BOS_SERVICEHELPER, (Object[])new Object[0]), String.format(ResManager.loadKDString((String)"%1$s\u5355\u636e%2$s\u5b57\u6bb5\u7d22\u5f15\u521b\u5efa\u72b6\u6001\u4e0d\u4e3a\u5df2\u5b8c\u6210", (String)"FullTextIndexHelper_4", (String)BOS_SERVICEHELPER, (Object[])new Object[0]), entityNumber, CommonUtil.getLangPN((String)propertyName, (Lang)lang)));
                                }
                                continue;
                            }
                            if (FullTextIndexHelper.isIndexCreated(entityNumber, propertyName, monitorValueMap)) {
                                String value;
                                if (mainEntityInfo != null && propertyName.equalsIgnoreCase(mainEntityInfo.getNumberFieldKey()) && mainEntityInfo.isNoSearchEnabled()) {
                                    billNoPropertyValues.add(new PropertyValue("billno", null, row.getString(1), false));
                                    billNoPropertyValues.add(new PropertyValue("entitynumber", null, entityNumber, false));
                                    for (Map.Entry dspEntry : mainEntityType.getDisplayName().entrySet()) {
                                        billNoPropertyValues.add(new PropertyValue("billnoentityname", Lang.from((String)((String)dspEntry.getKey())), (String)dspEntry.getValue(), "zh_CN".equals(dspEntry.getKey())));
                                    }
                                }
                                if ((value = row.getString(propertyName)) == null) continue;
                                propertyValues.add(new PropertyValue(propertyName, null, value.toString(), false));
                                continue;
                            }
                            FullTextIndexHelper.putErrorInfo(errorInfo, ResManager.loadKDString((String)"\u5b57\u6bb5\u7d22\u5f15\u521b\u5efa\u72b6\u6001\u4e0d\u4e3a\u5df2\u5b8c\u6210", (String)"FullTextIndexHelper_3", (String)BOS_SERVICEHELPER, (Object[])new Object[0]), String.format(ResManager.loadKDString((String)"%1$s\u5355\u636e%2$s\u5b57\u6bb5\u7d22\u5f15\u521b\u5efa\u72b6\u6001\u4e0d\u4e3a\u5df2\u5b8c\u6210", (String)"FullTextIndexHelper_4", (String)BOS_SERVICEHELPER, (Object[])new Object[0]), entityNumber, propertyName));
                        }
                        BatchValue batchValue = new BatchValue(row.get(0), propertyValues.toArray(new PropertyValue[0]));
                        batchValues.add(batchValue);
                        BatchValue billNoBatchValue = new BatchValue(row.get(0), billNoPropertyValues.toArray(new PropertyValue[0]));
                        billNoMatchProperties.add(billNoBatchValue);
                    }
                }
                finally {
                    ds.close();
                }
            }
        }
        catch (Exception exception) {
            FullTextIndexHelper.putErrorInfo(errorInfo, exception.getMessage(), entityNumber);
            return batchValues;
        }
        return batchValues;
    }

    private static boolean isIndexCreated(String entityName, String propertyName, Map<String, List<MonitorValue>> monitorValueMap) {
        boolean isIndexCreated = false;
        if (monitorValueMap != null) {
            List<MonitorValue> monitorValues = monitorValueMap.get(entityName);
            if (monitorValues == null) {
                return false;
            }
            for (MonitorValue monitorValue : monitorValues) {
                if (!propertyName.equalsIgnoreCase(monitorValue.getPropertyName()) || monitorValue.getStatus() != FTStatuEnum.ADDED) continue;
                isIndexCreated = true;
                break;
            }
        }
        return isIndexCreated;
    }

    private static boolean syncAllBillData(FullTextIndex fullTextIndex, MainEntityType mainEntityType, Map<String, List<MonitorValue>> monitorValueMap, List<MainEntityInfo> mainEntityInfos, FullTextUpdater ftu, Map<String, String> errorInfoMap, boolean hasMuliLang) {
        int start = 0;
        int limit = 10000;
        boolean isHasNext = true;
        boolean isUpdated = false;
        MainEntityInfo mainEntityInfo = FullTextIndexHelper.findMainEntityInfoByEntityNumber(mainEntityInfos, fullTextIndex.getEntityNumber());
        while (isHasNext) {
            ArrayList<BatchValue> billNoMatchProperties = new ArrayList<BatchValue>(10);
            List<BatchValue> batchValues = FullTextIndexHelper.getBatchValues(mainEntityType, mainEntityInfo, billNoMatchProperties, errorInfoMap, fullTextIndex.getEntityNumber(), "id," + fullTextIndex.getFieldName(), monitorValueMap, start, limit, hasMuliLang);
            boolean bl = isHasNext = batchValues.size() == 10000;
            if (isHasNext) {
                start += 10000;
            }
            if (!batchValues.isEmpty()) {
                ftu.insert(fullTextIndex.getEntityNumber(), batchValues.toArray(new BatchValue[0]));
                if (!isUpdated) {
                    isUpdated = true;
                }
            }
            if (billNoMatchProperties.isEmpty()) continue;
            ftu.insert("all_billno", billNoMatchProperties.toArray(new BatchValue[0]));
        }
        return isUpdated;
    }

    private static int syncBillData(Map<String, MainEntityType> mainEntityTypeMap, Map<String, List<MonitorValue>> monitorValueMap, FullTextUpdater ftu, FullTextIndex fullTextIndex, FullTextIndexWriter fullTextIndexWriter, List<MainEntityInfo> mainEntityInfos, Map<String, String> errorInfoMap, StringBuilder errorMessage, Date now) {
        int successCount = 0;
        MainEntityType mainEntityType = null;
        try {
            boolean hasIndex = false;
            boolean hasMuliLang = false;
            ArrayList<String> properties = new ArrayList<String>(10);
            for (String propertyName : fullTextIndex.getFieldName().split(",")) {
                properties.add(propertyName);
            }
            mainEntityType = mainEntityTypeMap.get(fullTextIndex.getEntityNumber());
            if (mainEntityType == null) {
                mainEntityType = (MainEntityType)EntityMetadataCache.getSubDataEntityType((String)fullTextIndex.getEntityNumber(), properties);
            }
            for (String propertyName : fullTextIndex.getFieldName().split(",")) {
                IDataEntityProperty dataEntityProperty = (IDataEntityProperty)mainEntityType.getProperties().get((Object)propertyName);
                if (dataEntityProperty instanceof MuliLangTextProp) {
                    for (Lang lang : Lang.values()) {
                        if (!FullTextIndexHelper.isIndexCreated(fullTextIndex.getEntityNumber(), CommonUtil.getLangPN((String)propertyName, (Lang)lang), monitorValueMap)) continue;
                        hasIndex = true;
                        hasMuliLang = true;
                        break;
                    }
                } else if (FullTextIndexHelper.isIndexCreated(fullTextIndex.getEntityNumber(), propertyName, monitorValueMap)) {
                    hasIndex = true;
                }
                if (!hasIndex) continue;
                properties.add(propertyName);
            }
            if (hasIndex) {
                if (!FullTextIndexHelper.syncAllBillData(fullTextIndex, mainEntityType, monitorValueMap, mainEntityInfos, ftu, errorInfoMap, hasMuliLang)) {
                    FullTextIndexHelper.putErrorInfo(errorInfoMap, ResManager.loadKDString((String)"\u6ca1\u6709\u8981\u540c\u6b65\u7684\u6570\u636e", (String)"FullTextIndexHelper_5", (String)BOS_SERVICEHELPER, (Object[])new Object[0]), fullTextIndex.getEntityNumber());
                } else {
                    successCount = 1;
                }
                fullTextIndex.setSyncTime(now);
            } else {
                fullTextIndex.setSyncTime(null);
            }
            fullTextIndexWriter.saveFullTextIndex(fullTextIndex, errorMessage);
        }
        catch (Exception e) {
            FullTextIndexHelper.putErrorInfo(errorInfoMap, ResManager.loadKDString((String)"\u5355\u636e\u83b7\u53d6\u5b9e\u4f53\u4fe1\u606f\u5931\u8d25", (String)"FullTextIndexHelper_6", (String)BOS_SERVICEHELPER, (Object[])new Object[0]), String.format(ResManager.loadKDString((String)"\u5355\u636e%1$s\u83b7\u53d6\u5b9e\u4f53\u4fe1\u606f\u5931\u8d25:%2$s", (String)"FullTextIndexHelper_7", (String)BOS_SERVICEHELPER, (Object[])new Object[0]), fullTextIndex.getEntityNumber(), e.getMessage()));
        }
        return successCount;
    }

    public static void syncData(List<FullTextIndex> fullTextIndexs, ITimeService timeService, Map<String, MainEntityType> mainEntityTypeMap) {
        ThreadPools.executeOnceIncludeRequestContext((String)FullTextIndexHelper.class.getSimpleName(), () -> {
            HashMap<String, String> errorInfoMap = new HashMap<String, String>();
            int successCount = 0;
            StringBuilder errorMessage = new StringBuilder();
            Log log = LogFactory.getLog((String)"FullTextIndexHelper");
            FullTextUpdater ftu = FullTextFactory.getFullTextUpdater();
            ArrayList<String> entityNumbers = new ArrayList<String>(10);
            for (FullTextIndex fullTextIndex : fullTextIndexs) {
                entityNumbers.add(fullTextIndex.getEntityNumber());
            }
            List<MainEntityInfo> mainEntityInfos = FullTextIndexHelper.getMainEntityInfoList(entityNumbers, RequestContext.get().getLang());
            Map monitorValueMap = FullTextFactory.getFullTextMonitor().entityNamesMonitor(entityNumbers.toArray(new String[0]));
            FullTextIndexWriter fullTextIndexWriter = new FullTextIndexWriter();
            long currentTimeMillis = System.currentTimeMillis();
            Date now = timeService.now();
            for (FullTextIndex fullTextIndex : fullTextIndexs) {
                successCount += FullTextIndexHelper.syncBillData(mainEntityTypeMap, monitorValueMap, ftu, fullTextIndex, fullTextIndexWriter, mainEntityInfos, errorInfoMap, errorMessage, now);
            }
            log.info(String.format("\u672c\u6b21\u6210\u529f\u540c\u6b65\u6570\u636e%s\u6761,\u5931\u8d25%s\u6761", successCount, fullTextIndexs.size() - successCount));
            log.info(String.format("kd.bos.servicehelper.FullTextIndexHelper.syncData,\u672c\u6b21\u540c\u6b65\u6570\u636e\u7684\u65f6\u95f4\u662f%s", System.currentTimeMillis() - currentTimeMillis));
            for (Map.Entry entry : errorInfoMap.entrySet()) {
                log.error(String.format("%s:%s", entry.getKey(), entry.getValue()));
            }
            if (StringUtils.isNotEmpty((CharSequence)errorMessage.toString())) {
                log.error(String.format("\u540c\u6b65\u6570\u636e\u65f6\u66f4\u65b0\u7d22\u5f15\u8bb0\u5f55\u5931\u8d25,\u9519\u8bef\u4fe1\u606f\uff1a%s", errorMessage.toString()));
            }
        });
    }
}

