/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.servicehelper;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicCollectionProperty;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.filter.FilterField;
import kd.bos.entity.property.MuliLangTextProp;
import kd.bos.fulltext.MatchProperty;
import kd.bos.lang.Lang;

public class FullTextMatchPropertiesHelper {
    private static final char COMMA = ',';

    public static List<MatchProperty> getMatchProperties(List<String> dynFieldReturn, String entityNumber, Collection<String> properties, String configgedFiledsStr, String specFieldsStr) {
        String neededEndtityfields;
        MainEntityType entityType = properties != null && properties.size() > 0 ? (MainEntityType)EntityMetadataCache.getSubDataEntityType((String)entityNumber, properties) : EntityMetadataCache.getDataEntityType((String)entityNumber);
        if (entityType instanceof BillEntityType || entityType instanceof BasedataEntityType) {
            if (entityType instanceof BillEntityType && !(entityType instanceof BasedataEntityType)) {
                String billNo = ((BillEntityType)entityType).getBillNo();
                dynFieldReturn.add(billNo);
            }
            if (entityType instanceof BasedataEntityType) {
                String number = ((BasedataEntityType)entityType).getNumberProperty();
                String name = ((BasedataEntityType)entityType).getNameProperty();
                dynFieldReturn.add(number);
                dynFieldReturn.add(name);
            }
        }
        ArrayList<MatchProperty> matchProperties = new ArrayList<MatchProperty>();
        if (specFieldsStr == null) {
            if (FullTextMatchPropertiesHelper.isAllFields(configgedFiledsStr)) {
                StringBuilder sb = new StringBuilder();
                DataEntityPropertyCollection collect = entityType.getProperties();
                collect.forEach(v -> {
                    if (!(v instanceof DynamicCollectionProperty)) {
                        sb.append(v.getName()).append(',');
                    }
                });
                neededEndtityfields = sb.toString();
            } else {
                neededEndtityfields = configgedFiledsStr;
                if (dynFieldReturn.size() > 0) {
                    neededEndtityfields = neededEndtityfields + "," + dynFieldReturn.stream().collect(Collectors.joining(","));
                    properties.addAll(dynFieldReturn);
                    entityType = (MainEntityType)EntityMetadataCache.getSubDataEntityType((String)entityNumber, properties);
                }
            }
        } else {
            neededEndtityfields = specFieldsStr;
        }
        for (String propertyName : neededEndtityfields.split(",")) {
            FilterField filterField;
            if (propertyName.length() == 0 || (filterField = FilterField.create((MainEntityType)entityType, (String)propertyName)) == null) continue;
            if (filterField.getSrcFieldProp() instanceof MuliLangTextProp) {
                boolean isNameField = false;
                if (entityType instanceof BasedataEntityType) {
                    isNameField = filterField.getRefPropKey().equalsIgnoreCase(((BasedataEntityType)entityType).getNameProperty());
                }
                for (Lang lang : Lang.values()) {
                    MatchProperty matchProperty = lang == Lang.zh_CN ? new MatchProperty(filterField.getRefPropKey(), lang, isNameField) : new MatchProperty(filterField.getRefPropKey(), lang, false);
                    matchProperties.add(matchProperty);
                }
                continue;
            }
            matchProperties.add(new MatchProperty(filterField.getRefPropKey(), null, false));
        }
        return matchProperties;
    }

    private static boolean isAllFields(String configgedFiledsStr) {
        return "*".equals(configgedFiledsStr) || "".equals(configgedFiledsStr);
    }
}

