/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.servicehelper;

import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.exception.OrmException;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.isv.ISVService;
import kd.bos.metadata.AbstractMetadata;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.dao.MetadataWriter;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.metadata.form.FormAp;
import kd.bos.metadata.form.FormMetadata;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.util.DevportalCommonUtil;
import kd.sdk.annotation.SdkPublic;

@SdkPublic
public class MetadataServiceHelper {
    public static MainEntityType getDataEntityType(String number) {
        return EntityMetadataCache.getDataEntityType((String)number);
    }

    public static Map<String, Object> copyMobleFormMetadata(String tplId, String bizAppId, String bizUnitId, String newNumber, LocaleString newName) {
        String newFormId = DBServiceHelper.genStringId();
        String currentIsv = ISVService.getISVInfo().getId();
        String envRegion = DevportalCommonUtil.genEnvRegion();
        FormMetadata formMetadata = (FormMetadata)MetadataDao.readMeta((String)tplId, (MetaCategory)MetaCategory.Form);
        formMetadata.setKey(newNumber);
        formMetadata.setId(newFormId);
        formMetadata.setName(newName);
        formMetadata.setBizappId(bizAppId);
        formMetadata.setEntityId(newFormId);
        formMetadata.setIsv(currentIsv);
        formMetadata.setEnvRegion(envRegion);
        FormAp rootAp = formMetadata.getRootAp();
        if (rootAp != null) {
            rootAp.initializeJsPlugin();
        }
        EntityMetadata entityMetadata = (EntityMetadata)MetadataDao.readMeta((String)tplId, (MetaCategory)MetaCategory.Entity);
        entityMetadata.setKey(newNumber);
        entityMetadata.setId(newFormId);
        entityMetadata.setName(newName);
        entityMetadata.setBizappId(bizAppId);
        entityMetadata.setIsv(currentIsv);
        entityMetadata.getRootEntity().setTemplate(false);
        entityMetadata.setEnvRegion(envRegion);
        Map<String, Object> saveResult = new HashMap(4);
        try (TXHandle h = TX.required();){
            MetadataWriter writer = new MetadataWriter("MobileFormModel");
            saveResult = writer.save(Boolean.FALSE, new AbstractMetadata[]{formMetadata, entityMetadata});
            boolean isSuccess = (Boolean)saveResult.get("success");
            if (isSuccess) {
                saveResult.put("formid", formMetadata.getId());
                saveResult.put("formname", formMetadata.getName());
                DynamicObject dObject = BusinessDataServiceHelper.newDynamicObject("bos_devportal_unitrelform");
                if (StringUtils.isNotBlank((CharSequence)bizAppId)) {
                    dObject.set("bizapp", (Object)bizAppId);
                } else {
                    dObject.set("bizapp", (Object)formMetadata.getBizappId());
                }
                dObject.set("bizunit", (Object)bizUnitId);
                dObject.set("form", (Object)formMetadata.getId());
                SaveServiceHelper.save(new DynamicObject[]{dObject});
            }
        }
        catch (Throwable e) {
            if (e instanceof KDException) {
                throw (KDException)e;
            }
            if (e instanceof OrmException) {
                throw (OrmException)e;
            }
            throw new KDException(e, BosErrorCode.bOS, new Object[]{String.format("Error:%s.", e.getMessage())});
        }
        if (saveResult.size() == 0) {
            saveResult.put("success", Boolean.FALSE);
            saveResult.put("message", ResManager.loadKDString((String)"\u590d\u5236\u79fb\u52a8\u8868\u5355\u6a21\u677f\u5143\u6570\u636e\u9519\u8bef\uff0c\u8bf7\u67e5\u770b\u65e5\u5fd7\uff01", (String)"MetadataServiceHelper_0", (String)"bos-servicehelper", (Object[])new Object[0]));
        }
        return saveResult;
    }
}

