/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.servicehelper;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.EntityTypeUtil;
import kd.bos.entity.EntryEntityDto;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.filter.FilterField;
import kd.bos.entity.filter.PermissionFilterUtil;
import kd.bos.entity.flex.FlexEntityMetaUtils;
import kd.bos.entity.flex.FlexProperty;
import kd.bos.entity.qing.AnalysisField;
import kd.bos.entity.qing.EntryEntity;
import kd.bos.entity.qing.Field;
import kd.bos.entity.qing.FlexBaseDataProp;
import kd.bos.entity.qing.FlexField;
import kd.bos.entity.qing.FlexFieldDetail;
import kd.bos.entity.qing.QingFieldType;
import kd.bos.entity.qing.QingMeta;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.FieldControlRule;
import kd.bos.service.ITimeService;
import kd.bos.service.IUserService;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryListParameter;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.util.JSONUtils;

public class QingServiceHelper {
    private static Log log = LogFactory.getLog(QingServiceHelper.class);

    public static DataSet queryList(QueryListParameter queryListParameter) {
        String[] selectedFields;
        long userId = Long.parseLong(RequestContext.get().getUserId());
        String entityNumber = queryListParameter.getEntityName();
        String appId = queryListParameter.getAppId();
        boolean iHasPermission = PermissionServiceHelper.hasSpecificPerm(userId, appId, entityNumber, "47150e89000000ac");
        if (!iHasPermission) {
            return null;
        }
        MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)entityNumber);
        List qFilters = PermissionFilterUtil.getListPermissionFilters((MainEntityType)mainEntityType, (boolean)queryListParameter.isIsolationOrg(), (String)queryListParameter.getAppId(), (ITimeService)queryListParameter.getTimeService(), (IUserService)queryListParameter.getUserService());
        qFilters.addAll(Arrays.asList(queryListParameter.getFilters()));
        HashSet<String> canNotReadFieldSet = new HashSet<String>();
        Set fieldControlRuleCanNotReadFields = new HashSet();
        List filterFields = EntityTypeUtil.getInstance().getFilterFields((IDataEntityType)mainEntityType);
        FieldControlRule fieldControlRule = PermissionServiceHelper.getFieldRulesSum(userId, appId, entityNumber);
        if (null != fieldControlRule) {
            fieldControlRuleCanNotReadFields = fieldControlRule.getCanNotReadFields();
            for (FilterField filterField : filterFields) {
                if (!fieldControlRuleCanNotReadFields.contains(filterField.getSrcFieldProp().getName())) continue;
                canNotReadFieldSet.add(filterField.getFullFieldName());
            }
        }
        ArrayList<String> allowFields = new ArrayList<String>();
        for (String field : selectedFields = queryListParameter.getSelectFields().split(", ")) {
            if (canNotReadFieldSet.contains(field)) continue;
            allowFields.add(field);
        }
        queryListParameter.selectFields = StringUtils.join((Object[])allowFields.toArray(), (String)",");
        ORM orm = ORM.create();
        orm.optimization().setRoleOnCostThreshold(500);
        return orm.queryDataSet(queryListParameter.getAlgoKey(), queryListParameter.getEntityName(), queryListParameter.getSelectFields(), qFilters.toArray(new QFilter[0]), queryListParameter.getOrderBys(), queryListParameter.getTop());
    }

    private static Map<String, DynamicObject> convert(Map<Object, DynamicObject> source) {
        Set<Map.Entry<Object, DynamicObject>> entries = source.entrySet();
        HashMap<String, DynamicObject> result = new HashMap<String, DynamicObject>(entries.size());
        for (Map.Entry<Object, DynamicObject> entry : entries) {
            result.put(String.valueOf(entry.getKey()), entry.getValue());
        }
        return result;
    }

    public static FlexBaseDataProp getFlexBaseDataType(FlexProperty flexProperty) {
        if (!flexProperty.getValueType().equals("1") && !flexProperty.getValueType().equals("2")) {
            return null;
        }
        String entityName = "";
        entityName = flexProperty.getValueType().equals("2") ? "bos_assistantdata_detail" : flexProperty.getValueSource();
        BasedataEntityType dt = (BasedataEntityType)EntityMetadataCache.getDataEntityType((String)entityName);
        return new FlexBaseDataProp(flexProperty, dt);
    }

    public static FlexBaseDataProp getFlexBaseDataType(String flexBaseDataKey) {
        FlexProperty flexProperty = FlexEntityMetaUtils.getFlexProperty((String)flexBaseDataKey);
        return QingServiceHelper.getFlexBaseDataType(flexProperty);
    }

    public static FlexFieldDetail convertToFlexDetail(FlexField flexField, String flexJsonValue, Map<String, Set<String>> invalidBaseFlexDatas) throws IOException {
        FlexFieldDetail flexFieldDetail = new FlexFieldDetail(flexField, flexJsonValue);
        String flexFieldRowKey = flexFieldDetail.getFlexFieldRowKey();
        Map keyValues = (Map)JSONUtils.cast((String)flexJsonValue, Map.class, (Class[])new Class[]{String.class, Object.class});
        for (Map.Entry entry : keyValues.entrySet()) {
            FlexProperty flexProperty = flexField.getFlexProp((String)entry.getKey());
            if (null == flexProperty) continue;
            String valueStr = String.valueOf(entry.getValue());
            FlexBaseDataProp baseDataFlexProp = QingServiceHelper.getFlexBaseDataType(flexProperty);
            if (null != baseDataFlexProp) {
                if (invalidBaseFlexDatas.get(flexFieldRowKey).contains((String)entry.getKey() + "_" + valueStr)) {
                    flexFieldDetail.addBaseFlexData(baseDataFlexProp);
                    continue;
                }
                DynamicObject dynamicObject = QingServiceHelper.getDynamicObjectForBaseDataProp(entry.getValue(), baseDataFlexProp);
                baseDataFlexProp.setDynamicObject(dynamicObject);
                if (!baseDataFlexProp.checkValid()) {
                    invalidBaseFlexDatas.get(flexFieldRowKey).add((String)entry.getKey() + "_" + valueStr);
                    log.warn("invalid flex base data prop " + (String)entry.getKey() + ":" + valueStr);
                }
                flexFieldDetail.addBaseFlexData(baseDataFlexProp);
                continue;
            }
            flexFieldDetail.addTextFlexPropData(flexProperty, String.valueOf(entry.getValue()));
        }
        return flexFieldDetail;
    }

    private static DynamicObject getDynamicObjectForBaseDataProp(Object baseDataValue, FlexBaseDataProp baseDataFlexProp) {
        String selectProperties = baseDataFlexProp.getSupportedSubPropertysAsString();
        QFilter[] filters = new QFilter[]{new QFilter(baseDataFlexProp.getPrimaryKey(), "=", baseDataValue)};
        Map<String, DynamicObject> flexBaseObjs = QingServiceHelper.convert(BusinessDataServiceHelper.loadFromCache(baseDataFlexProp.getEntityName(), selectProperties, filters));
        return flexBaseObjs.get(String.valueOf(baseDataValue));
    }

    private static void parseEntity(QingMeta qingMeta, Map<String, String> entityNameMap, Set<String> pks, IDataEntityType dataEntityType) {
        List entryEntityDtos = EntityTypeUtil.getEntryEntitiesForForQing((EntityType)((EntityType)dataEntityType));
        int defaultFieldType = QingFieldType.String.toNumber();
        HashMap<String, String> pkMap = new HashMap<String, String>();
        for (EntryEntityDto entryEntityDto : entryEntityDtos) {
            String parentKey;
            if (entryEntityDto.isDBIgnore() || (parentKey = entryEntityDto.getParentKey()) != null && !parentKey.isEmpty() && !entityNameMap.containsKey(parentKey)) continue;
            EntryEntity entryEntity = new EntryEntity();
            String entityKey = entryEntityDto.getKey();
            entryEntity.setKey(entityKey);
            LocaleString entityName = entryEntityDto.getName();
            entryEntity.setName(entityName);
            entityNameMap.put(entityKey, entityName.getLocaleValue());
            String pkFieldName = entryEntityDto.getPkFieldName();
            if (pkFieldName != null && !pkFieldName.isEmpty()) {
                if (parentKey == null || parentKey.isEmpty()) {
                    pkFieldName = pkFieldName.substring(pkFieldName.indexOf(46) + 1);
                }
                pkMap.put(entityKey, pkFieldName);
                entryEntity.setPkFieldName(pkFieldName);
                Field field = new Field();
                field.setEntity(entityKey);
                field.setFieldType(defaultFieldType);
                field.setHide(false);
                field.setKey(pkFieldName);
                field.setName(new LocaleString("PK"));
                pks.add(entityKey + "." + pkFieldName);
                qingMeta.addColumn(field);
            }
            if (parentKey != null && !parentKey.isEmpty()) {
                entryEntity.setParentKey(parentKey);
                String parentPkFieldName = (String)pkMap.get(parentKey);
                String parentEntityName = entityNameMap.get(parentKey);
                Field field = new Field();
                field.setEntity(entityKey);
                field.setFieldType(defaultFieldType);
                field.setHide(false);
                field.setKey(parentPkFieldName);
                field.setName(new LocaleString(parentEntityName + "FK"));
                qingMeta.addColumn(field);
            }
            qingMeta.addEntryEntity(entryEntity);
        }
    }

    private static void parseField(QingMeta qingMeta, Map<String, String> entityNameMap, Set<String> pks, String appId, IDataEntityType dataEntityType) {
        List filterFields = EntityTypeUtil.getInstance().getAnalysisField(dataEntityType);
        FieldControlRule fieldControlRule = PermissionServiceHelper.getFieldRulesSum(Long.parseLong(RequestContext.get().getUserId()), appId, dataEntityType.getName());
        Set canNotReadFields = null == fieldControlRule ? new HashSet() : fieldControlRule.getCanNotReadFields();
        for (AnalysisField filterField : filterFields) {
            Field field;
            if (!filterField.isAnalysis() || canNotReadFields.contains(filterField.getSrcFieldProp().getName()) || !entityNameMap.containsKey((field = filterField.buildField()).getEntity()) || pks.contains(field.getEntity() + "." + field.getKey())) continue;
            qingMeta.addColumn(field);
        }
    }

    public static QingMeta queryAnalysisMeta(String appId, String entityNumber) {
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)entityNumber);
        if (dataEntityType == null || dataEntityType.isDbIgnore()) {
            return null;
        }
        QingMeta qingMeta = new QingMeta();
        HashSet<String> pks = new HashSet<String>();
        HashMap<String, String> entityNameMap = new HashMap<String, String>();
        QingServiceHelper.parseEntity(qingMeta, entityNameMap, pks, (IDataEntityType)dataEntityType);
        QingServiceHelper.parseField(qingMeta, entityNameMap, pks, appId, (IDataEntityType)dataEntityType);
        return qingMeta;
    }
}

