/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.servicehelper.basedata;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeCacheHAPolicy;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.context.RequestContext;
import kd.bos.data.BusinessDataReader;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.DataEntitySerializer;
import kd.bos.dataentity.serialization.DataEntitySerializerOption;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.notification.IconType;
import kd.bos.notification.NotificationBody;
import kd.bos.notification.NotificationFormInfo;
import kd.bos.notification.NotificationLevel;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.servicehelper.basedata.SoftDeleteHandler;
import kd.bos.servicehelper.notification.NotificationServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;

public class DelBasedataTask
extends AbstractTask {
    private static final String BOS_SERVICEHELPER = "bos-servicehelper";

    public void execute(RequestContext context, Map<String, Object> map) throws KDException {
        String baseKey = (String)map.get("baseKey");
        List pkList = (List)SerializationUtils.fromJsonString((String)((String)map.get("basePks")), Object.class);
        Object[] basePks = pkList.toArray();
        String operateKey = (String)map.get("operateKey");
        String userId = (String)map.get("userId");
        Map originStatus = (Map)map.get("originStatus");
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)baseKey);
        try {
            DynamicObject[] objs;
            OperateOption option = OperateOption.create();
            option.setVariableValue("ishasright", "true");
            OperationResult result = OperationServiceHelper.executeOperate(operateKey, baseKey, basePks, option);
            HashSet errorIds = result.getValidateResult().getErrorPkIds();
            for (DynamicObject obj : objs = BusinessDataReader.load((Object[])errorIds.toArray(), (DynamicObjectType)entityType, (Boolean)Boolean.FALSE)) {
                obj.set("enable", originStatus.get(obj.getPkValue().toString()));
            }
            SaveServiceHelper.update(objs);
            if (errorIds.isEmpty()) {
                this.sendSuccessMsg(userId, entityType.getAppId(), ResManager.loadKDString((String)"\u5220\u9664\u4efb\u52a1\u5df2\u7ecf\u5904\u7406\u5b8c\u6bd5\uff0c\u5168\u90e8\u5220\u9664\u6210\u529f\uff0c\u5efa\u8bae\u5237\u65b0\u5217\u8868\u67e5\u770b\u6700\u65b0\u6570\u636e\u3002", (String)"DelBasedataTask_3", (String)BOS_SERVICEHELPER, (Object[])new Object[0]));
            } else {
                this.sendErrorMsg(userId, errorIds.size(), entityType.getAppId(), result);
            }
        }
        catch (Exception e) {
            DynamicObject[] objs;
            for (DynamicObject obj : objs = BusinessDataReader.load((Object[])basePks, (DynamicObjectType)entityType, (Boolean)Boolean.FALSE)) {
                obj.set("enable", originStatus.get(obj.getPkValue().toString()));
            }
            SaveServiceHelper.update(objs);
            this.sendSuccessMsg(userId, entityType.getAppId(), ResManager.loadKDString((String)"\u5220\u9664\u4efb\u52a1\u51fa\u73b0\u5f02\u5e38,\u8bf7\u5230\u8c03\u5ea6\u7ba1\u7406\u5f02\u5e38\u65e5\u5fd7\u4e2d\u67e5\u770b\uff0c\u5efa\u8bae\u5237\u65b0\u5217\u8868\u67e5\u770b\u6700\u65b0\u6570\u636e\u3002", (String)"DelBasedataTask_4", (String)BOS_SERVICEHELPER, (Object[])new Object[0]));
            throw new KDException((Throwable)e, new ErrorCode("delbasedata", ResManager.loadKDString((String)"\u5220\u9664\u4efb\u52a1\u51fa\u73b0\u5f02\u5e38", (String)"DelBasedataTask_5", (String)BOS_SERVICEHELPER, (Object[])new Object[0])), new Object[]{e.getMessage()});
        }
        finally {
            List<Object> records = SoftDeleteHandler.getSoftDeleteRecords(baseKey);
            records.removeAll(Arrays.asList(basePks));
            DistributeSessionlessCache cache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("basedata-softdelete", new DistributeCacheHAPolicy(true, true));
            if (records.isEmpty()) {
                cache.remove("softdelet-" + baseKey);
            } else {
                cache.put("softdelet-" + baseKey, (Object)SerializationUtils.toJsonString(records));
            }
        }
    }

    private String serializeOperationResult(OperationResult operationResult) {
        DataEntitySerializerOption option = new DataEntitySerializerOption();
        option.setIncludeComplexProperty(true);
        return DataEntitySerializer.serializerToString((Object)operationResult, (DataEntitySerializerOption)option);
    }

    private void sendErrorMsg(String userId, int size, String appId, OperationResult operationResult) {
        NotificationBody notificationBody = new NotificationBody();
        notificationBody.setAppId(appId);
        notificationBody.setTitle(ResManager.loadKDString((String)"\u7cfb\u7edf\u63d0\u793a", (String)"DelBasedataTask_0", (String)BOS_SERVICEHELPER, (Object[])new Object[0]));
        notificationBody.setContent(String.format(ResManager.loadKDString((String)"\u5220\u9664\u4efb\u52a1\u5df2\u7ecf\u5904\u7406\u5b8c\u6bd5\uff0c\u5176\u4e2d\u6709%s\u6761\u6570\u636e\u672a\u80fd\u5220\u9664\uff0c\u5efa\u8bae\u5237\u65b0\u5217\u8868\u67e5\u770b\u6700\u65b0\u6570\u636e\u3002", (String)"DelBasedataTask_1", (String)BOS_SERVICEHELPER, (Object[])new Object[0]), size));
        notificationBody.setNotificationId(UUID.randomUUID().toString());
        notificationBody.setIconType(IconType.Info.toString());
        notificationBody.setLevel(NotificationLevel.normal.getLevel());
        NotificationBody.ButtonInfo detailButton = new NotificationBody.ButtonInfo();
        detailButton.setKey("softdeletedetail");
        detailButton.setText(ResManager.loadKDString((String)"\u67e5\u770b\u8be6\u60c5", (String)"DelBasedataTask_2", (String)BOS_SERVICEHELPER, (Object[])new Object[0]));
        notificationBody.addButtonInfo(detailButton);
        notificationBody.setClickClassName("kd.bos.servicehelper.basedata.SoftDeleteNotificationClick");
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("operationResult", this.serializeOperationResult(operationResult));
        notificationBody.setParams(params);
        NotificationFormInfo notificationFormInfo = new NotificationFormInfo();
        notificationFormInfo.setNotification(notificationBody);
        NotificationServiceHelper.sendNotification(Collections.singletonList(userId), notificationFormInfo);
    }

    private void sendSuccessMsg(String userId, String appId, String msg) {
        NotificationBody notificationBody = new NotificationBody();
        notificationBody.setAppId(appId);
        notificationBody.setTitle(ResManager.loadKDString((String)"\u7cfb\u7edf\u63d0\u793a", (String)"DelBasedataTask_0", (String)BOS_SERVICEHELPER, (Object[])new Object[0]));
        notificationBody.setContent(msg);
        notificationBody.setNotificationId(UUID.randomUUID().toString());
        notificationBody.setIconType(IconType.Info.toString());
        notificationBody.setLevel(NotificationLevel.normal.getLevel());
        notificationBody.setClickClassName("kd.bos.servicehelper.basedata.SoftDeleteNotificationClick");
        NotificationFormInfo notificationFormInfo = new NotificationFormInfo();
        notificationFormInfo.setNotification(notificationBody);
        NotificationServiceHelper.sendNotification(Collections.singletonList(userId), notificationFormInfo);
    }
}

