/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.servicehelper.basedata;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;

public class ExchangeRateService {
    private static final String SOURCECUR = "sourcecur";
    private static final String TARGETCUR = "targetcur";
    private static final String ID = "id";
    private static final String ENTRY_ENTITY = "entryentity";
    private static final String EXCHANGE_RATE_ENTITY = "bd_exrate_tree";
    private static final String EXCHANGE_RATE_TABLE_ENTITY = "bd_exratetable";
    private static final String DIRECT_EXCHANGE_RATE = "directRate";
    private static final String INDIRECT_EXCHANGE_RATE = "indirectRate";
    private static final String ORIGINAL_CUR = "orgcur";
    private static final String TARGET_CUR = "cur";
    private static final String EXCHANGE_RATE_TYPE = "exctable";
    private static final String EFFECT_DATE = "effectdate";
    private static final String EXPIRY_DATE = "expirydate";
    private static final String DIRECT_RATE = "excval";
    private static final String INDIRECT_RATE = "indirectexrate";
    private static final String ENABLE = "enable";
    private static final String EFFECTIVE_DATE = "effectivedate";
    private static final String EXCHANGE_RATE_CONFIG_ENTITY = "bd_exrate_config";
    private static final String PRECISIONCONTROL = "precisioncontrol";
    private static final Log logger = LogFactory.getLog(ExchangeRateService.class);

    public static BigDecimal getExchangeRateByQuoteType(Long originalCurrency, Long targetCurrency, Long exchangeRateType, Date conversionDate, boolean quoteType) {
        if (originalCurrency == null || targetCurrency == null || exchangeRateType == null || conversionDate == null) {
            return null;
        }
        if (originalCurrency.compareTo(targetCurrency) == 0) {
            return BigDecimal.ONE;
        }
        BigDecimal rate = null;
        Map<String, Object> exchangeRateMap = ExchangeRateService.getExchangeRateMap(originalCurrency, targetCurrency, exchangeRateType, conversionDate);
        rate = quoteType ? (exchangeRateMap.get(INDIRECT_EXCHANGE_RATE) != null ? (BigDecimal)exchangeRateMap.get(INDIRECT_EXCHANGE_RATE) : null) : (exchangeRateMap.get(DIRECT_EXCHANGE_RATE) != null ? (BigDecimal)exchangeRateMap.get(DIRECT_EXCHANGE_RATE) : null);
        return rate;
    }

    private static Map<String, Object> getExchangeRateMap(Long originalCurrency, Long targetCurrency, Long exchangeRateType, Date conversionDate) {
        HashMap<String, Object> result = new HashMap<String, Object>(5);
        result.put(DIRECT_EXCHANGE_RATE, null);
        result.put(INDIRECT_EXCHANGE_RATE, null);
        Map<Object, DynamicObject> dynamicObjectMap = ExchangeRateService.loadExchangeRate(originalCurrency, targetCurrency, exchangeRateType, conversionDate);
        if (dynamicObjectMap.isEmpty()) {
            dynamicObjectMap = ExchangeRateService.loadExchangeRate(targetCurrency, originalCurrency, exchangeRateType, conversionDate);
            if (dynamicObjectMap.isEmpty()) {
                return result;
            }
            return ExchangeRateService.getExchangeRateMap(result, dynamicObjectMap, true);
        }
        return ExchangeRateService.getExchangeRateMap(result, dynamicObjectMap);
    }

    private static Map<String, Object> getExchangeRateMap(HashMap<String, Object> result, Map<Object, DynamicObject> dynamicObjectMap) {
        return ExchangeRateService.getExchangeRateMap(result, dynamicObjectMap, false);
    }

    private static Map<String, Object> getExchangeRateMap(HashMap<String, Object> result, Map<Object, DynamicObject> dynamicObjectMap, boolean swap) {
        Optional<DynamicObject> first = dynamicObjectMap.values().stream().findFirst();
        if (first.isPresent()) {
            DynamicObject object = first.get();
            BigDecimal directRate = object.getBigDecimal(DIRECT_RATE);
            BigDecimal indirectRate = object.getBigDecimal(INDIRECT_RATE);
            if (swap) {
                result.put(DIRECT_EXCHANGE_RATE, indirectRate);
                result.put(INDIRECT_EXCHANGE_RATE, directRate);
            } else {
                result.put(DIRECT_EXCHANGE_RATE, directRate);
                result.put(INDIRECT_EXCHANGE_RATE, indirectRate);
            }
        }
        return result;
    }

    private static Map<Object, DynamicObject> loadExchangeRate(Long originalCurrency, Long targetCurrency, Long exchangeRateType, Date conversionDate) {
        String selectProperties = "id, excval, indirectexrate";
        String orderBys = "effectdate desc";
        ArrayList<QFilter> qfilters = new ArrayList<QFilter>();
        qfilters.add(new QFilter(ORIGINAL_CUR, "=", (Object)originalCurrency));
        qfilters.add(new QFilter(TARGET_CUR, "=", (Object)targetCurrency));
        qfilters.add(new QFilter(EXCHANGE_RATE_TYPE, "=", (Object)exchangeRateType));
        qfilters.add(new QFilter(ENABLE, "=", (Object)Character.valueOf('1')));
        qfilters.add(new QFilter(EFFECT_DATE, "<=", (Object)conversionDate));
        if (ExchangeRateService.isEnableExchangeRateExpiryDate(exchangeRateType)) {
            qfilters.add(new QFilter(EXPIRY_DATE, ">=", (Object)conversionDate));
        }
        return BusinessDataServiceHelper.loadFromCache(EXCHANGE_RATE_ENTITY, selectProperties, qfilters.toArray(new QFilter[0]), orderBys);
    }

    public static boolean isEnableIndirectRateConversion() {
        String sql = "SELECT fid FROM T_INT_CURRENCYEXRULE where FINDIRECTEXRATE = '1'";
        return (Boolean)DB.query((DBRoute)DBRoute.basedata, (String)sql, ResultSet::next);
    }

    public static BigDecimal getExRatePrecision(Long currency1, Long currency2) throws KDBizException {
        QFilter qFilter = new QFilter(PRECISIONCONTROL, "=", (Object)Boolean.TRUE);
        String selectProps = "precisioncontrol,defaultprecision,int_precision_entry,int_precision_entry.currency1,int_precision_entry.currency2,int_precision_entry.precision";
        DynamicObject exRateConfig = BusinessDataServiceHelper.loadSingle(EXCHANGE_RATE_CONFIG_ENTITY, "precisioncontrol,defaultprecision,int_precision_entry,int_precision_entry.currency1,int_precision_entry.currency2,int_precision_entry.precision", qFilter.toArray());
        if (exRateConfig == null) {
            return null;
        }
        String defaultPrecisionInt = exRateConfig.getString("defaultprecision");
        BigDecimal defaultPrecision = StringUtils.isBlank((CharSequence)defaultPrecisionInt) ? BigDecimal.ZERO : new BigDecimal(defaultPrecisionInt);
        if (currency1 != null && currency2 != null) {
            List<DynamicObject> matchedRecords = ExchangeRateService.filterByCurrencyPeer(currency1, currency2, exRateConfig.getDynamicObjectCollection("int_precision_entry"));
            if (BigDecimal.ZERO.equals(defaultPrecision) && matchedRecords.isEmpty()) {
                return null;
            }
            if (matchedRecords.isEmpty()) {
                return defaultPrecision;
            }
            return (BigDecimal)((DynamicObject)matchedRecords.stream().findAny().get()).get("precision");
        }
        return defaultPrecision;
    }

    private static List<DynamicObject> filterByCurrencyPeer(long currency1, long currency2, DynamicObjectCollection precisionEntry) {
        return precisionEntry.stream().filter(item -> item.getDynamicObject("currency1").getLong(ID) == currency1 && item.getDynamicObject("currency2").getLong(ID) == currency2 || item.getDynamicObject("currency1").getLong(ID) == currency2 && item.getDynamicObject("currency2").getLong(ID) == currency1).collect(Collectors.toList());
    }

    public static boolean getRateConversionConfig(Long originalCurrency, Long targetCurrency, Date conversionDate) {
        if (originalCurrency == null || targetCurrency == null || conversionDate == null) {
            return false;
        }
        if (originalCurrency.equals(targetCurrency)) {
            return false;
        }
        boolean ret = ExchangeRateService.isEnableIndirectRateConversion();
        if (!ret) {
            return false;
        }
        DynamicObject object = BusinessDataServiceHelper.loadSingleFromCache(EXCHANGE_RATE_CONFIG_ENTITY, new QFilter[0]);
        if (object == null) {
            return false;
        }
        DynamicObjectCollection collection = object.getDynamicObjectCollection(ENTRY_ENTITY);
        ArrayList<DynamicObject> list = new ArrayList<DynamicObject>(16);
        ArrayList<DynamicObject> list2 = new ArrayList<DynamicObject>(16);
        ArrayList<DynamicObject> list3 = new ArrayList<DynamicObject>(16);
        for (DynamicObject dy : collection) {
            long targetCur;
            if (dy.getDate(EFFECTIVE_DATE).getTime() > conversionDate.getTime()) continue;
            long originalCur = dy.get(SOURCECUR) != null ? (Long)((DynamicObject)dy.get(SOURCECUR)).get(ID) : 0L;
            long l = targetCur = dy.get(TARGETCUR) != null ? (Long)((DynamicObject)dy.get(TARGETCUR)).get(ID) : 0L;
            if (originalCur == originalCurrency && targetCur == targetCurrency) {
                list.add(dy);
            }
            if (originalCur == 0L && targetCur == targetCurrency) {
                list2.add(dy);
            }
            if (originalCur != originalCurrency || targetCur != 0L) continue;
            list3.add(dy);
        }
        List<DynamicObject> listByComparator = ExchangeRateService.getDynamicObjectListByComparator(list, list2, list3);
        return !listByComparator.isEmpty() && listByComparator.get(0).getBoolean("isindirect");
    }

    private static List<DynamicObject> getDynamicObjectListByComparator(List<DynamicObject> list, List<DynamicObject> list2, List<DynamicObject> list3) {
        CurConversionComparator comparator = new CurConversionComparator();
        if (!list.isEmpty()) {
            list.sort(comparator);
            return list;
        }
        if (!list2.isEmpty()) {
            list2.sort(comparator);
            return list2;
        }
        if (!list3.isEmpty()) {
            list3.sort(comparator);
            return list3;
        }
        return Collections.emptyList();
    }

    public static boolean canModifyExchangeRate(Long exRateTableId) {
        DynamicObjectType exRateTableDyType;
        DynamicObject exRateTableDy;
        if (exRateTableId == null || exRateTableId <= 0L) {
            return true;
        }
        DynamicObjectType exRateConfigDyType = EntityMetadataCache.getSubDataEntityType((String)EXCHANGE_RATE_CONFIG_ENTITY, Arrays.asList("id,ratecontrol".split(",")));
        DynamicObject[] exRateConfigDyArray = BusinessDataServiceHelper.loadFromCache(exRateConfigDyType, null).values().toArray(new DynamicObject[0]);
        if (exRateConfigDyArray.length > 0 && exRateConfigDyArray[0].getBoolean("ratecontrol") && (exRateTableDy = BusinessDataServiceHelper.loadSingleFromCache((Object)exRateTableId, exRateTableDyType = EntityMetadataCache.getSubDataEntityType((String)EXCHANGE_RATE_TABLE_ENTITY, Arrays.asList("id,forbidmodifyrate".split(","))))) != null) {
            return !exRateTableDy.getBoolean("forbidmodifyrate");
        }
        return true;
    }

    public static boolean isEnableExchangeRateExpiryDate(Long exRateTableId) {
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingleFromCache(exRateTableId, EXCHANGE_RATE_TABLE_ENTITY, EXPIRY_DATE);
        return dynamicObject != null && dynamicObject.getBoolean(EXPIRY_DATE);
    }

    public static boolean isEnableExRatePrecisionControl() {
        try {
            QFilter qFilter = new QFilter(PRECISIONCONTROL, "=", (Object)Boolean.TRUE);
            DynamicObject exRateConfig = BusinessDataServiceHelper.loadSingleFromCache(EXCHANGE_RATE_CONFIG_ENTITY, ID, qFilter.toArray());
            return exRateConfig != null;
        }
        catch (Exception e) {
            logger.error("get isEnableExRatePrecisionControl() failed", (Throwable)e);
            return false;
        }
    }

    public static int getExchangeRatePrecision(Long currency1, Long currency2) {
        try {
            QFilter qFilter = new QFilter(PRECISIONCONTROL, "=", (Object)Boolean.TRUE);
            String selectProps = "precisioncontrol,defaultprecision,int_precision_entry,int_precision_entry.currency1,int_precision_entry.currency2,int_precision_entry.precision";
            DynamicObject exRateConfig = BusinessDataServiceHelper.loadSingleFromCache(EXCHANGE_RATE_CONFIG_ENTITY, "precisioncontrol,defaultprecision,int_precision_entry,int_precision_entry.currency1,int_precision_entry.currency2,int_precision_entry.precision", qFilter.toArray());
            if (exRateConfig == null) {
                return 0;
            }
            String defaultPrecisionInt = exRateConfig.getString("defaultprecision");
            int defaultPrecision = StringUtils.isBlank((CharSequence)defaultPrecisionInt) ? 0 : Integer.parseInt(defaultPrecisionInt);
            if (currency1 != null && currency2 != null) {
                List<DynamicObject> matchedRecords = ExchangeRateService.filterByCurrencyPeer(currency1, currency2, exRateConfig.getDynamicObjectCollection("int_precision_entry"));
                if (matchedRecords.isEmpty()) {
                    return defaultPrecision;
                }
                return ((DynamicObject)matchedRecords.stream().findAny().get()).getBigDecimal("precision").intValue();
            }
            return defaultPrecision;
        }
        catch (Exception e) {
            logger.error("getExchangeRatePrecision() failed", (Throwable)e);
            return 0;
        }
    }

    public static int getExchangeRateDefaultPrecision() {
        try {
            QFilter qFilter = new QFilter(PRECISIONCONTROL, "=", (Object)Boolean.TRUE);
            String selectProps = "precisioncontrol,defaultprecision,int_precision_entry,int_precision_entry.currency1,int_precision_entry.currency2,int_precision_entry.precision";
            DynamicObject exRateConfig = BusinessDataServiceHelper.loadSingleFromCache(EXCHANGE_RATE_CONFIG_ENTITY, "precisioncontrol,defaultprecision,int_precision_entry,int_precision_entry.currency1,int_precision_entry.currency2,int_precision_entry.precision", qFilter.toArray());
            if (exRateConfig == null) {
                return 0;
            }
            String defaultPrecisionInt = exRateConfig.getString("defaultprecision");
            int defaultPrecision = StringUtils.isBlank((CharSequence)defaultPrecisionInt) ? 0 : Integer.parseInt(defaultPrecisionInt);
            return defaultPrecision;
        }
        catch (Exception e) {
            logger.error("getExchangeRateDefaultPrecision() failed", (Throwable)e);
            return 0;
        }
    }

    public static Map<String, Object> getExRateConfig() {
        try {
            HashMap<String, Object> configMap = new HashMap<String, Object>();
            QFilter qFilter = new QFilter(PRECISIONCONTROL, "=", (Object)Boolean.TRUE);
            DynamicObject exRateConfig = BusinessDataServiceHelper.loadSingleFromCache(EXCHANGE_RATE_CONFIG_ENTITY, qFilter.toArray());
            if (exRateConfig == null) {
                return configMap;
            }
            HashMap<String, Integer> map = new HashMap<String, Integer>();
            DynamicObjectCollection syncColl = exRateConfig.getDynamicObjectCollection("int_precision_entry");
            for (DynamicObject dy : syncColl) {
                String currency1 = dy.getDynamicObject("currency1").getString("number");
                String currency2 = dy.getDynamicObject("currency2").getString("number");
                map.put(currency1 + "/" + currency2, dy.getInt("precision"));
                map.put(currency2 + "/" + currency1, dy.getInt("precision"));
            }
            String defaultPrecisionInt = exRateConfig.getString("defaultprecision");
            if (StringUtils.isNotBlank((CharSequence)defaultPrecisionInt)) {
                map.put("default", Integer.valueOf(defaultPrecisionInt));
            }
            configMap.put("exrateScale", map);
            return configMap;
        }
        catch (Exception e) {
            logger.error("getExRateConfig() failed", (Throwable)e);
            return new HashMap<String, Object>();
        }
    }

    public static Map<String, Object> getExRatePrecisionControlConfig() {
        try {
            QFilter qFilter = new QFilter(PRECISIONCONTROL, "=", (Object)Boolean.TRUE);
            DynamicObject exRateConfig = BusinessDataServiceHelper.loadSingleFromCache(EXCHANGE_RATE_CONFIG_ENTITY, qFilter.toArray());
            if (exRateConfig == null) {
                return null;
            }
            HashMap<String, Object> configMap = new HashMap<String, Object>();
            configMap.put(PRECISIONCONTROL, exRateConfig.getString("defaultprecision"));
            configMap.put("showtailzero", exRateConfig.getBoolean("showtailzero"));
            return configMap;
        }
        catch (Exception e) {
            logger.error("getExRatePrecisionControlConfig() failed", (Throwable)e);
            return null;
        }
    }

    static class CurConversionComparator
    implements Comparator<DynamicObject> {
        CurConversionComparator() {
        }

        @Override
        public int compare(DynamicObject o1, DynamicObject o2) {
            long time1 = o1.getDate(ExchangeRateService.EFFECTIVE_DATE).getTime();
            long time2 = o2.getDate(ExchangeRateService.EFFECTIVE_DATE).getTime();
            return Long.compare(time2, time1);
        }
    }
}

