/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.servicehelper.billtype;

import java.nio.charset.StandardCharsets;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.data.BusinessDataWriter;
import kd.bos.dataentity.SqlParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.billtype.entity.BillTypeFile;
import kd.bos.util.HexUtils;
import kd.bos.utils.DbTypeConverter;
import kd.sdk.annotation.SdkPublic;

@SdkPublic
public class BillTypeServiceHelper {
    private static final String entityId = "bos_billtype";
    private static final String billTypeTableName = "t_bas_billtype";
    private static final String billTypeTableNameL = "t_bas_billtype_l";
    private static final String billTypeEntryTableName = "t_bas_billtypefldctl";
    private static final String billTypeEntryTableNameL = "t_bas_billtypefldctl_l";
    private static final String billTypesTableName = "t_bas_billtypews";
    private static final String billTypeTableFieldStr = "FID,FNUMBER,FBILLFORMID,FISDEFAULT,FBILLCODERULEID,FCREATORID,FCREATETIME,FMODIFIERID,FMODIFYTIME,FCONTROLPRINTCOUNT,FMAXPRINTCOUNT,FPRINTAFTERAUDIT,FDOCUMENTSTATUS,FDEFPRINTTEMPLATE,FISSYSPRESET,FPARASETTINGXML,FLAYOUTSOLUTION,FDEFWNREPORTTEMPLATE,FSTATUS,FENABLE,FBILLINITSETTING,FMASTERID";
    private static final String billTypeTableLFieldStr = "FPKID,FID,FLOCALEID,FNAME,FDESCRIPTION";
    private static final String billTypeEntryTableFieldStr = "FENTRYID,FID,FSEQ,FFIELDKEY,FMUSTINPUT,FDEFAULTVALUE,FDEFAULTFUNCNAME,FDEFAULTVALUETYPE,FDEFAULTFUNCID,FDEFAULTFUNCPARAM,FFIELDELEMENTTYPE,FENABLED,FEDITENABLED,FSYSMUSTINPUT,FSUBMITENABLED,FAUDITENABLED,FVINIT,FVNEW,FVEDIT,FVVIEW,FVSUBMIT,FVAUDIT,FISDELETED";
    private static final String billTypeEntryTableLFieldStr = "FPKID,FENTRYID,FLOCALEID,FFIELDNAME";
    private static final String billTypesTableLFieldStr = "FENTRYID,FID,FSEQ,FBEGINDATE,FENDDATE,FISDEFAULTBF";
    private static final String BILLFORMID = "billformid";
    private static final String NUMBER = "number";
    private static final String ERROR_S = "Error:%s";
    private static final String DELETE_FROM = "DELETE from ";
    private static final String SELECT = "select ";
    private static final String FROM = " from ";
    private static final String VALUES = ") VALUES (";
    private static final String WHERE_FID = "where fid = ";
    private static final String BOS_FORMMETA = "bos_formmeta";

    @Deprecated
    public static List<Map<String, Object>> getBillTypesByAppId(String appId) {
        ArrayList<String> appIds = new ArrayList<String>();
        appIds.add(appId);
        return BillTypeServiceHelper.getBillTypesByAppId(appIds);
    }

    public static List<Map<String, Object>> getBillTypesByAppId(List<String> appIds) {
        QFilter[] filter;
        ArrayList<Map<String, Object>> billTypes = new ArrayList<Map<String, Object>>();
        List<String> entityIds = BillTypeServiceHelper.getEntityIDByAppId(appIds);
        ORM orm = ORM.create();
        DynamicObjectCollection queryResult = orm.query(entityId, "ID, NUMBER, NAME", filter = new QFilter[]{new QFilter(BILLFORMID, "in", entityIds)});
        if (queryResult != null && queryResult.size() != 0) {
            HashMap<String, Object> billType = null;
            for (DynamicObject item : queryResult) {
                billType = new HashMap<String, Object>();
                billType.put("id", item.get("id"));
                billType.put(NUMBER, item.get(NUMBER));
                billType.put("name", item.get("name"));
                billTypes.add(billType);
            }
        }
        return billTypes;
    }

    public static void updateBillTypeFormId(String formId, String oldFormId) {
        Object[] updateParam = new SqlParameter[]{new SqlParameter(":FBILLFORMID", 12, (Object)formId), new SqlParameter(":FBILLFORMID", 12, (Object)oldFormId)};
        String strSQL = "update t_bas_billtype set FBILLFORMID = ? where FBILLFORMID =?";
        DB.update((DBRoute)DBRoute.basedata, (String)strSQL, (Object[])updateParam);
    }

    public static List<BillTypeFile> exportBillTypeByIds(List<String> billTypeIds) {
        ArrayList<BillTypeFile> billTypeList = new ArrayList<BillTypeFile>();
        Map ids = null;
        Iterator<String> iterator = billTypeIds.iterator();
        while (iterator.hasNext()) {
            List<BillTypeFile> queryData;
            String billTypeSql = "select FID,FNUMBER,FBILLFORMID,FISDEFAULT,FBILLCODERULEID,FCREATORID,FCREATETIME,FMODIFIERID,FMODIFYTIME,FCONTROLPRINTCOUNT,FMAXPRINTCOUNT,FPRINTAFTERAUDIT,FDOCUMENTSTATUS,FDEFPRINTTEMPLATE,FISSYSPRESET,FPARASETTINGXML,FLAYOUTSOLUTION,FDEFWNREPORTTEMPLATE,FSTATUS,FENABLE,FBILLINITSETTING,FMASTERID from t_bas_billtype where FID = ?";
            String billTypeId = iterator.next();
            Object[] params = new SqlParameter[]{new SqlParameter(":fid", -5, DbTypeConverter.safeConvert((int)-5, (Object)billTypeId))};
            ids = (Map)DB.query((DBRoute)DBRoute.basedata, (String)billTypeSql, (Object[])params, (ResultSetHandler)new ResultSetHandler<Map<String, List<String>>>(){

                public Map<String, List<String>> handle(ResultSet rs) throws Exception {
                    HashMap<String, List<String>> billTypeIds = new HashMap<String, List<String>>();
                    try {
                        while (rs.next()) {
                            ArrayList billTypeSqls = new ArrayList();
                            String id = rs.getString("fid");
                            BillTypeServiceHelper.appendSqlByEntity(billTypeSqls, rs, BillTypeServiceHelper.billTypeTableName);
                            billTypeIds.put(id, billTypeSqls);
                        }
                    }
                    catch (SQLException e) {
                        throw new KDException((Throwable)e, BosErrorCode.sQL, new Object[]{String.format(BillTypeServiceHelper.ERROR_S, e.getMessage())});
                    }
                    return billTypeIds;
                }
            });
            if (null == ids || ids.size() <= 0 || (queryData = BillTypeServiceHelper.queryBillType(ids)).isEmpty()) continue;
            billTypeList.addAll(queryData);
        }
        return billTypeList;
    }

    public static List<BillTypeFile> exportBillTypeByEntityIds(List<String> entityIds) {
        ArrayList<BillTypeFile> billTypeList = new ArrayList<BillTypeFile>();
        Iterator<String> iterator = entityIds.iterator();
        while (iterator.hasNext()) {
            List<BillTypeFile> queryData;
            String billTypeSql = "select FID,FNUMBER,FBILLFORMID,FISDEFAULT,FBILLCODERULEID,FCREATORID,FCREATETIME,FMODIFIERID,FMODIFYTIME,FCONTROLPRINTCOUNT,FMAXPRINTCOUNT,FPRINTAFTERAUDIT,FDOCUMENTSTATUS,FDEFPRINTTEMPLATE,FISSYSPRESET,FPARASETTINGXML,FLAYOUTSOLUTION,FDEFWNREPORTTEMPLATE,FSTATUS,FENABLE,FBILLINITSETTING,FMASTERID from t_bas_billtype where FBILLFORMID = ?";
            String entityId = iterator.next();
            Object[] params = new SqlParameter[]{new SqlParameter(":fbillformid", 12, (Object)entityId)};
            Map billTypeIds = (Map)DB.query((DBRoute)DBRoute.basedata, (String)billTypeSql, (Object[])params, (ResultSetHandler)new ResultSetHandler<Map<String, List<String>>>(){

                public Map<String, List<String>> handle(ResultSet rs) throws Exception {
                    HashMap<String, List<String>> billTypeIds = new HashMap<String, List<String>>();
                    try {
                        while (rs.next()) {
                            ArrayList billTypeSqls = new ArrayList();
                            String id = rs.getString("fid");
                            BillTypeServiceHelper.appendSqlByEntity(billTypeSqls, rs, BillTypeServiceHelper.billTypeTableName);
                            billTypeIds.put(id, billTypeSqls);
                        }
                    }
                    catch (SQLException e) {
                        throw new KDException((Throwable)e, BosErrorCode.sQL, new Object[]{String.format(BillTypeServiceHelper.ERROR_S, e.getMessage())});
                    }
                    return billTypeIds;
                }
            });
            if (null == billTypeIds || billTypeIds.size() <= 0 || (queryData = BillTypeServiceHelper.queryBillType(billTypeIds)).isEmpty()) continue;
            billTypeList.addAll(queryData);
        }
        return billTypeList;
    }

    public static List<BillTypeFile> exportBillTypeByAppIds(List<String> appIds) {
        List<String> entityIDList = BillTypeServiceHelper.getEntityIDByAppId(appIds);
        return BillTypeServiceHelper.exportBillTypeByEntityIds(entityIDList);
    }

    private static List<BillTypeFile> queryBillType(Map<String, List<String>> billTypeIds) {
        ArrayList<BillTypeFile> billTypeList = new ArrayList<BillTypeFile>(billTypeIds.size());
        BillTypeFile btf = null;
        Object[] params = null;
        for (Map.Entry<String, List<String>> billType : billTypeIds.entrySet()) {
            btf = new BillTypeFile();
            final List<String> billTypes = billType.getValue();
            final String billTypeId = billType.getKey();
            String fileName = "bos_billtype_" + HexUtils.toHex((byte[])billTypeId.getBytes(StandardCharsets.UTF_8)) + "_" + System.currentTimeMillis();
            btf.setFileName(fileName);
            String billTypeLSql = "select FPKID,FID,FLOCALEID,FNAME,FDESCRIPTION from t_bas_billtype_l where fid = ?";
            params = new SqlParameter[]{new SqlParameter(":fid", -5, DbTypeConverter.safeConvert((int)-5, (Object)billTypeId))};
            DB.query((DBRoute)DBRoute.basedata, (String)billTypeLSql, (Object[])params, (ResultSetHandler)new ResultSetHandler<List<String>>(){

                public List<String> handle(ResultSet rs) throws Exception {
                    try {
                        int num = 0;
                        while (rs.next()) {
                            if (num == 0 && StringUtils.isNotEmpty((CharSequence)rs.getString("FID"))) {
                                String sql = "DELETE from t_bas_billtype_l where fid = " + Long.parseLong(billTypeId) + ";";
                                billTypes.add(sql);
                                ++num;
                            }
                            BillTypeServiceHelper.appendSqlByEntity(billTypes, rs, BillTypeServiceHelper.billTypeTableNameL);
                        }
                    }
                    catch (SQLException e) {
                        throw new KDException((Throwable)e, BosErrorCode.sQL, new Object[]{String.format(BillTypeServiceHelper.ERROR_S, e.getMessage())});
                    }
                    return null;
                }
            });
            String billTypeEntrySql = "select FENTRYID,FID,FSEQ,FFIELDKEY,FMUSTINPUT,FDEFAULTVALUE,FDEFAULTFUNCNAME,FDEFAULTVALUETYPE,FDEFAULTFUNCID,FDEFAULTFUNCPARAM,FFIELDELEMENTTYPE,FENABLED,FEDITENABLED,FSYSMUSTINPUT,FSUBMITENABLED,FAUDITENABLED,FVINIT,FVNEW,FVEDIT,FVVIEW,FVSUBMIT,FVAUDIT,FISDELETED from t_bas_billtypefldctl where fid = ? ";
            params = new SqlParameter[]{new SqlParameter(":fid", -5, DbTypeConverter.safeConvert((int)-5, (Object)billTypeId))};
            final ArrayList entryIds = new ArrayList();
            DB.query((DBRoute)DBRoute.basedata, (String)billTypeEntrySql, (Object[])params, (ResultSetHandler)new ResultSetHandler<List<String>>(){

                public List<String> handle(ResultSet rs) throws Exception {
                    try {
                        int num = 0;
                        while (rs.next()) {
                            String entryId = rs.getString("FID");
                            entryIds.add(entryId);
                            if (num == 0 && StringUtils.isNotEmpty((CharSequence)entryId)) {
                                String sql = "DELETE from t_bas_billtypefldctl where fid = " + Long.parseLong(billTypeId) + ";";
                                billTypes.add(sql);
                                ++num;
                            }
                            BillTypeServiceHelper.appendSqlByEntity(billTypes, rs, BillTypeServiceHelper.billTypeEntryTableName);
                        }
                    }
                    catch (SQLException e) {
                        throw new KDException((Throwable)e, BosErrorCode.sQL, new Object[]{String.format(BillTypeServiceHelper.ERROR_S, e.getMessage())});
                    }
                    return null;
                }
            });
            for (String entryId : entryIds) {
                String billTypeEntryLSql = "select FPKID,FENTRYID,FLOCALEID,FFIELDNAME from t_bas_billtypefldctl_l where fentryid = ?";
                params = new SqlParameter[]{new SqlParameter(":fentryid", -5, DbTypeConverter.safeConvert((int)-5, (Object)entryId))};
                DB.query((DBRoute)DBRoute.basedata, (String)billTypeEntryLSql, (Object[])params, (ResultSetHandler)new ResultSetHandler<List<String>>(){

                    public List<String> handle(ResultSet rs) throws Exception {
                        try {
                            int num = 0;
                            while (rs.next()) {
                                if (num == 0 && StringUtils.isNotEmpty((CharSequence)rs.getString("FID"))) {
                                    String sql = "DELETE from t_bas_billtypefldctl_l where fid = " + Long.parseLong(billTypeId) + ";";
                                    billTypes.add(sql);
                                    ++num;
                                }
                                BillTypeServiceHelper.appendSqlByEntity(billTypes, rs, BillTypeServiceHelper.billTypeEntryTableNameL);
                            }
                        }
                        catch (SQLException e) {
                            throw new KDException((Throwable)e, BosErrorCode.sQL, new Object[]{String.format(BillTypeServiceHelper.ERROR_S, e.getMessage())});
                        }
                        return null;
                    }
                });
            }
            String billTypesSql = "select FENTRYID,FID,FSEQ,FBEGINDATE,FENDDATE,FISDEFAULTBF from t_bas_billtypews where fid = ?";
            params = new SqlParameter[]{new SqlParameter(":fid", -5, DbTypeConverter.safeConvert((int)-5, (Object)billTypeId))};
            DB.query((DBRoute)DBRoute.basedata, (String)billTypesSql, (Object[])params, (ResultSetHandler)new ResultSetHandler<List<String>>(){

                public List<String> handle(ResultSet rs) throws Exception {
                    try {
                        int num = 0;
                        while (rs.next()) {
                            if (num == 0 && StringUtils.isNotEmpty((CharSequence)rs.getString("FID"))) {
                                String sql = "DELETE from t_bas_billtypews where fid = " + Long.parseLong(billTypeId) + ";";
                                billTypes.add(sql);
                                ++num;
                            }
                            BillTypeServiceHelper.appendSqlByEntity(billTypes, rs, BillTypeServiceHelper.billTypesTableName);
                        }
                    }
                    catch (SQLException e) {
                        throw new KDException((Throwable)e, BosErrorCode.sQL, new Object[]{String.format(BillTypeServiceHelper.ERROR_S, e.getMessage())});
                    }
                    return null;
                }
            });
            btf.setFileContent(billTypes);
            billTypeList.add(btf);
        }
        return billTypeList;
    }

    private static List<String> appendSqlByEntity(List<String> entityStrs, ResultSet rs, String tableName) throws SQLException {
        StringBuilder sb = new StringBuilder();
        String entityDelStr = "";
        String[] fields = null;
        String billTypeId = rs.getString("fid");
        switch (tableName) {
            case "t_bas_billtype": {
                fields = billTypeTableFieldStr.split(",");
                billTypeId = rs.getString("fid");
                entityDelStr = "DELETE from t_bas_billtype where fid = " + Long.parseLong(billTypeId) + ";";
                entityStrs.add(entityDelStr);
                sb.append(" INSERT INTO t_bas_billtype(FID,FNUMBER,FBILLFORMID,FISDEFAULT,FBILLCODERULEID,FCREATORID,FCREATETIME,FMODIFIERID,FMODIFYTIME,FCONTROLPRINTCOUNT,FMAXPRINTCOUNT,FPRINTAFTERAUDIT,FDOCUMENTSTATUS,FDEFPRINTTEMPLATE,FISSYSPRESET,FPARASETTINGXML,FLAYOUTSOLUTION,FDEFWNREPORTTEMPLATE,FSTATUS,FENABLE,FBILLINITSETTING,FMASTERID) VALUES (");
                break;
            }
            case "t_bas_billtype_l": {
                fields = billTypeTableLFieldStr.split(",");
                sb.append("INSERT INTO t_bas_billtype_l(FPKID,FID,FLOCALEID,FNAME,FDESCRIPTION) VALUES (");
                break;
            }
            case "t_bas_billtypefldctl": {
                fields = billTypeEntryTableFieldStr.split(",");
                sb.append("INSERT INTO t_bas_billtypefldctl(FENTRYID,FID,FSEQ,FFIELDKEY,FMUSTINPUT,FDEFAULTVALUE,FDEFAULTFUNCNAME,FDEFAULTVALUETYPE,FDEFAULTFUNCID,FDEFAULTFUNCPARAM,FFIELDELEMENTTYPE,FENABLED,FEDITENABLED,FSYSMUSTINPUT,FSUBMITENABLED,FAUDITENABLED,FVINIT,FVNEW,FVEDIT,FVVIEW,FVSUBMIT,FVAUDIT,FISDELETED) VALUES (");
                break;
            }
            case "t_bas_billtypefldctl_l": {
                fields = billTypeEntryTableFieldStr.split(",");
                sb.append("INSERT INTO t_bas_billtypefldctl_l(FPKID,FENTRYID,FLOCALEID,FFIELDNAME) VALUES (");
                break;
            }
            case "t_bas_billtypews": {
                fields = billTypesTableLFieldStr.split(",");
                sb.append("INSERT INTO t_bas_billtypews(FENTRYID,FID,FSEQ,FBEGINDATE,FENDDATE,FISDEFAULTBF) VALUES (");
                break;
            }
        }
        Objects.requireNonNull(fields);
        if (fields != null) {
            ArrayList<String> resultList = new ArrayList<String>(fields.length);
            for (String field : fields) {
                resultList.add(rs.getString(field));
            }
            if (!resultList.isEmpty()) {
                sb.append(BillTypeServiceHelper.joinString(resultList, fields)).append(");");
                entityStrs.add(sb.toString());
            }
        }
        return entityStrs;
    }

    private static String joinString(List<String> inputData, String[] fields) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < inputData.size(); ++i) {
            boolean isNumber = false;
            boolean isDate = false;
            List numberFields = Stream.of("FID", "FCREATORID", "FMODIFIERID", "FMAXPRINTCOUNT", "FMASTERID", "FENTRYID", "FSEQ", "FDEFAULTVALUETYPE", "FDEFAULTFUNCID", "FFIELDELEMENTTYPE").collect(Collectors.toList());
            List dateFields = Stream.of("FCREATETIME", "FMODIFYTIME", "FBEGINDATE", "FENDDATE").collect(Collectors.toList());
            if (numberFields.contains(fields[i])) {
                isNumber = true;
            } else if (dateFields.contains(fields[i])) {
                isDate = true;
            }
            if (inputData.get(i) != null && isNumber) {
                sb.append(inputData.get(i)).append(',');
                continue;
            }
            if (inputData.get(i) != null && isDate) {
                if (inputData.get(i).lastIndexOf(46) != -1) {
                    sb.append("{ts '").append(inputData.get(i).substring(0, inputData.get(i).lastIndexOf(46))).append("' },");
                    continue;
                }
                sb.append("{ts '").append(inputData.get(i)).append("' },");
                continue;
            }
            if (inputData.get(i) != null && !isNumber && !isDate) {
                if ("".equals(inputData.get(i))) {
                    sb.append("' ").append(inputData.get(i)).append("',");
                    continue;
                }
                sb.append('\'').append(inputData.get(i)).append("',");
                continue;
            }
            if (isNumber) {
                sb.append(0).append(',');
                continue;
            }
            sb.append(inputData.get(i)).append(',');
        }
        sb.deleteCharAt(sb.length() - 1);
        return sb.toString();
    }

    private static List<String> getEntityIDByAppId(List<String> appIDList) {
        HashSet<String> entityIDSet = new HashSet<String>();
        String[] modeltypes = new String[]{"BillFormModel", "BaseFormModel"};
        for (String appID : appIDList) {
            DynamicObject[] entitys = BusinessDataServiceHelper.load(BOS_FORMMETA, "id,number", new QFilter[]{new QFilter("bizappid", "=", (Object)appID), new QFilter("modeltype", "in", (Object)modeltypes)});
            if (null == entitys || entitys.length <= 0) continue;
            for (DynamicObject entity : entitys) {
                String number = entity.getString(NUMBER);
                if (!StringUtils.isNotEmpty((CharSequence)number)) continue;
                entityIDSet.add(entity.getString(NUMBER));
            }
        }
        return new ArrayList<String>(entityIDSet);
    }

    public static List<Map<String, Object>> getBillLayoutByFormId(String formId) {
        return BillTypeServiceHelper.getBillLayoutByFormId(formId, "BillFormModel");
    }

    public static List<Map<String, Object>> getMobileBillLayoutByFormId(String formId) {
        return BillTypeServiceHelper.getBillLayoutByFormId(formId, "MobileBillFormModel");
    }

    public static List<Map<String, Object>> getBillLayoutByFormId(String formId, String domainModelType) {
        DynamicObject[] formDatas;
        ArrayList<Map<String, Object>> layouts = new ArrayList<Map<String, Object>>(10);
        QFilter f = new QFilter(NUMBER, "=", (Object)formId);
        QFilter[] filters = new QFilter[]{f};
        DynamicObject formData = BusinessDataServiceHelper.loadSingle(BOS_FORMMETA, "id, number,name, basedatafield", filters);
        HashMap<String, Object> layout = new HashMap<String, Object>();
        layout.put("id", formData.getString("id"));
        layout.put(NUMBER, formData.getString(NUMBER));
        layout.put("name", formData.get("name"));
        layouts.add(layout);
        String layoutEntityId = formData.getDynamicObject("basedatafield").getString("id");
        filters = new QFilter[]{QFilter.of((String)"id <> basedatafield", (Object[])new Object[0]).and(new QFilter("basedatafield", "=", (Object)layoutEntityId)).and(new QFilter("modeltype", "=", (Object)domainModelType)).and(new QFilter("type", "!=", (Object)"2"))};
        for (DynamicObject form : formDatas = BusinessDataServiceHelper.load(BOS_FORMMETA, "id, number, name", filters)) {
            layout = new HashMap();
            layout.put("id", form.getString("id"));
            layout.put(NUMBER, form.getString(NUMBER));
            layout.put("name", form.get("name"));
            layouts.add(layout);
        }
        return layouts;
    }

    public static List<Map<String, Object>> getBillLayoutByFormId(String formId, boolean baseOrBill) {
        ArrayList<Map<String, Object>> layouts = new ArrayList<Map<String, Object>>(10);
        QFilter f = new QFilter(NUMBER, "=", (Object)formId);
        QFilter[] filters = new QFilter[]{f};
        DynamicObject formData = BusinessDataServiceHelper.loadSingle(BOS_FORMMETA, "id, number,name, basedatafield", filters);
        HashMap<String, Object> layout = new HashMap<String, Object>();
        layout.put("id", formData.getString("id"));
        layout.put(NUMBER, formData.getString(NUMBER));
        layout.put("name", formData.get("name"));
        layouts.add(layout);
        String layoutEntityId = formData.getDynamicObject("basedatafield").getString("id");
        filters = new QFilter[]{QFilter.of((String)"id <> basedatafield", (Object[])new Object[0]).and(new QFilter("basedatafield", "=", (Object)layoutEntityId)).and(new QFilter("modeltype", "=", (Object)"BillFormModel")).and(new QFilter("type", "!=", (Object)"2"))};
        DynamicObject[] formDatas = BusinessDataServiceHelper.load(BOS_FORMMETA, "id, number, name", filters);
        if (formDatas == null || formDatas.length == 0) {
            filters = new QFilter[]{QFilter.of((String)"id <> basedatafield", (Object[])new Object[0]).and(new QFilter("basedatafield", "=", (Object)layoutEntityId)).and(new QFilter("modeltype", "=", (Object)"BaseFormModel")).and(new QFilter("type", "!=", (Object)"2"))};
            formDatas = BusinessDataServiceHelper.load(BOS_FORMMETA, "id, number, name", filters);
        }
        for (DynamicObject form : formDatas) {
            layout = new HashMap();
            layout.put("id", form.getString("id"));
            layout.put(NUMBER, form.getString(NUMBER));
            layout.put("name", form.get("name"));
            layouts.add(layout);
        }
        return layouts;
    }

    public static Map<Object, DynamicObject> getBillTypeObject(String formId) {
        QFilter f = new QFilter(BILLFORMID, "=", (Object)formId);
        QFilter[] filters = new QFilter[]{f};
        return BusinessDataServiceHelper.loadFromCache(entityId, filters);
    }

    public static void setDefaultBillType(Long billTypeId) {
        Object[] dataEntities;
        String sql = "select fid,fbillformid from t_bas_billtype where fid = ? ";
        String formId = (String)DB.query((DBRoute)DBRoute.basedata, (String)sql, (Object[])new Object[]{billTypeId}, (ResultSetHandler)new ResultSetHandler<String>(){

            public String handle(ResultSet rs) throws Exception {
                return rs.next() ? rs.getString("fbillformid") : null;
            }
        });
        if (StringUtils.isBlank((CharSequence)formId)) {
            return;
        }
        Map<Object, DynamicObject> billTypeObject = BillTypeServiceHelper.getBillTypeObject(formId);
        if (billTypeObject == null || billTypeObject.isEmpty()) {
            return;
        }
        Object[] billTypePkIds = new Object[billTypeObject.size()];
        int i = 0;
        for (Map.Entry<Object, DynamicObject> resultMap : billTypeObject.entrySet()) {
            billTypePkIds[i] = resultMap.getValue().getPkValue();
            ++i;
        }
        MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)entityId);
        for (DynamicObject dynamicObject : dataEntities = BusinessDataServiceHelper.load(billTypePkIds, (DynamicObjectType)mainEntityType)) {
            if (dynamicObject.getPkValue() != null && dynamicObject.getPkValue().equals(billTypeId)) {
                dynamicObject.set("isdefault", (Object)1);
                continue;
            }
            dynamicObject.set("isdefault", (Object)0);
        }
        BusinessDataWriter.save((IDataEntityType)mainEntityType, (Object[])dataEntities);
    }
}

