/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.servicehelper.mulilang;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlParameter;
import kd.bos.inte.api.EnabledLang;
import kd.bos.inte.api.IInteService;
import kd.bos.lang.Lang;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.entity.BillEntity;
import kd.bos.metadata.entity.Entity;
import kd.bos.metadata.entity.EntityItem;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.metadata.entity.EntryEntity;
import kd.bos.metadata.entity.commonfield.MuliLangTextField;
import kd.bos.service.ServiceFactory;

public class GLDataServiceHelper {
    private static final Log log = LogFactory.getLog(GLDataServiceHelper.class);

    public static String getDefaultLocaleId() {
        try {
            IInteService inteService = (IInteService)ServiceFactory.getService(IInteService.class);
            List languages = inteService.getEnabledLang();
            for (EnabledLang lang : languages) {
                if (!lang.getIsDefault().booleanValue()) continue;
                return lang.getNumber();
            }
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6\u5f53\u524d\u73af\u5883\u9ed8\u8ba4\u8bed\u8a00\u5931\u8d25");
        }
        return Lang.zh_CN.toString();
    }

    public static void repairData(String entityNumber, List<String> fieldKeys) {
        GLDataServiceHelper.repairData(entityNumber, fieldKeys, GLDataServiceHelper.getDefaultLocaleId());
    }

    public static void repairData(String entityNumber, List<String> fieldKeys, String defaultLocaleId) {
        GLDataServiceHelper.repairData(entityNumber, fieldKeys, defaultLocaleId, false);
    }

    public static void repairData(String entityNumber, List<String> fieldKeys, String defaultLocaleId, boolean ignoreCheckGL) {
        log.info("\u4fee\u590d\u901a\u7528\u8bed\u8a00\u6570\u636e : " + entityNumber + "," + SerializationUtils.toJsonString(fieldKeys) + "," + defaultLocaleId + "," + ignoreCheckGL);
        if (StringUtils.isBlank((CharSequence)entityNumber) || fieldKeys == null || fieldKeys.isEmpty()) {
            return;
        }
        String entityId = MetadataDao.getIdByNumber((String)entityNumber, (MetaCategory)MetaCategory.Entity);
        if (StringUtils.isBlank((CharSequence)entityId)) {
            log.error("entity not exists, number is " + entityNumber);
            return;
        }
        EntityMetadata entityMetadata = (EntityMetadata)MetadataDao.readRuntimeMeta((String)entityId, (MetaCategory)MetaCategory.Entity);
        List entitys = entityMetadata.getEntitys();
        HashMap<String, List<String>> fieldMapping = new HashMap<String, List<String>>();
        HashMap<String, String> tablepkmap = new HashMap<String, String>();
        for (Entity entity : entitys) {
            List items = entity.getItems();
            for (EntityItem item : items) {
                if (!(item instanceof MuliLangTextField) || !((MuliLangTextField)item).isGL() && !ignoreCheckGL || !fieldKeys.contains(item.getKey())) continue;
                String tableName = entityMetadata.getFieldByKey(item.getKey()).getTableName(entity);
                String filedName = entityMetadata.getFieldByKey(item.getKey()).getFieldName();
                if (StringUtils.isBlank((CharSequence)filedName)) continue;
                String pkField = null;
                if (entity instanceof EntryEntity) {
                    pkField = ((EntryEntity)entity).getEntryPkFieldName();
                } else if (entity instanceof BillEntity) {
                    pkField = ((BillEntity)entity).getPkFieldName();
                }
                if (fieldMapping.get(tableName) == null) {
                    ArrayList<String> list = new ArrayList<String>();
                    list.add(filedName);
                    fieldMapping.put(tableName, list);
                } else {
                    ((List)fieldMapping.get(tableName)).add(filedName);
                }
                if (tablepkmap.containsKey(tableName)) continue;
                tablepkmap.put(tableName, pkField);
            }
        }
        GLDataServiceHelper.updateData(entityMetadata.getDBRouteKey(), fieldMapping, tablepkmap, defaultLocaleId);
    }

    private static void updateData(String dbRoute, Map<String, List<String>> fieldMapping, Map<String, String> tablePkMap, String localeId) {
        for (Map.Entry<String, List<String>> entry : fieldMapping.entrySet()) {
            String table = entry.getKey();
            String mulangTable = table + "_L";
            List<String> fields = entry.getValue();
            if (fields.isEmpty()) continue;
            StringBuilder selectField = new StringBuilder(tablePkMap.get(table));
            StringBuilder updateSqlPart = new StringBuilder();
            for (String field : fields) {
                selectField.append(',').append(field).append(" ");
                updateSqlPart.append(field).append(" = ").append(" ? ").append(" , ");
            }
            int fieldsize = fields.size();
            String sql = String.format("select %s from %s where flocaleid = ?", selectField.toString(), mulangTable);
            String updateSql = GLDataServiceHelper.generateUpdateSql(table, fields, tablePkMap.get(table));
            Object[] query = new Object[1];
            int paramsize = fieldsize * 3 + 1;
            query[0] = new SqlParameter(":flocaleid", 12, (Object)localeId);
            DataSet ds = DB.queryDataSet((String)"", (DBRoute)DBRoute.of((String)dbRoute), (String)sql, (Object[])query);
            Throwable throwable = null;
            try {
                ArrayList<Object[]> paramsList = new ArrayList<Object[]>(10);
                while (ds.hasNext()) {
                    Row row = ds.next();
                    Object pkId = row.get(0);
                    Object[] paras = new Object[paramsize];
                    int i = 0;
                    for (int j = 0; j < fieldsize; ++j) {
                        Object v = row.get(j + 1);
                        paras[i++] = v;
                        paras[i++] = v;
                        paras[i++] = v;
                    }
                    paras[paramsize - 1] = pkId;
                    paramsList.add(paras);
                    if (paramsList.size() != 1000) continue;
                    DB.executeBatch((DBRoute)DBRoute.of((String)dbRoute), (String)updateSql, paramsList);
                    paramsList.clear();
                }
                if (paramsList.isEmpty()) continue;
                DB.executeBatch((DBRoute)DBRoute.of((String)dbRoute), (String)updateSql, paramsList);
                paramsList.clear();
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (ds == null) continue;
                if (throwable != null) {
                    try {
                        ds.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                ds.close();
            }
        }
    }

    private static String getUpdateFieldPart(String field) {
        return String.format(" %s = CASE WHEN %s is null THEN ? WHEN %s = '' THEN ? WHEN %s = ' ' THEN ? ELSE %s END ", field, field, field, field, "TO_CHAR(" + field + ")");
    }

    private static String generateUpdateSql(String tableName, List<String> fields, String pkFieldName) {
        if (fields.isEmpty()) {
            return "";
        }
        StringBuilder sqlBuild = new StringBuilder();
        sqlBuild.append(String.format(" update %s set ", tableName));
        for (int i = 0; i < fields.size(); ++i) {
            sqlBuild.append(GLDataServiceHelper.getUpdateFieldPart(fields.get(i))).append(" , ");
        }
        String sql = sqlBuild.toString();
        sql = sql.substring(0, sql.lastIndexOf(44) - 1);
        return sql + " where " + pkFieldName + " = ? ";
    }
}

