/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.servicehelper.mulilang;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.SqlParameter;
import kd.bos.dataentity.entity.ILocaleValue;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.serialization.DcBinder;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.lang.Lang;
import kd.bos.metadata.AbstractMetadata;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.dao.MetadataReader;
import kd.bos.metadata.devportal.AppLangItemBuilder;
import kd.bos.metadata.devportal.AppMetadata;
import kd.bos.metadata.devportal.DesignAppMeta;
import kd.bos.metadata.domainmodel.DomainModelBinder;
import kd.bos.metadata.domainmodel.DomainModelType;
import kd.bos.metadata.entity.DesignEntityMeta;
import kd.bos.metadata.form.DesignFormMeta;
import kd.bos.metadata.lang.LangItemBuilder;

public class LocaleMetadataServiceHelper {
    private static List<Map<String, ILocaleValue<?>>> queryLocaleMetaRes(IDataEntityType designerMetaType, String id) {
        MetadataReader reader = new MetadataReader();
        AbstractMetadata meta = reader.readMeta(id, designerMetaType, false, false);
        DomainModelType domainModel = DomainModelType.getDomainModelType((String)meta.getModelType(), (boolean)false);
        Object builder = null;
        builder = meta instanceof AppMetadata ? new AppLangItemBuilder((DcBinder)new DomainModelBinder(domainModel)) : new LangItemBuilder((DcBinder)new DomainModelBinder(domainModel));
        builder.builderResouces((Object)meta, null);
        return builder.getLocaleItemValues();
    }

    public static Map<String, String> queryLocaleMetaRes(IDataEntityType designerMetaType, String id, Lang lang) {
        HashMap<String, String> result = new HashMap<String, String>();
        List<Map<String, ILocaleValue<?>>> allRes = LocaleMetadataServiceHelper.queryLocaleMetaRes(designerMetaType, id);
        String localeId = lang.toString();
        for (Map<String, ILocaleValue<?>> row : allRes) {
            for (Map.Entry<String, ILocaleValue<?>> data : row.entrySet()) {
                ILocaleValue<?> localeValue = data.getValue();
                if (null == localeValue) continue;
                result.put(data.getKey(), StringUtils.isBlank((Object)localeValue.getItem(localeId)) ? "" : localeValue.getItem(localeId).toString());
            }
        }
        return result;
    }

    public static Map<String, String> queryMatchLocaleMetaRes(IDataEntityType designerMetaType, String id, String value, Lang lang) {
        return LocaleMetadataServiceHelper.queryLocaleMetaRes(designerMetaType, id, lang.toString(), value, new Comparator<String>(){

            @Override
            public int compare(String arg0, String arg1) {
                if (arg0 == null && arg1 == null) {
                    return 1;
                }
                if (arg0 == null || arg1 == null) {
                    return 0;
                }
                return arg0.contains(arg1) ? 1 : 0;
            }
        });
    }

    public static Map<String, Map<String, String>> batchQueryMatchLocaleMetaRes(IDataEntityType designerMetaType, List<String> ids, List<String> terms, Lang lang) {
        HashMap<String, Map<String, String>> result = new HashMap<String, Map<String, String>>();
        for (String id : ids) {
            Map<String, String> subMap = LocaleMetadataServiceHelper.queryMatchLocaleMetaRes(designerMetaType, id, terms, lang);
            if (subMap == null || subMap.size() <= 0) continue;
            result.put(id, subMap);
        }
        return result;
    }

    public static Map<String, String> queryMatchLocaleMetaRes(IDataEntityType designerMetaType, String id, List<String> values, Lang lang) {
        return LocaleMetadataServiceHelper.queryLocaleMetaRes(designerMetaType, id, lang.toString(), values, new Comparator<String>(){

            @Override
            public int compare(String arg0, String arg1) {
                if (arg0 == null && arg1 == null) {
                    return 1;
                }
                if (arg0 == null || arg1 == null) {
                    return 0;
                }
                return arg0.contains(arg1) ? 1 : 0;
            }
        });
    }

    private static Map<String, String> queryLocaleMetaRes(IDataEntityType designerMetaType, String id, String localeId, List<String> matchValues, Comparator<String> func) {
        HashMap<String, String> result = new HashMap<String, String>();
        List<Map<String, ILocaleValue<?>>> allRes = LocaleMetadataServiceHelper.queryLocaleMetaRes(designerMetaType, id);
        for (Map<String, ILocaleValue<?>> row : allRes) {
            block1: for (Map.Entry<String, ILocaleValue<?>> data : row.entrySet()) {
                if (data.getValue() == null) continue;
                for (String matchValue : matchValues) {
                    if (func.compare(String.valueOf(data.getValue().getItem(localeId)), matchValue) <= 0) continue;
                    result.put(data.getKey(), String.valueOf(data.getValue().getItem(localeId)));
                    continue block1;
                }
            }
        }
        return result;
    }

    private static Map<String, String> queryLocaleMetaRes(IDataEntityType designerMetaType, String id, String localeId, String matchValue, Comparator<String> func) {
        HashMap<String, String> result = new HashMap<String, String>();
        List<Map<String, ILocaleValue<?>>> allRes = LocaleMetadataServiceHelper.queryLocaleMetaRes(designerMetaType, id);
        for (Map<String, ILocaleValue<?>> row : allRes) {
            for (Map.Entry<String, ILocaleValue<?>> data : row.entrySet()) {
                if (data.getValue() == null || func.compare(String.valueOf(data.getValue().getItem(localeId)), matchValue) <= 0) continue;
                result.put(data.getKey(), String.valueOf(data.getValue().getItem(localeId)));
            }
        }
        return result;
    }

    private static void buildDiffRes(Map<String, String> parent, Map<String, String> currentData) {
        if (parent == null || currentData == null || parent.isEmpty()) {
            return;
        }
        for (Map.Entry<String, String> row : parent.entrySet()) {
            if (!StringUtils.equals((CharSequence)row.getValue(), (CharSequence)currentData.get(row.getKey()))) continue;
            currentData.remove(row.getKey());
        }
    }

    public static void applyTermRes(IDataEntityType designerMetaType, String id, String localeId, Map<String, String> resMap) {
        ArrayList<String> restoreKeys = new ArrayList<String>();
        for (Map.Entry<String, String> row : resMap.entrySet()) {
            if (!StringUtils.isBlank((CharSequence)row.getValue())) continue;
            restoreKeys.add(row.getKey());
        }
        Map<String, String> data = new HashMap();
        MetadataReader reader = new MetadataReader();
        AbstractMetadata meta = reader.readMeta(id, designerMetaType, false, false);
        String parentId = meta.getParentId();
        Map parentRes = null;
        if (StringUtils.isNotBlank((CharSequence)parentId)) {
            parentRes = MetadataDao.loadMetaTermByLang((IDataEntityType)designerMetaType, (String)parentId, (Lang)Lang.from((String)localeId), (boolean)true);
        }
        data = MetadataDao.loadMetaTermByLang((IDataEntityType)designerMetaType, (String)id, (Lang)Lang.from((String)localeId), (boolean)false);
        data.putAll(resMap);
        LocaleMetadataServiceHelper.restoreRes(data, restoreKeys);
        LocaleMetadataServiceHelper.buildDiffRes(parentRes, data);
        DcBinder binder = new DcBinder(){

            public IDataEntityType tryBindToType(String paramString, Map<String, String> paramMap) {
                return OrmUtils.getDataEntityType(Map.class);
            }
        };
        binder.setLCId(localeId);
        String deleteSql = "delete from " + designerMetaType.getAlias() + "_Term where fid = ? and flocaleid = ?";
        Object[] parameters = new Object[]{new SqlParameter(":fid", -9, (Object)id), new SqlParameter(":flocaleid", -9, (Object)localeId)};
        SqlBuilder sbBuilder = new SqlBuilder();
        sbBuilder.append(deleteSql, parameters);
        DB.execute((DBRoute)DBRoute.meta, (SqlBuilder)sbBuilder);
        String pkId = DB.genStringId((String)(designerMetaType.getAlias() + "_Term"));
        String strSQL = "INSERT INTO " + designerMetaType.getAlias() + "_Term(FPKID,FID,FDATA,FLOCALEID) VALUES (?, ?, ?,?)  ";
        Object[] params = new SqlParameter[]{new SqlParameter(":fpkid", -15, (Object)pkId), new SqlParameter(":fid", -15, (Object)id), new SqlParameter(":fdata", 2011, (Object)SerializationUtils.toJsonString(data)), new SqlParameter(":flocaleid", -15, (Object)localeId)};
        DB.execute((DBRoute)DBRoute.meta, (String)strSQL, (Object[])params);
        Object type = designerMetaType.createInstance();
        if (type instanceof DesignAppMeta) {
            MetadataDao.rebuildRuntimeAppMetaById((String)id);
            MetadataDao.cleanAllPortalAppCache();
        } else if (type instanceof DesignFormMeta) {
            MetadataDao.rebuildRuntimeMetaById((String)id);
        } else if (type instanceof DesignEntityMeta) {
            MetadataDao.rebuildRuntimeMetaById((String)id);
        }
    }

    private static void restoreRes(Map<String, String> resData, List<String> restoreKeys) {
        if (restoreKeys == null || restoreKeys.isEmpty()) {
            return;
        }
        for (String key : restoreKeys) {
            resData.remove(key);
        }
    }
}

