/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.servicehelper.operation;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.data.BusinessDataWriter;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.script.annotations.KSMethod;
import kd.bos.script.annotations.KSObject;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.RecordSaveFormServiceHelper;
import kd.sdk.annotation.SdkInternal;
import kd.sdk.annotation.SdkService;

@KSObject
@SdkService(name="\u5355\u636e\u5220\u9664\u670d\u52a1")
public class DeleteServiceHelper {
    private static final Log log = LogFactory.getLog(DeleteServiceHelper.class);

    public static void delete(IDataEntityType type, Object[] pks) {
        if (log.isDebugEnabled()) {
            log.debug(String.format("delete %s, ids: %s", type, Arrays.toString(pks)));
        }
        BusinessDataWriter.delete((IDataEntityType)type, (Object[])pks);
    }

    @SdkInternal
    public OperationResult deleteOperate(String operationKey, String entityName, Object[] pks) {
        return this.deleteOperate(operationKey, entityName, pks, OperateOption.create());
    }

    public OperationResult deleteOperate(String operationKey, String entityName, Object[] pks, OperateOption option) {
        if (pks != null) {
            return OperationServiceHelper.executeOperate(operationKey, entityName, pks, option);
        }
        return new OperationResult();
    }

    @KSMethod
    public static int delete(String entityName, QFilter[] qFilters) {
        MainEntityType dt = EntityMetadataCache.getDataEntityType((String)entityName);
        String queryEntityName = entityName;
        String pkProperty = dt.getPrimaryKey().getName();
        int size = 0;
        try (DataSet ds = QueryServiceHelper.queryDataSet("DeleteServiceHelper." + entityName, queryEntityName, pkProperty, qFilters, null);){
            ArrayList<Object> pks = new ArrayList<Object>();
            Iterator iter = ds.iterator();
            while (iter.hasNext()) {
                pks.add(((Row)iter.next()).get(0));
                ++size;
            }
            DeleteServiceHelper.delete((IDataEntityType)dt, pks.toArray());
        }
        RecordSaveFormServiceHelper.recordSaveFormToCache(entityName);
        return size;
    }

    @SdkInternal
    public OperationResult deleteOperate(String entityName, Object[] pks) {
        return this.deleteOperate(entityName, pks, OperateOption.create());
    }

    public OperationResult deleteOperate(String entityName, Object[] pks, OperateOption option) {
        if (pks != null) {
            return OperationServiceHelper.executeOperate("delete", entityName, pks, option);
        }
        return new OperationResult();
    }
}

