/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.servicehelper.operation;

import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.serialization.DataEntitySerializer;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.operate.CoreMutexHelper;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.script.annotations.KSMethod;
import kd.bos.script.annotations.KSObject;
import kd.bos.service.operation.OperationService;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.sdk.annotation.SdkInternal;
import kd.sdk.annotation.SdkService;

@KSObject
@SdkService(name="\u5355\u636e\u64cd\u4f5c\u670d\u52a1")
public class OperationServiceHelper {
    @SdkInternal
    public static final String IS_OPEN_INTENT_LOCKS = "isOpenIntentLocks";

    @SdkInternal
    public static OperationResult executeOperate(String operationKey, String entityNumber, DynamicObject[] dataEntities) {
        return OperationServiceHelper.executeOperate(operationKey, entityNumber, dataEntities, OperateOption.create());
    }

    @KSMethod
    public static OperationResult executeOperate(String operationKey, String entityNumber, DynamicObject[] dataEntities, OperateOption option) {
        option = OperationServiceHelper.setOperateOption(option);
        MainEntityType dt = EntityMetadataCache.getDataEntityType((String)entityNumber);
        String appId = OperationServiceHelper.getAppId(entityNumber, dt);
        String str = (String)DispatchServiceHelper.invokeBOSService(appId, OperationService.class.getSimpleName(), "invokeOperation", operationKey, dataEntities, option);
        return (OperationResult)DataEntitySerializer.deSerializerFromString((String)str, (IDataEntityType)OrmUtils.getDataEntityType(OperationResult.class));
    }

    @SdkInternal
    public static OperationResult executeOperate(String operationKey, String entityNumber, Object[] ids) {
        return OperationServiceHelper.executeOperate(operationKey, entityNumber, ids, OperateOption.create());
    }

    public static OperationResult executeOperate(String operationKey, String entityNumber, Object[] ids, OperateOption option) {
        option = OperationServiceHelper.setOperateOption(option);
        MainEntityType dt = EntityMetadataCache.getDataEntityType((String)entityNumber);
        String appId = OperationServiceHelper.getAppId(entityNumber, dt);
        String str = (String)DispatchServiceHelper.invokeBOSService(appId, OperationService.class.getSimpleName(), "invokeOperation", operationKey, entityNumber, ids, option);
        return (OperationResult)DataEntitySerializer.deSerializerFromString((String)str, (IDataEntityType)OrmUtils.getDataEntityType(OperationResult.class));
    }

    private static OperateOption setOperateOption(OperateOption option) {
        if (option == null) {
            option = OperateOption.create();
        }
        option.setVariableValue(IS_OPEN_INTENT_LOCKS, String.valueOf(CoreMutexHelper.isOpenIntentLocks()));
        return option;
    }

    private static String getAppId(String entityNumber, MainEntityType dt) {
        String appId = dt.getAppId();
        if (!"bos".equals(appId)) {
            return appId;
        }
        String bizAppNumber = dt.getBizAppNumber();
        if (StringUtils.isBlank((CharSequence)bizAppNumber)) {
            bizAppNumber = MetadataDao.getAppNumberByEntityNumber((String)entityNumber);
        }
        if (StringUtils.isNotBlank((CharSequence)bizAppNumber)) {
            appId = String.format("%s.%s", "bos", bizAppNumber);
        }
        return appId;
    }
}

