/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.servicehelper.privacy;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import kd.bos.cache.ThreadCache;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.privacy.PrivacyCenterUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.privacy.PrivacyDataCenterManager;
import kd.bos.db.privacy.PrivacyDataConstant;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.QueryEntityType;
import kd.bos.entity.list.JoinProperty;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.property.IBasedataField;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.form.FormConfig;
import kd.bos.form.FormMetadataCache;
import kd.bos.lang.Lang;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.privacy.DesensitizeField;
import kd.sdk.annotation.SdkPublic;
import org.apache.poi.openxml4j.opc.OPCPackage;
import org.apache.poi.openxml4j.opc.PackageAccess;
import org.apache.poi.poifs.crypt.EncryptionInfo;
import org.apache.poi.poifs.crypt.EncryptionMode;
import org.apache.poi.poifs.crypt.Encryptor;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;

@SdkPublic
public class PrivacyCenterServiceHelper {
    private static Log log = LogFactory.getLog(PrivacyCenterServiceHelper.class);
    public static final String OPERATETYPE_LIST = "LIST";
    public static final String OPERATETYPE_FORM = "FORM";
    public static final String OPERATETYPE_PRINT = "PRINT";
    public static final String OPERATETYPE_EXPORT = "EXPORT";
    public static final String OPERATETYPE_API = "API";
    public static final ErrorCode ERRORCODE_PRIVACY = PrivacyDataConstant.ERRORCODE;

    public static boolean isDesensitizeField(String entityNum, String fieldIdent, String localeId, String operateType, DynamicObject dynamicObject) {
        MainEntityType mainType = EntityMetadataCache.getDataEntityType((String)entityNum);
        IDataEntityProperty[] props = PrivacyCenterServiceHelper.create(mainType, fieldIdent);
        if (props == null) {
            return false;
        }
        boolean isDesen = false;
        for (IDataEntityProperty prop : props) {
            isDesen = PrivacyCenterUtils.isDesensitizeField((IDataEntityProperty)prop, (String)localeId, (String)operateType, (DynamicObject)dynamicObject);
            if (!isDesen) continue;
            return isDesen;
        }
        return isDesen;
    }

    public static boolean isDesensitizeField(IDataEntityProperty prop, String localeId, String operateType, DynamicObject dynamicObject) {
        return PrivacyCenterUtils.isDesensitizeField((IDataEntityProperty)prop, (String)localeId, (String)operateType, (DynamicObject)dynamicObject);
    }

    public static Boolean[] getBatchDesensitizeField(List<DesensitizeField> desensitizeFields) {
        Boolean[] desensitizationArr = new Boolean[desensitizeFields.size()];
        for (int i = 0; i < desensitizeFields.size(); ++i) {
            DesensitizeField desensitizeField = desensitizeFields.get(i);
            String entityNumber = desensitizeField.getEntityNumber();
            String propName = desensitizeField.getPropName();
            DynamicObject dynamicObject = desensitizeField.getDynamicObject();
            if (entityNumber == null || propName == null) continue;
            String localeId = desensitizeField.getLocalId() != null ? desensitizeField.getLocalId() : Lang.get().toString();
            String operateType = desensitizeField.getOperateType() != null ? desensitizeField.getOperateType() : OPERATETYPE_FORM;
            MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)entityNumber);
            IDataEntityProperty prop = mainEntityType.findProperty(propName);
            desensitizationArr[i] = PrivacyCenterUtils.isDesensitizeField((IDataEntityProperty)prop, (String)localeId, (String)operateType, (DynamicObject)dynamicObject);
        }
        return desensitizationArr;
    }

    public static String getDesensitizeStrategy(IDataEntityProperty prop, String operateType, DynamicObject dynamicObject) {
        if (!PrivacyDataCenterManager.isEnable()) {
            return "PLAINTEXT";
        }
        if (prop == null || kd.bos.util.StringUtils.isEmpty((String)operateType)) {
            return PrivacyDataCenterManager.getPermissionService().getDefaultStrategy();
        }
        IDataEntityType entityType = prop.getParent();
        String entityNum = PrivacyCenterServiceHelper.getEntityNumber(entityType);
        String fieldIdent = prop.getName();
        if (kd.bos.util.StringUtils.isEmpty((String)entityNum) || kd.bos.util.StringUtils.isEmpty((String)fieldIdent)) {
            return PrivacyDataCenterManager.getPermissionService().getDefaultStrategy();
        }
        return PrivacyDataCenterManager.getPermissionService().getDesensitizeStrategy(entityNum, fieldIdent, operateType, (Object)dynamicObject);
    }

    private static String getEntityNumber(IDataEntityType entityType) {
        String entityNum = null;
        while (entityType != null) {
            entityNum = entityType instanceof QueryEntityType ? ((QueryEntityType)entityType).getEntityName() : entityType.getName();
            entityType = entityType.getParent();
        }
        return entityNum;
    }

    public static Object getDesensitizeValue(IDataEntityProperty prop, String localeid, String operateType, DynamicObject dynmicObject, Object value) {
        return PrivacyCenterUtils.getDesensitizeValue((IDataEntityProperty)prop, (String)localeid, (String)operateType, (DynamicObject)dynmicObject, (Object)value);
    }

    public static Object getDesenValueByRule(String desenRuleId, Object value) {
        return PrivacyCenterUtils.getDesenValueByRule((String)desenRuleId, (Object)value);
    }

    public static Object getDesensitizeValue(String entityNum, String fieldIdent, String localeid, String operateType, DynamicObject dynamicObject, Object value) {
        if (kd.bos.util.StringUtils.isEmpty((String)fieldIdent) || kd.bos.util.StringUtils.isEmpty((String)entityNum)) {
            return value;
        }
        String cacheKey = entityNum;
        MainEntityType mainType = (MainEntityType)ThreadCache.get((Object)cacheKey, () -> {
            MainEntityType mainType1;
            block5: {
                try {
                    try {
                        mainType1 = EntityMetadataCache.getDataEntityType((String)entityNum);
                    }
                    catch (KDException e) {
                        if (BosErrorCode.entityMetaDataNotExist.equals((Object)e.getErrorCode())) {
                            FormConfig config = FormMetadataCache.getFormConfig((String)entityNum);
                            mainType1 = EntityMetadataCache.getDataEntityType((String)config.getEntityTypeId());
                            break block5;
                        }
                        throw e;
                    }
                }
                catch (Exception e) {
                    log.error(String.format("getDesensitizeValue error. entityNum %s fieldIdent %s", entityNum, fieldIdent), (Throwable)e);
                    throw e;
                }
            }
            return mainType1;
        });
        IDataEntityProperty[] props = PrivacyCenterServiceHelper.create(mainType, fieldIdent);
        if (props == null || props.length == 0) {
            return value;
        }
        for (IDataEntityProperty prop : props) {
            boolean isDesen = PrivacyCenterUtils.isDesensitizeField((IDataEntityProperty)prop, (String)localeid, (String)operateType, (DynamicObject)dynamicObject);
            if (!isDesen) continue;
            return PrivacyCenterServiceHelper.getDesensitizeValue(prop, localeid, operateType, dynamicObject, value);
        }
        return value;
    }

    public static boolean isDesensitizeFieldWithoutPerm(IDataEntityProperty prop, String localeId, String operateType, DynamicObject dynamicObject) {
        return PrivacyCenterUtils.isDesensitizeFieldWithoutPerm((IDataEntityProperty)prop, (String)localeId, (String)operateType, (DynamicObject)dynamicObject);
    }

    public static Object getDesensitizeValueWithoutPerm(IDataEntityProperty prop, String localeid, String operateType, DynamicObject dynamicObject, Object value) {
        return PrivacyCenterUtils.getDesensitizeValueWithoutPerm((IDataEntityProperty)prop, (String)localeid, (String)operateType, (DynamicObject)dynamicObject, (Object)value);
    }

    private static IDataEntityProperty[] create(MainEntityType mainType, String fieldName) {
        String[] keys = StringUtils.split((String)fieldName, (String)".");
        ArrayList<String> propNames = new ArrayList<String>(10);
        for (int i = 0; i < keys.length; ++i) {
            propNames.add(keys[i]);
        }
        IDataEntityProperty srcFieldProp = null;
        StringBuilder preFieldPropName = new StringBuilder();
        if (mainType instanceof QueryEntityType) {
            srcFieldProp = PrivacyCenterServiceHelper.getQueryEntitySrcFieldProp(mainType, fieldName, propNames);
            while (srcFieldProp != null && !((String)propNames.get(0)).equals(srcFieldProp.getName())) {
                preFieldPropName.append((String)propNames.get(0));
                preFieldPropName.append('.');
                propNames.remove(0);
            }
        } else {
            srcFieldProp = mainType.findProperty((String)propNames.get(0));
        }
        if (srcFieldProp == null && mainType.getProperties().containsKey(propNames.get(0))) {
            srcFieldProp = (IDataEntityProperty)mainType.getProperties().get(propNames.get(0));
        }
        while (srcFieldProp instanceof EntryProp && propNames.size() > 1) {
            propNames.remove(0);
            srcFieldProp = (IDataEntityProperty)((EntryProp)srcFieldProp).getItemType().getProperties().get(propNames.get(0));
        }
        if (srcFieldProp instanceof EntryProp) {
            propNames.clear();
            srcFieldProp = ((EntryProp)srcFieldProp).getItemType().getPrimaryKey();
            propNames.add(srcFieldProp.getName());
        }
        if (srcFieldProp == null) {
            return null;
        }
        int index = 0;
        Iterator<String> iterator = new ArrayList<String>(propNames).iterator();
        MainEntityType parenType = mainType;
        DynamicProperty parentProp = null;
        while (iterator.hasNext()) {
            DynamicProperty property;
            String name = iterator.next();
            if (parentProp instanceof MulBasedataProp && !"fbasedataid".equals(name)) {
                propNames.add(index++, "fbasedataid");
            }
            if ((property = (DynamicProperty)parenType.findProperty(name)) instanceof IBasedataField) {
                parenType = (MainEntityType)((IBasedataField)property).getComplexType();
            }
            ++index;
            parentProp = property;
        }
        IDataEntityProperty[] ret = srcFieldProp instanceof BasedataProp ? new IDataEntityProperty[]{srcFieldProp, parentProp} : new IDataEntityProperty[]{parentProp};
        return ret;
    }

    private static IDataEntityProperty getQueryEntitySrcFieldProp(MainEntityType mainType, String fieldName, List<String> propNames) {
        if (propNames.size() > 1) {
            String propName = propNames.get(0);
            if (fieldName.equals(mainType.getName() + "." + mainType.getPrimaryKey().getName())) {
                propName = propNames.get(1);
                return mainType.getProperty(propName);
            }
            DynamicProperty dp = ((QueryEntityType)mainType).getProperty(propName);
            if (dp instanceof JoinProperty) {
                JoinProperty joinProp = (JoinProperty)((QueryEntityType)mainType).getProperty(propName);
                MainEntityType complexType = (MainEntityType)joinProp.getComplexType();
                String subPropName = fieldName.substring(propName.length());
                if (subPropName.startsWith(".")) {
                    subPropName = subPropName.substring(1);
                }
                return complexType.findProperty(StringUtils.split((String)subPropName, (String)".")[0]);
            }
            return ((QueryEntityType)mainType).getProperty(propNames.get(0));
        }
        return ((QueryEntityType)mainType).getProperty(propNames.get(0));
    }

    static void checkDecryptPermission(IDataEntityProperty prop, String operateType, String operateTerminal) throws KDException {
        PrivacyCenterUtils.checkDecryptPermission((IDataEntityProperty)prop, (String)operateType, (String)operateTerminal);
    }

    public static boolean isEncryptField(IDataEntityProperty prop) {
        return PrivacyCenterUtils.isEncryptField((IDataEntityProperty)prop);
    }

    public static void buildEncryptDoc(String filename, String password) throws IOException {
        try (POIFSFileSystem fs = new POIFSFileSystem();){
            EncryptionInfo info = new EncryptionInfo(EncryptionMode.agile);
            Encryptor enc = info.getEncryptor();
            enc.confirmPassword(password);
            try (OPCPackage opc = OPCPackage.open((File)new File(filename), (PackageAccess)PackageAccess.READ_WRITE);
                 OutputStream os = enc.getDataStream(fs);){
                opc.save(os);
            }
            var7_10 = null;
            try (FileOutputStream fos = new FileOutputStream(filename);){
                fs.writeFilesystem((OutputStream)fos);
            }
            catch (Throwable throwable) {
                var7_10 = throwable;
                throw throwable;
            }
        }
        catch (Exception e) {
            log.error("setPwd office file ex", (Throwable)e);
        }
    }

    public static void buildEncryptDoc(InputStream inputStream, OutputStream outputStream, String password) {
        try (POIFSFileSystem fs = new POIFSFileSystem();){
            EncryptionInfo info = new EncryptionInfo(EncryptionMode.agile);
            Encryptor enc = info.getEncryptor();
            enc.confirmPassword(password);
            try (OPCPackage opc = OPCPackage.open((InputStream)inputStream);
                 OutputStream os = enc.getDataStream(fs);){
                opc.save(os);
            }
            fs.writeFilesystem(outputStream);
        }
        catch (Exception e) {
            log.error("setPwd4OOXML ex", (Throwable)e);
        }
    }
}

