/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.servicehelper.pushMessage;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeCacheHAPolicy;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.cache.ThreadCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.message.PushMessage;
import kd.bos.dataentity.message.PushMessageRange;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.api.AsynMessage;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.pushservice.AsynMessagePublisher;
import kd.bos.pushservice.PushMessagePublisher;
import kd.bos.pushservice.WebSocketIdReader;
import kd.sdk.annotation.SdkService;

@SdkService(name="\u6d88\u606f\u63a8\u9001\u670d\u52a1")
public class PushServiceHelper {
    private static final String WEBSOCKET_TARGET = "websocetRecord";
    private static DistributeSessionlessCache cache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache(null, new DistributeCacheHAPolicy(true, false));

    public static void push(AsynMessage message) {
        AsynMessagePublisher.publishAsynMessage((AsynMessage)message);
    }

    public static void push(PushMessage message) {
        PushMessagePublisher.sendPushMessage((PushMessage)message);
    }

    public static void push(PushMessage message, List<String> webSocketIdList) {
        PushMessagePublisher.sendPushMessage((PushMessage)message, webSocketIdList);
    }

    public static void sendWebSocketAction(String actionName, Object param, List<String> userIds) {
        String msg = PushServiceHelper.buildWebSocketAction(actionName, param);
        String accountId = RequestContext.get().getAccountId();
        List socketIds = null;
        if (userIds.size() > 1) {
            socketIds = WebSocketIdReader.getWebSocketIdByUserIds((String)accountId, userIds);
        }
        if (socketIds != null && !socketIds.isEmpty()) {
            PushMessage pushMessage = new PushMessage(PushMessageRange.Session, "", (Object)msg);
            PushMessagePublisher.sendPushMessage((List)socketIds, (PushMessage)pushMessage);
            return;
        }
        ArrayList<String> socketIdsList = new ArrayList<String>(10);
        for (String userId : userIds) {
            String[] sessionIds = WebSocketIdReader.getWSSessionIdByUser((String)accountId, (String)userId);
            ThreadCache.put((Object)"pushservice_websocket_push_userId", (Object)userId);
            if (sessionIds == null || sessionIds.length <= 0) continue;
            for (String sessionId : sessionIds) {
                if (StringUtils.isBlank((CharSequence)sessionId)) continue;
                PushMessage pushMessage = new PushMessage(PushMessageRange.Session, sessionId, (Object)msg);
                PushServiceHelper.push(pushMessage, socketIdsList);
            }
        }
        if (!CollectionUtils.isEmpty(socketIdsList)) {
            String[] setValues = cache.getSetValues(PushServiceHelper.buildWsKey());
            if (socketIdsList.size() < 10 && setValues != null && setValues.length > 0) {
                for (String setValue : setValues) {
                    socketIdsList.add(setValue);
                    if (socketIdsList.size() > 10) break;
                }
            }
            if (setValues != null && setValues.length > 0 && setValues.length > 10) {
                cache.remove(PushServiceHelper.buildWsKey());
            }
            cache.addToSet(PushServiceHelper.buildWsKey(), socketIdsList.toArray(new String[socketIdsList.size()]));
        }
        ThreadCache.remove((Object)"pushservice_websocket_push_userId");
    }

    private static String buildWsKey() {
        return "websocetRecord:" + RequestContext.get().getAccountId() + ":websocketids";
    }

    public static void sendWebSocketActionBySession(String actionName, Object param, String[] sessionIds) {
        String msg = PushServiceHelper.buildWebSocketAction(actionName, param);
        if (sessionIds != null && sessionIds.length > 0) {
            for (String sessionId : sessionIds) {
                if (StringUtils.isBlank((CharSequence)sessionId)) continue;
                PushMessage pushMessage = new PushMessage(PushMessageRange.Session, sessionId, (Object)msg);
                PushServiceHelper.push(pushMessage);
            }
        }
    }

    private static String buildWebSocketAction(String actionName, Object param) {
        ArrayList acts = new ArrayList();
        HashMap<String, Object> action = new HashMap<String, Object>();
        action.put("a", actionName);
        ArrayList<Object> paras = new ArrayList<Object>();
        action.put("p", paras);
        if (param instanceof List) {
            List p = (List)param;
            for (int i = 0; i < p.size(); ++i) {
                paras.add(p.get(i));
            }
        } else {
            paras.add(param);
        }
        acts.add(action);
        return SerializationUtils.toJsonString(acts);
    }
}

