/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.servicehelper.util;

import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.param.AppParam;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.isv.ISVService;
import kd.bos.metadata.devportal.EnvTypeHelper;
import kd.bos.param.service.IParameterHelperService;
import kd.bos.service.ServiceSvcFactory;
import kd.bos.servicehelper.devportal.DevVerifyServiceHelper;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;

public class DevportalCommonUtil {
    private static final String BOS_SERVICEHELPER = "bos-servicehelper";

    public static boolean isDevelopEnv() {
        return EnvTypeHelper.EnvType.Develop.equals((Object)EnvTypeHelper.getCurrentEnvType());
    }

    public static boolean isGitManageType() {
        Map<String, Object> param = DevportalCommonUtil.getSystemParam();
        String mngType = (String)param.get("combo_mng_type");
        return "git".equals(mngType);
    }

    public static Object option(String key) {
        Map<String, Object> param = DevportalCommonUtil.getSystemParam();
        return param.get(key);
    }

    public static boolean isExportMetaToLocal() {
        return false;
    }

    public static boolean isEnableNewGit() {
        return true;
    }

    public static String getGitCommonRemoteUrl() {
        Map<String, Object> param = DevportalCommonUtil.getSystemParam();
        return (String)param.get("git_url");
    }

    public static String getSvnCommonRemoteUrl() {
        Map<String, Object> param = DevportalCommonUtil.getSystemParam();
        return (String)param.get("svn_url");
    }

    public static String getGitBranch() {
        Map<String, Object> param = DevportalCommonUtil.getSystemParam();
        return (String)param.get("git_branch");
    }

    public static boolean isGitMultiParallel() {
        Map<String, Object> param = DevportalCommonUtil.getSystemParam();
        Object git_multiparallel = param.get("git_multiparallel");
        if (git_multiparallel == null) {
            return false;
        }
        return Boolean.parseBoolean(git_multiparallel.toString());
    }

    private static Map<String, Object> getSystemParam() {
        AppParam param = new AppParam();
        param.setAppId("83bfebc800003dac");
        long rootOrgId = ((IParameterHelperService)ServiceSvcFactory.getService(IParameterHelperService.class)).getParamRootOrgId();
        param.setOrgId(Long.valueOf(rootOrgId));
        param.setViewType("15");
        return SystemParamServiceHelper.loadAppParameterFromCache(param);
    }

    public static String getCodeManageType() {
        if (DevportalCommonUtil.isDevelopEnv()) {
            return DevportalCommonUtil.isGitManageType() ? "git" : "svn";
        }
        return "none";
    }

    public static String getCodeManageTypeByBizAppId(String bizAppId) {
        return DevportalCommonUtil.getCodeManageType();
    }

    public static String genEnvRegion() {
        boolean isOEMEnv = DevVerifyServiceHelper.isOEMEnv();
        String currentIsv = ISVService.getISVInfo().getId();
        if (StringUtils.isBlank((CharSequence)currentIsv)) {
            throw new KDException(BosErrorCode.bOS, new Object[]{ResManager.loadKDString((String)"\u5f53\u524d\u6570\u636e\u4e2d\u5fc3\u672a\u6ce8\u518c\u5f00\u53d1\u5546\uff0c\u8bf7\u4f7f\u7528\u8d85\u7ba1\u8d26\u53f7\u767b\u5f55\u5e76\u6ce8\u518c\u5f00\u53d1\u5546\u3002", (String)"DevportalCommonUtil_0", (String)BOS_SERVICEHELPER, (Object[])new Object[0])});
        }
        if (isOEMEnv && !"kingdee".equals(currentIsv)) {
            String encodeValue = new String(Base64.getEncoder().encode("OEM".getBytes(StandardCharsets.UTF_8)));
            StringBuilder builder = new StringBuilder(encodeValue);
            return builder.reverse().toString();
        }
        return null;
    }
}

