/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.servicehelper.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDBizException;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.deploy.DeployFile;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.devportal.AppMetaServiceHelper;
import kd.bos.servicehelper.devportal.BizAppServiceHelp;
import kd.bos.servicehelper.devportal.BizCloudServiceHelp;

public class GitOperateUtil {
    private static final Log logger = LogFactory.getLog(GitOperateUtil.class);
    private static final String BOS_SERVICEHELPER = "bos-servicehelper";

    private GitOperateUtil() {
    }

    public static void exportFormMetadata(String formId, String path) {
        try {
            List list = MetadataDao.getFormDeployFile((String)formId);
            if (!list.isEmpty()) {
                String fileContent = ((DeployFile)list.get(0)).getFileContent();
                String fileName = ((DeployFile)list.get(0)).getFileName();
                GitOperateUtil.saveMetadata(fileContent, fileName, path);
                for (int i = 1; i < list.size(); ++i) {
                    if (!((DeployFile)list.get(i)).getFileName().endsWith("zh_CN.dymx")) continue;
                    GitOperateUtil.saveMetadata(((DeployFile)list.get(i)).getFileContent(), ((DeployFile)list.get(i)).getFileName(), path);
                }
            }
        }
        catch (Exception e) {
            logger.error((Throwable)e);
            throw new KDBizException(e.getMessage());
        }
    }

    public static void exportScriptMetadata(String scriptId, String path) {
        try {
            List scriptDeployFile = MetadataDao.getScriptDeployFile((String[])new String[]{scriptId});
            if (!scriptDeployFile.isEmpty()) {
                String scriptContent = ((DeployFile)scriptDeployFile.get(0)).getFileContent();
                String scriptName = ((DeployFile)scriptDeployFile.get(0)).getFileName();
                GitOperateUtil.saveMetadata(scriptContent, scriptName, path);
            }
        }
        catch (Exception e) {
            logger.error((Throwable)e);
            throw new KDBizException(e.getMessage());
        }
    }

    public static void exportAppFile(String bizAppId, String path) {
        try {
            List<DeployFile> appDeployFile = AppMetaServiceHelper.getAppDeployFile(bizAppId);
            if (!appDeployFile.isEmpty()) {
                String fileContent = appDeployFile.get(0).getFileContent();
                String fileName = appDeployFile.get(0).getFileName();
                GitOperateUtil.saveMetadata(fileContent, fileName, path);
                for (int i = 1; i < appDeployFile.size(); ++i) {
                    if (!appDeployFile.get(i).getFileName().endsWith("zh_CN.appx")) continue;
                    GitOperateUtil.saveMetadata(appDeployFile.get(i).getFileContent(), appDeployFile.get(i).getFileName(), path);
                }
            }
        }
        catch (Exception e) {
            logger.error((Throwable)e);
            throw new KDBizException(e.getMessage());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getPath(String bizAppId) {
        String path = System.getProperty("git.export");
        if (path == null) return null;
        if (StringUtils.isBlank((CharSequence)path)) {
            return null;
        }
        String bizNumber = BizAppServiceHelp.getAppNumByAppId(bizAppId);
        File file = new File(path);
        if (!file.exists()) {
            return null;
        }
        try (FileInputStream inputStream = new FileInputStream(file);
             InputStreamReader reader = new InputStreamReader((InputStream)inputStream, StandardCharsets.UTF_8);){
            Properties properties = new Properties();
            properties.load(reader);
            path = properties.getProperty(bizNumber);
            if (!StringUtils.isBlank((CharSequence)path)) return path + File.separator + "metadata";
            String string = null;
            return string;
        }
        catch (IOException e) {
            logger.error(e.getMessage());
        }
        return path + File.separator + "metadata";
    }

    public static void saveMetadata(String fileContent, String fileName, String path) {
        String fullPath = path + File.separator + fileName;
        String[] abovePath = fullPath.split(fileName);
        File file = new File(fullPath);
        File fileAbovePath = new File(abovePath[0]);
        if (!fileAbovePath.exists()) {
            fileAbovePath.mkdirs();
        }
        if (!file.exists()) {
            try {
                boolean flag = file.createNewFile();
                if (!flag) {
                    logger.info(ResManager.loadKDString((String)"\u521b\u5efa\u6587\u4ef6\u5931\u8d25", (String)"GitOperateUtil_1", (String)BOS_SERVICEHELPER, (Object[])new Object[0]));
                }
            }
            catch (IOException e) {
                logger.error((Throwable)e);
                throw new KDBizException(e.getMessage());
            }
        }
        OutputStreamWriter writer = null;
        try {
            writer = new OutputStreamWriter((OutputStream)new FileOutputStream(file), StandardCharsets.UTF_8);
            writer.write(fileContent);
        }
        catch (IOException e) {
            logger.error((Throwable)e);
            throw new KDBizException(e.getMessage());
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (IOException e) {
                    logger.error((Throwable)e);
                }
            }
        }
    }

    public static void importAppMetadata(String bizAppId) {
        DynamicObject cloud = BizCloudServiceHelp.getBizCloudByAppID(bizAppId);
        String id = cloud.getString("id");
        DynamicObject appObj = BusinessDataServiceHelper.loadSingle((Object)bizAppId, "bos_devportal_bizapp", "id,type,name,masterid");
        String appNumber = appObj.getString("number");
        String path = GitOperateUtil.getPath(bizAppId);
        List<File> files = GitOperateUtil.getFiles(path, appNumber, ".app");
        boolean exits = GitOperateUtil.isFileExits(files, appNumber, ".app");
        if (!exits) {
            throw new KDBizException("no file");
        }
        try (TXHandle tx = TX.required();){
            for (File file : files) {
                String content = GitOperateUtil.getContent(file);
                MetadataDao.deployAppMetadata((String)content, (String)id);
            }
            String type = appObj.getString("type");
            String masterId = appObj.getString("masterid");
            if (StringUtils.equals((CharSequence)"2", (CharSequence)type) && StringUtils.isNotBlank((CharSequence)masterId)) {
                bizAppId = appObj.getString("masterid");
            }
            MetadataDao.rebuildRuntimeAppMetaById((String)bizAppId);
        }
    }

    /*
     * Exception decompiling
     */
    public static void importPageMetadata(Map<String, String> pages, String bizAppId, AbstractFormPlugin plugin) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static void importScriptMetadata(Map<String, String> scripts, String bizAppId) {
        Iterator<Map.Entry<String, String>> iterator = scripts.entrySet().iterator();
        String path = GitOperateUtil.getPath(bizAppId);
        try (TXHandle tx = TX.required();){
            while (iterator.hasNext()) {
                Map.Entry<String, String> script = iterator.next();
                String scriptId = script.getKey();
                List<File> files = GitOperateUtil.getFiles(path, scriptId, ".ks");
                boolean exits = GitOperateUtil.isFileExits(files, scriptId, ".ks");
                if (!exits) {
                    throw new KDBizException("no file");
                }
                String bizUnitId = script.getValue();
                for (File file : files) {
                    String content = GitOperateUtil.getContent(file);
                    MetadataDao.deployScript((String)content, (String)bizUnitId, (String)bizAppId);
                }
            }
        }
    }

    public static String getContent(File file) {
        String fileContent = "";
        FileInputStream in = null;
        try {
            in = new FileInputStream(file);
            Long length = file.length();
            byte[] bytes = new byte[length.intValue()];
            int count = 0;
            while ((count = ((InputStream)in).read(bytes)) > 0) {
                fileContent = new String(bytes, StandardCharsets.UTF_8);
            }
        }
        catch (Exception e) {
            throw new KDBizException(e.getMessage());
        }
        finally {
            if (in != null) {
                try {
                    ((InputStream)in).close();
                }
                catch (IOException e) {
                    logger.error((Throwable)e);
                }
            }
        }
        return fileContent;
    }

    public static boolean isHaveFile(String bizAppId) {
        File[] files;
        String path = GitOperateUtil.getPath(bizAppId);
        if (path == null) {
            return false;
        }
        try {
            File file = new File(path);
            files = file.listFiles();
        }
        catch (Exception e) {
            return false;
        }
        return files != null && files.length >= 1;
    }

    public static List<File> getFiles(String path, String fileName, String type) {
        ArrayList<File> fileList = new ArrayList<File>(2);
        try {
            File file = new File(path);
            File[] files = file.listFiles();
            if (files == null) {
                return fileList;
            }
            for (File file1 : files) {
                String fName;
                String name;
                if (file1.isDirectory() || !(name = (fName = file1.getName()).split("\\.")[0]).equals(fileName) || !fName.contains(type)) continue;
                fileList.add(file1);
            }
            return fileList;
        }
        catch (Exception e) {
            throw new KDBizException(e.getMessage());
        }
    }

    public static boolean isFileExits(List<File> files, String number, String type) {
        String fileName = String.format("%s%s", number, type);
        for (File file : files) {
            if (!file.getName().contains(fileName)) continue;
            return true;
        }
        return false;
    }
}

