/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.servicehelper.util;

import java.sql.ResultSet;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import kd.bos.dataentity.SqlParameter;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;

public class QueryPluginUtil {
    private static final String NO_CODE_BIZAPPID = "2HGKTA7HH43C";

    public Set<String> queryScriptPluginLinkForms(String className, String scriptType) {
        if (StringUtils.isBlank((CharSequence)scriptType)) {
            return Collections.emptySet();
        }
        Set<String> numbers = new HashSet<String>(10);
        if (className.contains("%")) {
            return numbers;
        }
        switch (scriptType) {
            case "1": {
                numbers = this.queryFormPluginNumbers(className);
                break;
            }
            case "2": {
                numbers = this.queryBillPluginNumbers(className);
                break;
            }
            case "3": {
                numbers = this.queryListPluginNumbers(className);
                break;
            }
            case "4": {
                numbers = this.queryOperatePluginNumbers(className);
                break;
            }
            case "6": {
                numbers = this.queryBusinessExtPluginNumbers(className);
                break;
            }
            case "10": {
                numbers = this.queryBotpPluginNumbers(className);
                break;
            }
            case "11": {
                numbers = this.queryWriteBackPluginNumbers(className);
                break;
            }
            case "12": {
                numbers = this.queryPrintPluginNumbers(className);
                break;
            }
            case "13": {
                numbers = this.queryImportPluginNumbers(className);
                break;
            }
            case "14": {
                numbers = this.queryBusinessEarlyWarnPluginNumbers(className);
                break;
            }
        }
        return numbers;
    }

    private Set<String> queryFormPluginNumbers(String className) {
        String filterKey = String.format("%s%s%s", "<ClassName>", className, "</ClassName>");
        String sql = "select fnumber from t_meta_formdesign where fdata like ? and fbizappid != ?";
        Object[] params = new SqlParameter[]{new SqlParameter(":fdata", 12, (Object)("%" + filterKey + "%")), new SqlParameter(":fbizappid", 12, (Object)NO_CODE_BIZAPPID)};
        return (Set)DB.query((DBRoute)DBRoute.meta, (String)sql, (Object[])params, (ResultSetHandler)new ResultSetHandler<Set<String>>(){

            public Set<String> handle(ResultSet resultSet) throws Exception {
                HashSet<String> numbers = new HashSet<String>(10);
                while (resultSet.next()) {
                    numbers.add(resultSet.getString("fnumber"));
                }
                return numbers;
            }
        });
    }

    private Set<String> queryBillPluginNumbers(String className) {
        return this.queryFormPluginNumbers(className);
    }

    private Set<String> queryListPluginNumbers(String className) {
        return this.queryFormPluginNumbers(className);
    }

    private Set<String> queryOperatePluginNumbers(String className) {
        String sql1 = "select fnumber from t_meta_entitydesign where fdata like ? and fbizappid != ?";
        String filterKey = String.format("%s%s%s", "<ClassName>", className, "</ClassName>");
        Object[] params = new SqlParameter[]{new SqlParameter(":fdata", 12, (Object)("%" + filterKey + "%")), new SqlParameter(":fbizappid", 12, (Object)NO_CODE_BIZAPPID)};
        return (Set)DB.query((DBRoute)DBRoute.meta, (String)sql1, (Object[])params, (ResultSetHandler)new ResultSetHandler<Set<String>>(){

            public Set<String> handle(ResultSet resultSet) throws Exception {
                HashSet<String> numbers = new HashSet<String>(10);
                while (resultSet.next()) {
                    numbers.add(resultSet.getString("fnumber"));
                }
                return numbers;
            }
        });
    }

    private Set<String> queryBusinessExtPluginNumbers(String className) {
        String sql = "SELECT ECA.FOBJECTTYPE FROM T_META_BIZEXTPLUGIN EPL JOIN T_META_BIZEXTCASE ECA ON EPL.FID = ECA.FID WHERE EPL.FPLUGINCLASS = ? AND ECA.FBIZAPPID != ?";
        Object[] parameters = new SqlParameter[]{new SqlParameter(":FPLUGINCLASS", 12, (Object)className), new SqlParameter(":FBIZAPPID", 12, (Object)NO_CODE_BIZAPPID)};
        return (Set)DB.query((DBRoute)DBRoute.meta, (String)sql, (Object[])parameters, rs -> {
            HashSet<String> result = new HashSet<String>(8);
            while (rs.next()) {
                result.add(rs.getString("FOBJECTTYPE"));
            }
            return result;
        });
    }

    private Set<String> queryBusinessEarlyWarnPluginNumbers(String className) {
        String filterKey = String.format("<ClassName>%s</ClassName>", className);
        String sql = "SELECT FDATASOURCEID FROM T_WARN_EARLYWARN WHERE FDATA LIKE ? AND FBIZAPPID != ?";
        Object[] params = new SqlParameter[]{new SqlParameter(":FDATA", 12, (Object)("%" + filterKey + "%")), new SqlParameter(":FBIZAPPID", 12, (Object)NO_CODE_BIZAPPID)};
        return (Set)DB.query((DBRoute)DBRoute.meta, (String)sql, (Object[])params, rs -> {
            HashSet<String> numbers = new HashSet<String>(8);
            while (rs.next()) {
                if (!StringUtils.isNotBlank((CharSequence)rs.getString("FDATASOURCEID"))) continue;
                numbers.add(rs.getString("FDATASOURCEID"));
            }
            return numbers;
        });
    }

    private Set<String> queryBotpPluginNumbers(String className) {
        String filterKey = String.format("%s%s%s", "<ClassName>", className, "</ClassName>");
        String sql = "select fsourceentitynumber from T_BOTP_ConvertRule where fdata like ? and fbizappid != ?";
        Object[] params = new SqlParameter[]{new SqlParameter(":fdata", 12, (Object)("%" + filterKey + "%")), new SqlParameter(":fbizappid", 12, (Object)NO_CODE_BIZAPPID)};
        return (Set)DB.query((DBRoute)DBRoute.meta, (String)sql, (Object[])params, (ResultSetHandler)new ResultSetHandler<Set<String>>(){

            public Set<String> handle(ResultSet resultSet) throws Exception {
                HashSet<String> numbers = new HashSet<String>(10);
                while (resultSet.next()) {
                    numbers.add(resultSet.getString("fsourceentitynumber"));
                }
                return numbers;
            }
        });
    }

    private Set<String> queryWriteBackPluginNumbers(String className) {
        String filterKey = String.format("%s%s%s", "<ClassName>", className, "</ClassName>");
        String sql = "select fnumber from t_meta_entitydesign where fdata like ? and fbizappid != ?";
        Object[] params = new SqlParameter[]{new SqlParameter(":fdata", 12, (Object)("%" + filterKey + "%")), new SqlParameter(":fbizappid", 12, (Object)NO_CODE_BIZAPPID)};
        return (Set)DB.query((DBRoute)DBRoute.meta, (String)sql, (Object[])params, (ResultSetHandler)new ResultSetHandler<Set<String>>(){

            public Set<String> handle(ResultSet resultSet) throws Exception {
                HashSet<String> numbers = new HashSet<String>(10);
                while (resultSet.next()) {
                    numbers.add(resultSet.getString("fnumber"));
                }
                return numbers;
            }
        });
    }

    private Set<String> queryPrintPluginNumbers(String className) {
        String sql = "select fbillformid from t_svc_printmeta where fdata like ? and fbizappid != ?";
        Object[] params = new SqlParameter[]{new SqlParameter(":fdata", 12, (Object)("%" + className + "%")), new SqlParameter(":fbizappid", 12, (Object)NO_CODE_BIZAPPID)};
        return (Set)DB.query((DBRoute)DBRoute.base, (String)sql, (Object[])params, (ResultSetHandler)new ResultSetHandler<Set<String>>(){

            public Set<String> handle(ResultSet resultSet) throws Exception {
                HashSet<String> numbers = new HashSet<String>(10);
                while (resultSet.next()) {
                    numbers.add(resultSet.getString("fbillformid"));
                }
                return numbers;
            }
        });
    }

    private Set<String> queryImportPluginNumbers(String className) {
        String sql = "select fbizobject from T_BAS_IMPORTTEMPLATE where fplugin like ?";
        Object[] params = new SqlParameter[]{new SqlParameter(":fplugin", 12, (Object)("%" + className + "%"))};
        return (Set)DB.query((DBRoute)DBRoute.base, (String)sql, (Object[])params, (ResultSetHandler)new ResultSetHandler<Set<String>>(){

            public Set<String> handle(ResultSet resultSet) throws Exception {
                HashSet<String> numbers = new HashSet<String>(10);
                while (resultSet.next()) {
                    numbers.add(resultSet.getString("fbizobject"));
                }
                return numbers;
            }
        });
    }

    static interface ScriptPluginType {
        public static final String FORM_PLUGIN = "1";
        public static final String BILL_PLUGIN = "2";
        public static final String LIST_PLUGIN = "3";
        public static final String OPERATE_PLUGIN = "4";
        public static final String BUSINESS_EXT_PLUGIN = "6";
        public static final String BOTP_PLUGIN = "10";
        public static final String WRITEBACK_PLUGIN = "11";
        public static final String PRINT_PLUGIN = "12";
        public static final String IMPORT_PLUGIN = "13";
        public static final String BUSINESS_EARLY_WARNING_PLUGIN = "14";
    }
}

