/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.filter;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import kd.bos.dataentity.entity.SimplePropertyAttribute;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.filter.FilterField;
import kd.bos.filter.CommonBaseDataFilterColumn;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.DependField;
import kd.bos.filter.FilterColumn;
import kd.bos.filter.IFilterGridView;
import kd.bos.form.container.Container;
import kd.bos.form.control.Control;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.list.ControlContext;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.param.ParameterReader;
import kd.sdk.annotation.SdkInternal;
import kd.sdk.annotation.SdkPublic;
import org.jetbrains.annotations.NotNull;

@SdkPublic
public abstract class AbstractFilterGridView
extends Container
implements IFilterGridView {
    private static final Log log = LogFactory.getLog(AbstractFilterGridView.class);
    protected List<FilterColumn> filterColumns;
    Map<String, List<DependField>> dependFieldMap = new HashMap<String, List<DependField>>(16);
    private List<Consumer<SetFilterEvent>> setFilterListeners = new ArrayList<Consumer<SetFilterEvent>>();
    private MainEntityType entityType;
    ControlContext context;
    private int visible;
    private Map<String, Set<String>> beDependFieldNameMap;
    private boolean baseDataControl;

    Map<String, List<DependField>> getDependFieldMap() {
        return this.dependFieldMap;
    }

    void setDependFieldMap(Map<String, List<DependField>> dependFieldMap) {
        this.dependFieldMap = dependFieldMap;
    }

    public void addSetFilterListeners(Consumer<SetFilterEvent> setFilterListener) {
        this.setFilterListeners.add(setFilterListener);
    }

    public List<Consumer<SetFilterEvent>> getSetFilterListeners() {
        return this.setFilterListeners;
    }

    public void setSetFilterListeners(List<Consumer<SetFilterEvent>> setFilterListeners) {
        this.setFilterListeners = setFilterListeners;
    }

    public MainEntityType getEntityType() {
        return this.entityType;
    }

    @SdkInternal
    public void setEntityType(MainEntityType entityType) {
        this.entityType = entityType;
    }

    public ControlContext getContext() {
        return this.context;
    }

    @SdkInternal
    public void setContext(ControlContext context) {
        this.context = context;
    }

    @SimplePropertyAttribute
    public int getVisible() {
        return this.visible;
    }

    @SdkInternal
    public void setVisible(int visible) {
        this.visible = visible;
    }

    protected void createChildClientConfigs(Map<String, Object> map) {
    }

    void setDependFieldMap() {
        this.setDependFieldMap(this.getFilterColumns());
    }

    Map<String, Set<String>> getBeDependFieldNameMap() {
        if (this.beDependFieldNameMap == null) {
            this.beDependFieldNameMap = new HashMap<String, Set<String>>(16);
            for (Map.Entry<String, List<DependField>> entry : this.dependFieldMap.entrySet()) {
                for (DependField dependField : entry.getValue()) {
                    if (dependField.getDependFieldName() == null) continue;
                    Set<String> depentFieldSet = this.beDependFieldNameMap.get(dependField.getDependFieldName());
                    if (depentFieldSet == null) {
                        depentFieldSet = new HashSet<String>(16);
                    }
                    depentFieldSet.add(entry.getKey());
                    this.beDependFieldNameMap.put(dependField.getDependFieldName(), depentFieldSet);
                }
            }
        }
        return this.beDependFieldNameMap;
    }

    void setDependFieldMap(List<FilterColumn> filterColumnsList) {
        Map<String, List<String>> orgFieldColumnsMap = this.getOrgFieldColumnsMap(filterColumnsList);
        Map billParam = ParameterReader.loadBillParameterObjectFromCache((String)this.getEntityType().getName());
        boolean baseDataControl = this.isBaseDataControl(billParam);
        for (FilterColumn filterColumn : filterColumnsList) {
            DependField dependField;
            if (!filterColumn.isEntityField() || !filterColumn.isBaseDataProp()) continue;
            filterColumn.setBaseDataControl(baseDataControl);
            List<DependField> dependFields = this.dependFieldMap.get(filterColumn.getFieldName());
            if (dependFields != null) continue;
            if (filterColumn instanceof CommonBaseDataFilterColumn && (dependField = ((CommonBaseDataFilterColumn)filterColumn).getDependField()) != null) {
                dependFields = new ArrayList<DependField>(10);
                dependFields.add(dependField);
                this.dependFieldMap.put(filterColumn.getFieldName(), dependFields);
            }
            if (dependFields != null || !baseDataControl) continue;
            filterColumn.setOrgFieldColumnsMap(orgFieldColumnsMap);
            this.appendFilterColumnOrgDependField(filterColumn);
        }
    }

    void setBaseDataControl(boolean baseDataControl) {
        this.baseDataControl = baseDataControl;
    }

    private boolean isBaseDataControl(Map<String, Object> billParam) {
        if (billParam != null) {
            Object isBaseDataControl = billParam.get("listfilterbasedatacontrol");
            if (isBaseDataControl != null) {
                return this.baseDataControl && Boolean.parseBoolean(isBaseDataControl.toString());
            }
            return true;
        }
        return true;
    }

    private void appendFilterColumnOrgDependField(FilterColumn filterColumn) {
        List<DependField> orgDependFields = filterColumn.getOrgDependField();
        for (DependField orgDependField : orgDependFields) {
            ArrayList<DependField> dependFields = new ArrayList<DependField>(10);
            dependFields.add(orgDependField);
            this.dependFieldMap.put(filterColumn.getFieldName(), dependFields);
        }
    }

    private Map<String, List<String>> getOrgFieldColumnsMap(List<FilterColumn> filterColumnsList) {
        HashMap<String, List<String>> orgFieldColumnsMap = new HashMap<String, List<String>>(16);
        for (FilterColumn filterColumn : filterColumnsList) {
            if (!filterColumn.isEntityOrgField()) continue;
            String preFieldName = filterColumn.getFieldName().split("\\.")[0];
            ArrayList<String> orgFieldColumns = (ArrayList<String>)orgFieldColumnsMap.get(preFieldName);
            if (orgFieldColumns == null) {
                orgFieldColumns = new ArrayList<String>(10);
            }
            orgFieldColumns.add(filterColumn.getFieldName());
            orgFieldColumnsMap.put(preFieldName, orgFieldColumns);
        }
        return orgFieldColumnsMap;
    }

    @SdkInternal
    public static List<Map<String, Object>> createFilterColumns(List<FilterColumn> filterColumns, MainEntityType entityType) {
        ArrayList<Map<String, Object>> cols = new ArrayList<Map<String, Object>>();
        if (filterColumns != null) {
            for (FilterColumn filterColumn : filterColumns) {
                if (filterColumn.isNeedHideOrg() || filterColumn.isBlackField()) continue;
                filterColumn.setEntityType(entityType);
                cols.add(filterColumn.createColumn());
            }
        }
        return cols;
    }

    boolean skip(FilterColumn filterColumn) {
        return false;
    }

    List<FilterColumn> filterAndSort(List<FilterColumn> filterColumns) {
        return filterColumns;
    }

    List<FilterColumn> getShowFilterColumns(boolean isAll) {
        List<FilterColumn> fltColumns = this.getFilterColumns();
        ArrayList<FilterColumn> showFilterColumns = new ArrayList<FilterColumn>(10);
        if (fltColumns != null) {
            for (FilterColumn filterColumn : fltColumns) {
                if (filterColumn.isNeedHideOrg() || filterColumn.isBlackField()) continue;
                if (filterColumn.getFilterField() != null) {
                    FilterField filterField2;
                    FilterField filterField = filterColumn.getFilterField();
                    if (filterField.isDesenAndNoSearch()) {
                        log.info("\u8131\u654f\u5b57\u6bb5\u652f\u6301\u67e5\u8be2\u672a\u5f00\u542f\u6216\u8131\u654f\u7b56\u7565\u4e0d\u7b26\u5408\u6761\u4ef6\uff0c\u56e0\u6b64\u5feb\u901f\u8fc7\u6ee4\u5c4f\u853d\u8be5\u8131\u654f\u5b57\u6bb5, prop is {}", (Object)filterColumn.getFieldName());
                        continue;
                    }
                    if (filterField.isEncryptField()) {
                        log.info("\u5feb\u901f\u8fc7\u6ee4\u5c4f\u853d\u52a0\u5bc6\u5b57\u6bb5, prop is {}", (Object)filterColumn.getFieldName());
                        continue;
                    }
                    if (filterColumn instanceof CommonFilterColumn && (filterField2 = ((CommonFilterColumn)filterColumn).getOriFilterField()) != null && !filterField2.equals((Object)filterField)) {
                        if (filterField.isDesenAndNoSearch()) {
                            log.info("\u8131\u654f\u5b57\u6bb5\u652f\u6301\u67e5\u8be2\u672a\u5f00\u542f\u6216\u8131\u654f\u7b56\u7565\u4e0d\u7b26\u5408\u6761\u4ef6\uff0c\u56e0\u6b64\u5feb\u901f\u8fc7\u6ee4\u5c4f\u853d\u8be5\u8131\u654f\u5b57\u6bb5, prop is {}", (Object)filterColumn.getFieldName());
                            continue;
                        }
                        if (filterField2.isEncryptField()) {
                            log.info("\u5feb\u901f\u8fc7\u6ee4\u5c4f\u853d\u8131\u654f\u548c\u52a0\u5bc6\u5b57\u6bb5, prop is {}", (Object)filterColumn.getFieldName());
                            continue;
                        }
                    }
                }
                showFilterColumns.add(filterColumn);
            }
            if (!isAll) {
                return this.filterAndSort(showFilterColumns);
            }
        }
        return showFilterColumns;
    }

    @SdkInternal
    public Object createFilterColumns() {
        List<FilterColumn> fltColumns = this.getShowFilterColumns(false);
        ArrayList<Map<String, Object>> cols = new ArrayList<Map<String, Object>>(10);
        for (FilterColumn filterColumn : fltColumns) {
            filterColumn.setEntityType(this.getEntityType());
            filterColumn.setContext(this.context);
            filterColumn.setView(this.getView());
            cols.add(filterColumn.createColumn());
        }
        return cols;
    }

    List<Map<String, List<Object>>> getDefaultFilterValues() {
        List<FilterColumn> showFilterColumns = this.getShowFilterColumns(false);
        return AbstractFilterGridView.getFilterValues(showFilterColumns, this.entityType);
    }

    @SdkInternal
    public static List<Map<String, List<Object>>> getFilterValues(List<FilterColumn> filterColumns, MainEntityType entityType) {
        return AbstractFilterGridView.getDefaultFilterValues(filterColumns, entityType, t -> t.getDefaultFilter());
    }

    static Map<String, List<Object>> getDefaultFilterValuesWithVirtural(List<FilterColumn> filterColumns, MainEntityType entityType) {
        List<Map<String, List<Object>>> defaultFilterValues = AbstractFilterGridView.getDefaultFilterValues(filterColumns, entityType, t -> t.getDefaultFilterWithVirtural());
        HashMap<String, List<Object>> fieldValueMap = new HashMap<String, List<Object>>(defaultFilterValues.size());
        for (Map<String, List<Object>> defaultFilterValue : defaultFilterValues) {
            fieldValueMap.put(defaultFilterValue.get("FieldName").get(0).toString(), defaultFilterValue.get("Value"));
        }
        return fieldValueMap;
    }

    @NotNull
    private static List<Map<String, List<Object>>> getDefaultFilterValues(List<FilterColumn> filterColumns, MainEntityType entityType, Function<FilterColumn, Map<String, List<Object>>> function) {
        ArrayList<Map<String, List<Object>>> filterValues = new ArrayList<Map<String, List<Object>>>();
        for (FilterColumn filterColumn : filterColumns) {
            filterColumn.setEntityType(entityType);
            FilterField filterField = filterColumn.getFilterField();
            if (filterField != null && filterField.isEncryptField()) {
                log.info(String.format("privacycenter warn, filterColumn %s isEncryptField and will skip", filterField.toString()));
                continue;
            }
            Map<String, List<Object>> defaultFilter = function.apply(filterColumn);
            if (defaultFilter == null) continue;
            filterValues.add(defaultFilter);
        }
        return filterValues;
    }

    @Override
    public void initDefaultValues() {
        for (FilterColumn filterColumn : this.getFilterColumns()) {
            filterColumn.initDefaultValues();
        }
    }

    @SdkInternal
    public void initProperties() {
        ArrayList<FilterColumn> filterColumnList = new ArrayList<FilterColumn>();
        for (Control childitem : this.getItems()) {
            if (!(childitem instanceof FilterColumn)) continue;
            FilterColumn filterColumn = (FilterColumn)childitem;
            filterColumn.setParentViewKey(this.getKey());
            filterColumn.setView(this.getView());
            filterColumn.setEntityType(this.getEntityType());
            filterColumn.setContext(this.context);
            filterColumn.createBlankProp();
            filterColumnList.add(filterColumn);
        }
        this.initFilterColumns(filterColumnList);
    }

    protected void initFilterColumns(List<FilterColumn> filterColumns) {
        for (FilterColumn filterColumn : filterColumns) {
            filterColumn.initProperties();
        }
    }

    void addFilterColumn(FilterColumn filterColumn) {
        this.getItems().add(filterColumn);
        this.filterColumns.add(filterColumn);
    }

    @Override
    public List<FilterColumn> getFilterColumns() {
        if (this.filterColumns == null) {
            LinkedHashSet<FilterColumn> filterColumnsSet = new LinkedHashSet<FilterColumn>(16);
            for (Control childitem : this.getItems()) {
                if (!(childitem instanceof FilterColumn)) continue;
                FilterColumn filterColumn = (FilterColumn)childitem;
                filterColumnsSet.addAll(filterColumn.getFilterColumns());
            }
            this.filterColumns = new ArrayList<FilterColumn>(filterColumnsSet);
        }
        return this.filterColumns;
    }

    void fixContext() {
        ArrayList<String> filterColumnNames = new ArrayList<String>();
        for (Control control : this.getItems()) {
            if (!(control instanceof FilterColumn)) continue;
            filterColumnNames.add(((FilterColumn)control).getFieldName());
        }
        for (FilterColumn filterColumn : this.getFilterColumns()) {
            if (!filterColumnNames.contains(filterColumn.getFieldName())) {
                filterColumn.setNewAdded(true);
                filterColumn.setEntityType(this.getEntityType());
                filterColumn.setContext(this.getContext());
            } else {
                this.fixCompareTypes(filterColumn);
                if (filterColumn.getEntityType() == null) {
                    filterColumn.setEntityType(this.getEntityType());
                }
                if (filterColumn.getContext() == null) {
                    filterColumn.setContext(this.getContext());
                }
            }
            filterColumn.fixContext();
        }
    }

    void fixCompareTypes(FilterColumn filterColumn) {
    }
}

