/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.filter;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import joptsimple.internal.Strings;
import kd.bos.algo.DataSet;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.TypesContainer;
import kd.bos.dataentity.entity.ComplexPropertyAttribute;
import kd.bos.dataentity.entity.DefaultValueAttribute;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.entity.SimplePropertyAttribute;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.trace.EntityTraceSpan;
import kd.bos.dataentity.trace.EntityTracer;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityMetadataProvider;
import kd.bos.entity.EntityType;
import kd.bos.entity.EntryEntityDto;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.QueryEntityType;
import kd.bos.entity.RefEntityType;
import kd.bos.entity.Tips;
import kd.bos.entity.datamodel.IFilterModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.filter.CompareType;
import kd.bos.entity.filter.ControlFilters;
import kd.bos.entity.filter.FilterKeyValue;
import kd.bos.entity.filter.FilterKeyValueCollections;
import kd.bos.entity.filter.FilterMetadata;
import kd.bos.entity.filter.FilterModelContext;
import kd.bos.entity.filter.FilterParameter;
import kd.bos.entity.filter.FilterScheme;
import kd.bos.entity.filter.SortObject;
import kd.bos.entity.filter.TypeChange;
import kd.bos.entity.param.ShowColumn;
import kd.bos.entity.property.IBasedataField;
import kd.bos.entity.property.IFieldHandle;
import kd.bos.entity.property.IRefBillField;
import kd.bos.entity.property.LongProp;
import kd.bos.entity.property.MuliLangTextProp;
import kd.bos.entity.property.PKFieldProp;
import kd.bos.entity.property.RefBillProp;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.exception.XDBErrorCode;
import kd.bos.filter.AbstractFilterGridView;
import kd.bos.filter.ArchiveUIProxy;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.CompareTypeConfig;
import kd.bos.filter.CompareTypeField;
import kd.bos.filter.CompareTypeModel;
import kd.bos.filter.CompareTypeModelCollection;
import kd.bos.filter.CompareTypeQuery;
import kd.bos.filter.CustomBaseDataSchemeFilterColumn;
import kd.bos.filter.DependField;
import kd.bos.filter.FastSearchGridView;
import kd.bos.filter.FieldPluginQFilterMapCache;
import kd.bos.filter.FilterColumn;
import kd.bos.filter.FilterContainerCache;
import kd.bos.filter.FilterContainerFilterValues;
import kd.bos.filter.FilterControlHelper;
import kd.bos.filter.FilterGridView;
import kd.bos.filter.FilterSchemeService;
import kd.bos.filter.FilterSchemeUIProxy;
import kd.bos.filter.FlexPropSchemeFilterColumn;
import kd.bos.filter.IFilterControlCache;
import kd.bos.filter.ListBillParameterLoader;
import kd.bos.filter.ListSysPublicParameter;
import kd.bos.filter.PinnedConditionCollection;
import kd.bos.filter.SchemeCodeType;
import kd.bos.filter.SchemeFilterColumn;
import kd.bos.filter.SchemeFilterView;
import kd.bos.filter.events.CloseQueryByOrEvent;
import kd.bos.filter.events.CloseQueryByOrListener;
import kd.bos.filter.events.ExpandEvent;
import kd.bos.filter.events.ExpandListener;
import kd.bos.filter.events.SetFilterContainerBaseDataSearchClosedEvent;
import kd.bos.filter.events.SetFilterContainerBaseDataSearchClosedListener;
import kd.bos.filter.events.SetFilterContainerFlatEvent;
import kd.bos.filter.events.SetFilterContainerFlatListener;
import kd.bos.filter.helper.BaseDataSearchHelper;
import kd.bos.filter.helper.QueryLookUpdataParameter;
import kd.bos.filter.model.NlpAnalysisHttpRequest;
import kd.bos.filter.model.NlpAnalysisHttpResponse;
import kd.bos.form.BindingContext;
import kd.bos.form.ClientControlTypes;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ControlTypes;
import kd.bos.form.CoreLicenseServiceFacade;
import kd.bos.form.FilterF7Helper;
import kd.bos.form.FormConfig;
import kd.bos.form.FormMetadataCache;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.ICloseCallBack;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageProxy;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.container.Container;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.AfterSearchClickListener;
import kd.bos.form.control.events.BaseDataColumnDependFieldSetEvent;
import kd.bos.form.control.events.BaseDataColumnDependFieldSetListener;
import kd.bos.form.control.events.FilterContainerInitEvent;
import kd.bos.form.control.events.FilterContainerInitListener;
import kd.bos.form.control.events.SearchClickEvent;
import kd.bos.form.control.events.SearchClickListener;
import kd.bos.form.control.events.SwitchModeListener;
import kd.bos.form.control.events.filter.SchemeValidateListener;
import kd.bos.form.events.AfterBindDataEvent;
import kd.bos.form.events.AfterBindDataListener;
import kd.bos.form.events.BeforeBindDataEvent;
import kd.bos.form.events.BeforeBindDataListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.FilterContainerSearchClickArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeFilterF7SelectListener;
import kd.bos.form.plugin.FormViewPluginProxy;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.form.plugin.IListColumnsSetting;
import kd.bos.form.plugin.IListSortSetting;
import kd.bos.list.BillList;
import kd.bos.list.ControlContext;
import kd.bos.list.FilterControlContext;
import kd.bos.list.IListView;
import kd.bos.list.IMobileListView;
import kd.bos.list.ITemplateControl;
import kd.bos.list.LinkQueryPkIdCollection;
import kd.bos.list.ListCache;
import kd.bos.list.ListShowParameter;
import kd.bos.list.SelectedRowCondition;
import kd.bos.list.ViewCommonUtil;
import kd.bos.list.plugin.ListViewPluginProxy;
import kd.bos.list.query.SchemeQuery;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.ORMException;
import kd.bos.orm.query.QFilter;
import kd.bos.script.annotations.KSMethod;
import kd.bos.service.IUserService;
import kd.bos.service.KDDateUtils;
import kd.bos.session.SystemPropertyUtils;
import kd.bos.util.CollectionUtils;
import kd.bos.xdb.ExceedShardingQueryLimit;
import kd.bos.xdb.mservice.ShardingMetadataServiceImpl;
import kd.sdk.annotation.SdkInternal;
import kd.sdk.annotation.SdkPublic;
import org.jetbrains.annotations.NotNull;

@SdkPublic
public class FilterContainer
extends Container
implements ITemplateControl,
ICloseCallBack,
IFilterControlCache {
    private static final String VALUE2 = "value";
    private static final Log log = LogFactory.getLog(FilterContainer.class);
    private static final String FASTFILTER_ALL_KEY = "quanbu_id_6ab82085_7ef3_4a6d_9ad9_b02e54bfb06f";
    private String filterModelClassName = "kd.bos.mvc.list.ListFilterModel";
    private IFilterModel filterModel;
    private MainEntityType entityType;
    private ListCache listCache = null;
    private FilterContainerCache filterContainerCache = null;
    private boolean defCollapse = true;
    private DateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private static final String BOSFORMCORE = "bos-form-core";
    private static final String FASTFILTER = "fastfilter";
    private static final String CUSTOMFILTER = "customfilter";
    private static final String SCHEMEFILTER = "schemefilter";
    private static final String FIEIDNAME = "FieldName";
    private static final String VALUE = "Value";
    private static final String SCHEME = "scheme";
    private static final String ADVANCE = "advance";
    private static final String MAINFILTERCONTENT = "mainFilterContent";
    private static final String ARCHIVEKEY = "archiveKey";
    private static final String TRIGGERSEARCH = "triggerSearch";
    private static final String SCHEMEID = "schemeId";
    private Object mainFilterContent = null;
    private boolean mainFilterFlag = false;
    private Object mainFilter;
    private boolean againLinkSearch = false;
    private static final String REF_BILL_CALLBACK_PREFIX = "RefBill";
    private CompareTypeConfig compareTypeConfig;
    private String linkQueryDescription;
    private LinkQueryPkIdCollection linkQueryPkIdCollection;
    private List<String> searchFields = new ArrayList<String>();
    Map<String, List<Object>> searchValueMap = new HashMap<String, List<Object>>();
    private List<Consumer<SetFilterEvent>> setFilterListeners = new ArrayList<Consumer<SetFilterEvent>>();
    List<Long> selectedMainOrgIds = new ArrayList<Long>();
    private ControlContext context = null;
    private boolean quickSearchAll;
    private String schemeId;
    private int visible;
    private Tips ctlTips;
    private List<SwitchModeListener> switchModeListeners = new ArrayList<SwitchModeListener>();
    private List<SetFilterContainerBaseDataSearchClosedListener> setFilterContainerBaseDataSearchClosedListeners = new ArrayList<SetFilterContainerBaseDataSearchClosedListener>();
    private List<SetFilterContainerFlatListener> setFilterContainerFlatListeners = new ArrayList<SetFilterContainerFlatListener>();
    private List<BeforeBindDataListener> beforeBindDataListeners = new ArrayList<BeforeBindDataListener>();
    private List<AfterBindDataListener> afterBindDataListeners = new ArrayList<AfterBindDataListener>();
    private List<BeforeFilterF7SelectListener> beforeF7SelectListeners = new ArrayList<BeforeFilterF7SelectListener>();
    private List<SearchClickListener> searchClickListeners = new ArrayList<SearchClickListener>();
    private List<AfterSearchClickListener> afterSearchClickListeners = new ArrayList<AfterSearchClickListener>();
    private List<FilterContainerInitListener> filterContainerInitListeners = new ArrayList<FilterContainerInitListener>();
    private List<BaseDataColumnDependFieldSetListener> baseDataColumnDependFieldSetListeners = new ArrayList<BaseDataColumnDependFieldSetListener>();
    private List<CloseQueryByOrListener> queryByOrListeners = new ArrayList<CloseQueryByOrListener>();
    private List<ExpandListener> expandListeners = new ArrayList<ExpandListener>(10);
    private List<SchemeValidateListener> schemeValidateListeners = new ArrayList<SchemeValidateListener>(10);
    private boolean isNeedShareScheme = false;
    private LocaleString title;
    private String billFormId;
    private String entityId;
    private StringBuilder sb = new StringBuilder();
    private Boolean isOrQuery;
    Map<String, Object> userCommonFilterConfig;
    Set<FilterColumn> filterColumns = null;
    private boolean isCommonSearch = false;
    private Map<String, List<CompareType>> fieldCompareTypeMap;
    private String selectedCommomFilterFieldName = "";
    private List<Object> selectedCommomFilterFieldValues = new ArrayList<Object>();
    private boolean isSchemeValidate = true;
    private boolean isKeepSchemeId;
    private boolean isSaveScheme;

    protected ListCache getListCache() {
        if (this.listCache == null) {
            IPageCache pageCache = (IPageCache)this.getView().getService(IPageCache.class);
            this.listCache = new ListCache(pageCache, this.getKey());
        }
        return this.listCache;
    }

    @ComplexPropertyAttribute
    @Deprecated
    @SdkInternal
    public CompareTypeConfig getCompareTypeConfig() {
        return this.compareTypeConfig;
    }

    @Deprecated
    @SdkInternal
    public void setCompareTypeConfig(CompareTypeConfig compareTypeConfig) {
        this.compareTypeConfig = compareTypeConfig;
        this.fieldCompareTypeMap = null;
    }

    public String getLinkQueryDescription() {
        return this.linkQueryDescription;
    }

    public void setLinkQueryDescription(String linkQueryDescription) {
        this.linkQueryDescription = linkQueryDescription;
    }

    public LinkQueryPkIdCollection getLinkQueryPkIdCollection() {
        if (this.linkQueryPkIdCollection == null) {
            this.linkQueryPkIdCollection = this.getListCache().getLinkQueryPkIdCollection();
            this.againLinkSearch = true;
        }
        return this.linkQueryPkIdCollection;
    }

    public void putLinkQueryPkIdCollection(LinkQueryPkIdCollection linkQueryPkIdCollection) {
        this.linkQueryPkIdCollection = linkQueryPkIdCollection;
        this.getListCache().putLinkQueryPkIdCollection(linkQueryPkIdCollection);
    }

    public FilterContainerFilterValues getCachedFilterValues() {
        return this.getListCache().getCachedFilterValues();
    }

    @Override
    @SdkInternal
    public void setCachedFilterValues(FilterContainerFilterValues cachedFilterValues) {
        this.getListCache().setCachedFilterValues(cachedFilterValues);
    }

    @SdkInternal
    public List<String> getSearchFields() {
        return this.searchFields;
    }

    @SdkInternal
    public void setSearchFields(List<String> searchFields) {
        this.searchFields = searchFields;
    }

    public Map<String, List<Object>> getSearchValueMap() {
        return this.searchValueMap;
    }

    public void setSearchValueMap(Map<String, List<Object>> searchValueMap) {
        this.searchValueMap = searchValueMap;
    }

    public void addSetFilterListeners(Consumer<SetFilterEvent> setFilterListener) {
        this.setFilterListeners.add(setFilterListener);
    }

    public List<Consumer<SetFilterEvent>> getSetFilterListeners() {
        return this.setFilterListeners;
    }

    public void setSetFilterListeners(List<Consumer<SetFilterEvent>> setFilterListeners) {
        this.setFilterListeners = setFilterListeners;
    }

    @Deprecated
    @SdkInternal
    public List<Long> getSelectedMainOrgIds() {
        return this.selectedMainOrgIds;
    }

    @Deprecated
    @SdkInternal
    public void setSelectedMainOrgIds(List<Long> selectedMainOrgIds) {
        this.selectedMainOrgIds = selectedMainOrgIds;
    }

    @Deprecated
    public Map<String, Object> getSelectedValues() {
        return this.getListCache().getSelectedValues();
    }

    @SdkInternal
    public void setContext(ControlContext context) {
        this.context = context;
        this.context.setFilterControlKey(this.getKey());
    }

    @SdkInternal
    public ControlContext getContext() {
        if (this.context == null) {
            this.context = new ControlContext(new FilterControlContext());
            this.context.setFilterControlKey(this.getKey());
        }
        return this.context;
    }

    @SimplePropertyAttribute(name="QuickSearchAll")
    @SdkInternal
    public boolean isQuickSearchAll() {
        return this.quickSearchAll;
    }

    @SdkInternal
    public void setQuickSearchAll(boolean quickSearchAll) {
        this.quickSearchAll = quickSearchAll;
    }

    public String getSchemeId() {
        return this.schemeId;
    }

    @KSMethod
    public void setSchemeId(String schemeId) {
        this.schemeId = schemeId;
    }

    @SimplePropertyAttribute
    @SdkInternal
    public int getVisible() {
        return this.visible;
    }

    @SdkInternal
    public void setVisible(int visible) {
        this.visible = visible;
    }

    @ComplexPropertyAttribute
    @SdkInternal
    public Tips getCtlTips() {
        return this.ctlTips;
    }

    @SdkInternal
    public void setCtlTips(Tips ctlTips) {
        this.ctlTips = ctlTips;
    }

    @KSMethod
    @SimplePropertyAttribute(name="DefCollapse")
    @DefaultValueAttribute(value="true")
    @SdkInternal
    public boolean isDefCollapse() {
        return this.defCollapse;
    }

    @KSMethod
    @SdkInternal
    public void setDefCollapse(boolean defCollapse) {
        this.defCollapse = defCollapse;
    }

    public void addSwitchModeListener(SwitchModeListener listener) {
        this.switchModeListeners.add(listener);
    }

    public void addSetFilterContainerBaseDataSearchClosedListener(SetFilterContainerBaseDataSearchClosedListener listener) {
        this.setFilterContainerBaseDataSearchClosedListeners.add(listener);
    }

    @Deprecated
    @SdkInternal
    public void addSetFilterContainerFlatListener(SetFilterContainerFlatListener listener) {
        this.setFilterContainerFlatListeners.add(listener);
    }

    public void addBeforeBindDataListener(BeforeBindDataListener listener) {
        this.beforeBindDataListeners.add(listener);
    }

    public void addAfterBindDataListener(AfterBindDataListener listener) {
        this.afterBindDataListeners.add(listener);
    }

    public void addBeforeF7SelectListener(BeforeFilterF7SelectListener listener) {
        this.beforeF7SelectListeners.add(listener);
    }

    public void addSearchClickListener(SearchClickListener listener) {
        this.searchClickListeners.add(listener);
    }

    public void addAfterSearchClickListener(AfterSearchClickListener listener) {
        this.afterSearchClickListeners.add(listener);
    }

    public void addFilterContainerInitListener(FilterContainerInitListener listener) {
        this.filterContainerInitListeners.add(listener);
    }

    public void addBaseDataColumnDependFieldSetListener(BaseDataColumnDependFieldSetListener listener) {
        this.baseDataColumnDependFieldSetListeners.add(listener);
    }

    public void addQueryByOrListener(CloseQueryByOrListener listener) {
        this.queryByOrListeners.add(listener);
    }

    public void addExpandListener(ExpandListener listener) {
        this.expandListeners.add(listener);
    }

    public void addSchemeValidateListener(SchemeValidateListener schemeValidateListener) {
        this.schemeValidateListeners.add(schemeValidateListener);
    }

    public boolean isNeedShareScheme() {
        return this.isNeedShareScheme;
    }

    public void setNeedShareScheme(boolean isNeedShareScheme) {
        this.isNeedShareScheme = isNeedShareScheme;
    }

    @SimplePropertyAttribute
    public LocaleString getTitle() {
        return this.title;
    }

    public void setTitle(LocaleString title) {
        this.title = title;
    }

    public void setBillFormId(String billFormId) {
        this.billFormId = billFormId;
        this.entityType = null;
        this.filterModel = null;
    }

    public String getBillFormId() {
        return this.billFormId;
    }

    public String getFilterModelClassName() {
        return this.filterModelClassName;
    }

    public void setFilterModelClassName(String filterModelClassName) {
        this.filterModelClassName = filterModelClassName;
    }

    public void setEntityId(String entityId) {
        this.entityId = entityId;
    }

    public String getEntityId() {
        return this.entityId;
    }

    public MainEntityType getEntityType() {
        if (StringUtils.isNotBlank((CharSequence)this.billFormId) && StringUtils.isBlank((CharSequence)this.entityId)) {
            this.entityId = FormMetadataCache.getFormConfig((String)this.billFormId).getEntityTypeId();
        }
        if (StringUtils.isBlank((CharSequence)this.getEntityId())) {
            throw new KDException(BosErrorCode.metaNotFound, new Object[]{String.format(ResManager.loadKDString((String)"%s\u5b9e\u4f53\u6807\u8bc6\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"FilterContainer_0", (String)BOSFORMCORE, (Object[])new Object[0]), this.getKey())});
        }
        if (this.entityType == null) {
            this.entityType = EntityMetadataCache.getDataEntityType((String)this.entityId);
        }
        if (this.entityType == null) {
            throw new KDException(BosErrorCode.metaNotFound, new Object[]{String.format(ResManager.loadKDString((String)"%s\u5b9e\u4f53\u5143\u6570\u636e\u4e0d\u5b58\u5728\u3002", (String)"FilterContainer_1", (String)BOSFORMCORE, (Object[])new Object[0]), this.entityId)});
        }
        return this.entityType;
    }

    public void setEntityType(MainEntityType entityType) {
        this.entityType = entityType;
    }

    private String getEntryEntity() {
        if (StringUtils.isNotBlank((CharSequence)this.getContext().getEntryEntity())) {
            return this.getContext().getEntryEntity();
        }
        String entryEntity = this.getListCache().getBillEntryEntity();
        if (StringUtils.isNotBlank((CharSequence)entryEntity)) {
            return entryEntity;
        }
        return this.getFirstEntryEntity(this.getFixedEntryEntityDtos(), this.getEntityType(), this.getContext().getBillListEntityId());
    }

    @SdkInternal
    public Map<String, Object> createClientConfig() {
        Map map = super.createClientConfig();
        map.put("type", ClientControlTypes.ListQueryPanel);
        if (this.isInvisible()) {
            map.put("vi", 0);
        } else {
            map.put("vi", this.getVisible());
        }
        if (this.getCtlTips() != null) {
            map.put("tips", this.getCtlTips());
        }
        if (!this.isDefCollapse()) {
            map.put("defaultCollapse", this.isDefCollapse());
        }
        SetFilterContainerBaseDataSearchClosedEvent setFilterContainerBaseDataSearchClosedEvent = new SetFilterContainerBaseDataSearchClosedEvent((Object)this);
        for (SetFilterContainerBaseDataSearchClosedListener searchClosedListener : this.setFilterContainerBaseDataSearchClosedListeners) {
            searchClosedListener.setFilterContainerBaseDataSearchClosed(setFilterContainerBaseDataSearchClosedEvent);
        }
        Collection fieldNames = setFilterContainerBaseDataSearchClosedEvent.getFieldNames();
        if (!fieldNames.isEmpty()) {
            map.put("closeBaseDataFieldsSearch", fieldNames);
        }
        this.collectFilterMode(map);
        if (this.isNeedShareScheme && FilterSchemeUIProxy.isNeedShareScheme()) {
            map.put("isNeedShareScheme", true);
        }
        Map enableF7SchemeMap = (Map)ListSysPublicParameter.loadCustom("enableF7Scheme");
        if (this.getView() instanceof IListView && this.isLookUp() && FilterSchemeUIProxy.isNeedShareScheme() && (enableF7SchemeMap == null || !"0".equals(enableF7SchemeMap.getOrDefault("enableF7Scheme", "1")))) {
            Object enableForScheme = ListBillParameterLoader.load(this.getEntityName(), "enablescheme");
            map.put("enablescheme", enableForScheme == null ? Boolean.valueOf(true) : enableForScheme);
        }
        Object listtriggersearch = ListSysPublicParameter.option("listtriggersearch");
        if (this.getView() instanceof IListView && listtriggersearch != null && listtriggersearch.equals("0")) {
            map.put("triggersearch", false);
        }
        return map;
    }

    private void collectFilterMode(Map<String, Object> map) {
        if (!(this.getView() instanceof IListView)) {
            return;
        }
        SetFilterContainerFlatEvent setFilterContainerFlatEvent = new SetFilterContainerFlatEvent((Object)this);
        FilterGridView filterGridView = this.getFilterGridView();
        if (filterGridView == null) {
            filterGridView = new FilterGridView();
        }
        Object gnewfilter = ListSysPublicParameter.option("gnewfilter");
        Optional<Integer> filterMode = this.getListCache().getFilterMode();
        boolean isDesignNewFilter = filterGridView != null && filterGridView.isNewFilter() || gnewfilter != null && Boolean.TRUE.equals(gnewfilter);
        this.getListCache().setDesignNewFilter(isDesignNewFilter);
        if (filterGridView != null) {
            filterGridView.setDesignerNewFilter(isDesignNewFilter);
        }
        boolean isnewfilter = filterMode.isPresent() ? filterMode.get() == 1 : isDesignNewFilter;
        Optional<Boolean> newFilter = this.getListCache().isNewFilter();
        if (!newFilter.isPresent()) {
            for (SetFilterContainerFlatListener setFilterContainerFlatListener : this.setFilterContainerFlatListeners) {
                setFilterContainerFlatListener.setFilterContainerFlat(setFilterContainerFlatEvent);
            }
            if (!setFilterContainerFlatEvent.isNewFilter()) {
                this.getListCache().setNewFilter(false);
                map.put("newfilter", false);
            }
        } else {
            map.put("newfilter", false);
        }
        map.put("switchfiltermode", isnewfilter ? 1 : 0);
    }

    @SdkInternal
    public void switchFilterMode(int filterMode, String filterView, String schemeId) {
        FilterContainerFilterValues cachedFilterValues = this.getCachedFilterValues();
        if (filterMode == 0) {
            this.getListCache().setSchemeId("");
        }
        this.getListCache().setFilterMode(filterMode);
        if (SCHEME.equals(filterView) && schemeId.isEmpty()) {
            this.setCachedFilterValues(new FilterContainerFilterValues());
        } else {
            String entryEntity = cachedFilterValues.getEntryEntity();
            this.clearSelection();
            this.setMetadata();
            this.initFilterGridView();
            this.pluginInit();
            FilterControlHelper filterControlHelper = this.createFilterControlHelper();
            filterControlHelper.setSwitchModeListeners(this.switchModeListeners);
            this.cacheAndFilter(null);
            if ("common".equals(filterView)) {
                this.isCommonSearch = true;
                filterControlHelper.parseFilterValues(this.buildDefaultFilter(entryEntity), entryEntity, null);
            } else {
                FilterScheme currentScheme = this.getFilterModel().getScheme(schemeId);
                if (currentScheme != null) {
                    this.setSchemeId(currentScheme);
                    Map<String, List<Map<String, List<Object>>>> filterValues = this.buildSchemeFilterValues(null, (List)SerializationUtils.deSerializeFromBase64((String)currentScheme.getScheme()), currentScheme.getEntryEntity());
                    filterControlHelper.parseFilterValues(filterValues, entryEntity, null);
                }
            }
            this.savePageCache();
            this.renderControl(this.getFixedEntryEntityDtos());
        }
    }

    private void setSchemeId(FilterScheme scheme) {
        if (scheme != null && !scheme.isFixed() && (scheme.isShare() || scheme.getUserId() == RequestContext.get().getCurrUserId())) {
            this.getListCache().setSchemeId(scheme.getId());
        } else {
            this.getListCache().setSchemeId("");
        }
    }

    private FilterGridView getFilterGridView() {
        for (Control item : this.getItems()) {
            if (!(item instanceof FilterGridView)) continue;
            return (FilterGridView)item;
        }
        return null;
    }

    public void setPinnedCondition(PinnedConditionCollection pinnedConditionCollection) {
        this.clientViewProxy.invokeControlMethod(this.getKey(), "setPinnedCondition", new Object[]{pinnedConditionCollection.createClientData()});
    }

    private Map<String, List<Map<String, List<Object>>>> buildCommonFilterValues(List<Map<String, List<Object>>> fastFilter, List<Map<String, List<Object>>> filter, String entryEntity) {
        HashMap<String, List<Map<String, List<Object>>>> filterValues = new HashMap<String, List<Map<String, List<Object>>>>();
        filterValues.put(FASTFILTER, fastFilter);
        filterValues.put(CUSTOMFILTER, filter);
        this.createFilterControlHelper().cacheFilterValues(fastFilter, filter, entryEntity);
        return filterValues;
    }

    private Map<String, List<Map<String, List<Object>>>> buildDefaultFilter(String entryEntity) {
        List<Map<String, List<Object>>> fasetFilterValues = new ArrayList<Map<String, List<Object>>>(10);
        List<Map<String, List<Object>>> filterValues = new ArrayList<Map<String, List<Object>>>(10);
        for (Control item : this.getItems()) {
            if (item instanceof FastSearchGridView) {
                fasetFilterValues = ((FastSearchGridView)item).getDefaultFilterValues();
                this.setFastSearchValueMap(fasetFilterValues);
                continue;
            }
            if (!(item instanceof FilterGridView)) continue;
            this.setFilterMode(item);
            filterValues = ((FilterGridView)item).getDefaultFilterValues();
        }
        return this.buildCommonFilterValues(fasetFilterValues, filterValues, entryEntity);
    }

    private String getCompareTypeId(CommonFilterColumn commonFilterColumn) {
        if (commonFilterColumn.getDefaultValues().isEmpty()) {
            return null;
        }
        List<Map<String, Object>> clientItems = commonFilterColumn.getClientItems();
        for (Object defaultValue : commonFilterColumn.getDefaultValues()) {
            for (Map<String, Object> clientItem : clientItems) {
                if (!defaultValue.toString().equals(clientItem.get(VALUE2).toString()) || clientItem.get("compare") == null) continue;
                return clientItem.get("compare").toString();
            }
        }
        return null;
    }

    private boolean isDefaultFilterColumn(CommonFilterColumn commonFilterColumn, FilterColumn schemeFilterColumn, Predicate<CommonFilterColumn> predicate) {
        CustomBaseDataSchemeFilterColumn filterColumn;
        boolean isFieldNameEqual = commonFilterColumn.getFieldName().equals(schemeFilterColumn.getFieldName());
        if (schemeFilterColumn instanceof CustomBaseDataSchemeFilterColumn && (filterColumn = (CustomBaseDataSchemeFilterColumn)schemeFilterColumn).isFieldNameEmpty()) {
            isFieldNameEqual = commonFilterColumn.getFieldName().equals(schemeFilterColumn.getKey());
        }
        return (predicate == null || predicate.test(commonFilterColumn)) && isFieldNameEqual;
    }

    private void convertDefaultValues(CommonFilterColumn commonFilterColumn, SchemeFilterColumn schemeFilterColumn) {
        if (commonFilterColumn.isBaseDataProp()) {
            ArrayList<Object> defaultValues = new ArrayList<Object>();
            ArrayList<String> ids = new ArrayList<String>();
            for (ComboItem comboItem : commonFilterColumn.getComboItems()) {
                if (!StringUtils.isNotBlank((CharSequence)comboItem.getValue()) || !commonFilterColumn.getDefaultValues().contains(comboItem.getValue())) continue;
                ids.add(comboItem.getValue());
            }
            if (!ids.isEmpty()) {
                IDataEntityProperty latestParent = commonFilterColumn.getLatestParent();
                IBasedataField prop = (IBasedataField)latestParent;
                DynamicObjectType dynamicComplexPropertyType = (DynamicObjectType)prop.getComplexType();
                List rpkList = TypeChange.getRealPkList((DynamicObjectType)dynamicComplexPropertyType, ids);
                Map dataMap = this.getModel().loadReferenceDataBatch(dynamicComplexPropertyType, rpkList.toArray());
                for (Map.Entry data : dataMap.entrySet()) {
                    Object defaultValueObj;
                    IDataEntityProperty refProp = schemeFilterColumn.getFilterField().getFieldProp();
                    if (refProp instanceof MuliLangTextProp) {
                        defaultValues.add(((DynamicObject)data.getValue()).getString(refProp.getName()));
                        continue;
                    }
                    if (refProp instanceof PKFieldProp && StringUtils.isNotBlank((CharSequence)((IBasedataField)latestParent).getDisplayProp())) {
                        String displayProp = ((IBasedataField)latestParent).getDisplayProp();
                        MainEntityType complexType = (MainEntityType)((IBasedataField)latestParent).getComplexType();
                        refProp = complexType.findProperty(displayProp);
                    }
                    defaultValues.add((defaultValueObj = ((DynamicObject)data.getValue()).get(refProp)) == null ? "" : defaultValueObj.toString());
                }
            }
            schemeFilterColumn.setIdValues(ids.stream().map(Object::toString).collect(Collectors.toList()));
            schemeFilterColumn.setDefaultValues(defaultValues);
        } else {
            schemeFilterColumn.setDefaultValues(commonFilterColumn.getDefaultValues());
        }
    }

    private void initDefaultValues(CommonFilterColumn commonFilterColumn, SchemeFilterColumn schemeFilterColumn) {
        String defaultCompareTypeId = this.getCompareTypeId(commonFilterColumn);
        if (defaultCompareTypeId != null) {
            schemeFilterColumn.setDefaultCompareType(defaultCompareTypeId);
        } else {
            IFieldHandle fieldProp = (IFieldHandle)schemeFilterColumn.getFilterField().getSrcFieldProp();
            if (commonFilterColumn.getDefaultValues().size() > 1) {
                schemeFilterColumn.setDefaultCompareType(fieldProp.getDefaultMultiCompareTypeId());
            } else if ("id".equals(schemeFilterColumn.getFilterField().getFieldProp().getName())) {
                schemeFilterColumn.setDefaultCompareType((String)((IFieldHandle)schemeFilterColumn.getFilterField().getLatestParent()).getPkPropCompareTypeIds().get(0));
            } else {
                schemeFilterColumn.setDefaultCompareType(fieldProp.getDefaultCompareTypeId());
            }
            this.convertDefaultValues(commonFilterColumn, schemeFilterColumn);
        }
    }

    private List<String> getFixedFilters(List<FilterColumn> commonFilterColumns, List<FilterColumn> schemeFilterColumns) {
        Map<String, Object> myuserSchemeFilterConfig = this.getMyuserSchemeFilterConfig();
        if (myuserSchemeFilterConfig != null && !myuserSchemeFilterConfig.isEmpty()) {
            ArrayList<String> fixFilters = new ArrayList<String>(myuserSchemeFilterConfig.size());
            List rows = (List)myuserSchemeFilterConfig.get("rows");
            for (Map row : rows) {
                Object vi = row.get("v");
                Object k = row.get("k");
                if (k == null || vi == null || Integer.parseInt(vi.toString()) != 1) continue;
                fixFilters.add(k.toString());
            }
            return fixFilters;
        }
        return this.getInitFixFilters(commonFilterColumns, schemeFilterColumns);
    }

    @NotNull
    private List<String> getInitFixFilters(List<FilterColumn> commonFilterColumns, List<FilterColumn> schemeFilterColumns) {
        if (schemeFilterColumns.isEmpty() || commonFilterColumns.isEmpty()) {
            return new ArrayList<String>(0);
        }
        ArrayList<String> fixFilters = new ArrayList<String>(schemeFilterColumns.size());
        for (FilterColumn schemeFilterColumn : schemeFilterColumns) {
            for (FilterColumn filterColumn : commonFilterColumns) {
                CommonFilterColumn commonFilterColumn = (CommonFilterColumn)filterColumn;
                if (!this.isDefaultFilterColumn(commonFilterColumn, schemeFilterColumn, null)) continue;
                fixFilters.add(schemeFilterColumn.getFilterFieldName());
            }
        }
        return fixFilters;
    }

    private List<FilterColumn> getDefaultSchemeFilterColumns(List<FilterColumn> commonFilterColumns, List<FilterColumn> schemeFilterColumns) {
        ArrayList<FilterColumn> defaultSchemeFilterColumns = new ArrayList<FilterColumn>();
        if (schemeFilterColumns.isEmpty() || commonFilterColumns.isEmpty()) {
            return defaultSchemeFilterColumns;
        }
        for (FilterColumn schemeFilterColumn : schemeFilterColumns) {
            for (FilterColumn filterColumn : commonFilterColumns) {
                CommonFilterColumn commonFilterColumn = (CommonFilterColumn)filterColumn;
                if (!this.isDefaultFilterColumn(commonFilterColumn, schemeFilterColumn, CommonFilterColumn::isMustInput)) continue;
                this.initDefaultValues(commonFilterColumn, (SchemeFilterColumn)schemeFilterColumn);
                defaultSchemeFilterColumns.add(schemeFilterColumn);
            }
        }
        return defaultSchemeFilterColumns;
    }

    @Deprecated
    @KSMethod
    @SdkInternal
    public void addSearchClickListener(String billListId) {
        BillList list = (BillList)this.getView().getControl(billListId);
        if (list == null) {
            return;
        }
        list.setContext(this.getContext());
        this.addSearchClickListener(searchClickEvent -> {
            this.createFilterControlHelper().buildContext(searchClickEvent.getFilterValues(), false);
            FilterContainerSearchClickArgs filterContainerSearchClickArgs = new FilterContainerSearchClickArgs(searchClickEvent);
            FormViewPluginProxy formViewPluginProxy = (FormViewPluginProxy)this.getView().getService(FormViewPluginProxy.class);
            if (formViewPluginProxy instanceof ListViewPluginProxy) {
                ((ListViewPluginProxy)formViewPluginProxy).fireFilterContainerSearchClick(filterContainerSearchClickArgs);
            }
            searchClickEvent.setFilterParameter(null);
            if (this.getView() instanceof IListView) {
                IListView listView = (IListView)this.getView();
                listView.setSelectedMainOrgIds(this.filterModel.getSelectedMainOrgIds());
            }
            list.bindData(new BindingContext(searchClickEvent.getSource(), 0));
        });
    }

    private List<Map<String, List<Object>>> getDefaultFastFilterValues() {
        ArrayList<Map<String, List<Object>>> defaultFastFilterValues;
        List<FilterColumn> fastFilterColumns = new ArrayList<FilterColumn>();
        for (Control item : this.getItems()) {
            if (!(item instanceof FastSearchGridView)) continue;
            fastFilterColumns = ((FastSearchGridView)item).getFilterColumns();
        }
        if (this.isQuickSearchAll() && this.searchValueMap.containsKey(FASTFILTER_ALL_KEY) || this.getSearchFields().isEmpty()) {
            defaultFastFilterValues = new ArrayList();
            ArrayList<Object> defValues = new ArrayList();
            if (this.searchValueMap.get(FASTFILTER_ALL_KEY) != null) {
                defValues = this.searchValueMap.get(FASTFILTER_ALL_KEY);
            }
            if (!defValues.isEmpty()) {
                ArrayList<Object> fieldNames = new ArrayList<Object>(10);
                for (FilterColumn filterColumn : fastFilterColumns) {
                    fieldNames.add(filterColumn.getFilterField().getFieldName());
                }
                this.initDefaultFastFilterValues(defaultFastFilterValues, fieldNames, defValues);
            }
        } else {
            defaultFastFilterValues = AbstractFilterGridView.getFilterValues(fastFilterColumns, this.getEntityType());
            this.setFastSearchValueMap(defaultFastFilterValues);
        }
        return defaultFastFilterValues;
    }

    private void buildSmartFilterContent() {
        if (this.searchValueMap.containsKey(MAINFILTERCONTENT)) {
            this.mainFilterFlag = true;
            this.mainFilterContent = this.searchValueMap.get(MAINFILTERCONTENT);
            List<Object> mainFilters = this.searchValueMap.get("mainFilters");
            if (String.valueOf(mainFilters) != null) {
                NlpAnalysisHttpResponse response = (NlpAnalysisHttpResponse)SerializationUtils.fromJsonString((String)String.valueOf(mainFilters), NlpAnalysisHttpResponse.class);
                List filter = response.getData().getFilter();
                Map<String, FilterColumn> columnMap = this.getColumnName();
                filter.forEach(filterBean -> {
                    List valueList = filterBean.getValue();
                    String fieldName = filterBean.getField();
                    FilterColumn filterColumn = (FilterColumn)((Object)((Object)columnMap.get(fieldName)));
                    List convertList = valueList.stream().map(word -> this.convertDescToCompare((String)word, filterColumn)).collect(Collectors.toList());
                    filterBean.setValue(convertList);
                });
                this.mainFilter = response.getData();
            }
        }
    }

    private void initDefaultFastFilterValues(List<Map<String, List<Object>>> defaultFastFilterValues, List<Object> fieldNames, List<Object> defValues) {
        HashMap<String, List<Object>> filter = new HashMap<String, List<Object>>();
        ArrayList compares = new ArrayList();
        filter.put(FIEIDNAME, fieldNames);
        filter.put("Compare", compares);
        filter.put(VALUE, defValues);
        defaultFastFilterValues.add(filter);
    }

    private void setFastSearchValueMap(List<Map<String, List<Object>>> defaultFastFilterValues) {
        for (Map<String, List<Object>> map : defaultFastFilterValues) {
            this.searchValueMap.put(map.get(FIEIDNAME).get(0).toString(), map.get(VALUE));
        }
    }

    private String getIsOrQueryKey() {
        return "ioq";
    }

    private void cacheIsOrQuery(boolean isOrQuery) {
        IPageCache pageCache = (IPageCache)this.getView().getService(IPageCache.class);
        pageCache.put(this.getIsOrQueryKey(), Boolean.toString(isOrQuery));
        this.isOrQuery = isOrQuery;
    }

    private boolean isOrQuery() {
        if (this.isOrQuery != null) {
            return this.isOrQuery;
        }
        IPageCache pageCache = (IPageCache)this.getView().getService(IPageCache.class);
        String isOrQueryStr = pageCache.get(this.getIsOrQueryKey());
        if (isOrQueryStr != null) {
            boolean isOrQuery = Boolean.parseBoolean(isOrQueryStr);
            this.isOrQuery = isOrQuery;
            return isOrQuery;
        }
        this.isOrQuery = false;
        return false;
    }

    boolean isLookUp() {
        return this.context != null ? this.context.isLookup() : false;
    }

    public void bindData(BindingContext bctx) {
        BeforeBindDataEvent beforeBindDataEvent = new BeforeBindDataEvent((Object)this);
        for (BeforeBindDataListener beforeBindDataListener : this.beforeBindDataListeners) {
            beforeBindDataListener.beforeBindData(beforeBindDataEvent);
        }
        this.setMetadata();
        this.initContextControlFilters();
        this.getContext().setInitDefaultValues(this.getLinkQueryPkIdCollection().isEmpty());
        this.isOrQuery = this.initQueryBy();
        this.initFilterGridView();
        this.pluginInit();
        List<EntryEntityDto> fixedEntryEntityDtos = this.getFixedEntryEntityDtos();
        String metStr = "FilterContainer.bindData log:";
        if (this.entityType == null) {
            metStr = metStr + " entityType is null. ";
        }
        if (StringUtils.isNotBlank((CharSequence)this.billFormId)) {
            metStr = metStr + " billFormId = " + this.billFormId + ", entityid = " + FormMetadataCache.getFormConfig((String)this.billFormId).getEntityTypeId();
        } else if (StringUtils.isNotBlank((CharSequence)this.entityId)) {
            metStr = metStr + " billFormId is null , entityid = " + this.entityId;
        }
        MainEntityType met = this.getEntityType();
        metStr = metStr + String.format(".  getEntityType: formid=%s, entityid=%s, propnames=%s", this.billFormId, this.entityId, met.getProperties().toString());
        String billListEntityId = this.getBillListEntityId();
        ShardingMetadataServiceImpl shardingMetadataService = new ShardingMetadataServiceImpl();
        if (this.isOrQuery.booleanValue() && shardingMetadataService.isXDBEnableByEntity(billListEntityId)) {
            this.isOrQuery = false;
        }
        this.cacheIsOrQuery(this.isOrQuery);
        String firstEntryEntity = this.getFirstEntryEntity(fixedEntryEntityDtos, met, billListEntityId);
        IFilterModel schemeFilterModel = this.getFilterModel();
        schemeFilterModel.setFormId(this.getBillFormId() == null ? this.getEntityId() : this.getBillFormId());
        ArrayList<FilterScheme> allSchemeList = new ArrayList<FilterScheme>();
        List filterSchemes = new ArrayList();
        List sharedSchemeList = new ArrayList();
        if (this.isLookUp()) {
            boolean isEnableForScheme = true;
            Object enableForScheme = ListBillParameterLoader.load(this.getEntityName(), "enablescheme");
            if (enableForScheme != null) {
                isEnableForScheme = Boolean.parseBoolean(enableForScheme.toString());
            }
            if (isEnableForScheme) {
                filterSchemes = schemeFilterModel.getF7SchemeList();
                sharedSchemeList = schemeFilterModel.getF7SharedSchemeList();
            }
        } else if (!this.isLookUp()) {
            filterSchemes = schemeFilterModel.getSchemeList();
            sharedSchemeList = schemeFilterModel.getSharedSchemeList();
        }
        List idList = sharedSchemeList.stream().map(scheme -> scheme.getId()).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(idList)) {
            Map map = this.filterModel.getShareSchemeByIdList(idList, Long.valueOf(RequestContext.get().getCurrUserId()));
            for (FilterScheme scheme2 : sharedSchemeList) {
                if (map.containsKey(scheme2.getId()) && "1".equals(map.get(scheme2.getId()))) {
                    scheme2.setDefault(true);
                    continue;
                }
                scheme2.setDefault(false);
            }
        }
        allSchemeList.addAll(filterSchemes);
        allSchemeList.addAll(sharedSchemeList);
        if (StringUtils.isBlank((CharSequence)this.getContext().getEntryEntity())) {
            this.getContext().setEntryEntity(firstEntryEntity);
        } else {
            String entryEntity = this.getContext().getEntryEntity();
            for (EntryEntityDto entryEntityDto : fixedEntryEntityDtos) {
                if (!entryEntity.equals(entryEntityDto.getKey())) continue;
                firstEntryEntity = entryEntity;
                this.getContext().setEntryEntity(firstEntryEntity);
                break;
            }
        }
        if (!this.getLinkQueryPkIdCollection().isEmpty()) {
            FilterContainerFilterValues cachedFilterValues = new FilterContainerFilterValues(new ArrayList(), CUSTOMFILTER, new ArrayList(), firstEntryEntity);
            this.setCachedFilterValues(cachedFilterValues);
            this.getContext().setFastQueryFilterParameter(new FilterParameter());
            this.getContext().setClientQueryFilterParameter(new FilterParameter(this.getLinkQueryPkIdCollection().toQFilter(), ""));
            this.getContext().setMainOrgNoLimit(true);
            this.selectedMainOrgIds = new ArrayList<Long>();
            this.renderControl(fixedEntryEntityDtos);
            FilterSchemeService.initFilterSchemesToDefaultToFalse(allSchemeList);
        } else {
            try {
                this.loadDefaultFilters(allSchemeList, fixedEntryEntityDtos, firstEntryEntity);
            }
            catch (KDBizException e) {
                if (e.getErrorCode().equals((Object)BosErrorCode.variableNameNotFound)) {
                    EntityMetadataProvider provider = new EntityMetadataProvider();
                    StringBuilder errorMsg = new StringBuilder();
                    errorMsg.append(String.format("dt:name=%s, props=%s, setEntityType:%s", met.getName(), metStr, this.sb.toString())).append("entityid:").append(this.entityId).append("; redis props:").append(provider.getDataEntityType(this.entityId).getProperties().toString()).append("entityid:").append(this.entityId).append("; local props:").append(EntityMetadataCache.getDataEntityType((String)this.entityId).getProperties().toString());
                    log.error(this.fillAppid(errorMsg.toString()), (Throwable)e);
                }
                throw e;
            }
        }
        Object searchorforfast = ListBillParameterLoader.load(this.getEntityName(), "searchorforfast");
        if (searchorforfast != null && !Boolean.parseBoolean(searchorforfast.toString())) {
            IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
            HashMap<String, Object> dataMap = new HashMap<String, Object>(8);
            dataMap.put("k", this.getKey());
            dataMap.put("useOrReplaceBlank", false);
            proxy.addAction("u", dataMap);
        }
        if (this.isQuickSearchAll() && this.searchValueMap.containsKey(FASTFILTER_ALL_KEY) || this.getSearchFields().isEmpty()) {
            this.clientViewProxy.invokeControlMethod(this.getKey(), "setFastCondition", new Object[]{this.searchValueMap});
        }
        ArchiveUIProxy archiveUIProxy = new ArchiveUIProxy(this, this.getEntityType().getDBRouteKey(), this.getEntityType().getName());
        archiveUIProxy.setArchiveInfo();
        FilterSchemeUIProxy filterSchemeUIProxy = this.createFilterSchemeUIProxy();
        filterSchemeUIProxy.loadSchemeList(filterSchemes, sharedSchemeList, false, SchemeCodeType.BASE64);
        super.bindData(bctx);
        AfterBindDataEvent afterBindDataEvent = new AfterBindDataEvent((Object)this);
        for (AfterBindDataListener afterBindDataListener : this.afterBindDataListeners) {
            afterBindDataListener.afterBindData(afterBindDataEvent);
        }
        if (!this.getLinkQueryPkIdCollection().isEmpty()) {
            this.setLinkQuery();
        }
        this.requestOpenNlpSearch();
        this.savePageCache();
    }

    private String getEntityName() {
        MainEntityType mainEntityType = this.getEntityType();
        String entityName = mainEntityType instanceof QueryEntityType ? ((QueryEntityType)mainEntityType).getEntityName() : mainEntityType.getName();
        return entityName;
    }

    private boolean initQueryBy() {
        boolean queryByOr = false;
        if (this.getView() instanceof IListView && !(this.getView() instanceof IMobileListView)) {
            String orQueryMcPara = SystemPropertyUtils.getProptyByTenant((String)"orquery.enable", (String)RequestContext.get().getTenantId());
            queryByOr = StringUtils.equals((CharSequence)System.getProperty("orm.crossdb.enable"), (CharSequence)"true") || Boolean.parseBoolean(orQueryMcPara) || CoreLicenseServiceFacade.getModelType() == 4;
            CloseQueryByOrEvent setQueryByOrEvent = new CloseQueryByOrEvent((Object)this);
            setQueryByOrEvent.setQueryByOr(queryByOr);
            if (queryByOr) {
                for (CloseQueryByOrListener queryByOrListener : this.queryByOrListeners) {
                    queryByOrListener.setQueryByOr(setQueryByOrEvent);
                }
            }
            queryByOr = setQueryByOrEvent.isQueryByOr();
        }
        return queryByOr;
    }

    private String getFirstEntryEntity(List<EntryEntityDto> fixedEntryEntityDtos, MainEntityType met, String billListEntityId) {
        return ViewCommonUtil.getFirstEntryEntity(StringUtils.isBlank((CharSequence)billListEntityId) || met.getName().equals(billListEntityId) ? met.getName() : billListEntityId, fixedEntryEntityDtos);
    }

    private void initContextControlFilters() {
        if (!this.getCachedFilterValues().isEmpty()) {
            ControlFilters controlFilters = new ControlFilters(this.getCachedFilterValues().getFastFilterValues(), this.getCachedFilterValues().getOtherFilterValues());
            this.getContext().setControlFilters(controlFilters);
        }
    }

    private void requestOpenNlpSearch() {
        String entityNumber = this.getBillFormId() == null ? this.getEntityId() : this.getBillFormId();
        this.clientViewProxy.invokeControlMethod(this.getKey(), "nlpFunctionOpen", new Object[]{ViewCommonUtil.checkOpenNlp(entityNumber)});
    }

    private void loadDefaultFilters(List<FilterScheme> filterSchemes, List<EntryEntityDto> fixedEntryEntityDtos, String firstEntryEntity) {
        FilterControlHelper filterControlHelper = this.createFilterControlHelper();
        boolean isNeedCheckMainOrgs = false;
        isNeedCheckMainOrgs = !this.getCachedFilterValues().isEmpty() ? true : Boolean.parseBoolean(System.getProperty("bos.filter.isNeedCheckMainOrgs", "false"));
        Map<Object, Object> filterValues = new HashMap();
        if (!this.getCachedFilterValues().isEmpty()) {
            filterValues = this.getCachedFilterValues().createMapFilterValues();
            this.getContext().setEntryEntity(this.getCachedFilterValues().getEntryEntity());
        }
        if (filterValues.isEmpty()) {
            filterValues = this.loadSchemeList(filterSchemes, fixedEntryEntityDtos, firstEntryEntity);
            this.getListCache().setHasFlexFilter(this.checkFlexPropFieldsExists(filterValues));
        } else {
            FilterSchemeService.initFilterSchemesToDefaultToFalse(filterSchemes);
        }
        if (filterValues.isEmpty()) {
            if (!this.getContext().isLookup()) {
                filterValues = this.buildDefaultFilter(firstEntryEntity);
            }
            FilterSchemeService.initFilterSchemesToDefaultToFalse(filterSchemes);
        }
        if (!this.getContext().isLookup() || !filterValues.isEmpty()) {
            filterControlHelper.buildContext(filterValues, isNeedCheckMainOrgs);
        } else {
            filterControlHelper.buildContext(this.buildCommonFilterValues(this.getDefaultFastFilterValues(), new ArrayList<Map<String, List<Object>>>(), firstEntryEntity), isNeedCheckMainOrgs);
        }
        this.buildSmartFilterContent();
        this.renderControl(fixedEntryEntityDtos);
    }

    private void setLinkQuery() {
        HashMap<String, String> clientMeta = new HashMap<String, String>();
        String description = String.format(ResManager.loadKDString((String)"\u8054\u67e5\uff1a%s\u6761", (String)"FilterContainer_17", (String)BOSFORMCORE, (Object[])new Object[0]), this.getLinkQueryPkIdCollection().size());
        if (StringUtils.isNotBlank((CharSequence)this.getLinkQueryDescription())) {
            description = this.getLinkQueryDescription();
        }
        clientMeta.put("content", description);
        this.clientViewProxy.invokeControlMethod(this.getKey(), "setLinkQuery", new Object[]{clientMeta});
    }

    @Deprecated
    public void closeLinkQuery() {
        this.putLinkQueryPkIdCollection(new LinkQueryPkIdCollection());
        FilterContainerFilterValues cachedFilterValues = this.getCachedFilterValues();
        this.fireFilterSearchClickByCache(cachedFilterValues.createMapFilterValues(), cachedFilterValues.getEntryEntity(), null);
    }

    public void expand(boolean isExpand) {
        ExpandEvent expandEvent = new ExpandEvent((Object)this, isExpand);
        for (ExpandListener expandListener : this.expandListeners) {
            expandListener.expand(expandEvent);
        }
    }

    private List<EntryEntityDto> getFixedEntryEntityDtos() {
        String billListEntityId = this.getBillListEntityId();
        List<EntryEntityDto> entryEntityDtos = this.getEntryEntityDtos();
        ArrayList<EntryEntityDto> finalEntryEntityDtos = new ArrayList<EntryEntityDto>();
        for (EntryEntityDto entryEntityDto : entryEntityDtos) {
            if (entryEntityDto.getKey().equals(billListEntityId)) {
                finalEntryEntityDtos.add(entryEntityDto);
                continue;
            }
            if (!entryEntityDto.getParentKey().equals(billListEntityId)) continue;
            finalEntryEntityDtos.add(entryEntityDto);
            for (EntryEntityDto entryEntityDto1 : entryEntityDtos) {
                if (!entryEntityDto.getKey().equals(entryEntityDto1.getParentKey())) continue;
                finalEntryEntityDtos.add(entryEntityDto1);
            }
        }
        for (EntryEntityDto entryEntityDto : finalEntryEntityDtos) {
            if (!StringUtils.isEmpty((CharSequence)entryEntityDto.getParentKey())) continue;
            entryEntityDto.setName(new LocaleString(ResManager.loadKDString((String)"\u57fa\u672c\u4fe1\u606f", (String)"FilterContainer_2", (String)BOSFORMCORE, (Object[])new Object[0])));
            break;
        }
        return finalEntryEntityDtos;
    }

    private String getBillListEntityId() {
        return this.getContext().getBillListEntityId() != null ? this.getContext().getBillListEntityId() : this.getEntityType().getName();
    }

    private void setMetadata() {
        if (StringUtils.isBlank((CharSequence)this.billFormId)) {
            this.updateControlMeta();
            return;
        }
        Map meta = FormMetadataCache.getFilterMeta((String)this.billFormId);
        if (meta != null && meta.containsKey(FilterContainer.class.getSimpleName())) {
            String strFilterContainer = (String)meta.get(FilterContainer.class.getSimpleName());
            FilterContainer filterContainer = (FilterContainer)ControlTypes.fromJsonString((String)strFilterContainer);
            if (StringUtils.isBlank((Object)this.title)) {
                this.title = filterContainer.getTitle();
                this.getListCache().setFilterContainerTitle(this.title);
            }
            if (this.getCompareTypeConfig() == null) {
                this.setCompareTypeConfig(filterContainer.getCompareTypeConfig());
            }
            this.getContext().setFieldCompareTypeMap(this.getFieldCompareTypeMap());
            this.setVisible(filterContainer.getVisible());
            if (filterContainer.getCtlTips() != null) {
                this.setCtlTips(filterContainer.getCtlTips());
            }
            this.quickSearchAll = filterContainer.isQuickSearchAll();
            this.setDefCollapse(filterContainer.isDefCollapse());
            this.getItems().clear();
            this.getItems().addAll(filterContainer.getItems());
            this.updateControlMeta();
        }
    }

    @Deprecated
    @KSMethod
    public void setColumns(boolean isInit) {
        this.initFilterGridView();
        this.pluginInit();
        List<EntryEntityDto> fixedEntryEntityDtos = this.getFixedEntryEntityDtos();
        this.renderControl(fixedEntryEntityDtos);
    }

    @KSMethod
    public void setColumns() {
        this.initFilterGridView();
        this.pluginInit();
        List<EntryEntityDto> fixedEntryEntityDtos = this.getFixedEntryEntityDtos();
        this.renderControl(fixedEntryEntityDtos);
    }

    public void refresh() {
        this.setMetadata();
        this.initFilterGridView();
    }

    private void initFilterGridView() {
        FilterContainerFilterValues cachedFilterValues = this.getCachedFilterValues();
        if (!cachedFilterValues.isEmpty()) {
            ControlFilters controlFilters = new ControlFilters(cachedFilterValues.getFastFilterValues(), cachedFilterValues.getOtherFilterValues());
            this.getContext().setControlFilters(controlFilters);
        }
        for (Control item : this.getItems()) {
            if (!(item instanceof AbstractFilterGridView)) continue;
            AbstractFilterGridView abstractFilterGridView = (AbstractFilterGridView)item;
            if (abstractFilterGridView instanceof SchemeFilterView) {
                abstractFilterGridView.setBaseDataControl(!this.isOrQuery());
            }
            if (item instanceof FastSearchGridView && !this.searchFields.isEmpty()) {
                this.initFastSearchGridView(abstractFilterGridView);
            }
            if (item instanceof FilterGridView) {
                ((FilterGridView)abstractFilterGridView).setDesignerNewFilter(this.getListCache().isDesignerNewFilter());
                abstractFilterGridView.setBaseDataControl(true);
                this.initCommonFilterGridView(item);
            }
            this.initFilterGridViewPropeties(abstractFilterGridView);
            if (!(item instanceof FilterGridView)) continue;
            Map<String, List<QFilter>> pluginQFilterMap = ((FilterGridView)item).getPluginQFilterMap();
            FieldPluginQFilterMapCache fieldPluginQFilterMapCache = new FieldPluginQFilterMapCache((IPageCache)this.getView().getService(IPageCache.class));
            fieldPluginQFilterMapCache.cache(pluginQFilterMap);
        }
    }

    private void initFilterGridViewPropeties(AbstractFilterGridView abstractFilterGridView) {
        abstractFilterGridView.setView(this.getView());
        abstractFilterGridView.setContext(this.getContext());
        abstractFilterGridView.setEntityType(this.getEntityType());
        abstractFilterGridView.setSetFilterListeners(this.getSetFilterListeners());
        abstractFilterGridView.initProperties();
    }

    private void initCommonFilterGridView(Control item) {
        FilterGridView filterGridView = (FilterGridView)item;
        Map<String, List<DependField>> dependFieldMap = this.invokeBaseDataColumnDependFieldSetListeners();
        filterGridView.setDependFieldMap(dependFieldMap);
        filterGridView.setSelectedCommomFilterFieldName(this.selectedCommomFilterFieldName);
        filterGridView.setSelectedCommomFilterFieldValues(this.selectedCommomFilterFieldValues);
    }

    private Map<String, List<DependField>> invokeBaseDataColumnDependFieldSetListeners() {
        BaseDataColumnDependFieldSetEvent commonBaseDataColumnDependFieldSetEvent = new BaseDataColumnDependFieldSetEvent(this);
        for (BaseDataColumnDependFieldSetListener commonBaseDataColumnDependFieldSetListener : this.baseDataColumnDependFieldSetListeners) {
            commonBaseDataColumnDependFieldSetListener.dependFieldSet(commonBaseDataColumnDependFieldSetEvent);
        }
        return commonBaseDataColumnDependFieldSetEvent.getDependField();
    }

    private void initFastSearchGridView(AbstractFilterGridView abstractFilterGridView) {
        Map<String, FilterColumn> orgFilterColumns = abstractFilterGridView.getFilterColumns().stream().collect(Collectors.toMap(FilterColumn::getFieldName, item -> item));
        for (String searchField : this.searchFields) {
            FilterColumn filterColumn = orgFilterColumns.get(searchField);
            if (filterColumn == null) {
                filterColumn = new FilterColumn();
                filterColumn.setFieldName(searchField);
                abstractFilterGridView.addFilterColumn(filterColumn);
            }
            if (this.searchValueMap.get(searchField) == null) continue;
            filterColumn.setDefaultValues(this.searchValueMap.get(searchField));
        }
    }

    private void pluginInit() {
        List<FilterColumn> fastFilterColumns = new ArrayList<FilterColumn>();
        List<FilterColumn> commonFilterColumns = new ArrayList<FilterColumn>();
        List<FilterColumn> schemeFilterColumns = new ArrayList<FilterColumn>();
        FastSearchGridView fastSearchGridView = null;
        FilterGridView filterGridView = null;
        SchemeFilterView schemeFilterView = null;
        for (Object item : this.getItems()) {
            if (item instanceof FastSearchGridView) {
                fastSearchGridView = (FastSearchGridView)item;
                fastFilterColumns = ((FastSearchGridView)item).getFilterColumns();
                continue;
            }
            if (item instanceof FilterGridView) {
                filterGridView = (FilterGridView)item;
                commonFilterColumns = ((FilterGridView)item).getFilterColumns();
                continue;
            }
            if (!(item instanceof SchemeFilterView)) continue;
            schemeFilterView = (SchemeFilterView)item;
            schemeFilterColumns = ((SchemeFilterView)item).getFilterColumns();
        }
        FilterContainerInitEvent evt = new FilterContainerInitEvent(this, fastSearchGridView, filterGridView, schemeFilterView, fastFilterColumns, commonFilterColumns, schemeFilterColumns);
        for (FilterContainerInitListener filterContainerInitListener : this.filterContainerInitListeners) {
            filterContainerInitListener.filterContainerInit(evt);
        }
        for (Control item : this.getItems()) {
            if (!(item instanceof AbstractFilterGridView)) continue;
            ((AbstractFilterGridView)item).fixContext();
        }
        if (filterGridView != null) {
            if (this.isCommonSearch && !this.getContext().getControlFiltersMap().isEmpty()) {
                LinkedHashSet<FilterColumn> filterColumnsSet = new LinkedHashSet<FilterColumn>(16);
                for (FilterColumn filterColumn : commonFilterColumns) {
                    filterColumnsSet.add(filterColumn);
                }
                Map<String, List<Object>> commonFilters = filterGridView.getCommonFilters(filterColumnsSet, this.getContext().getControlFiltersMap());
                filterGridView.setCommonFilters(commonFilters);
            } else {
                Map<String, List<Object>> commonFilters = filterGridView.getCommonFilters();
                for (FilterColumn filterColumn : commonFilterColumns) {
                    if (filterColumn.getDefaultValues().isEmpty() || commonFilters.containsKey(filterColumn.getFilterFieldName())) continue;
                    commonFilters.put(filterColumn.getFieldName(), filterColumn.getDefaultValues());
                }
            }
            filterGridView.initDependFilterColumns(commonFilterColumns);
        }
    }

    private void fullfillClientMeta(Map<String, Object> clientMeta) {
        ArrayList<String> filterGridViewKeys = new ArrayList<String>();
        filterGridViewKeys.add("fast");
        filterGridViewKeys.add("common");
        filterGridViewKeys.add(SCHEME);
        filterGridViewKeys.add(ADVANCE);
        for (String key : filterGridViewKeys) {
            if (clientMeta.containsKey(key)) continue;
            if (ADVANCE.equalsIgnoreCase(key)) {
                clientMeta.put(key, new ArrayList());
                continue;
            }
            clientMeta.put(key, new HashMap());
        }
    }

    private List<EntryEntityDto> getEntryEntityDtos() {
        ArrayList<EntryEntityDto> entryEntityDtos = new ArrayList<EntryEntityDto>();
        ArrayList<EntryEntityDto> finalEntryEntityDtos = new ArrayList<EntryEntityDto>();
        String billListEntityId = this.getContext().getBillListEntityId();
        if (StringUtils.isBlank((CharSequence)billListEntityId) || this.getEntityType().getName().equals(billListEntityId)) {
            entryEntityDtos.addAll(ViewCommonUtil.getValidEntryListByFilterColumn((EntityType)this.getEntityType(), new ArrayList<FilterColumn>(this.getFilterColumns())));
        }
        if (!entryEntityDtos.isEmpty()) {
            for (EntryEntityDto entryEntityDto : this.getContext().getEntryEntityDtos()) {
                if (finalEntryEntityDtos.contains(entryEntityDto)) continue;
                finalEntryEntityDtos.add(entryEntityDto);
            }
            for (EntryEntityDto entryEntityDto : entryEntityDtos) {
                if (finalEntryEntityDtos.contains(entryEntityDto)) continue;
                finalEntryEntityDtos.add(entryEntityDto);
            }
        } else {
            finalEntryEntityDtos.addAll(this.getContext().getEntryEntityDtos());
        }
        return finalEntryEntityDtos;
    }

    private void renderControl(List<EntryEntityDto> entryEntityDtos) {
        List<FilterColumn> commonFilterColumns = new ArrayList<FilterColumn>(10);
        List<FilterColumn> schemeFilterColumns = new ArrayList<FilterColumn>(10);
        HashMap<String, Object> clientMeta = new HashMap<String, Object>();
        HashMap<String, Object> smart = new HashMap<String, Object>();
        if (this.getListCache().getFilterContainerTitle() == null) {
            this.getListCache().setFilterContainerTitle(this.title);
        }
        clientMeta.put("title", this.getListCache().getFilterContainerTitle());
        if (!this.isQuickSearchAll()) {
            clientMeta.put("quickSearchAll", this.isQuickSearchAll());
        }
        clientMeta.putAll(this.collectFilterColumnsClientMeta());
        this.fullfillClientMeta(clientMeta);
        Map schemeMeta = (Map)clientMeta.get(SCHEME);
        if (!this.getContext().isLookup()) {
            AbstractFilterGridView schemeFilterGridView = null;
            for (Control item : this.getItems()) {
                item.setView(this.getView());
                if (!(item instanceof AbstractFilterGridView)) continue;
                AbstractFilterGridView abstractFilterGridView = (AbstractFilterGridView)item;
                if (item instanceof FilterGridView) {
                    this.setFilterMode(item);
                    commonFilterColumns = abstractFilterGridView.getFilterColumns();
                    continue;
                }
                if (!(item instanceof SchemeFilterView)) continue;
                schemeFilterColumns = abstractFilterGridView.getFilterColumns();
                schemeFilterGridView = abstractFilterGridView;
            }
            List<FilterColumn> defaultSchemeFilterColumns = this.getDefaultSchemeFilterColumns(commonFilterColumns, schemeFilterColumns);
            schemeMeta.put(ADVANCE, AbstractFilterGridView.createFilterColumns(defaultSchemeFilterColumns, this.getEntityType()));
            schemeMeta.put("fixedfilters", this.getFixedFilters(commonFilterColumns, schemeFilterColumns));
            if (schemeFilterGridView != null) {
                schemeFilterGridView.setDependFieldMap();
                Map<String, Set<String>> beDependFieldNameMap = schemeFilterGridView.getBeDependFieldNameMap();
                if (!beDependFieldNameMap.isEmpty()) {
                    schemeMeta.put("fieldsDependent", schemeFilterGridView.getBeDependFieldNameMap());
                }
            }
        } else {
            schemeMeta.put(ADVANCE, new ArrayList());
        }
        String entryEntity = this.getEntryEntity();
        for (EntryEntityDto entryEntityDto : entryEntityDtos) {
            if (!entryEntityDto.getKey().equals(entryEntity)) continue;
            entryEntityDto.setSelected(true);
            break;
        }
        schemeMeta.put("multiFilter", this.getLinkQueryPkIdCollection().isEmpty());
        schemeMeta.put("entryenties", entryEntityDtos);
        schemeMeta.put("showComplexSchema", false);
        schemeMeta.put("againLinkSearch", this.againLinkSearch);
        if (this.isOrQuery()) {
            schemeMeta.put("showComplexSchema", true);
            schemeMeta.put("orquery.enable", true);
        }
        if (this.mainFilterFlag) {
            smart.put("mainFilterFlag", this.mainFilterFlag);
            smart.put(MAINFILTERCONTENT, this.mainFilterContent);
            smart.put("mainFilter", this.mainFilter);
            clientMeta.put("smart", smart);
        }
        this.clientViewProxy.invokeControlMethod(this.getKey(), "createFilterColumns", new Object[]{clientMeta});
    }

    void setFilterMode(Control item) {
        Optional<Integer> filterMode = this.getListCache().getFilterMode();
        FilterGridView filterGridView = (FilterGridView)item;
        Boolean usersNewFilter = Boolean.FALSE;
        if (filterMode.isPresent()) {
            usersNewFilter = filterMode.get() == 1 ? Boolean.TRUE : Boolean.FALSE;
        }
        filterGridView.setDesignerNewFilter(this.getListCache().isDesignerNewFilter());
        filterGridView.setUsersIsNewFilter(filterMode.isPresent() ? Optional.of(usersNewFilter) : Optional.empty());
        filterGridView.setPluginsIsNewFilter(this.getListCache().isNewFilter());
        filterGridView.setUserCommonFilterConfig(this.getUserCommonFilterConfig());
    }

    private Map<String, Object> collectFilterColumnsClientMeta() {
        HashMap<String, Object> clientMeta = new HashMap<String, Object>();
        for (Control item : this.getItems()) {
            item.setView(this.getView());
            if (!(item instanceof AbstractFilterGridView)) continue;
            AbstractFilterGridView abstractFilterGridView = (AbstractFilterGridView)item;
            if (item instanceof FilterGridView) {
                this.setFilterMode(item);
                if (!this.userCommonFilterConfig.isEmpty()) {
                    clientMeta.put("commonLayoutType", this.userCommonFilterConfig.get("type"));
                } else {
                    Object listfilterlayout = ListSysPublicParameter.option("listfilterlayout");
                    clientMeta.put("commonLayoutType", listfilterlayout == null ? 0 : Integer.parseInt(listfilterlayout.toString()));
                }
                clientMeta.put("hasCommon", !abstractFilterGridView.getShowFilterColumns(true).isEmpty());
            }
            clientMeta.put(abstractFilterGridView.getClientKey(), abstractFilterGridView.createFilterColumns());
        }
        return clientMeta;
    }

    private Map<String, Object> getUserCommonFilterConfig() {
        if (this.userCommonFilterConfig == null) {
            this.userCommonFilterConfig = new HashMap<String, Object>(16);
            String setting = this.getModel().getCurrUserSetting(this.getContext().getBillFormId() + "_commonfilter");
            if (StringUtils.isNotBlank((CharSequence)setting)) {
                this.userCommonFilterConfig = (Map)SerializationUtils.fromJsonString((String)setting, Map.class);
            }
        }
        return this.userCommonFilterConfig;
    }

    private void updateControlMeta() {
        ArrayList<Object> list = new ArrayList<Object>();
        list.add(this.getKey());
        list.add(this.createClientConfig());
        this.clientViewProxy.addAction("updateControlMetadata", list);
    }

    protected Set<FilterColumn> getFilterColumns() {
        if (this.filterColumns != null) {
            return this.filterColumns;
        }
        this.filterColumns = new LinkedHashSet<FilterColumn>(16);
        for (Control item : this.getItems()) {
            if (!(item instanceof AbstractFilterGridView)) continue;
            for (Control control : ((AbstractFilterGridView)item).getFilterColumns()) {
                FilterColumn filterColumn = (FilterColumn)control;
                this.filterColumns.add(filterColumn);
            }
        }
        return this.filterColumns;
    }

    private IFilterModel getFilterModel() {
        if (this.filterModel == null) {
            this.filterModel = this.createFilterModel();
        }
        return this.initFilterModel(this.filterModel);
    }

    private IFilterModel createFilterModel() {
        return (IFilterModel)TypesContainer.createInstance((String)this.getFilterModelClassName());
    }

    private IFilterModel initFilterModel(IFilterModel filterModel) {
        filterModel.setFieldCompareTypeMap(this.getFieldCompareTypeMap());
        filterModel.setSortObject(new SortObject());
        filterModel.setFormId(this.getBillFormId() == null ? this.getEntityId() : this.getBillFormId());
        filterModel.setDataType(this.getEntityType());
        filterModel.getFilterObject().setUserService((IUserService)this.getView().getService(IUserService.class));
        filterModel.getFilterObject().setDataType(this.getEntityType());
        filterModel.setFilterModelContext(new FilterModelContext(this.isOrQuery()));
        return filterModel;
    }

    private void clearSelection() {
        if (this.getContext() == null) {
            return;
        }
        this.getContext().setClearSelection(true);
    }

    private String getCommFilterConfigKey() {
        return this.getBillFormId() + "_commonfilter";
    }

    @SdkInternal
    public void getCommonFilterConfig() {
        this.refresh();
        this.pluginInit();
        Map<String, Object> myuserCommonFilterConfig = this.getMyuserCommonFilterConfig();
        Map<Object, Object> factoryCommonFilterConfig = new HashMap(16);
        for (Control item : this.getItems()) {
            if (!(item instanceof FilterGridView)) continue;
            factoryCommonFilterConfig = ((FilterGridView)item).createCommonFilterConfig();
        }
        HashMap<String, Map<String, Object>> commonFilterConfig = new HashMap<String, Map<String, Object>>(16);
        commonFilterConfig.put("user", myuserCommonFilterConfig);
        commonFilterConfig.put("factory", factoryCommonFilterConfig);
        this.clientViewProxy.invokeControlMethod(this.getKey(), "setCommonFilterConfig", new Object[]{commonFilterConfig});
    }

    private Map<String, Object> getMyuserCommonFilterConfig() {
        String setting = this.getModel().getCurrUserSetting(this.getCommFilterConfigKey());
        Map<String, Object> myuserCommonFilterConfig = new HashMap<String, Object>(16);
        if (StringUtils.isNotBlank((CharSequence)setting)) {
            myuserCommonFilterConfig = (Map)SerializationUtils.fromJsonString((String)setting, Map.class);
        }
        return myuserCommonFilterConfig;
    }

    @SdkInternal
    public void setCommonFilterConfig(Map<String, Object> commonFilterConfig, List<Map<String, List<Object>>> fastFilter, List<Map<String, List<Object>>> filter, final String entryEntity) {
        String setting = SerializationUtils.toJsonString(commonFilterConfig);
        long currUserId = RequestContext.getOrCreate().getCurrUserId();
        Map<String, Object> myuserCommonFilterConfig = this.getMyuserCommonFilterConfig();
        if (!this.getModel().setCurrUserSetting(currUserId, this.getCommFilterConfigKey(), setting)) {
            log.info(String.format("setCommonFilterConfig has failed,key:%s,userId:%s,setting:%s", this.getCommFilterConfigKey(), currUserId, setting));
        }
        List<String> preHiddenFields = this.getPredicateFields(myuserCommonFilterConfig, p -> (Integer)p.get("v") == 0);
        List<String> hiddenCommonFilterNames = this.getPredicateFields(commonFilterConfig, p -> (Integer)p.get("v") == 0);
        final List<String> showUpFields = this.getPredicateFields(commonFilterConfig, p -> (Integer)p.get("v") == 1 && preHiddenFields.contains(p.get("n")));
        FilterContainerFilterValues cachedFilterValues = new FilterContainerFilterValues(fastFilter, CUSTOMFILTER, filter, entryEntity);
        FilterKeyValueCollections otherFilterValues = cachedFilterValues.getOtherFilterValues();
        FilterKeyValueCollections finalOtherFilterValues = new FilterKeyValueCollections();
        ArrayList filterValueCollectionList = new ArrayList(otherFilterValues.getFilterValueCollection());
        finalOtherFilterValues.setFilterKey(otherFilterValues.getFilterKey());
        finalOtherFilterValues.setFilterValueCollection(filterValueCollectionList);
        FilterContainerFilterValues finalCachedFilterValues = new FilterContainerFilterValues(cachedFilterValues.getFastFilterValues(), finalOtherFilterValues);
        filterValueCollectionList.stream().forEach(t -> {
            Optional<FilterKeyValue> value;
            Optional<FilterKeyValue> name = t.getFilterKeyValues().stream().filter(u -> FIEIDNAME.contains(u.getKey())).findFirst();
            if (name.isPresent() && hiddenCommonFilterNames.contains(name.get().getValue().get(0)) && (value = t.getFilterKeyValues().stream().filter(u -> VALUE.contains(u.getKey())).findFirst()).isPresent()) {
                value.get().setValue(new ArrayList());
            }
        });
        Map mapFilterValues = finalCachedFilterValues.createMapFilterValues();
        if (showUpFields.isEmpty()) {
            this.createFilterControlHelper().cacheFilterValues((List)mapFilterValues.get(FASTFILTER), (List)mapFilterValues.get(CUSTOMFILTER), entryEntity);
            this.savePageCache();
        }
        this.searchClickListeners.add(0, new SearchClickListener(){

            public void click(SearchClickEvent evt) {
                if (!showUpFields.isEmpty()) {
                    FilterContainer.this.createFilterControlHelper().cacheFilterValues((List)evt.getFilterValues().get(FilterContainer.FASTFILTER), (List)evt.getFilterValues().get(FilterContainer.CUSTOMFILTER), entryEntity);
                    FilterContainer.this.savePageCache();
                }
            }
        });
        this.fireFilterSearchClickByCache(mapFilterValues, cachedFilterValues.getEntryEntity(), columns -> {
            ArrayList<FilterColumn> filterColumnList = new ArrayList<FilterColumn>(columns.size());
            for (FilterColumn filterColumn : columns) {
                if (hiddenCommonFilterNames.contains(filterColumn.getFieldName())) continue;
                filterColumnList.add(filterColumn);
            }
            return filterColumnList;
        });
        this.renderControl(this.getFixedEntryEntityDtos());
    }

    private String getSchemeFilterConfigKey() {
        return this.getBillFormId() + "_schemefilter";
    }

    private Map<String, Object> getMyuserSchemeFilterConfig() {
        String setting = this.getModel().getCurrUserSetting(this.getSchemeFilterConfigKey());
        Map myuserSchmeFilterConfig = null;
        if (StringUtils.isNotBlank((CharSequence)setting)) {
            myuserSchmeFilterConfig = (Map)SerializationUtils.fromJsonString((String)setting, Map.class);
        }
        return myuserSchmeFilterConfig;
    }

    @SdkInternal
    public void getSchemeFilterConfig() {
        this.refresh();
        this.pluginInit();
        List<FilterColumn> commonFilterColumns = new ArrayList<FilterColumn>(10);
        List<FilterColumn> schemeFilterColumns = new ArrayList<FilterColumn>(10);
        for (Control item : this.getItems()) {
            item.setView(this.getView());
            if (!(item instanceof AbstractFilterGridView)) continue;
            AbstractFilterGridView abstractFilterGridView = (AbstractFilterGridView)item;
            if (item instanceof FilterGridView) {
                commonFilterColumns = abstractFilterGridView.getFilterColumns();
                continue;
            }
            if (!(item instanceof SchemeFilterView)) continue;
            schemeFilterColumns = abstractFilterGridView.getFilterColumns();
        }
        List<String> initFixFilters = this.getInitFixFilters(commonFilterColumns, schemeFilterColumns);
        Map<Object, Object> factoryCommonFilterConfig = new HashMap(16);
        for (Control item : this.getItems()) {
            if (!(item instanceof SchemeFilterView)) continue;
            factoryCommonFilterConfig = ((SchemeFilterView)item).createSchemeFilterConfig(initFixFilters);
        }
        Map<String, Object> myuserSchemeFilterConfig = this.getMyuserSchemeFilterConfig();
        List factoryRows = (List)factoryCommonFilterConfig.get("rows");
        if (myuserSchemeFilterConfig != null) {
            Set keysInFactory = factoryRows.stream().map(map -> map.get("k").toString()).collect(Collectors.toSet());
            ((List)myuserSchemeFilterConfig.get("rows")).stream().filter(map -> keysInFactory.contains(map.get("k"))).collect(Collectors.toList());
        } else {
            myuserSchemeFilterConfig = new HashMap<String, Object>(factoryRows.size());
            List userRows = factoryRows.stream().map(map -> {
                HashMap newMap = new HashMap();
                newMap.put("k", map.get("k"));
                newMap.put("v", map.get("v"));
                return newMap;
            }).collect(Collectors.toList());
            myuserSchemeFilterConfig.put("rows", userRows);
        }
        HashMap<String, Map<String, Object>> schemeFilterConfig = new HashMap<String, Map<String, Object>>(2);
        schemeFilterConfig.put("user", myuserSchemeFilterConfig);
        schemeFilterConfig.put("factory", factoryCommonFilterConfig);
        this.clientViewProxy.invokeControlMethod(this.getKey(), "setSchemeFilterConfig", new Object[]{schemeFilterConfig});
    }

    public void setSchemeFilterConfig(Map<String, Object> schemeFilterConfig) {
        String setting = SerializationUtils.toJsonString(schemeFilterConfig);
        long currUserId = RequestContext.getOrCreate().getCurrUserId();
        if (!this.getModel().setCurrUserSetting(currUserId, this.getSchemeFilterConfigKey(), setting)) {
            log.info(String.format("setSchemeFilterConfig has failed,key:%s,userId:%s,setting:%s", this.getSchemeFilterConfigKey(), currUserId, setting));
        }
    }

    private List<String> getPredicateFields(Map<String, Object> myuserCommonFilterConfig, Predicate<Map<String, Object>> predicate) {
        ArrayList<String> predicateCommonFilterNames = new ArrayList<String>(10);
        if (!myuserCommonFilterConfig.isEmpty()) {
            List preConfig = (List)myuserCommonFilterConfig.get("rows");
            for (Map map : preConfig) {
                if (!predicate.test(map)) continue;
                predicateCommonFilterNames.add(map.get("n").toString());
            }
        }
        return predicateCommonFilterNames;
    }

    @SdkInternal
    public void commonSearch(List<Map<String, List<Object>>> fastFilter, List<Map<String, List<Object>>> filter, String entryEntity) {
        this.getListCache().setSchemeId("");
        this.isCommonSearch = true;
        this.clearSelection();
        this.setMetadata();
        Map<String, List<Map<String, List<Object>>>> filterValues = this.buildCommonFilterValues(fastFilter, filter, entryEntity);
        this.cacheAndFilter(null);
        try (ExceedShardingQueryLimit es = ExceedShardingQueryLimit.create();){
            this.filterSearchClick(filterValues, entryEntity, null, null);
        }
        catch (KDException e) {
            if (e.getErrorCode() == XDBErrorCode.exceedShardingTableQueryLimit) {
                throw new KDBizException(e.getErrorCode(), new Object[]{ResManager.loadKDString((String)"\u67e5\u8be2\u6570\u636e\u8303\u56f4\u8fc7\u5927\uff0c\u8bf7\u5c1d\u8bd5\u7f29\u5c0f\u67e5\u8be2\u8303\u56f4\u3002", (String)"ExceedShardingTableQueryLimit_0", (String)BOSFORMCORE, (Object[])new Object[0])});
            }
            if (e.getErrorCode() == ORMException.excessiveInParameters) {
                throw new KDBizException(e.getErrorCode(), new Object[]{ResManager.loadKDString((String)"\u67e5\u8be2\u6570\u636e\u8303\u56f4\u8fc7\u5927\uff0c\u8bf7\u5c1d\u8bd5\u7f29\u5c0f\u67e5\u8be2\u8303\u56f4\u3002", (String)"LimitInSize_0", (String)BOSFORMCORE, (Object[])new Object[0])});
            }
            throw e;
        }
        this.renderControl(this.getFixedEntryEntityDtos());
    }

    private Map<String, List<Map<String, List<Object>>>> buildSchemeFilterValues(List<Map<String, List<Object>>> fastFilter, List<Map<String, List<Object>>> filter, String entryEntity) {
        HashMap<String, List<Map<String, List<Object>>>> filterValues = new HashMap<String, List<Map<String, List<Object>>>>();
        filterValues.put(FASTFILTER, fastFilter);
        filterValues.put(SCHEMEFILTER, filter);
        FilterContainerFilterValues cachedFilterValues = new FilterContainerFilterValues(fastFilter, SCHEMEFILTER, filter, entryEntity);
        this.setCachedFilterValues(cachedFilterValues);
        ControlFilters controlFilters = new ControlFilters(cachedFilterValues.getFastFilterValues(), cachedFilterValues.getOtherFilterValues());
        this.getContext().setControlFilters(controlFilters);
        this.getContext().setEntryEntity(entryEntity);
        return filterValues;
    }

    public void schemeSearch(List<Map<String, List<Object>>> fastFilter, List<Map<String, List<Object>>> filter, String entryEntity) {
        this.schemeSearch(fastFilter, filter, entryEntity, null);
    }

    public void schemeSearch(List<Map<String, List<Object>>> fastFilter, List<Map<String, List<Object>>> filter, String entryEntity, List<Map<String, List<Object>>> andFilter) {
        if (!this.isKeepSchemeId) {
            this.getListCache().setSchemeId("");
        }
        if (!this.isSchemeValidate) {
            return;
        }
        if (!this.isOrQuery() && andFilter != null && !andFilter.isEmpty() && filter != null) {
            filter.addAll(andFilter);
        }
        this.cacheAndFilter(andFilter);
        this.clearSelection();
        this.setMetadata();
        Map<String, List<Map<String, List<Object>>>> filterValues = this.buildSchemeFilterValues(fastFilter, filter, entryEntity);
        try (ExceedShardingQueryLimit es = ExceedShardingQueryLimit.create();){
            this.filterSearchClick(filterValues, entryEntity, null, andFilter);
        }
        catch (KDException e) {
            if (e.getErrorCode() == XDBErrorCode.exceedShardingTableQueryLimit) {
                throw new KDBizException(e.getErrorCode(), new Object[]{ResManager.loadKDString((String)"\u67e5\u8be2\u6570\u636e\u8303\u56f4\u8fc7\u5927\uff0c\u8bf7\u5c1d\u8bd5\u7f29\u5c0f\u67e5\u8be2\u8303\u56f4\u3002", (String)"ExceedShardingTableQueryLimit_0", (String)BOSFORMCORE, (Object[])new Object[0])});
            }
            if (e.getErrorCode() == ORMException.excessiveInParameters) {
                throw new KDBizException(e.getErrorCode(), new Object[]{ResManager.loadKDString((String)"\u67e5\u8be2\u6570\u636e\u8303\u56f4\u8fc7\u5927\uff0c\u8bf7\u5c1d\u8bd5\u7f29\u5c0f\u67e5\u8be2\u8303\u56f4\u3002", (String)"LimitInSize_0", (String)BOSFORMCORE, (Object[])new Object[0])});
            }
            throw e;
        }
    }

    public List<Map<String, List<Object>>> getAndFilter() {
        if (this.isOrQuery()) {
            return this.getFilterContainerCache().getAndFilterValues();
        }
        return null;
    }

    private void cacheAndFilter(List<Map<String, List<Object>>> andFilter) {
        if (this.isOrQuery()) {
            this.getFilterContainerCache().setAndFilterValues(andFilter);
        }
    }

    @NotNull
    private FilterContainerCache getFilterContainerCache() {
        if (this.filterContainerCache == null) {
            this.filterContainerCache = new FilterContainerCache((IPageCache)this.getView().getService(IPageCache.class), this.getKey());
        }
        return this.filterContainerCache;
    }

    private void filterSearchClick(Map<String, List<Map<String, List<Object>>>> filterValues, String entryEntity, Function<List<FilterColumn>, List<FilterColumn>> filterColumnFilterFunction, List<Map<String, List<Object>>> andFilter) {
        this.initFilterGridView();
        this.pluginInit();
        this.getListCache().setHasFlexFilter(this.checkFlexPropFieldsExists(filterValues));
        FilterControlHelper filterControlHelper = this.createFilterControlHelper();
        filterControlHelper.setSearchClickListeners(this.searchClickListeners);
        filterControlHelper.setAfterSearchClickListeners(this.afterSearchClickListeners);
        filterControlHelper.setLinkQueryPkIdCollection(this.getLinkQueryPkIdCollection());
        if (this.isOrQuery() && andFilter != null && !andFilter.isEmpty()) {
            filterControlHelper.setAndFilter(andFilter);
        }
        filterControlHelper.parseFilterValues(filterValues, entryEntity, filterColumnFilterFunction);
        String routeKey = this.getListCache().getRouteKey();
        if (!"".equals(routeKey)) {
            this.getContext().setRouteKey(routeKey);
            this.getContext().setArchiveKey(this.getListCache().getArchiveKey());
        }
        this.savePageCache();
    }

    private boolean checkInputEmpty(FilterControlHelper filterControlHelper) {
        if (!filterControlHelper.getCannotEmptyNames().isEmpty()) {
            this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u201c%s\u201d\u5b57\u6bb5\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"FilterContainer_20", (String)BOSFORMCORE, (Object[])new Object[0]), Strings.join(filterControlHelper.getCannotEmptyNames(), (String)"\uff0c")));
            return true;
        }
        return false;
    }

    private boolean checkFlexPropFieldsExists(Map<String, List<Map<String, List<Object>>>> filterValues) {
        List<Map<String, List<Object>>> schemeFilter = filterValues.get(SCHEMEFILTER);
        if (schemeFilter == null) {
            return false;
        }
        SchemeFilterView schemeFilterView = null;
        for (Object control : this.getItems()) {
            if (!(control instanceof SchemeFilterView)) continue;
            schemeFilterView = (SchemeFilterView)control;
        }
        if (schemeFilterView == null) {
            return false;
        }
        ArrayList<String> filterNames = new ArrayList<String>(schemeFilter.size());
        for (Map map : schemeFilter) {
            filterNames.add(((List)map.get(FIEIDNAME)).get(0).toString());
        }
        ArrayList<String> flexFilterNames = new ArrayList<String>();
        for (FilterColumn filterColumn : schemeFilterView.getFilterColumns()) {
            if (!(filterColumn instanceof FlexPropSchemeFilterColumn)) continue;
            flexFilterNames.add(filterColumn.getFieldName());
        }
        for (String filterName : filterNames) {
            if (!flexFilterNames.contains(filterName)) continue;
            return true;
        }
        return false;
    }

    private Map<String, List<CompareType>> getFieldCompareTypeMap() {
        if (this.fieldCompareTypeMap == null) {
            this.fieldCompareTypeMap = new HashMap<String, List<CompareType>>();
            if (this.getCompareTypeConfig() != null) {
                CompareTypeModelCollection compareTypeModelCollection = CompareTypeQuery.getCompareTypeModelCollection();
                for (CompareTypeField compareTypeField : this.getCompareTypeConfig().getCompareTypeFields()) {
                    this.putCompareTypeField(compareTypeModelCollection, compareTypeField);
                }
            }
        }
        return this.fieldCompareTypeMap;
    }

    private void putCompareTypeField(CompareTypeModelCollection compareTypeModelCollection, CompareTypeField compareTypeField) {
        CompareType compareType = null;
        for (CompareTypeModel compareTypeModel : compareTypeModelCollection) {
            if (!compareTypeModel.getId().equals(compareTypeField.getId())) continue;
            compareType = compareTypeModel.createCompareType();
        }
        if (compareType != null) {
            String[] fieldNames;
            for (String fieldName : fieldNames = compareTypeField.getFieldNames().split(",")) {
                List<CompareType> compareTypes = new ArrayList<CompareType>();
                if (this.fieldCompareTypeMap.containsKey(fieldName)) {
                    compareTypes = this.fieldCompareTypeMap.get(fieldName);
                }
                compareTypes.add(compareType);
                this.fieldCompareTypeMap.put(fieldName, compareTypes);
            }
        }
    }

    @SdkInternal
    public void f7Click(String fieldName, boolean isMulti, List<String> selectedIds) {
        this.f7Click(fieldName, isMulti, selectedIds, null);
    }

    @SdkInternal
    public void f7Click(String fieldName, boolean isMulti, List<String> selectedIds, String searchValue) {
        this.initFilterGridViewF7Context();
        FilterControlHelper filterControlHelper = this.createFilterControlHelper();
        FilterColumn filterColumn = filterControlHelper.getFilterColumn(fieldName, FilterGridView.class);
        if (filterColumn.getLatestParent() instanceof RefBillProp) {
            this.showRefBillF7Form(fieldName, isMulti, true, selectedIds, "setCommonF7Value", -1, -1, filterColumn);
        } else {
            FilterF7Helper filterF7Helper = filterControlHelper.createF7FormShowParameter(fieldName, "setCommonF7Value", filterColumn, "");
            filterF7Helper.setMulti(isMulti);
            filterF7Helper.setSelectedIds(selectedIds.toArray(new String[0]));
            filterF7Helper.setBillFormId(this.getBillFormId());
            filterF7Helper.setF7ClickByFilter(true);
            if (filterColumn instanceof CommonFilterColumn) {
                filterF7Helper.setMustInput(((CommonFilterColumn)filterColumn).isMustInput());
            }
            filterF7Helper.setSearchValue(searchValue);
            ShowFormHelper.showF7Form(filterF7Helper, this.getView(), this.getKey());
        }
    }

    private void showRefBillF7Form(String fieldName, boolean isMulti, boolean isLookUP, List<String> selectedIds, String clientMethodName, int clientType, int rowIndex, FilterColumn filterColumn) {
        List<QFilter> qfilters;
        RefBillProp refBillProp = (RefBillProp)filterColumn.getLatestParent();
        RefEntityType refEntityType = (RefEntityType)refBillProp.getComplexType();
        String refEntityId = refEntityType.getName();
        ListShowParameter para = new ListShowParameter();
        para.setBillFormId(refEntityId);
        if (isLookUP) {
            para.setLookUp(true);
            para.getOpenStyle().setShowType(ShowType.Modal);
            StyleCss css = new StyleCss();
            css.setWidth("960px");
            css.setHeight("580px");
            para.getOpenStyle().setInlineStyleCss(css);
            para.setF7Style(2);
        }
        para.setFormId("bos_listf7");
        FormConfig listFormConfig = FormMetadataCache.getListFormConfig((String)refEntityId);
        para.setCaption(listFormConfig.getCaption().toString());
        para.setMultiSelect(isMulti);
        para.setShowTitle(false);
        para.setHasRight(true);
        para.setShowUsed(false);
        para.setShowApproved(true);
        if (!refBillProp.isShowOnlyAudited()) {
            para.setF7ClickByFilter(true);
        }
        if (CollectionUtils.isNotEmpty(qfilters = filterColumn.getFilter0((IRefBillField)refBillProp))) {
            para.getListFilterParameter().setQFilters(qfilters);
        }
        if (filterColumn instanceof SchemeFilterColumn && !para.getCustomParams().containsKey("isFromSchemeFilterColumn")) {
            para.getCustomParams().put("isFromSchemeFilterColumn", true);
        }
        if (filterColumn instanceof CommonFilterColumn && !para.getCustomParams().containsKey("isFromCommonFilterColumn")) {
            para.getCustomParams().put("isFromCommonFilterColumn", true);
        }
        if (selectedIds != null && selectedIds.size() > 0) {
            if (refEntityType.getPrimaryKey() instanceof LongProp) {
                ArrayList<Long> pkIds = new ArrayList<Long>(selectedIds.size());
                for (String selectedId : selectedIds) {
                    long pkId = StringUtils.isBlank((CharSequence)selectedId) ? 0L : Long.parseLong(selectedId);
                    pkIds.add(pkId);
                }
                para.setSelectedRows(pkIds.toArray());
            } else {
                para.setSelectedRows(selectedIds.toArray());
            }
        }
        CloseCallBack closeCallBack = new CloseCallBack();
        closeCallBack.setControlKey(this.getKey());
        String refPropKey = filterColumn.getFilterField().getRefPropKey();
        closeCallBack.setActionId("RefBill$" + refEntityId + "$" + clientType + "$" + rowIndex + "$" + refPropKey + "$" + clientMethodName + "$" + fieldName);
        para.setCloseCallBack(closeCallBack);
        this.getView().showForm((FormShowParameter)para);
    }

    private void closeCallBackForRefBill(ClosedCallBackEvent e, String[] actionIds) {
        if (!(e.getReturnData() instanceof ListSelectedRowCollection)) {
            return;
        }
        int clientType = Integer.parseInt(actionIds[2]);
        int rowIndex = Integer.parseInt(actionIds[3]);
        String fieldKey = actionIds[4];
        String clientMethodName = actionIds[5];
        String fieldName = actionIds[6];
        ListSelectedRowCollection rows = (ListSelectedRowCollection)e.getReturnData();
        ArrayList<Object> selectedIds = new ArrayList<Object>();
        if (rows != null) {
            for (ListSelectedRow listSelectedRow : rows) {
                selectedIds.add(listSelectedRow.getPrimaryKeyValue().toString());
            }
        } else {
            return;
        }
        if (rows.isClearFlag()) {
            MessageProxy.sendBaseDataSetValueAction((String)this.getKey(), (String)fieldName, (IFormView)this.getView(), (int)clientType, (int)rowIndex, (String)clientMethodName, new ArrayList(), new ArrayList());
            return;
        }
        BillEntityType billEntityType = (BillEntityType)EntityMetadataCache.getDataEntityType((String)actionIds[1]);
        if ("setCommonF7Value".equals(clientMethodName)) {
            this.selectedCommomFilterFieldName = fieldName;
            this.selectedCommomFilterFieldValues = selectedIds;
            MessageProxy.sendRefBillSetValueAction((String)this.getKey(), (String)fieldKey, (String)fieldName, (BillEntityType)billEntityType, (ListSelectedRowCollection)rows, (IFormView)this.getView(), (int)clientType, (int)rowIndex, (String)clientMethodName);
        } else {
            ArrayList<Object> pkValues = new ArrayList<Object>();
            if (!rows.isEmpty()) {
                for (ListSelectedRow row : rows) {
                    pkValues.add(row.getPrimaryKeyValue());
                }
            }
            Map mapObjects = this.getModel().loadReferenceDataBatch((DynamicObjectType)billEntityType, pkValues.toArray(new Object[0]));
            ArrayList<String> ids = new ArrayList<String>(10);
            for (DynamicObject entry : mapObjects.values()) {
                ids.add(entry.getPkValue().toString());
            }
            IDataEntityProperty property = billEntityType.findProperty(fieldKey);
            if (property == null) {
                property = billEntityType.getProperty(billEntityType.getBillNo());
            }
            ArrayList<String> values = new ArrayList<String>();
            if (property != null) {
                for (DynamicObject entry : mapObjects.values()) {
                    Object value = property.getValue((Object)entry);
                    if (value == null) continue;
                    values.add(value.toString());
                }
            }
            MessageProxy.sendBaseDataSetValueAction((String)this.getKey(), (String)fieldName, (IFormView)this.getView(), (int)clientType, (int)rowIndex, (String)clientMethodName, ids, values);
        }
    }

    private void initFilterGridViewF7Context() {
        FilterContainerFilterValues cachedFilterValues = this.getCachedFilterValues();
        this.isCommonSearch = true;
        if (SCHEMEFILTER.equals(cachedFilterValues.getOtherFilterValues().getFilterKey())) {
            this.initContainer();
            this.buildDefaultFilter(cachedFilterValues.getEntryEntity());
        } else {
            this.initContextControlFilters();
            this.initContainer();
        }
    }

    @SdkInternal
    public void f7Click(String entityId, String fieldName, String compareTypeId, int clientType, int rowIndex, List<Object> filter) {
        FilterControlHelper filterControlHelper;
        FilterColumn filterColumn;
        List andFilter = null;
        if (filter.size() >= 3) {
            andFilter = (List)filter.get(2);
        }
        if (!this.isOrQuery() && andFilter != null && !andFilter.isEmpty() && filter.get(0) != null) {
            List schemeFilter = (List)filter.get(0);
            schemeFilter.addAll(andFilter);
        }
        this.cacheAndFilter(andFilter);
        List<Map<String, List<Object>>> filterListMap = this.initF7ClickContext(filter);
        if (andFilter != null && !andFilter.isEmpty()) {
            filterListMap = new ArrayList<Map<String, List<Object>>>(andFilter);
        }
        if ((filterColumn = (filterControlHelper = this.createFilterControlHelper()).getFilterColumn(fieldName, SchemeFilterView.class)) != null && filterColumn.getLatestParent() instanceof RefBillProp) {
            String clientMethodName = "setF7Value";
            String refPropKey = null;
            String refEntityId = entityId;
            boolean isMulti = true;
            FilterF7Helper filterF7Helper = new FilterF7Helper(refEntityId, fieldName, isMulti, refPropKey, clientMethodName);
            this.setSelectedValues(fieldName, rowIndex, filterListMap, filterF7Helper);
            ArrayList<String> selectedIds = new ArrayList<String>();
            for (Object selectedId : filterF7Helper.getSelectedIds()) {
                if (selectedId == null || !StringUtils.isNotEmpty((CharSequence)selectedId.toString())) continue;
                selectedIds.add(selectedId.toString());
            }
            if (StringUtils.isNotBlank((CharSequence)compareTypeId) && filterColumn.getFilterField() != null) {
                CompareType compareType = filterColumn.getFilterField().getCompareType(compareTypeId);
                isMulti = compareType.isMulti();
            }
            this.showRefBillF7Form(fieldName, isMulti, true, selectedIds, clientMethodName, -1, rowIndex, filterColumn);
        } else {
            FilterF7Helper filterF7Helper = this.createFilterF7Helper(entityId, fieldName, filterControlHelper);
            this.setSelectedValues(fieldName, rowIndex, filterListMap, filterF7Helper);
            if (StringUtils.isNotBlank((CharSequence)compareTypeId) && filterF7Helper.getFilterColumn().getFilterField() != null) {
                CompareType compareType = filterF7Helper.getFilterColumn().getFilterField().getCompareType(compareTypeId);
                filterF7Helper.setMulti(compareType.isMulti());
            }
            filterF7Helper.setClientType(clientType);
            filterF7Helper.setRowIndex(rowIndex);
            filterF7Helper.setBillFormId(this.getBillFormId());
            filterF7Helper.setF7ClickByFilter(true);
            ShowFormHelper.showF7Form(filterF7Helper, this.getView(), this.getKey());
        }
    }

    private void setSelectedValues(String fieldName, int rowIndex, List<Map<String, List<Object>>> filterListMap, FilterF7Helper filterF7Helper) {
        int i = 0;
        ArrayList<Object> filterValues = new ArrayList<Object>(10);
        boolean isSelectedId = false;
        for (Map<String, List<Object>> filterMap : filterListMap) {
            if (i == rowIndex && fieldName.equals(filterMap.get(FIEIDNAME).get(0))) {
                if (filterMap.containsKey("Id")) {
                    isSelectedId = true;
                    for (Object object : filterMap.get("Id")) {
                        if (object == null || !StringUtils.isNotEmpty((CharSequence)object.toString())) continue;
                        filterValues.add(object);
                    }
                } else {
                    for (Object object : filterMap.get(VALUE)) {
                        if (object == null || !StringUtils.isNotEmpty((CharSequence)object.toString())) continue;
                        filterValues.add(object);
                    }
                }
            }
            ++i;
        }
        if (!filterValues.isEmpty()) {
            if (isSelectedId) {
                filterF7Helper.setSelectedIds(filterValues.toArray(new Object[0]));
            } else {
                filterF7Helper.setSelectedRowCondition(new SelectedRowCondition(filterValues, filterF7Helper.getRefPropKey()));
            }
        }
    }

    private FilterF7Helper createFilterF7Helper(String entityId, String fieldName, FilterControlHelper filterControlHelper) {
        filterControlHelper.setDependFieldMap(SchemeFilterView.class);
        FilterColumn filterColumn = filterControlHelper.getFilterColumn(fieldName, SchemeFilterView.class);
        if (filterColumn instanceof SchemeFilterColumn && filterColumn.isEntityField()) {
            ((SchemeFilterColumn)filterColumn).addDependFilter(this.invokeBaseDataColumnDependFieldSetListeners());
        }
        return filterControlHelper.createF7FormShowParameter(fieldName, "setF7Value", filterColumn, entityId);
    }

    private FilterControlHelper createFilterControlHelper() {
        return this.createFilterControlHelper(this.getFilterModel(), this.getContext());
    }

    @NotNull
    private FilterControlHelper createFilterControlHelper(IFilterModel filterModel, ControlContext context) {
        FilterControlHelper filterControlHelper = new FilterControlHelper(this, filterModel, this.getEntityType(), context, this.getListCache());
        filterControlHelper.setBeforeF7SelectListeners(this.beforeF7SelectListeners);
        return filterControlHelper;
    }

    private List<Map<String, List<Object>>> initF7ClickContext(List<Object> filter) {
        List<Map<String, List<Object>>> filterListMap = this.cacheSchemeFitlers(filter);
        this.initContainer();
        this.savePageCache();
        return filterListMap;
    }

    private List<Map<String, List<Object>>> cacheSchemeFitlers(List<Object> filter) {
        FilterContainerFilterValues cachedFilterValues = this.getCachedFilterValues();
        List filterListMap = (List)filter.get(0);
        List createFilterValuesList = cachedFilterValues.getFastFilterValues().createFilterValuesList();
        this.buildSchemeFilterValues(createFilterValuesList, filterListMap, filter.get(1).toString());
        return filterListMap;
    }

    @SdkInternal
    public void getBaseDataItems(String fieldName, String searchKey) {
        this.sendLookUpValues(null, fieldName, searchKey, FilterGridView.class, null);
    }

    public void getSchemeBaseDataItems(String entityId, String fieldName, String searchKey, List<Object> filters) {
        this.sendLookUpValues(entityId, fieldName, searchKey, SchemeFilterView.class, filters);
    }

    private void sendLookUpValues(String entityId, String fieldName, String searchKey, Class<?> cls, List<Object> filters) {
        if (filters != null) {
            this.cacheSchemeFitlers(filters);
        } else {
            this.isCommonSearch = true;
        }
        this.initContainer();
        FilterControlHelper filterControlHelper = this.createFilterControlHelper();
        FilterColumn filterColumn = filterControlHelper.getFilterColumn(fieldName, cls);
        if (filterColumn.getLatestParent() instanceof RefBillProp) {
            this.setLookUpListValueForRefBill(fieldName, searchKey, filterColumn);
        } else {
            if (cls == SchemeFilterView.class) {
                filterControlHelper.setDependFieldMap(SchemeFilterView.class);
                if (filterColumn instanceof SchemeFilterColumn && filterColumn.isEntityField()) {
                    ((SchemeFilterColumn)filterColumn).addDependFilter(this.invokeBaseDataColumnDependFieldSetListeners());
                }
            }
            FilterF7Helper filterF7Helper = filterControlHelper.createF7FormShowParameter(fieldName, "setLookUpListValue", filterColumn, "");
            filterF7Helper.setBillFormId(this.getBillFormId());
            filterF7Helper.setSearchKey(searchKey);
            filterF7Helper.setControlKey(this.getKey());
            if (StringUtils.isNotBlank((CharSequence)entityId)) {
                filterF7Helper.setRefEntityId(entityId);
            }
            ShowFormHelper.sendLookupData(filterF7Helper, this.view, q -> filterColumn.queryBaseDataCollections((QueryLookUpdataParameter)q));
        }
    }

    private void setLookUpListValueForRefBill(String fieldName, String searchKey, FilterColumn filterColumn) {
        List<QFilter> dataQFilter;
        List<QFilter> qfilters;
        if (StringUtils.isEmpty((CharSequence)searchKey)) {
            return;
        }
        RefBillProp refBillProp = (RefBillProp)filterColumn.getLatestParent();
        RefEntityType refEntityType = (RefEntityType)refBillProp.getComplexType();
        String billEntityId = refBillProp.getBillEntityId();
        ArrayList<QFilter> listFilters = new ArrayList<QFilter>();
        ArrayList<String> searchFields = new ArrayList<String>();
        searchFields.add(refEntityType.getBillNo());
        QFilter searchFilter = BaseDataSearchHelper.getSearchFilter((String)searchKey, searchFields, (String)refBillProp.getBillEntityId());
        if (searchFilter != null) {
            listFilters.add(searchFilter);
        }
        if (CollectionUtils.isNotEmpty(qfilters = filterColumn.getFilter0((IRefBillField)refBillProp))) {
            listFilters.addAll(qfilters);
        }
        if (CollectionUtils.isNotEmpty(dataQFilter = filterColumn.getFilterByRefBillField((IRefBillField)refBillProp))) {
            listFilters.addAll(dataQFilter);
        }
        ORM orm = ORM.create();
        try (DataSet ds = orm.queryDataSet("kd.bos.filter.CommonFilterColumn." + billEntityId, billEntityId, refEntityType.getPrimaryKey().getName() + "," + refEntityType.getBillNo(), listFilters.toArray(new QFilter[0]), null, 20);){
            DynamicObjectCollection dynamicObjectCollection = orm.toPlainDynamicObjectCollection(ds);
            HashMap<String, Object> data2Client = new HashMap<String, Object>();
            ArrayList<ShowColumn> showColumns = new ArrayList<ShowColumn>();
            ShowColumn idCol = new ShowColumn();
            idCol.setId(refEntityType.getPrimaryKey().getName());
            idCol.setCaption(refEntityType.getPrimaryKey().getName());
            idCol.setVisible(false);
            showColumns.add(idCol);
            ShowColumn idBillNo = new ShowColumn();
            idBillNo.setId(refEntityType.getBillNo());
            idBillNo.setCaption(filterColumn.getCaption().toString());
            idBillNo.setWidth(250.0f);
            idBillNo.setVisible(true);
            showColumns.add(idBillNo);
            ShowColumn idBillNoTwo = new ShowColumn();
            idBillNoTwo.setId(refEntityType.getBillNo());
            idBillNoTwo.setCaption(filterColumn.getCaption().toString());
            idBillNoTwo.setVisible(false);
            showColumns.add(idBillNoTwo);
            data2Client.put("columns", showColumns);
            ArrayList data = new ArrayList();
            for (DynamicObject dynamicObject : dynamicObjectCollection) {
                ArrayList<String> rowData = new ArrayList<String>();
                String pkId = dynamicObject.getString(refEntityType.getPrimaryKey().getName());
                rowData.add(pkId);
                String billNo = dynamicObject.getString(refEntityType.getBillNo());
                rowData.add(billNo);
                data.add(rowData);
            }
            data2Client.put("data", data);
            data2Client.put("next", !dynamicObjectCollection.isEmpty() && dynamicObjectCollection.size() >= 20);
            data2Client.put("k", fieldName);
            data2Client.put("size", 20);
            if (filterColumn instanceof SchemeFilterColumn) {
                data2Client.put("aliasindex", 1);
            }
            ((IClientViewProxy)this.getView().getService(IClientViewProxy.class)).invokeControlMethod(this.getKey(), "setLookUpListValue", new Object[]{data2Client});
        }
    }

    @SdkInternal
    public void fieldValueClick(String entityId, String fieldName, String compareTypeId, int clientType, int rowIndex, List<Map<String, List<Object>>> filter) {
        String showEntityId = entityId;
        if (showEntityId == null) {
            showEntityId = "bos_multitext";
        }
        this.initContainer();
        FilterColumn filterColumn = this.createFilterControlHelper().getFilterColumn(fieldName, SchemeFilterView.class);
        if (filterColumn == null) {
            throw new KDBizException(BosErrorCode.fieldNotExist, new Object[]{this.getEntityType().getName(), String.format(ResManager.loadKDString((String)"%1$s\uff0c\u9519\u8bef\u4ee3\u7801: %2$s", (String)"FilterColumn_1", (String)BOSFORMCORE, (Object[])new Object[0]), fieldName, "FIELDNOTEXISTS000007")});
        }
        if ("text".equals(filterColumn.getFilterControlType()) || filterColumn instanceof FlexPropSchemeFilterColumn && "text".equals(filterColumn.getType())) {
            if (filterColumn instanceof FlexPropSchemeFilterColumn && "text".equals(filterColumn.getType())) {
                showEntityId = "bos_multitext";
            }
            Object value = this.getValueByFieldName(fieldName, filter, rowIndex);
            FormShowParameter lsp = new FormShowParameter();
            lsp.setFormId(showEntityId);
            lsp.getOpenStyle().setShowType(ShowType.Modal);
            lsp.setCustomParam("params", value);
            lsp.setCaption(filterColumn.getCaption().toString());
            CloseCallBack closeCallBack = new CloseCallBack();
            closeCallBack.setControlKey(this.getKey());
            closeCallBack.setActionId("text$" + clientType + "$" + rowIndex + "$" + fieldName);
            lsp.setCloseCallBack(closeCallBack);
            this.view.showForm(lsp);
        }
    }

    private void initContainer() {
        this.setMetadata();
        this.initFilterGridView();
        this.pluginInit();
    }

    private Object getValueByFieldName(String fieldName, List<Map<String, List<Object>>> filter, int rowindex) {
        Map row;
        String value = "";
        List filterRows = (List)((Object)filter.get(0));
        if (filterRows != null && ((List)(row = (Map)filterRows.get(rowindex)).get(FIEIDNAME)).get(0).equals(fieldName)) {
            value = row.get(VALUE);
        }
        return value;
    }

    @SdkInternal
    public void closedCallBack(ClosedCallBackEvent e) {
        String[] actionIds = e.getActionId().split("\\$");
        if ("shareScheme".equals(actionIds[0])) {
            if (actionIds.length > 2) {
                this.setBillFormId(actionIds[2]);
                this.initContainer();
            }
            FilterScheme filterScheme = this.getFilterModel().getScheme(actionIds[1]);
            FilterSchemeUIProxy.checkFilterSchemeNull((FilterScheme)filterScheme);
            this.clientViewProxy.invokeControlMethod(this.getKey(), "updateScheme", new Object[]{FilterSchemeService.createSchemeMap((FilterScheme)filterScheme, (boolean)false, (SchemeCodeType)SchemeCodeType.BASE64)});
        } else if ("text".equals(actionIds[0])) {
            this.closeCallBackForText(e, actionIds);
        } else if (REF_BILL_CALLBACK_PREFIX.equalsIgnoreCase(actionIds[0])) {
            this.closeCallBackForRefBill(e, actionIds);
        } else {
            FilterControlHelper filterControlHelper = this.createFilterControlHelper();
            String clientMethodName = actionIds[4];
            if ("setCommonF7Value".equals(clientMethodName)) {
                this.selectedCommomFilterFieldName = filterControlHelper.getSelectedCommomFilterFieldName();
                this.selectedCommomFilterFieldValues = filterControlHelper.getSelectedCommomFilterFieldValues();
            }
            filterControlHelper.closeCallBackForBaseData(e, actionIds);
        }
    }

    private void closeCallBackForText(ClosedCallBackEvent e, String[] actionIds) {
        Object value = e.getReturnData();
        int clientType = Integer.parseInt(actionIds[1]);
        int rowIndex = Integer.parseInt(actionIds[2]);
        String fieldName = actionIds[3];
        IClientViewProxy viewProxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        HashMap<String, Object> clientMeta = new HashMap<String, Object>();
        clientMeta.put("fieldName", fieldName);
        clientMeta.put("clientType", clientType);
        clientMeta.put("rowIndex", rowIndex);
        value = this.convertMultiValueToArray(value);
        clientMeta.put(VALUE2, value);
        viewProxy.invokeControlMethod(this.key, "setF7Value", new Object[]{clientMeta});
    }

    private Object convertMultiValueToArray(Object value) {
        if (value == null || "".equals(value.toString().trim())) {
            return "";
        }
        String s = value.toString().trim();
        s = s.replaceAll(",", "\n");
        String[] array = s.split("\n");
        return array;
    }

    private void fireFilterSearchClickByCache(Map<String, List<Map<String, List<Object>>>> filterValues, String entryEntity, Function<List<FilterColumn>, List<FilterColumn>> filterColumnFilterFunction) {
        this.clearSelection();
        this.setMetadata();
        this.filterSearchClick(filterValues, entryEntity, filterColumnFilterFunction, null);
    }

    private Map<String, List<Map<String, List<Object>>>> loadSchemeList(List<FilterScheme> filterSchemes, List<EntryEntityDto> fixedEntryEntityDtos, String firstEntryEntity) {
        Map<String, List<Map<String, List<Object>>>> filterValues = new HashMap<String, List<Map<String, List<Object>>>>();
        FilterScheme defaultScheme = FilterSchemeService.getDefaultScheme(filterSchemes, (String)this.schemeId);
        if (defaultScheme != null) {
            FilterSchemeService.initFilterSchemesToDefaultToFalseById(filterSchemes, (FilterScheme)defaultScheme);
            if (fixedEntryEntityDtos.size() <= 2 || !fixedEntryEntityDtos.contains(new EntryEntityDto(defaultScheme.getEntryEntity()))) {
                this.getContext().setEntryEntity(firstEntryEntity);
                defaultScheme.setEntryEntity(firstEntryEntity);
            }
            filterValues = this.buildSchemeFilterValues(null, (List)SerializationUtils.deSerializeFromBase64((String)defaultScheme.getScheme()), defaultScheme.getEntryEntity());
            this.setSchemeId(defaultScheme);
        }
        return filterValues;
    }

    @Deprecated
    @SdkInternal
    public void clearFast() {
        this.clientViewProxy.invokeControlMethod(this.getKey(), "clearFast", new Object[0]);
    }

    private String getFormId() {
        return this.getBillFormId() == null ? this.getEntityId() : this.getBillFormId();
    }

    @SdkInternal
    public void loadScheme(String schemeId) {
        FilterScheme filterScheme = this.getFilterModel().load(schemeId);
        FilterSchemeUIProxy.checkFilterSchemeNull((FilterScheme)filterScheme);
        Map scheme = (Map)SerializationUtils.fromJsonString((String)SerializationUtils.toJsonString((Object)filterScheme), Map.class);
        List schemeRows = (List)SerializationUtils.deSerializeFromBase64((String)scheme.get(SCHEME).toString());
        this.schemeSearch(null, schemeRows, filterScheme.getEntryEntity());
        this.clientViewProxy.invokeControlMethod(this.getKey(), "loadScheme", new Object[]{scheme});
    }

    @SdkInternal
    public void setDefaultScheme(String schemeId, boolean isDefault) {
        FilterSchemeUIProxy filterSchemeUIProxy = this.createFilterSchemeUIProxy();
        SchemeQuery schemeQuery = new SchemeQuery();
        FilterScheme filterScheme = schemeQuery.getScheme(schemeId);
        this.checkFilterSchemeNull(filterScheme);
        if (this.isLookUp()) {
            filterSchemeUIProxy.setF7DefaultScheme(schemeId, isDefault);
            filterSchemeUIProxy.setDefaultSchemeForShared(isDefault, schemeId);
        } else {
            filterSchemeUIProxy.setDefaultScheme(schemeId, isDefault);
            filterSchemeUIProxy.setDefaultSchemeForShared(isDefault, schemeId);
        }
    }

    private void checkFilterSchemeNull(FilterScheme fScheme) {
        if (fScheme == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u65b9\u6848\u5df2\u4e0d\u5b58\u5728\uff0c\u8bf7\u5237\u65b0\u9875\u9762\u3002", (String)"FilterContainer_19", (String)BOSFORMCORE, (Object[])new Object[0]));
        }
    }

    private FilterSchemeUIProxy createFilterSchemeUIProxy() {
        FilterSchemeUIProxy filterSchemeUIProxy = new FilterSchemeUIProxy(this.getView(), this.getFilterModel(), this.getFormId(), this.getKey(), this.getFieldCompareTypeMap(), this.getBillFormId());
        filterSchemeUIProxy.setLookUp(this.isLookUp());
        return filterSchemeUIProxy;
    }

    @SdkInternal
    public void saveScheme(Map<String, Object> filterSchemeMap) {
        this.isKeepSchemeId = true;
        this.isSaveScheme = true;
        this.setMetadata();
        this.initFilterGridView();
        List schemeRows = (List)filterSchemeMap.get(SCHEME);
        FilterControlHelper filterControlHelper = this.createFilterControlHelper(this.initFilterModel(this.createFilterModel()), new ControlContext(new FilterControlContext()));
        filterControlHelper.buildSchemeFilter(null, schemeRows);
        if (this.checkInputEmpty(filterControlHelper)) {
            return;
        }
        FilterSchemeUIProxy filterSchemeUIProxy = this.createFilterSchemeUIProxy();
        filterSchemeMap.put("f7", this.isLookUp());
        filterSchemeUIProxy.saveScheme(filterSchemeMap, t -> {
            IListSortSetting listSortSetting;
            IFormView listSortView;
            String listSortPageId;
            IListColumnsSetting listColumnsSetting;
            IFormView listColumnsView;
            this.setSchemeId(t.getFilterScheme());
            String listColumnsPageId = this.getListCache().getListColumnSettingPageId();
            if (listColumnsPageId != null && (listColumnsView = this.getView().getView(listColumnsPageId)) != null && (listColumnsSetting = this.getListColumnsSetting(listColumnsView)) != null) {
                listColumnsSetting.saveListColumnsSetting(t.getSchemeId());
            }
            if ((listSortPageId = this.getListCache().getListSortSettingPageId()) != null && (listSortView = this.getView().getView(listSortPageId)) != null && (listSortSetting = this.getListSortSetting(listSortView)) != null) {
                listSortSetting.saveSortSetting(t.getSchemeId());
            }
        }, f -> {
            try (EntityTraceSpan span = EntityTracer.create((String)"list", (String)"FilterContainer.saveScheme");){
                Iterator<SchemeValidateListener> iterator = this.schemeValidateListeners.iterator();
                while (iterator.hasNext()) {
                    SchemeValidateListener schemeValidateListener = iterator.next();
                    if (span.isRealtime()) {
                        span.addLocaleTag("FilterSchemeDto::before", f);
                    }
                    if (!schemeValidateListener.validate(f)) {
                        this.isSchemeValidate = false;
                        Boolean bl = false;
                        return bl;
                    }
                    if (!span.isRealtime()) continue;
                    span.addLocaleTag("FilterSchemeDto::after", f);
                }
                return true;
            }
            catch (Exception e) {
                this.isSchemeValidate = false;
                throw e;
            }
        });
    }

    private IListColumnsSetting getListColumnsSetting(IFormView editForm) {
        FormViewPluginProxy pluginProxy = (FormViewPluginProxy)editForm.getService(FormViewPluginProxy.class);
        IListColumnsSetting listColumnsSetting = null;
        for (IFormPlugin plugin : pluginProxy.getPlugIns()) {
            if (!(plugin instanceof IListColumnsSetting)) continue;
            listColumnsSetting = (IListColumnsSetting)plugin;
            break;
        }
        return listColumnsSetting;
    }

    private IListSortSetting getListSortSetting(IFormView editForm) {
        FormViewPluginProxy pluginProxy = (FormViewPluginProxy)editForm.getService(FormViewPluginProxy.class);
        IListSortSetting listSortSetting = null;
        for (IFormPlugin plugin : pluginProxy.getPlugIns()) {
            if (!(plugin instanceof IListSortSetting)) continue;
            listSortSetting = (IListSortSetting)plugin;
            break;
        }
        return listSortSetting;
    }

    @SdkInternal
    public void deleteScheme(String schemeId) {
        FilterSchemeUIProxy filterSchemeUIProxy = this.createFilterSchemeUIProxy();
        filterSchemeUIProxy.deleteScheme(schemeId);
    }

    @SdkInternal
    public void shareScheme(String schemeId) {
        FilterSchemeUIProxy filterSchemeUIProxy = this.createFilterSchemeUIProxy();
        if (this.isLookUp()) {
            filterSchemeUIProxy.shareF7Scheme(schemeId);
        } else {
            filterSchemeUIProxy.shareScheme(schemeId);
        }
    }

    @SdkInternal
    public void updateShareScheme(String schemeId) {
        FilterSchemeUIProxy filterSchemeUIProxy = this.createFilterSchemeUIProxy();
        if (this.isLookUp()) {
            filterSchemeUIProxy.updateF7ShareScheme(schemeId);
        } else {
            filterSchemeUIProxy.updateShareScheme(schemeId);
        }
    }

    @SdkInternal
    public void nlpSearch(String searchContent) {
        this.setMetadata();
        this.initFilterGridView();
        this.pluginInit();
        Object url = null;
        HashMap params = new HashMap();
        String result = null;
        try {
            result = ViewCommonUtil.analysisSearch2Sql(this.getBillFormId(), searchContent);
            NlpAnalysisHttpResponse analysisHttpResponse = (NlpAnalysisHttpResponse)SerializationUtils.fromJsonString((String)result, NlpAnalysisHttpResponse.class);
            List filterResultBeanList = null;
            if (Objects.nonNull(analysisHttpResponse) && analysisHttpResponse.getErrcode() == 0) {
                Map<String, FilterColumn> columnNames = this.getColumnName();
                Map<String, CompareType> allCustomFields = this.getAllCustomFields();
                filterResultBeanList = analysisHttpResponse.getData().getFilter();
                for (NlpAnalysisHttpResponse.DataBean.FilterBean filterBean : filterResultBeanList) {
                    ArrayList<String> valueList = new ArrayList<String>(10);
                    List wordList = filterBean.getValue();
                    if (!wordList.isEmpty() && StringUtils.isNotEmpty((CharSequence)((CharSequence)wordList.get(0)))) {
                        wordList.forEach(word -> {
                            String convertValue = this.convertDescToCompare((String)word, (FilterColumn)((Object)((Object)columnNames.get(filterBean.getField()))));
                            valueList.add(convertValue);
                        });
                    } else if ("$".equalsIgnoreCase(filterBean.getCp())) {
                        String id = filterBean.getId();
                        filterBean.setCp(id);
                        CompareType type = allCustomFields.get(id);
                        if (type != null) {
                            valueList.add(id);
                        }
                    }
                    filterBean.setValue(valueList);
                }
                analysisHttpResponse.getData().setSearchContent(searchContent);
                this.clientViewProxy.invokeControlMethod(this.getKey(), "nlpSearch", new Object[]{analysisHttpResponse.getData()});
                return;
            }
            log.info(String.format("NLP word segmentation is abnormal,request url:%1$s, searchContent:%2$s, result:%3$s", url, searchContent, result));
        }
        catch (Exception e) {
            log.warn(this.fillAppid(String.format("NLP\u5206\u8bcd\u5f02\u5e38: \u8bf7\u6c42URL: %1$s, params:%2$s, result:%3$s", url, SerializationUtils.toJsonString(params), result)), (Throwable)e);
        }
        this.clientViewProxy.invokeControlMethod(this.getKey(), "nlpSearch", new Object[]{""});
    }

    private String convertDescToCompare(String word, FilterColumn filterColumn) {
        if (word == null || filterColumn == null) {
            return word;
        }
        String[] result = new String[1];
        List<ComboItem> comboItems = ((SchemeFilterColumn)filterColumn).getComboItems();
        String type = filterColumn.getType();
        if (comboItems != null && comboItems.size() > 0) {
            comboItems.forEach(comboItem -> {
                if (comboItem.getCaption().getLocaleValue().equals(word)) {
                    result[0] = comboItem.getValue();
                }
            });
        } else {
            String format;
            result[0] = "date".equalsIgnoreCase(type) || "time".equalsIgnoreCase(type) || "dateTime".equalsIgnoreCase(type) ? (format = this.sdf.format(KDDateUtils.parseDate((String)word))) : word;
        }
        return result[0];
    }

    private Map<String, CompareType> getMetaCompareType() {
        HashMap<String, CompareType> result = new HashMap<String, CompareType>();
        FilterMetadata.get().getCompareCategories().stream().flatMap(compareCategory -> compareCategory.getCompareTypes().stream()).forEach(compareType -> result.put(String.format("%s%s", compareType.getId(), compareType.getOperate()), (CompareType)compareType));
        return result;
    }

    private Map<String, FilterColumn> getColumnName() {
        Map<String, FilterColumn> result = new HashMap<String, FilterColumn>();
        try {
            SchemeFilterView filterView = (SchemeFilterView)this.getItems().get(2);
            result = filterView.getFilterColumns().stream().collect(Collectors.toMap(FilterColumn::getFieldName, value -> value, (filterColumn, filterColumn2) -> filterColumn));
        }
        catch (Exception e) {
            log.error(this.fillAppid(e.getMessage()));
        }
        return result;
    }

    private Map<String, CompareType> getAllCustomFields() {
        HashMap<String, CompareType> customField = new HashMap<String, CompareType>(16);
        Set<FilterColumn> thisFilterColumns = this.getFilterColumns();
        if (thisFilterColumns != null) {
            for (FilterColumn filterColumn : thisFilterColumns) {
                try {
                    Set<CompareType> customCompareTypes = filterColumn.getCustomCompareTypes();
                    if (customCompareTypes == null) continue;
                    for (CompareType compareType : customCompareTypes) {
                        customField.put(compareType.getId(), compareType);
                    }
                }
                catch (Exception e) {
                    log.error((Throwable)e);
                }
            }
        }
        return customField;
    }

    @SdkInternal
    public NlpAnalysisHttpRequest.EntityMeta buildEntityMeta(Map<String, Object> clientMeta, boolean needCompareType) {
        Map columns = (Map)clientMeta.get(SCHEME);
        ArrayList conditions = (ArrayList)columns.get("conditions");
        NlpAnalysisHttpRequest.EntityMeta entityMeta = new NlpAnalysisHttpRequest.EntityMeta();
        entityMeta.setFieldCaption(this.entityId);
        if (StringUtils.isBlank((Object)this.title)) {
            entityMeta.setName(FormMetadataCache.getFormConfig((String)this.getBillFormId()).getCaption().getLocaleValue());
        } else {
            entityMeta.setName(this.title.getLocaleValue());
        }
        ArrayList<NlpAnalysisHttpRequest.EntityMeta.FieldBean> fieldBeanList = new ArrayList<NlpAnalysisHttpRequest.EntityMeta.FieldBean>(20);
        for (Object condition : conditions) {
            if (!(condition instanceof HashMap)) continue;
            HashMap conditionMap = (HashMap)condition;
            String metaDataType = (String)conditionMap.get("type");
            String metaDataEntityId = (String)conditionMap.get("entityId");
            String metaType = metaDataType != null && "basedata".contains(metaDataType) || "user".equals(metaDataType) ? metaDataEntityId : metaDataType;
            NlpAnalysisHttpRequest.EntityMeta.FieldBean fieldBean = new NlpAnalysisHttpRequest.EntityMeta.FieldBean((String)conditionMap.get("fieldName"), (LocaleString)conditionMap.get("fieldCaption"), metaType, (List)((ArrayList)conditionMap.get("items")), needCompareType ? (ArrayList)conditionMap.get("compareTypes") : null);
            fieldBeanList.add(fieldBean);
        }
        entityMeta.setField(fieldBeanList);
        return entityMeta;
    }

    private String fillAppid(String data) {
        String appid = this.getView().getFormShowParameter().getAppId();
        return String.format("appid:%s, %s", appid, data);
    }

    void savePageCache() {
        this.getListCache().savePageCache();
    }

    @SdkInternal
    public void postBack(Object value) {
        Map state = (Map)value;
        if (!this.isSaveScheme && state.get(SCHEMEID) != null) {
            String schemeId = state.get(SCHEMEID).toString();
            this.getContext().setArchiveKey(state.get(SCHEMEID).toString());
            FilterScheme scheme = this.getFilterModel().getScheme(schemeId);
            this.setSchemeId(scheme);
            this.isKeepSchemeId = true;
        }
        if (state.get(ARCHIVEKEY) != null) {
            String archiveKey = state.get(ARCHIVEKEY).toString();
            this.getContext().setArchiveKey(state.get(ARCHIVEKEY).toString());
            this.getListCache().putArchiveKey(archiveKey);
        }
        if (state.get(SCHEMEID) != null || state.get(ARCHIVEKEY) != null) {
            this.savePageCache();
        }
        if (state.get(TRIGGERSEARCH) != null) {
            this.getContext().getFilterControlContext().setTriggerSearch(Boolean.parseBoolean(state.get(TRIGGERSEARCH).toString()));
        }
    }
}

