/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.filter;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.context.RequestContext;
import kd.bos.data.BusinessDataWriter;
import kd.bos.data.PkSnapshotFactory;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.PkSnapshotSet;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.clr.DataEntityType;
import kd.bos.dataentity.privacy.PrivacyCenterUtils;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlParameter;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IFilterModel;
import kd.bos.entity.filter.CompareType;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.filter.FilterField;
import kd.bos.entity.filter.FilterMetadata;
import kd.bos.entity.filter.FilterModelContext;
import kd.bos.entity.filter.FilterObject;
import kd.bos.entity.filter.FilterParameter;
import kd.bos.entity.filter.FilterRow;
import kd.bos.entity.filter.FilterScheme;
import kd.bos.entity.filter.FilterSchemeL;
import kd.bos.entity.filter.FilterUtil;
import kd.bos.entity.filter.LocaleFilterScheme;
import kd.bos.entity.filter.OrderByField;
import kd.bos.entity.filter.OrderByParameter;
import kd.bos.entity.filter.SchemeShareUser;
import kd.bos.entity.filter.ShareFilterScheme;
import kd.bos.entity.filter.SortObject;
import kd.bos.entity.filter.SortType;
import kd.bos.entity.property.BillStatusProp;
import kd.bos.entity.property.MainOrgProp;
import kd.bos.exception.KDBizException;
import kd.bos.list.ViewCommonUtil;
import kd.bos.list.query.SchemeQuery;
import kd.bos.list.query.SchemeWriter;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.sequence.SequenceReader;
import kd.bos.param.ParameterReader;
import kd.bos.util.CollectionUtils;
import kd.sdk.annotation.SdkPublic;
import org.jetbrains.annotations.NotNull;

@SdkPublic
public class FilterModel
implements IFilterModel {
    private MainEntityType dataType;
    private String formId;
    private FilterObject filterObject;
    private SortObject sortObject;
    private List<Long> selectedMainOrgIds = new ArrayList<Long>();
    private Map<String, Object> selectedValues = new HashMap<String, Object>();
    private boolean is_ContainMainOrg;
    private boolean is_MainOrgNoLimit;
    private boolean is_ContainBillStatus;
    private boolean is_ContainUsedStatus;
    private Map<String, List<CompareType>> fieldCompareTypeMap = new HashMap<String, List<CompareType>>();
    private static final String FIELD_NAME = "FieldName";
    private static final String RIGHT = "Right";
    private static final String LEFT = "Left";
    private static final String LOGIC = "Logic";
    private static final String BOS_FORM_CORE = "bos-form-core";
    private static final String VALUE = "Value";
    private FilterModelContext filterModelContext;

    public Map<String, List<CompareType>> getFieldCompareTypeMap() {
        return this.fieldCompareTypeMap;
    }

    public void setFieldCompareTypeMap(Map<String, List<CompareType>> fieldCompareTypeMap) {
        this.fieldCompareTypeMap = fieldCompareTypeMap;
    }

    public boolean isContainMainOrg() {
        return this.is_ContainMainOrg;
    }

    public boolean isMainOrgNoLimit() {
        return this.is_MainOrgNoLimit;
    }

    public boolean isContainBillStatus() {
        return this.is_ContainBillStatus;
    }

    public boolean isContainUsedStatus() {
        return this.is_ContainUsedStatus;
    }

    public Map<String, Object> getSelectedValues() {
        return this.selectedValues;
    }

    public List<Long> getSelectedMainOrgIds() {
        return this.selectedMainOrgIds;
    }

    public MainEntityType getDataType() {
        return this.dataType;
    }

    public void setDataType(MainEntityType dataType) {
        this.dataType = dataType;
    }

    public String getFormId() {
        return this.formId;
    }

    public void setFormId(String formId) {
        this.formId = formId;
    }

    public SortObject getSortObject() {
        return this.sortObject;
    }

    public void setSortObject(SortObject sortObject) {
        this.sortObject = sortObject;
    }

    public FilterModel() {
        this.filterObject = new FilterObject();
        this.sortObject = new SortObject();
        this.filterObject.setFilterMetaData(FilterMetadata.get());
    }

    private void setFastSetting(List<Map<String, List<Object>>> fastFilterList, List<QFilter> matchQFilters) {
        this.filterObject.getFilterRows().clear();
        if (fastFilterList != null && !fastFilterList.isEmpty()) {
            for (int i = 0; i < fastFilterList.size(); ++i) {
                Map<String, List<Object>> dct = fastFilterList.get(i);
                List<Object> filterNames = dct.get(FIELD_NAME);
                List<Object> valueList = dct.get(VALUE);
                List newValueList = FilterUtil.getValidValues(valueList);
                if (newValueList.isEmpty() || filterNames.isEmpty()) continue;
                ArrayList<String> fullFilterNames = new ArrayList<String>(10);
                for (Object filterName : filterNames) {
                    FilterField filterField = FilterBuilder.getFilterField((FilterObject)this.filterObject, (String)filterName.toString());
                    fullFilterNames.add(filterField.getFullFieldName());
                }
                int maxLikeLimits = Integer.getInteger("listQuery.maxLikeLimits", 5);
                int n = maxLikeLimits = maxLikeLimits > 100 ? 100 : maxLikeLimits;
                if (newValueList.size() > maxLikeLimits) {
                    QFilter qFilter = null;
                    for (String filterName : fullFilterNames) {
                        if (qFilter == null) {
                            qFilter = new QFilter(filterName, "in", (Object)newValueList);
                            continue;
                        }
                        qFilter.or(new QFilter(filterName, "in", (Object)newValueList));
                    }
                    matchQFilters.add(qFilter);
                    continue;
                }
                Map pubSysParam = ParameterReader.loadBillParameterObjectFromCache((String)this.getDataType().getName());
                String searchtype = pubSysParam != null ? (String)pubSysParam.get("searchtype") : "1";
                ArrayList<String> encryptFields = new ArrayList<String>(6);
                fullFilterNames = new ArrayList(fullFilterNames);
                Iterator iterator = fullFilterNames.iterator();
                while (iterator.hasNext()) {
                    boolean isEncrypt;
                    String searchField = (String)iterator.next();
                    IDataEntityProperty prop = null;
                    FilterField filterField = FilterField.create((MainEntityType)this.dataType, (String)searchField);
                    if (filterField != null) {
                        prop = filterField.getFieldProp();
                    }
                    if (!(isEncrypt = PrivacyCenterUtils.isEncryptField(prop))) continue;
                    iterator.remove();
                    encryptFields.add(searchField);
                }
                QFilter qFilter = QFilter.ftlike((boolean)"2".equals(searchtype), (String[])newValueList.toArray(new String[0]), (String[])fullFilterNames.toArray(new String[0]));
                for (String encryptField : encryptFields) {
                    qFilter.or(new QFilter(encryptField, "=", (Object)newValueList));
                }
                matchQFilters.add(qFilter);
            }
        }
    }

    private FilterRow getFilterRowByCompareType(String fieldName, List<String> newCompareList, List<String> newValueList, FilterField filterField, String left, String right, String logic) {
        FilterRow filterRow = null;
        int index = 0;
        for (String compare : newCompareList) {
            CompareType compareType = FilterBuilder.getCompareType((String)fieldName, (FilterField)filterField, (String)compare.toString(), this.fieldCompareTypeMap);
            if (compareType == null) {
                ++index;
                continue;
            }
            ArrayList<String> constantValueList = new ArrayList<String>();
            constantValueList.add(newValueList.get(index++));
            filterRow = new FilterRow(filterField.getMainType(), this.filterObject, filterField, left, compareType, constantValueList, right, FilterBuilder.getFiledLogic((Object)logic));
        }
        return filterRow;
    }

    private FilterRow getFilterRowByDefaultCompareType(String fieldName, List<Object> valueList, List<String> newValueList, FilterField filterField, String left, String right, String logic) {
        CompareType compareType;
        FilterRow filterRow = null;
        if (filterField.getFieldType() == 91 || filterField.getFieldType() == 92 || filterField.getFieldType() == 93) {
            if (valueList.size() == 2) {
                if (newValueList.size() != 2) {
                    return null;
                }
                compareType = filterField.getDefaultMultiCompareType();
            } else {
                compareType = FilterBuilder.getCompareType((String)fieldName, (FilterField)filterField, (String)valueList.get(0).toString(), this.fieldCompareTypeMap);
            }
        } else {
            compareType = newValueList.size() > 1 ? filterField.getDefaultMultiCompareType() : filterField.getDefaultCompareType();
        }
        if (compareType == null) {
            return null;
        }
        filterRow = new FilterRow(filterField.getMainType(), this.filterObject, filterField, left, compareType, newValueList, right, FilterBuilder.getFiledLogic((Object)logic));
        return filterRow;
    }

    private void parseMainOrgFilter(MainOrgProp mainOrgProp, FilterField filterField, List<Object> valueList, List<String> newValueList) {
        block8: {
            String dimFldKey;
            block7: {
                boolean isUseDimField;
                dimFldKey = this.getDataType().getPermissionControlType().getDataDimensionField();
                boolean isControlFuction = this.getDataType().getPermissionControlType().isControlFunction();
                boolean bl = isUseDimField = isControlFuction && StringUtils.isNotBlank((CharSequence)dimFldKey) && !"null".equals(dimFldKey);
                if (isUseDimField) break block7;
                if (mainOrgProp == null || !filterField.getSrcFieldProp().getName().equals(mainOrgProp.getName())) break block8;
                this.is_ContainMainOrg = true;
                if (newValueList.isEmpty()) {
                    this.is_MainOrgNoLimit = true;
                }
                if (!valueList.isEmpty() && StringUtils.isNotBlank((CharSequence)valueList.get(0).toString())) {
                    for (Object value : valueList) {
                        this.selectedMainOrgIds.add(Long.parseLong(value.toString()));
                    }
                }
                break block8;
            }
            if (filterField.getSrcFieldProp().getName().equals(dimFldKey)) {
                this.is_ContainMainOrg = true;
                if (newValueList.isEmpty()) {
                    this.is_MainOrgNoLimit = true;
                }
                if (!valueList.isEmpty() && StringUtils.isNotBlank((CharSequence)valueList.get(0).toString())) {
                    for (Object value : valueList) {
                        this.selectedMainOrgIds.add(Long.parseLong(value.toString()));
                    }
                }
            }
        }
    }

    private void addFilterRows(FilterRow filterRow, FilterField filterField) {
        List newFilterRows = FilterBuilder.convertIsNullFilterRow((FilterRow)filterRow, (FilterObject)this.filterObject, (FilterField)filterField);
        if (!newFilterRows.isEmpty()) {
            this.filterObject.getFilterRows().addAll(newFilterRows);
        } else {
            this.filterObject.getFilterRows().add(filterRow);
        }
    }

    private FilterRow getFilterRowByMap(FilterField filterField, Map<String, List<Object>> dct, List<Object> valueList, List<String> newValueList) {
        String right;
        String left;
        FilterRow filterRow = null;
        String string = dct.get(LEFT) == null ? "" : (left = dct.get(LEFT).get(0) == null ? "" : dct.get(LEFT).get(0).toString());
        String string2 = dct.get(RIGHT) == null ? "" : (right = dct.get(RIGHT).get(0) == null ? "" : dct.get(RIGHT).get(0).toString());
        String logic = dct.get(LOGIC) == null ? "0" : (dct.get(LOGIC).get(0) == null ? "0" : dct.get(LOGIC).get(0).toString());
        List<Object> compareList = dct.get("Compare");
        List newCompareList = FilterUtil.getValidValues(compareList);
        if (!newCompareList.isEmpty()) {
            if (newCompareList.size() == 1 && CollectionUtils.isNotEmpty(valueList) && valueList.size() > 1 && CollectionUtils.isNotEmpty(newValueList) && newValueList.equals(valueList)) {
                CompareType compareType = FilterBuilder.getCompareType((String)dct.get(FIELD_NAME).get(0).toString(), (FilterField)filterField, (String)((String)newCompareList.get(0)), this.fieldCompareTypeMap);
                filterRow = new FilterRow(filterField.getMainType(), this.filterObject, filterField, left, compareType, newValueList, right, FilterBuilder.getFiledLogic((Object)logic));
            } else {
                filterRow = this.getFilterRowByCompareType(dct.get(FIELD_NAME).get(0).toString(), newCompareList, newValueList, filterField, left, right, logic);
            }
        } else {
            filterRow = this.getFilterRowByDefaultCompareType(dct.get(FIELD_NAME).get(0).toString(), valueList, newValueList, filterField, left, right, logic);
        }
        return filterRow;
    }

    private void parseCommonSettingRow(Map<String, List<Object>> dct, MainOrgProp mainOrgProp, BillStatusProp billStatusProp) {
        FilterField filterField = FilterBuilder.getFilterField((FilterObject)this.filterObject, (String)dct.get(FIELD_NAME).get(0).toString());
        FilterRow filterRow = null;
        if (filterField != null) {
            List<Object> valueList = dct.get(VALUE);
            List newValueList = FilterUtil.getValidValues(valueList);
            this.parseMainOrgFilter(mainOrgProp, filterField, valueList, newValueList);
            if (billStatusProp != null && StringUtils.isNotBlank((Object)filterField.getSrcFieldProp()) && filterField.getSrcFieldProp().getName().equals(billStatusProp.getName())) {
                this.is_ContainBillStatus = true;
            }
            if (this.dataType instanceof BillEntityType && StringUtils.isNotBlank((Object)filterField.getSrcFieldProp()) && "enable".equalsIgnoreCase(filterField.getSrcFieldProp().getName())) {
                this.is_ContainUsedStatus = true;
            }
            if (newValueList.isEmpty()) {
                return;
            }
            filterRow = this.getFilterRowByMap(filterField, dct, valueList, newValueList);
        }
        if (filterRow != null) {
            boolean isUseDimField;
            String dimFldKey = this.getDataType().getPermissionControlType().getDataDimensionField();
            boolean isControlFuction = this.getDataType().getPermissionControlType().isControlFunction();
            boolean bl = isUseDimField = isControlFuction && StringUtils.isNotBlank((CharSequence)dimFldKey) && !"null".equals(dimFldKey);
            if (!isUseDimField) {
                if (mainOrgProp != null && mainOrgProp.getName() != null && mainOrgProp.getName().equalsIgnoreCase(filterField.getSrcFieldProp().getName()) && this.is_ContainMainOrg) {
                    filterRow.setNeedParse(false);
                }
            } else if (filterField.getSrcFieldProp().getName().equals(dimFldKey) && this.is_ContainMainOrg) {
                filterRow.setNeedParse(false);
            }
            this.addFilterRows(filterRow, filterField);
        }
    }

    private void setCommonSetting(List<Map<String, List<Object>>> commonFilterList) {
        this.selectedMainOrgIds = new ArrayList<Long>(10);
        this.is_ContainMainOrg = false;
        this.is_MainOrgNoLimit = false;
        this.is_ContainBillStatus = false;
        this.is_ContainUsedStatus = false;
        this.filterObject.getFilterRows().clear();
        if (commonFilterList != null && !commonFilterList.isEmpty()) {
            MainOrgProp mainOrgProp = null;
            BillStatusProp billStatusProp = null;
            if (this.dataType instanceof BillEntityType) {
                BillEntityType billEntityType = (BillEntityType)this.dataType;
                mainOrgProp = billEntityType.getMainOrgProperty();
                if (StringUtils.isNotBlank((CharSequence)billEntityType.getBillStatus())) {
                    billStatusProp = (BillStatusProp)billEntityType.findProperty(billEntityType.getBillStatus());
                }
            }
            for (int i = 0; i < commonFilterList.size(); ++i) {
                Map<String, List<Object>> dct = commonFilterList.get(i);
                this.parseCommonSettingRow(dct, mainOrgProp, billStatusProp);
            }
        }
    }

    public List<FilterScheme> getSchemeList() {
        SchemeQuery schemeQuery = new SchemeQuery();
        return schemeQuery.getScheme(this.formId, RequestContext.get().getUserId());
    }

    public List<FilterScheme> getF7SchemeList() {
        SchemeQuery schemeQuery = new SchemeQuery();
        return schemeQuery.getF7Scheme(this.formId, RequestContext.get().getUserId());
    }

    public FilterScheme getScheme(String schemeId) {
        SchemeQuery schemeQuery = new SchemeQuery();
        return schemeQuery.getScheme(schemeId);
    }

    public List<FilterScheme> getSharedSchemeList() {
        SchemeQuery schemeQuery = new SchemeQuery();
        return schemeQuery.getSharedScheme(this.formId, RequestContext.get().getUserId());
    }

    public List<FilterScheme> getF7SharedSchemeList() {
        SchemeQuery schemeQuery = new SchemeQuery();
        return schemeQuery.getF7SharedScheme(this.formId, RequestContext.get().getUserId());
    }

    public Long getSharedSchemeId(String schemeId) {
        Long id = null;
        ORM orm = ORM.create();
        try (DataSet ds = orm.queryDataSet("FilterContainer.bos_share_filterscheme", "bos_share_filterscheme", "id", new QFilter[]{new QFilter("scheme", "=", (Object)schemeId)}, null, 1);){
            DynamicObjectCollection rows = orm.toPlainDynamicObjectCollection(ds);
            if (!rows.isEmpty() && rows.get(0) != null) {
                id = ((DynamicObject)rows.get(0)).getLong("id");
            }
        }
        return id;
    }

    public void clearScheme() {
        this.filterObject.clearFilterRow();
        this.sortObject.deleteSortRows();
    }

    public List<FilterScheme> getAllSchemeList() {
        SchemeQuery schemeQuery = new SchemeQuery();
        return schemeQuery.getSchemeList(this.formId);
    }

    private FilterScheme getFilterSchemeByName(String name) {
        return null;
    }

    public boolean isExistsScheme(String name) {
        FilterScheme scheme = this.getFilterSchemeByName(name);
        return scheme != null;
    }

    public void loadInitDefaultScheme() {
        FilterScheme dfscheme = this.getDefaultScheme();
        this.load(dfscheme.getId());
    }

    public FilterScheme load(String schemeId) {
        SchemeQuery schemeQuery = new SchemeQuery();
        return schemeQuery.getScheme(schemeId);
    }

    private FilterScheme getDefaultScheme() {
        return new FilterScheme();
    }

    public boolean saveScheme(FilterScheme filterScheme, StringBuilder errorMessage) {
        FilterScheme[] filterSchemes = new FilterScheme[]{filterScheme};
        return this.saveScheme(filterSchemes, false, errorMessage);
    }

    private boolean saveScheme(FilterScheme[] filterSchemes, Boolean isSetDefault, StringBuilder errorMessage) {
        try (TXHandle txHandle = TX.requiresNew((String)"savefilterscheme");){
            try {
                DataEntityType dataEntityType = (DataEntityType)OrmUtils.getDataEntityType(FilterScheme.class);
                for (FilterScheme filterScheme : filterSchemes) {
                    if (filterScheme.getId() != null) {
                        SchemeQuery schemeQuery = new SchemeQuery();
                        FilterScheme scheme = schemeQuery.getScheme(filterScheme.getId());
                        if (scheme == null) {
                            throw new KDBizException(ResManager.loadKDString((String)"\u65b9\u6848\u5df2\u4e0d\u5b58\u5728\uff0c\u8bf7\u5237\u65b0\u9875\u9762\u3002", (String)"FilterContainer_19", (String)BOS_FORM_CORE, (Object[])new Object[0]));
                        }
                        filterScheme.setUserId(scheme.getUserId());
                        filterScheme.setShare(scheme.isShare());
                        filterScheme.setFixed(scheme.isFixed());
                        if (!isSetDefault.booleanValue()) {
                            filterScheme.setDefault(scheme.isDefault());
                        }
                        filterScheme.setCreateTime(scheme.getCreateTime());
                        filterScheme.setSeq(scheme.getSeq());
                        filterScheme.setNextEntryScheme(scheme.isNextEntryScheme());
                        this.modifyFilterScheme(dataEntityType, filterScheme);
                    } else {
                        String schemeId = SequenceReader.getStringSequence((int)1)[0];
                        filterScheme.setId(schemeId);
                        if (filterScheme.getLocaleFilterScheme().isEmpty()) {
                            this.buildeFilterSchemeL(filterScheme, new String[]{"zh_CN", "en_US", "zh_TW"});
                        }
                        filterScheme.setCreateTime(new Date());
                    }
                    this.saveSchemeL(filterScheme.getLocaleFilterScheme().values().toArray(new FilterSchemeL[0]));
                }
                BusinessDataWriter.save((IDataEntityType)dataEntityType, (Object[])filterSchemes);
            }
            catch (Exception e) {
                errorMessage.append(e.getMessage());
                txHandle.markRollback();
                boolean bl = false;
                if (txHandle != null) {
                    if (var5_5 != null) {
                        try {
                            txHandle.close();
                        }
                        catch (Throwable throwable) {
                            var5_5.addSuppressed(throwable);
                        }
                    } else {
                        txHandle.close();
                    }
                }
                return bl;
            }
        }
        return true;
    }

    private void modifyFilterScheme(DataEntityType dataEntityType, FilterScheme filterScheme) {
        PkSnapshotSet pkSnapshotSet = new PkSnapshotSet();
        pkSnapshotSet.Snapshots.add(PkSnapshotFactory.createDataEntitiesSnapshot((DataEntityType)dataEntityType, (Object)filterScheme));
        dataEntityType.setPkSnapshot((Object)filterScheme, pkSnapshotSet);
        SchemeQuery schemeQuery = new SchemeQuery();
        LocaleFilterScheme fLs = schemeQuery.getSchemeL(filterScheme.getId());
        if (fLs.isEmpty()) {
            this.buildeFilterSchemeL(filterScheme, new String[]{"zh_CN", "en_US", "zh_TW"});
        } else {
            FilterSchemeL filterSchemeL = (FilterSchemeL)fLs.get((Object)RequestContext.get().getLang().toString());
            if (filterSchemeL == null) {
                this.buildeFilterSchemeL(filterScheme, new String[]{RequestContext.get().getLang().toString()});
            } else {
                if (StringUtils.isEmpty((CharSequence)filterSchemeL.getName())) {
                    filterSchemeL.setName(filterScheme.getSchemeName());
                }
                filterSchemeL.setDescription(filterScheme.getDescription());
                for (Map.Entry fEntry : fLs.entrySet()) {
                    ((FilterSchemeL)fEntry.getValue()).setSchemeId(filterScheme.getId());
                }
            }
        }
        filterScheme.setLocaleFilterScheme(fLs);
        filterScheme.setModifyTime(new Date());
    }

    private boolean saveSchemeL(FilterSchemeL[] filterSchemeLs) {
        DataEntityType dataEntityTypeL = (DataEntityType)OrmUtils.getDataEntityType(FilterSchemeL.class);
        for (FilterSchemeL filterSchemeL : filterSchemeLs) {
            if (filterSchemeL.getPkId() != null) {
                PkSnapshotSet pkSnapshotSet = new PkSnapshotSet();
                pkSnapshotSet.Snapshots.add(PkSnapshotFactory.createDataEntitiesSnapshot((DataEntityType)dataEntityTypeL, (Object)filterSchemeL));
                dataEntityTypeL.setPkSnapshot((Object)filterSchemeL, pkSnapshotSet);
                continue;
            }
            String schemeId = SequenceReader.getStringSequence((int)1)[0];
            filterSchemeL.setPkId(schemeId);
        }
        BusinessDataWriter.save((IDataEntityType)dataEntityTypeL, (Object[])filterSchemeLs);
        return true;
    }

    private void buildeFilterSchemeL(FilterScheme filterScheme, String[] lang) {
        for (String localeId : lang) {
            FilterSchemeL filterSchemeL = new FilterSchemeL();
            filterSchemeL.setId(filterScheme.getId());
            filterSchemeL.setSchemeId(filterScheme.getId());
            filterSchemeL.setLocaleId(localeId);
            filterSchemeL.setName(filterScheme.getSchemeName());
            filterSchemeL.setDescription(filterScheme.getDescription());
            filterScheme.getLocaleFilterScheme().setItem(localeId, (Object)filterSchemeL);
        }
    }

    public boolean updateScheme(String schemeId, boolean isDefault, StringBuilder errorMessage) {
        return this.updateScheme(schemeId, isDefault, errorMessage, false);
    }

    public boolean updateF7Scheme(String SchemeId, boolean isDefault, StringBuilder errorMessage) {
        return this.updateScheme(SchemeId, isDefault, errorMessage, true);
    }

    private boolean updateScheme(String schemeId, boolean isDefault, StringBuilder errorMessage, boolean isF7) {
        try {
            List<FilterScheme> filterSchemes = isF7 ? this.getF7SchemeList() : this.getSchemeList();
            for (FilterScheme filterScheme : filterSchemes) {
                if (schemeId.equals(filterScheme.getId()) && !filterScheme.isFixed()) {
                    filterScheme.setDefault(isDefault);
                    continue;
                }
                if (!isDefault) continue;
                filterScheme.setDefault(false);
            }
            this.saveScheme(filterSchemes.toArray(new FilterScheme[0]), true, errorMessage);
            return true;
        }
        catch (Exception e) {
            errorMessage.append(e.getMessage());
            return false;
        }
    }

    public boolean deleteScheme(String schemeid, StringBuilder errorMessage) {
        try {
            SchemeQuery schemeQuery = new SchemeQuery();
            LocaleFilterScheme localeFilterScheme = schemeQuery.getSchemeL(schemeid);
            ArrayList<String> fillterSchemeIds = new ArrayList<String>(10);
            for (Map.Entry entry : localeFilterScheme.entrySet()) {
                fillterSchemeIds.add(((FilterSchemeL)localeFilterScheme.get(entry.getKey())).getPkId());
            }
            ShareFilterScheme sharedScheme = schemeQuery.getSharedScheme(schemeid);
            if (sharedScheme != null) {
                List schemeShareUsers = schemeQuery.getSchemeShareUsers(sharedScheme.getId());
                ArrayList<Long> schemeShareUserIds = new ArrayList<Long>(10);
                for (SchemeShareUser schemeShareUser : schemeShareUsers) {
                    schemeShareUserIds.add(schemeShareUser.getPkId());
                }
                BusinessDataWriter.delete((IDataEntityType)OrmUtils.getDataEntityType(ShareFilterScheme.class), (Object[])new Object[]{sharedScheme.getId()});
                BusinessDataWriter.delete((IDataEntityType)OrmUtils.getDataEntityType(SchemeShareUser.class), (Object[])schemeShareUserIds.toArray());
            }
            BusinessDataWriter.delete((IDataEntityType)OrmUtils.getDataEntityType(FilterScheme.class), (Object[])new Object[]{schemeid});
            BusinessDataWriter.delete((IDataEntityType)OrmUtils.getDataEntityType(FilterSchemeL.class), (Object[])fillterSchemeIds.toArray());
            return true;
        }
        catch (Exception e) {
            errorMessage.append(e.getMessage());
            return false;
        }
    }

    public boolean deleteShareUser(String schemeid, StringBuilder errorMessage) {
        try {
            SchemeQuery schemeQuery = new SchemeQuery();
            ShareFilterScheme sharedScheme = schemeQuery.getSharedScheme(schemeid);
            if (sharedScheme != null) {
                List schemeShareUsers = schemeQuery.getSchemeShareUsers(sharedScheme.getId());
                ArrayList<Long> schemeShareUserIds = new ArrayList<Long>();
                for (SchemeShareUser schemeShareUser : schemeShareUsers) {
                    if (!RequestContext.get().getUserId().equals(Long.toString(schemeShareUser.getUserId()))) continue;
                    schemeShareUserIds.add(schemeShareUser.getPkId());
                }
                if (schemeShareUserIds.isEmpty()) {
                    errorMessage.append(ResManager.loadKDString((String)"\u65b9\u6848\u5df2\u4e0d\u5b58\u5728\uff0c\u8bf7\u5237\u65b0\u9875\u9762\u3002", (String)"FilterContainer_19", (String)BOS_FORM_CORE, (Object[])new Object[0]));
                    return false;
                }
                BusinessDataWriter.delete((IDataEntityType)OrmUtils.getDataEntityType(SchemeShareUser.class), (Object[])schemeShareUserIds.toArray());
                schemeShareUsers = schemeQuery.getSchemeShareUsers(sharedScheme.getId());
                if (schemeShareUsers.isEmpty()) {
                    SchemeWriter.deleteShareScheme((long)sharedScheme.getId());
                }
            }
            return true;
        }
        catch (Exception e) {
            errorMessage.append(e.getMessage());
            return false;
        }
    }

    public FilterParameter getFastFilterParameter(List<Map<String, List<Object>>> fastFilterList) {
        FilterParameter filterParameter;
        ArrayList<QFilter> matchQFilters = new ArrayList<QFilter>();
        if (ViewCommonUtil.checkCompare(fastFilterList)) {
            filterParameter = this.getSchemeFilterParameter(fastFilterList);
        } else {
            this.setFastSetting(fastFilterList, matchQFilters);
            this.buildFilter();
            ArrayList<String> selectFields = new ArrayList<String>(10);
            for (FilterRow filterRow : this.getFilterObject().getFilterRows()) {
                selectFields.add(filterRow.getFilterField().getFieldName());
            }
            matchQFilters.add(this.filterObject.getFilterResult().getQFilter());
            filterParameter = new FilterParameter(selectFields, matchQFilters, null);
        }
        return filterParameter;
    }

    public OrderByParameter getOrderByFilterParameter(List<Map<String, List<Object>>> orderByFilterList) {
        OrderByParameter orderByParameter = null;
        if (orderByFilterList != null && !orderByFilterList.isEmpty()) {
            for (int i = 0; i < orderByFilterList.size(); ++i) {
                Map<String, List<Object>> dct = orderByFilterList.get(i);
                List<Object> filterNames = dct.get(FIELD_NAME);
                List<Object> valueList = dct.get(VALUE);
                List newValueList = FilterUtil.getValidValues(valueList);
                if (newValueList.isEmpty()) continue;
                ArrayList<String> fullFilterNames = new ArrayList<String>(10);
                for (Object filterName : filterNames) {
                    FilterField filterField = FilterBuilder.getFilterField((FilterObject)this.filterObject, (String)filterName.toString());
                    fullFilterNames.add(filterField.getFullFieldName());
                }
                if (fullFilterNames.isEmpty()) continue;
                orderByParameter = new OrderByParameter();
                for (String fullFilterName : fullFilterNames) {
                    orderByParameter.addOrderByField(new OrderByField(fullFilterName, SortType.valueOf((String)((String)newValueList.get(0)))));
                }
            }
        }
        return orderByParameter;
    }

    private Object getRealValue(List<QFilter> qFilters, String fieldName) {
        for (QFilter qFilter : qFilters) {
            if (!qFilter.getProperty().equalsIgnoreCase(fieldName)) continue;
            return qFilter.getValue();
        }
        return null;
    }

    private FilterParameter getFilterParameter() {
        QFilter qFilter = null;
        if (this.filterModelContext != null && this.filterModelContext.isOrQuery()) {
            qFilter = this.filterObject.getFilterResult().getQFilter();
        }
        List qFilters = this.filterObject.getFilterResult().getQFilters();
        ArrayList selectFields = new ArrayList(this.filterObject.getSelectFields());
        FilterParameter filterParameter = qFilter == null ? new FilterParameter(selectFields, qFilters, this.sortObject.getSQLString()) : new FilterParameter(selectFields, qFilter, this.sortObject.getSQLString());
        filterParameter.setSelectFieldsWithNotCompare(this.filterObject.getSelectFieldsWithNotCompare());
        return filterParameter;
    }

    public FilterParameter getCommonFilterParameter(List<Map<String, List<Object>>> commonFilterList) {
        this.setCommonSetting(commonFilterList);
        this.buildFilter();
        FilterParameter filterParameter = this.getFilterParameter();
        for (FilterRow filterRow : this.getFilterObject().getFilterRows()) {
            IDataEntityProperty prop = filterRow.getFilterField().getSrcFieldProp();
            if (!(prop instanceof MainOrgProp) || filterRow.getValue().size() != 1) continue;
            this.selectedValues.put(filterRow.getFilterField().getFieldName(), this.getRealValue(filterParameter.getQFilters(), filterRow.getFilterField().getFullFieldName()));
        }
        return filterParameter;
    }

    public FilterParameter getSchemeFilterParameter(List<Map<String, List<Object>>> schemeFilterList) {
        return this.getSchemeFilterParameterInner(schemeFilterList, null);
    }

    @NotNull
    private FilterParameter getSchemeFilterParameterInner(List<Map<String, List<Object>>> schemeFilterList, List<Map<String, List<Object>>> andFilter) {
        FilterBuilder filterBuilder = new FilterBuilder(this.dataType, this.filterObject);
        filterBuilder.setFieldCompareTypeMap(this.fieldCompareTypeMap);
        filterBuilder.setSchemeSetting(schemeFilterList, true, andFilter);
        this.is_ContainMainOrg = filterBuilder.isContainMainOrg();
        this.is_MainOrgNoLimit = filterBuilder.isMainOrgNoLimit();
        this.is_ContainBillStatus = filterBuilder.isContainBillStatus();
        this.is_ContainUsedStatus = filterBuilder.isContainUsedStatus();
        this.selectedMainOrgIds = filterBuilder.getSelectedMainOrgIds();
        this.buildFilter();
        FilterParameter filterParameter = this.getFilterParameter();
        filterParameter.setConvertFieldsMap(filterBuilder.getConvertFieldsMap());
        return filterParameter;
    }

    public FilterParameter getSchemeFilterParameter(List<Map<String, List<Object>>> schemeFilterList, List<Map<String, List<Object>>> andFilter) {
        return this.getSchemeFilterParameterInner(schemeFilterList, andFilter);
    }

    private void buildFilter() {
        this.filterObject.setCheckInput(true);
        this.filterObject.buildFilter();
    }

    public FilterObject getFilterObject() {
        return this.filterObject;
    }

    public void setFilterModelContext(FilterModelContext filterModelContext) {
        this.filterModelContext = filterModelContext;
    }

    private void updateSchemeshareusersDefault(List<Long> fpkidList, boolean isDefault) {
        String ids = this.listToString(fpkidList);
        String flag = "1";
        if (!isDefault) {
            flag = "0";
        }
        String updateSql = "update t_bas_schemeshareusers set fisdefault = " + flag + " where fpkid in (" + ids + ") and fbasedataid = " + RequestContext.get().getCurrUserId();
        DB.update((DBRoute)DBRoute.basedata, (String)updateSql);
    }

    private String listToString(List<Long> list) {
        StringBuilder sb = new StringBuilder();
        for (Long id : list) {
            sb.append("'").append(id).append("'").append(",");
        }
        return sb.substring(0, sb.length() - 1);
    }

    public Map<String, String> getShareSchemeByIdList(List<String> schemeIdList, Long userId) {
        SchemeQuery schemeQuery = new SchemeQuery();
        return schemeQuery.getShareSchemeByIdList(schemeIdList, userId);
    }

    public Map<String, Integer> getShareSchemeMap(long userId, List<String> schemeIdList) {
        SchemeQuery schemeQuery = new SchemeQuery();
        return schemeQuery.getShareSchemeMap(userId, schemeIdList);
    }

    public void setDefaultScheme(boolean isDefault, String schemeId) {
        Long fpkid;
        SchemeQuery schemeQuery = new SchemeQuery();
        FilterScheme scheme = schemeQuery.getScheme(schemeId);
        long userId = RequestContext.get().getCurrUserId();
        boolean flag = false;
        if (scheme.isFixed() && ((fpkid = schemeQuery.getSchemeshareusersPkid(schemeId, Long.valueOf(userId))) == null || fpkid == 0L)) {
            flag = true;
        }
        try (TXHandle h = TX.requiresNew();){
            try {
                if (flag) {
                    this.insertShareScheme4Fixed(schemeId, userId);
                }
                this.setDefaultSchemeForShared(schemeId, isDefault, userId, schemeQuery);
            }
            catch (Throwable e1) {
                h.markRollback();
                throw e1;
            }
        }
    }

    private void setDefaultSchemeForShared(String schemeId, boolean isDefault, Long userId, SchemeQuery schemeQuery) {
        List fpkidList = schemeQuery.getShareUserFpkid(this.formId);
        if (CollectionUtils.isNotEmpty((Collection)fpkidList)) {
            this.updateSchemeshareusersDefault(fpkidList, false);
        }
        if (!isDefault) {
            return;
        }
        long fpkid = schemeQuery.getSchemeshareusersPkid(schemeId, userId);
        if (fpkid != 0L) {
            ArrayList<Long> list = new ArrayList<Long>();
            list.add(fpkid);
            this.updateSchemeshareusersDefault(list, isDefault);
        }
    }

    public void insertShareScheme4Fixed(String schemeId, Long userId) {
        long sFid = DB.genGlobalLongId();
        long uPkId = DB.genGlobalLongId();
        Object[] insertShareParams = new SqlParameter[]{new SqlParameter(":fid", -5, (Object)sFid), new SqlParameter(":fschemeid", 12, (Object)schemeId), new SqlParameter(":fsharetime", 91, (Object)new Date())};
        String sql = "insert into t_bas_sharefilterscheme (fid, fschemeid, fsharetime) values (?, ?, ?)";
        DB.execute((DBRoute)DBRoute.basedata, (String)sql, (Object[])insertShareParams);
        Object[] insertUserParams = new SqlParameter[]{new SqlParameter(":fpkid", -5, (Object)uPkId), new SqlParameter(":fid", 12, (Object)sFid), new SqlParameter(":fbasedataid", 91, (Object)userId)};
        String sql1 = "insert into t_bas_schemeshareusers (fpkid, fid, fbasedataid, fisdefault) values (?, ?, ?, 0)";
        DB.execute((DBRoute)DBRoute.basedata, (String)sql1, (Object[])insertUserParams);
    }
}

