/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.filter;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.CollectionPropertyAttribute;
import kd.bos.dataentity.entity.SimplePropertyAttribute;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityTypeUtil;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.filter.ColumnParam;
import kd.bos.entity.filter.CompareType;
import kd.bos.entity.filter.CompareTypeEnum;
import kd.bos.entity.filter.ControlFilter;
import kd.bos.entity.filter.FilterField;
import kd.bos.entity.filter.FilterMetadata;
import kd.bos.entity.filter.FilterUtil;
import kd.bos.entity.property.AmountProp;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.ComboProp;
import kd.bos.entity.property.DateTimeProp;
import kd.bos.entity.property.FlexProp;
import kd.bos.entity.property.IBasedataField;
import kd.bos.entity.property.IFieldHandle;
import kd.bos.entity.property.IRefBillField;
import kd.bos.entity.property.ItemClassProp;
import kd.bos.entity.property.PKFieldProp;
import kd.bos.entity.property.PrivacyProp;
import kd.bos.entity.property.QtyProp;
import kd.bos.entity.property.TextProp;
import kd.bos.filter.DependField;
import kd.bos.filter.FilterColumn;
import kd.bos.form.field.ComboItem;
import kd.bos.list.IListView;
import kd.bos.mservice.svc.picture.IPictureProp;
import kd.bos.orm.query.QFilter;
import kd.sdk.annotation.SdkInternal;
import kd.sdk.annotation.SdkPublic;

@SdkPublic
public class SchemeFilterColumn
extends FilterColumn {
    private List<ComboItem> comboItems = new ArrayList<ComboItem>();
    private List<CompareType> compareTypes = new ArrayList<CompareType>();
    private String entityId;
    private String defaultCompareType;
    private List<String> idValues;
    private boolean mustInput;

    @SimplePropertyAttribute(name="MustInput")
    public boolean isMustInput() {
        return this.mustInput;
    }

    public void setMustInput(boolean value) {
        this.mustInput = value;
    }

    public SchemeFilterColumn() {
    }

    public SchemeFilterColumn(String fieldName) {
        super(fieldName);
    }

    @SimplePropertyAttribute
    public String getDefaultCompareType() {
        return this.defaultCompareType;
    }

    @SdkInternal
    public void setDefaultCompareType(String defaultCompareType) {
        this.defaultCompareType = defaultCompareType;
    }

    @CollectionPropertyAttribute(collectionItemPropertyType=ComboItem.class)
    public List<ComboItem> getComboItems() {
        return this.comboItems;
    }

    public void setComboItems(List<ComboItem> comboItems) {
        this.comboItems = comboItems;
    }

    List<CompareType> getCompareTypes() {
        return this.compareTypes;
    }

    void setIdValues(List<String> idValues) {
        this.idValues = idValues;
    }

    @Override
    public Map<String, Object> createColumn() {
        IDataEntityProperty latestParent;
        FilterField myFilterField;
        Map<String, Object> map = super.createColumn();
        if (this.isMustInput()) {
            map.put("mustInput", this.isMustInput());
        }
        if ((myFilterField = this.getFilterField()) != null) {
            map.put("compareGroupId", myFilterField.getCompareGroupID());
        }
        map.put("items", this.comboItems);
        List<CompareType> compareTypesTemp = null;
        if (this.getFilterField() != null && this.getFilterField().getFieldProp() instanceof DateTimeProp) {
            compareTypesTemp = new ArrayList<CompareType>(this.compareTypes.size());
            for (CompareType compareType : this.compareTypes) {
                if (compareType.getGroupId() == 14) continue;
                compareTypesTemp.add(compareType);
            }
            if (myFilterField != null && myFilterField.getCompareGroupID() != null) {
                map.put("compareGroupId", myFilterField.getCompareGroupID().replace(",14", ""));
            }
        } else {
            compareTypesTemp = this.compareTypes;
        }
        List compareTypeDtos = FilterUtil.getCompareTypeDtos(compareTypesTemp);
        map.put("compareTypes", compareTypeDtos);
        map.put("defaultCompareType", this.defaultCompareType);
        map.put("defaultValues", super.getDefaultValues());
        if (this.idValues != null) {
            map.put("id", this.idValues);
        }
        if (this.getFilterField() != null && !"0".equals(this.getFilterField().getDefaultMultiCompareTypeId())) {
            map.put("inCompareId", this.getFilterField().getDefaultMultiCompareTypeId());
        }
        if (this.getFilterField() != null && this.getFilterField().getSrcFieldProp() instanceof TextProp && !(this.getFilterField().getSrcFieldProp() instanceof PrivacyProp)) {
            map.put("inCompareId", CompareTypeEnum.LIKE.getId());
        }
        if ((latestParent = this.getLatestParent()) instanceof IBasedataField || latestParent instanceof IRefBillField) {
            IFieldHandle bProp = (IFieldHandle)latestParent;
            ColumnParam param = new ColumnParam(true);
            param.setFilterField(myFilterField);
            param.setCompareTypes(this.compareTypes);
            param.setCompareTypeDtos(compareTypeDtos);
            bProp.afterCreateFilterColumn(map, param);
        }
        return map;
    }

    protected List<ComboItem> getComboItems(ComboProp comboProp) {
        ArrayList<ComboItem> myComboItems = new ArrayList<ComboItem>(10);
        List valueMapItems = comboProp.getComboItems();
        for (ValueMapItem valueMapItem : valueMapItems) {
            ComboItem comboItem = new ComboItem(valueMapItem.getName(), valueMapItem.getValue());
            myComboItems.add(comboItem);
        }
        return myComboItems;
    }

    @Override
    protected void addFieldCompareTypes() {
        if (this.getView() instanceof IListView && this.filterField != null && (this.filterField.getSrcFieldProp() instanceof DateTimeProp || this.filterField.getSrcFieldProp() instanceof QtyProp || this.filterField.getSrcFieldProp() instanceof AmountProp)) {
            List allCompareTypes = new ArrayList();
            allCompareTypes.addAll(this.filterField.getCompareTypes());
            allCompareTypes = EntityTypeUtil.setCompareTypes(allCompareTypes, (boolean)true);
            this.filterField.setCompareTypes(allCompareTypes);
            String oldCompareGroupID = this.filterField.getCompareGroupID();
            StringBuilder newCompareGroupId = new StringBuilder(oldCompareGroupID);
            newCompareGroupId.append(",9");
            this.filterField.setCompareGroupID(newCompareGroupId.toString());
        }
    }

    @Override
    public void initProperties() {
        super.initProperties();
        if (this.comboItems.isEmpty()) {
            ArrayList<ComboItem> myComboItems = new ArrayList<ComboItem>(10);
            for (ValueMapItem mapItem : this.getFilterField().getComboItems()) {
                ComboItem comboItem = new ComboItem(mapItem.getName(), mapItem.getValue());
                myComboItems.add(comboItem);
            }
            this.setComboItems(myComboItems);
        }
        this.initCompareTypes();
    }

    @Override
    void fixContext() {
        super.fixContext();
        if (this.isNewAdded()) {
            this.initCompareTypes();
        }
        if (StringUtils.isEmpty((CharSequence)this.entityId)) {
            this.initEntityId();
        }
    }

    private void initCompareTypes() {
        this.compareTypes.addAll(this.getFilterField().getCompareTypes());
        if (this.getFilterField().getFieldProp() instanceof PKFieldProp) {
            for (CompareType compareType : FilterMetadata.get().getCompareTypes("2")) {
                if (compareType.isNeedInput() || !StringUtils.isNotBlank((CharSequence)compareType.getClassName()) || this.compareTypes.contains(compareType)) continue;
                this.compareTypes.add(compareType);
            }
        } else {
            this.compareTypes.addAll(this.getCustomCompareTypes());
        }
    }

    private void initEntityId() {
        IDataEntityProperty latestParent = this.getLatestParent();
        if (latestParent instanceof IBasedataField) {
            this.entityId = ((IBasedataField)latestParent).getBaseEntityId();
        } else if (latestParent instanceof IRefBillField) {
            this.entityId = ((IRefBillField)latestParent).getBillEntityId();
        }
        if (this.entityId == null && "text".equals(this.getFilterControlType()) && this.getFilterField().getSrcFieldProp() instanceof FlexProp || this.entityId == null && this.getFilterField().getSrcFieldProp() instanceof TextProp) {
            this.entityId = "bos_multitext";
        }
    }

    private BasedataEntityType getBaseDataEntityType() {
        BasedataProp basedataProp = (BasedataProp)this.getLatestParent();
        return this.getBaseDataEntityType((IBasedataField)basedataProp);
    }

    @Override
    String getItemClassTypeEntityId(ItemClassProp itemClassProp) {
        List itemTypeList;
        String typePropName = itemClassProp.getTypePropName();
        Map<String, ControlFilter> controlFilters = this.context.getControlFiltersMap();
        ControlFilter controlFilter = controlFilters.get(typePropName);
        if (controlFilter != null && (itemTypeList = controlFilter.getValue()) != null && !itemTypeList.isEmpty() && StringUtils.isNotEmpty((CharSequence)itemTypeList.get(0).toString())) {
            return itemTypeList.get(0).toString();
        }
        return this.entityId;
    }

    @Override
    protected BasedataEntityType getBaseDataEntityType(IBasedataField basedataProp) {
        String itemClassTypeEntityId;
        BasedataEntityType complexType = super.getBaseDataEntityType(basedataProp);
        if (basedataProp instanceof ItemClassProp && this.context != null && (itemClassTypeEntityId = this.getItemClassTypeEntityId((ItemClassProp)basedataProp)) != null) {
            complexType = EntityMetadataCache.getDataEntityType((String)itemClassTypeEntityId);
        }
        return complexType;
    }

    DependField getDependField() {
        return null;
    }

    void addDependFilter(Map<String, List<DependField>> dependFieldMap) {
        block3: {
            block2: {
                List<DependField> dependFields = dependFieldMap.get(this.getFieldName());
                if (dependFields == null) break block2;
                for (DependField dependField : dependFields) {
                    this.addDependFilter(dependField);
                }
                break block3;
            }
            DependField dependField = null;
            dependField = this.getDependField();
            if (dependField != null || !this.isBaseDataControl()) break block3;
            List<DependField> orgDependFields = this.getOrgDependField();
            for (DependField orgDependField : orgDependFields) {
                this.addDependFilter(orgDependField);
            }
        }
    }

    @SdkInternal
    protected void addDependFilter(DependField dependField) {
        FilterField dependFilterField = FilterField.create((MainEntityType)this.getEntityType(), (String)dependField.getDependFieldName());
        if (dependFilterField == null) {
            return;
        }
        if (dependFilterField.getLatestParent() instanceof IBasedataField) {
            this.addDependQFilter(this.getDependFilter(dependField));
        }
    }

    @Override
    QFilter getDependFilter(DependField dependField, FilterField dependFilterField, FilterField joinPropertyFilterField) {
        Map<String, ControlFilter> controlFilters = this.context.getControlFiltersMap();
        ControlFilter controlFilter = controlFilters.get(dependField.getDependFieldName());
        return dependField.getDependFilter(dependFilterField, joinPropertyFilterField, controlFilter == null ? null : controlFilter.getCompareType(), controlFilter == null ? null : controlFilter.getValue(), this.getBaseDataEntityType((IBasedataField)dependFilterField.getLatestParent()), this.getEntityType());
    }

    Map<String, Object> createSchemeFilterConfig(List<String> fixedFilters) {
        if (this.getFilterField() == null || this.getFilterField() != null && (StringUtils.isBlank((CharSequence)this.getFilterFieldName()) || "number".equals(this.getFilterControlType()) || this.getFilterField().getFieldProp() instanceof IPictureProp)) {
            return null;
        }
        HashMap<String, Object> schemeFilterConfig = new HashMap<String, Object>(2);
        schemeFilterConfig.put("k", this.getFilterFieldName());
        schemeFilterConfig.put("c", this.getCaption());
        schemeFilterConfig.put("v", fixedFilters.contains(this.getFilterFieldName()) ? 1 : 0);
        return schemeFilterConfig;
    }

    @Override
    public boolean equals(Object obj) {
        if (this.getFieldName() == null) {
            return false;
        }
        if (obj instanceof SchemeFilterColumn) {
            SchemeFilterColumn state = (SchemeFilterColumn)((Object)obj);
            return this.getFieldName().equals(state.getFieldName());
        }
        return super.equals(obj);
    }

    @Override
    public int hashCode() {
        return this.getFieldName().hashCode();
    }
}

