/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.filter.mcontrol;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.TypesContainer;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.entity.SimplePropertyAttribute;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.DcJsonSerializer;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.EntityTypeUtil;
import kd.bos.entity.EntryEntityDto;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.RuntimeMetaType;
import kd.bos.entity.datamodel.IFilterModel;
import kd.bos.entity.filter.ControlFilters;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.filter.FilterField;
import kd.bos.entity.filter.FilterObject;
import kd.bos.entity.filter.FilterParameter;
import kd.bos.entity.filter.FilterScheme;
import kd.bos.entity.filter.SortObject;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.filter.AbstractFilterGridView;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.DefaultHiddenField;
import kd.bos.filter.FilterColumn;
import kd.bos.filter.FilterContainerFilterValues;
import kd.bos.filter.FilterControlHelper;
import kd.bos.filter.IFilterControlCache;
import kd.bos.filter.mcontrol.MobAdvFilterPanel;
import kd.bos.filter.mcontrol.MobSortColumn;
import kd.bos.form.BindingContext;
import kd.bos.form.ControlTypes;
import kd.bos.form.FilterF7Helper;
import kd.bos.form.FormMetadataCache;
import kd.bos.form.ICloseCallBack;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.container.Container;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.AfterSearchClickListener;
import kd.bos.form.control.events.MobFilterSortInitEvent;
import kd.bos.form.control.events.MobFilterSortInitListener;
import kd.bos.form.control.events.SearchClickEvent;
import kd.bos.form.control.events.SearchClickListener;
import kd.bos.form.events.AfterBindDataEvent;
import kd.bos.form.events.AfterBindDataListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.events.BeforeFilterF7SelectListener;
import kd.bos.list.ControlContext;
import kd.bos.list.ITemplateControl;
import kd.bos.list.ListCache;
import kd.bos.list.MobControlContext;
import kd.bos.list.ViewCommonUtil;
import kd.bos.list.query.SchemeQuery;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.service.IUserService;
import kd.bos.service.ServiceFactory;
import kd.bos.service.metadata.MetadataService;
import kd.sdk.annotation.SdkPublic;
import org.jetbrains.annotations.NotNull;

@SdkPublic
public class MobFilterSort
extends Container
implements ITemplateControl,
ICloseCallBack,
IFilterControlCache {
    private static final Log log = LogFactory.getLog(MobFilterSort.class);
    private static final String BOS_FORM_CORE = "bos-form-core";
    private static final String CUSTOM_FILTER = "customfilter";
    private static final String SCHEME = "scheme";
    private static final String FAST_FILTER = "fastfilter";
    private static final String FIELD_NAME = "FieldName";
    private MainEntityType entityType;
    private LocaleString title;
    private IFilterModel filterModel;
    private ListCache listCache = null;
    private boolean schemeQuery = false;
    private FilterScheme defaultScheme;
    private int visible;
    private String billFormId;
    private String entityId;
    ControlContext context = null;
    private List<BeforeFilterF7SelectListener> beforeF7SelectListeners = new ArrayList<BeforeFilterF7SelectListener>();
    private List<MobFilterSortInitListener> mobFilterSortInitListeners = new ArrayList<MobFilterSortInitListener>();
    private List<SearchClickListener> searchClickListeners = new ArrayList<SearchClickListener>();
    private List<AfterSearchClickListener> afterSearchClickListeners = new ArrayList<AfterSearchClickListener>();
    private List<AfterBindDataListener> afterBindDataListeners = new ArrayList<AfterBindDataListener>();

    @SimplePropertyAttribute
    public LocaleString getTitle() {
        return this.title;
    }

    public void setTitle(LocaleString title) {
        this.title = title;
    }

    @SimplePropertyAttribute
    public int getVisible() {
        return this.visible;
    }

    public void setVisible(int visible) {
        this.visible = visible;
    }

    @SimplePropertyAttribute(name="SchemeQuery")
    public boolean isSchemeQuery() {
        return this.schemeQuery;
    }

    public void setSchemeQuery(boolean schemeQuery) {
        this.schemeQuery = schemeQuery;
    }

    public void setBillFormId(String billFormId) {
        this.billFormId = billFormId;
        this.entityType = null;
        this.filterModel = null;
    }

    public String getBillFormId() {
        return this.billFormId;
    }

    public void setEntityId(String entityId) {
        this.entityId = entityId;
    }

    public String getEntityId() {
        return this.entityId;
    }

    public void setContext(ControlContext context) {
        this.context = context;
        this.context.setFilterControlKey(this.getKey());
    }

    public ControlContext getContext() {
        if (this.context == null) {
            this.context = new MobControlContext();
            this.context.setFilterControlKey(this.getKey());
        }
        return this.context;
    }

    private ListCache getListCache() {
        if (this.listCache == null) {
            IPageCache pageCache = (IPageCache)this.getView().getService(IPageCache.class);
            this.listCache = new ListCache(pageCache, this.getKey());
        }
        return this.listCache;
    }

    public FilterContainerFilterValues getCachedFilterValues() {
        return this.getListCache().getCachedFilterValues();
    }

    @Override
    public void setCachedFilterValues(FilterContainerFilterValues cachedFilterValues) {
        this.getListCache().setCachedFilterValues(cachedFilterValues);
    }

    public void addBeforeF7SelectListener(BeforeFilterF7SelectListener listener) {
        this.beforeF7SelectListeners.add(listener);
    }

    public void addMobFilterSortInitListener(MobFilterSortInitListener listener) {
        this.mobFilterSortInitListeners.add(listener);
    }

    public void addSearchClickListener(SearchClickListener listener) {
        this.searchClickListeners.add(listener);
    }

    public void addAfterSearchClickListener(AfterSearchClickListener listener) {
        this.afterSearchClickListeners.add(listener);
    }

    public void addAfterBindDataListener(AfterBindDataListener listener) {
        this.afterBindDataListeners.add(listener);
    }

    public MainEntityType getEntityType() {
        if (StringUtils.isNotBlank((CharSequence)this.billFormId) && StringUtils.isBlank((CharSequence)this.entityId)) {
            this.entityId = FormMetadataCache.getFormConfig((String)this.billFormId).getEntityTypeId();
        }
        if (StringUtils.isBlank((CharSequence)this.getEntityId())) {
            throw new KDException(BosErrorCode.metaNotFound, new Object[]{String.format(ResManager.loadKDString((String)"%s\u5b9e\u4f53\u6807\u8bc6\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"FilterContainer_0", (String)BOS_FORM_CORE, (Object[])new Object[0]), this.getKey())});
        }
        if (this.entityType == null) {
            this.entityType = EntityMetadataCache.getDataEntityType((String)this.entityId);
        }
        if (this.entityType == null) {
            throw new KDException(BosErrorCode.metaNotFound, new Object[]{String.format(ResManager.loadKDString((String)"%s\u5b9e\u4f53\u5143\u6570\u636e\u4e0d\u5b58\u5728\u3002", (String)"FilterContainer_1", (String)BOS_FORM_CORE, (Object[])new Object[0]), this.entityId)});
        }
        return this.entityType;
    }

    private IFilterModel getFilterModel() {
        if (this.filterModel != null) {
            return this.filterModel;
        }
        this.filterModel = (IFilterModel)TypesContainer.createInstance((String)"kd.bos.mvc.list.ListFilterModel");
        this.filterModel.setSortObject(new SortObject());
        this.filterModel.setFormId(this.getBillFormId() == null ? this.getEntityId() : this.getBillFormId());
        this.filterModel.setDataType(this.getEntityType());
        this.filterModel.getFilterObject().setUserService((IUserService)this.getView().getService(IUserService.class));
        this.filterModel.getFilterObject().setDataType(this.getEntityType());
        return this.filterModel;
    }

    private Map<String, List<Map<String, List<Object>>>> buildDefaultFilter(String entryEntity) {
        ArrayList<FilterColumn> commonFilterColumns = new ArrayList<FilterColumn>();
        for (Control item : this.getItems()) {
            if (!(item instanceof FilterColumn) || ((FilterColumn)item).getFilterField() != null && ((FilterColumn)item).getFilterField().isDesenAndNoSearch()) continue;
            commonFilterColumns.add((FilterColumn)item);
        }
        return this.buildCommonFilterValues(AbstractFilterGridView.getFilterValues(commonFilterColumns, this.getEntityType()), entryEntity);
    }

    private Map<String, List<Map<String, List<Object>>>> buildCommonFilterValues(List<Map<String, List<Object>>> filter, String entryEntity) {
        HashMap<String, List<Map<String, List<Object>>>> filterValues = new HashMap<String, List<Map<String, List<Object>>>>();
        filterValues.put(FAST_FILTER, new ArrayList());
        filterValues.put(CUSTOM_FILTER, filter);
        this.createFilterControlHelper().cacheFilterValues(new ArrayList<Map<String, List<Object>>>(), filter, entryEntity);
        return filterValues;
    }

    public List<EntryEntityDto> getValidEntryList() {
        List entryEntityDtos = EntityTypeUtil.getEntryEntities((EntityType)this.getEntityType());
        ArrayList<EntryEntityDto> validEntryEntityDtos = new ArrayList<EntryEntityDto>();
        block0: for (Control filterColumn : this.getItems()) {
            String entryEntity = "";
            if (filterColumn instanceof FilterColumn) {
                entryEntity = ((FilterColumn)filterColumn).getEntryEntity();
            } else if (filterColumn instanceof MobSortColumn) {
                entryEntity = ((MobSortColumn)filterColumn).getEntryEntity();
            }
            for (EntryEntityDto entryEntityDto : entryEntityDtos) {
                if (validEntryEntityDtos.contains(entryEntityDto) || !entryEntity.equals(entryEntityDto.getKey())) continue;
                validEntryEntityDtos.add(entryEntityDto);
                continue block0;
            }
        }
        return validEntryEntityDtos;
    }

    private List<EntryEntityDto> getEntryEntityDtos() {
        List<EntryEntityDto> entryEntityDtos = this.getValidEntryList();
        for (EntryEntityDto entryEntityDto : this.getContext().getEntryEntityDtos()) {
            if (entryEntityDtos.contains(entryEntityDto)) continue;
            entryEntityDtos.add(entryEntityDto);
        }
        return ViewCommonUtil.getFullEntryEntityDtos(entryEntityDtos, this.getEntityType());
    }

    private List<EntryEntityDto> getFixedEntryEntityDtos() {
        List<EntryEntityDto> entryEntityDtos = this.getEntryEntityDtos();
        for (EntryEntityDto entryEntityDto : entryEntityDtos) {
            if (!StringUtils.isEmpty((CharSequence)entryEntityDto.getParentKey())) continue;
            entryEntityDto.setName(new LocaleString(ResManager.loadKDString((String)"\u57fa\u672c\u4fe1\u606f", (String)"FilterContainer_2", (String)BOS_FORM_CORE, (Object[])new Object[0])));
            break;
        }
        return entryEntityDtos;
    }

    private void clearSelection() {
        if (this.getContext() == null) {
            return;
        }
        this.getContext().setClearSelection(true);
    }

    public void search(List<Map<String, List<Object>>> filter, List<Map<String, List<Object>>> sortFilter, String entryEntity) {
        List<EntryEntityDto> fixedEntryEntityDtos = this.getFixedEntryEntityDtos();
        ControlContext mobContext = this.getContext();
        if (mobContext instanceof MobControlContext) {
            ((MobControlContext)mobContext).setMobFilterSortEntryEntityDtos(fixedEntryEntityDtos);
        }
        this.clearSelection();
        this.setMetadata();
        this.initChildControls();
        Map<String, List<Map<String, List<Object>>>> filterValues = this.buildCommonFilterValues(filter, entryEntity);
        this.addSortFilterFields();
        this.filterSearchClick(filterValues, sortFilter, entryEntity);
    }

    public void schemeSearch(List<Map<String, Object>> search) {
        if (CollectionUtils.isEmpty(search) || CollectionUtils.isEmpty(search.get(0)) || search.get(0).get("Id") == null || ((List)search.get(0).get("Id")).get(0) == null) {
            return;
        }
        this.clearSelection();
        this.setMetadata();
        this.initChildControls();
        String entryEntity = this.getBillFormId() == null ? this.getEntityId() : this.getBillFormId();
        SchemeQuery schemeQuery = new SchemeQuery();
        FilterScheme filterScheme = schemeQuery.getScheme(((List)search.get(0).get("Id")).get(0).toString());
        List<Map<String, List<Object>>> schemeFilter = new ArrayList<Map<String, List<Object>>>();
        if (filterScheme != null) {
            Map schemeValue;
            entryEntity = filterScheme.getEntryEntity();
            Map scheme = schemeValue = MobFilterSort.getDcJsonSerializer().serializeToMap((Object)filterScheme, null);
            schemeFilter = (List)SerializationUtils.deSerializeFromBase64((String)scheme.get(SCHEME).toString());
        }
        this.schemeFilterSearchClick(schemeFilter, entryEntity);
    }

    private void filterSearchClick(Map<String, List<Map<String, List<Object>>>> filterValues, List<Map<String, List<Object>>> sortFilter, String entryEntity) {
        this.getContext().setEntryEntity(entryEntity);
        FilterControlHelper filterControlHelper = this.createFilterControlHelper();
        filterControlHelper.setSearchClickListeners(this.searchClickListeners);
        filterControlHelper.setAfterSearchClickListeners(this.afterSearchClickListeners);
        filterControlHelper.parseFilterValues(filterValues, sortFilter, entryEntity);
        this.renderControl(this.getFixedEntryEntityDtos(), null);
    }

    @NotNull
    private FilterControlHelper createFilterControlHelper() {
        FilterControlHelper filterControlHelper = new FilterControlHelper(this, this.getFilterModel(), this.getEntityType(), this.getContext(), this.getListCache());
        return filterControlHelper;
    }

    private void schemeFilterSearchClick(List<Map<String, List<Object>>> schemeFilter, String entryEntity) {
        this.buildSchemeFilter(schemeFilter);
        SearchClickEvent evt = new SearchClickEvent((Object)this, new HashMap(), entryEntity, this.getFilterModel(), null, new HashMap(), this.getContext().getFastQueryFilterParameter().getQFilters());
        this.getContext().getClientQueryFilterParameter().setOrderBy(this.getListCache().getMobFilterSortFilterParameter().getOrderBy());
        for (AfterSearchClickListener afterSearchClickListener : this.afterSearchClickListeners) {
            afterSearchClickListener.click(evt);
        }
    }

    public void bindData(BindingContext bctx) {
        this.setMetadata();
        this.initChildControls();
        List<EntryEntityDto> fixedEntryEntityDtos = this.getFixedEntryEntityDtos();
        String firstEntryEntity = ViewCommonUtil.getFirstEntryEntity((EntityType)this.getEntityType(), this.getFixedEntryEntityDtos());
        ControlContext mobContext = this.getContext();
        if (mobContext instanceof MobControlContext) {
            ((MobControlContext)mobContext).setMobFilterSortEntryEntityDtos(fixedEntryEntityDtos);
        }
        this.addSortFilterFields();
        FilterControlHelper filterControlHelper = this.createFilterControlHelper();
        filterControlHelper.buildContext(this.buildDefaultFilter(ViewCommonUtil.getFirstEntryEntity((EntityType)this.getEntityType(), this.getFixedEntryEntityDtos())));
        List<Map<String, Object>> schemeList = this.loadSchemeList(fixedEntryEntityDtos, firstEntryEntity);
        if (this.defaultScheme != null) {
            List filter = (List)SerializationUtils.deSerializeFromBase64((String)this.defaultScheme.getScheme());
            this.buildSchemeFilter(filter);
        }
        HashMap<String, Object> clientMeta = new HashMap<String, Object>();
        this.renderScheme(clientMeta, schemeList);
        this.renderControl(fixedEntryEntityDtos, clientMeta);
        this.renderMobAdvFilterConfig();
        AfterBindDataEvent afterBindDataEvent = new AfterBindDataEvent((Object)this);
        for (AfterBindDataListener afterBindDataListener : this.afterBindDataListeners) {
            afterBindDataListener.afterBindData(afterBindDataEvent);
        }
    }

    private void addSortFilterFields() {
        Map allFilterFields = this.getFilterModel().getFilterObject().getAllFilterFields();
        for (Control item : this.getItems()) {
            if (!(item instanceof MobSortColumn)) continue;
            MobSortColumn mobSortColumn = (MobSortColumn)item;
            if (mobSortColumn.getFilterField() != null && (mobSortColumn.getFilterField().isEncryptField() || mobSortColumn.getFilterField().isDesensitizeField())) {
                log.info("\u6392\u5e8f\u5c4f\u853d\u52a0\u5bc6\u548c\u8131\u654f\u5b57\u6bb5, prop is {}", (Object)mobSortColumn.getFieldName());
                continue;
            }
            if (mobSortColumn.isBlackField()) continue;
            mobSortColumn.addFilterFields(allFilterFields);
        }
    }

    private void renderControl(List<EntryEntityDto> entryEntityDtos, Map<String, Object> clientMeta) {
        if (clientMeta == null) {
            clientMeta = new HashMap<String, Object>();
        }
        clientMeta.putAll(this.collectFilterColumnsClientMeta());
        clientMeta.put("entryenties", entryEntityDtos);
        this.clientViewProxy.invokeControlMethod(this.getKey(), "createFilterSortColumns", new Object[]{clientMeta});
    }

    private Map<String, Object> collectFilterColumnsClientMeta() {
        HashMap<String, Object> clientMeta = new HashMap<String, Object>();
        ArrayList<Map<String, Object>> metaList = new ArrayList<Map<String, Object>>();
        for (Control item : this.getItems()) {
            MobSortColumn mobSortColumn;
            if (item instanceof FilterColumn) {
                FilterColumn filterColumn = (FilterColumn)item;
                FilterField filterField = filterColumn.getFilterField();
                if (filterField != null && (filterField.isDesenAndNoSearch() || filterField.isEncryptField())) continue;
                metaList.add(filterColumn.createColumn());
                continue;
            }
            if (!(item instanceof MobSortColumn) || (mobSortColumn = (MobSortColumn)item).getFilterField() != null && (mobSortColumn.getFilterField().isEncryptField() || mobSortColumn.getFilterField().isDesensitizeField())) continue;
            metaList.add(mobSortColumn.createColumn());
        }
        clientMeta.put("filtersort", metaList);
        return clientMeta;
    }

    private Map<String, Object> getFilterMeta(String formId, String key) {
        MetadataService metadataService = (MetadataService)ServiceFactory.getService(MetadataService.class);
        String str = metadataService.loadFormRuntimeMeta(formId, RuntimeMetaType.MobList.getValue(), key);
        if (StringUtils.isBlank((CharSequence)str)) {
            return new HashMap<String, Object>();
        }
        return (Map)SerializationUtils.fromJsonString((String)str, Map.class);
    }

    private void setMetadata() {
        if (StringUtils.isBlank((CharSequence)this.billFormId)) {
            return;
        }
        Map<String, Object> meta = this.getFilterMeta(this.billFormId, "FilterSort");
        if (meta != null && meta.containsKey(MobFilterSort.class.getSimpleName())) {
            String strFilterContainer = (String)meta.get(MobFilterSort.class.getSimpleName());
            MobFilterSort mobFilterSort = (MobFilterSort)ControlTypes.fromJsonString((String)strFilterContainer);
            if (StringUtils.isBlank((Object)this.title)) {
                this.title = mobFilterSort.getTitle();
            }
            this.setVisible(mobFilterSort.getVisible());
            this.setSchemeQuery(mobFilterSort.isSchemeQuery());
            this.getItems().clear();
            this.getItems().addAll(mobFilterSort.getItems());
            this.updateControlMeta();
        }
    }

    private void updateControlMeta() {
        ArrayList<Object> list = new ArrayList<Object>();
        list.add(this.getKey());
        list.add(this.createClientConfig());
        this.clientViewProxy.addAction("updateControlMetadata", list);
    }

    private void renderMobAdvFilterConfig() {
        Map<String, Object> meta = this.getFilterMeta(this.billFormId, "MobAdvFilter");
        if (CollectionUtils.isEmpty(meta) || !meta.containsKey(MobAdvFilterPanel.class.getSimpleName())) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>(2);
        String strFilterContainer = (String)meta.get(MobAdvFilterPanel.class.getSimpleName());
        MobAdvFilterPanel mobAdvFilterPanel = (MobAdvFilterPanel)ControlTypes.fromJsonString((String)strFilterContainer);
        HashMap<String, String> realFilterNameMap = new HashMap<String, String>(10);
        for (Control item : this.getItems()) {
            if (!(item instanceof CommonFilterColumn) || !((CommonFilterColumn)item).isAdvField()) continue;
            CommonFilterColumn filterColumn = (CommonFilterColumn)item;
            realFilterNameMap.put(filterColumn.getFieldName(), this.getFilterFieldName(filterColumn));
        }
        for (DefaultHiddenField field : mobAdvFilterPanel.getUserInitialField()) {
            String realFilterName = (String)realFilterNameMap.get(field.getFieldName());
            if (!StringUtils.isNotBlank((CharSequence)realFilterName)) continue;
            field.setFieldName(realFilterName);
        }
        map.put("userConfiguration", mobAdvFilterPanel.isUserConfiguration());
        map.put("userInitialField", mobAdvFilterPanel.getUserInitialField());
        map.put("synchronizeFilterItems", mobAdvFilterPanel.isSynchronizeFilterItems());
        map.put("rememberFilterCriteria", mobAdvFilterPanel.isRememberFilterCriteria());
        map.put("panelOpenStyle", mobAdvFilterPanel.getPanelOpenStyle());
        ArrayList<Object> list = new ArrayList<Object>();
        list.add(this.getKey());
        map.put("type", "mobilefilter");
        list.add(map);
        this.clientViewProxy.addAction("updateControlMetadata", list);
    }

    protected String getFilterFieldName(FilterColumn filterColumn) {
        return filterColumn.isEntityField() && filterColumn.getEntityType() != null ? filterColumn.getFilterField().getFieldName() : filterColumn.getFieldName();
    }

    public Map<String, Object> createClientConfig() {
        Map map = super.createClientConfig();
        map.put("type", "mobilefilter");
        if (this.isInvisible()) {
            map.put("vi", 0);
        } else {
            map.put("vi", this.getVisible());
        }
        map.put("schemeQuery", this.isSchemeQuery());
        return map;
    }

    public void refresh() {
        this.setMetadata();
        this.initChildControls();
    }

    private void initChildControls() {
        ArrayList<FilterColumn> filterColumns = new ArrayList<FilterColumn>();
        ArrayList<MobSortColumn> sortColumns = new ArrayList<MobSortColumn>();
        for (Control childitem : this.getItems()) {
            if (childitem instanceof FilterColumn) {
                FilterColumn filterColumn = (FilterColumn)childitem;
                filterColumn.setParentViewKey(this.getKey());
                filterColumn.setView(this.getView());
                filterColumn.setEntityType(this.getEntityType());
                filterColumn.setContext(this.getContext());
                FilterControlHelper.createBlankProp(filterColumn);
                filterColumn.initProperties();
                filterColumns.add(filterColumn);
                continue;
            }
            if (!(childitem instanceof MobSortColumn)) continue;
            MobSortColumn mobSortColumn = (MobSortColumn)childitem;
            mobSortColumn.setView(this.getView());
            mobSortColumn.setEntityType(this.getEntityType());
            mobSortColumn.setContext(this.getContext());
            mobSortColumn.initProperties();
            sortColumns.add(mobSortColumn);
        }
        MobFilterSortInitEvent evt = new MobFilterSortInitEvent(this, filterColumns, sortColumns);
        for (MobFilterSortInitListener mobFilterSortInitListener : this.mobFilterSortInitListeners) {
            mobFilterSortInitListener.mobFilterSortInit(evt);
        }
    }

    private void initContextControlFilters() {
        if (!this.getCachedFilterValues().isEmpty()) {
            ControlFilters controlFilters = new ControlFilters(this.getCachedFilterValues().getFastFilterValues(), this.getCachedFilterValues().getOtherFilterValues());
            this.getContext().setControlFilters(controlFilters);
        }
    }

    public void f7Click(String fieldName, boolean isMulti, List<String> selectedIds) {
        this.f7Click(fieldName, isMulti, selectedIds, null);
    }

    public void f7Click(String fieldName, boolean isMulti, List<String> selectedIds, List<Object> filter) {
        this.setMetadata();
        this.initContextControlFilters();
        this.initChildControls();
        if (!CollectionUtils.isEmpty(filter)) {
            this.buildCommonFilterValues((List)filter.get(0), filter.get(1).toString());
        }
        FilterControlHelper filterControlHelper = this.createFilterControlHelper();
        FilterColumn filterColumn = filterControlHelper.getFilterColumn(fieldName);
        filterControlHelper.setBeforeF7SelectListeners(this.beforeF7SelectListeners);
        FilterF7Helper f7FormShowParameter = filterControlHelper.createF7FormShowParameter(fieldName, "setCommonF7Value", filterColumn, "");
        FilterField filterField = FilterField.create((MainEntityType)this.getEntityType(), (String)filterColumn.getFieldName());
        f7FormShowParameter.setRefPropKey(filterField.getRefPropKey());
        f7FormShowParameter.setMulti(isMulti);
        f7FormShowParameter.setSelectedIds(selectedIds.toArray(new String[0]));
        f7FormShowParameter.setBillFormId(this.getBillFormId());
        ShowFormHelper.showF7Form(f7FormShowParameter, this.getView(), this.getKey(), true);
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        String[] actionIds = e.getActionId().split("\\$");
        FilterControlHelper filterControlHelper = this.createFilterControlHelper();
        filterControlHelper.closeCallBackForBaseData(e, actionIds);
    }

    private List<QFilter> buildSchemeFilter(List<Map<String, List<Object>>> schemeFilter) {
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        if (schemeFilter == null) {
            return filters;
        }
        FilterObject filterObject = this.getFilterModel().getFilterObject();
        if (!schemeFilter.isEmpty()) {
            for (Map<String, List<Object>> mergeFilter : schemeFilter) {
                FilterField filterField = FilterField.create((MainEntityType)this.getEntityType(), (String)mergeFilter.get(FIELD_NAME).get(0).toString());
                filterObject.addField(filterField);
            }
            FilterBuilder filterBuilder = new FilterBuilder(this.getEntityType(), filterObject);
            filterBuilder.setFieldCompareTypeMap(this.getContext().getFieldCompareTypeMap());
            filterBuilder.setSchemeSetting(schemeFilter, true);
            filterBuilder.buildFilter();
            filters.add(filterBuilder.getQFilter());
        }
        FilterParameter schemeQueryFilterParameter = new FilterParameter(filters, this.getFilterModel().getSortObject().getSQLString());
        this.getContext().setSchemeQueryFilterParameter(schemeQueryFilterParameter);
        return filters;
    }

    private List<Map<String, Object>> loadSchemeList(List<EntryEntityDto> fixedEntryEntityDtos, String firstEntryEntity) {
        if (!this.isSchemeQuery()) {
            return null;
        }
        ArrayList allSchemeList = new ArrayList();
        IFilterModel schemeFilterModel = this.getFilterModel();
        schemeFilterModel.setFormId(this.getBillFormId() == null ? this.getEntityId() : this.getBillFormId());
        List filterSchemes = schemeFilterModel.getSchemeList();
        List sharedSchemeList = schemeFilterModel.getSharedSchemeList();
        allSchemeList.addAll(filterSchemes);
        allSchemeList.addAll(sharedSchemeList);
        ArrayList<Map<String, Object>> schemeList = new ArrayList<Map<String, Object>>();
        if (!allSchemeList.isEmpty()) {
            HashMap<String, String> allScheme = new HashMap<String, String>();
            allScheme.put("value", "all");
            allScheme.put("caption", (String)new LocaleString(ResManager.loadKDString((String)"\u4e0d\u9650", (String)"CommonFilterColumn_0", (String)BOS_FORM_CORE, (Object[])new Object[0])));
            schemeList.add(allScheme);
            for (FilterScheme filterScheme : allSchemeList) {
                if (!filterScheme.getEntryEntity().equals(firstEntryEntity) && !filterScheme.getEntryEntity().equals(filterScheme.getFormId())) continue;
                HashMap<String, String> scheme = new HashMap<String, String>();
                scheme.put("value", filterScheme.getId());
                scheme.put("caption", (String)filterScheme.getLocaleName());
                schemeList.add(scheme);
                if (!filterScheme.isDefault() || filterScheme.isShare() && !filterScheme.isFixed() && RequestContext.get().getCurrUserId() == filterScheme.getUserId() || this.defaultScheme != null && !this.defaultScheme.isFixed()) continue;
                this.defaultScheme = filterScheme;
            }
            if (this.defaultScheme != null) {
                for (FilterScheme filterScheme : filterSchemes) {
                    if (this.defaultScheme.getId().equals(filterScheme.getId())) continue;
                    filterScheme.setDefault(false);
                }
                if (fixedEntryEntityDtos.size() <= 2 || !fixedEntryEntityDtos.contains(new EntryEntityDto(this.defaultScheme.getEntryEntity()))) {
                    this.getContext().setEntryEntity(firstEntryEntity);
                    this.defaultScheme.setEntryEntity(firstEntryEntity);
                }
            }
        }
        return schemeList;
    }

    private void renderScheme(Map<String, Object> clientMeta, List<Map<String, Object>> schemeList) {
        ArrayList filterSchemeList = new ArrayList();
        HashMap<String, Object> schemeMap = new HashMap<String, Object>();
        ArrayList<String> defaultValues = new ArrayList<String>();
        if (this.defaultScheme != null) {
            defaultValues.add(this.defaultScheme.getId());
        }
        schemeMap.put("defaultValues", defaultValues);
        schemeMap.put("fieldCaption", new LocaleString(ResManager.loadKDString((String)"\u9ed8\u8ba4\u65b9\u6848", (String)"MobFilterSort_0", (String)BOS_FORM_CORE, (Object[])new Object[0])));
        schemeMap.put("items", schemeList);
        schemeMap.put("entryEntity", this.getBillFormId() == null ? this.getEntityId() : this.getBillFormId());
        schemeMap.put("type", "filterscheme");
        schemeMap.put("fieldName", "filterscheme");
        schemeMap.put("isMulti", false);
        filterSchemeList.add(schemeMap);
        clientMeta.put("filterscheme", filterSchemeList);
    }

    private static DcJsonSerializer getDcJsonSerializer() {
        ArrayList<IDataEntityType> dts = new ArrayList<IDataEntityType>();
        dts.add(OrmUtils.getDataEntityType(FilterScheme.class));
        return new DcJsonSerializer(dts);
    }
}

