/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.aicommand;

import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.api.AICommandParameter;
import kd.bos.form.IFormView;
import kd.bos.form.aicommand.IAICommand;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public abstract class DefaultAICommand
implements IAICommand {
    private static final Log log = LogFactory.getLog(DefaultAICommand.class);
    protected IFormView targetView;
    protected AICommandParameter params;
    protected String cmdType;

    @Override
    public void invoke() {
        if (this.checkPredition()) {
            log.info(String.format("\u5f00\u59cb\u6267\u884cAI\u547d\u4ee4,\u76ee\u6807\u89c6\u56fe\u4e3a\uff1a%s  \u547d\u4ee4\u7c7b\u578b\u4e3a\uff1a%s   \u53c2\u6570\u4e3a\uff1a %s", this.targetView.toString(), this.cmdType, this.params.toString()));
            this.execute();
        } else {
            this.targetView.showErrorNotification(ResManager.loadKDString((String)"\u6267\u884cAI\u547d\u4ee4--\u53c2\u6570\u4e0d\u6b63\u786e", (String)"DefaultAICommand_0", (String)"bos-form-core", (Object[])new Object[0]));
        }
    }

    protected abstract void execute();

    protected boolean checkPredition() {
        return this.targetView != null && this.params != null && this.checkParameterExist();
    }

    protected boolean checkParameterExist() {
        return true;
    }

    public IFormView getTargetView() {
        return this.targetView;
    }

    public void setTargetView(IFormView targetView) {
        this.targetView = targetView;
    }

    public AICommandParameter getParams() {
        return this.params;
    }

    public void setParams(AICommandParameter params) {
        this.params = params;
    }

    public String getCmdType() {
        return this.cmdType;
    }

    public void setCmdType(String cmdType) {
        this.cmdType = cmdType;
    }
}

