/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.control;

import java.util.List;
import kd.bos.dataentity.entity.SimplePropertyAttribute;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.qing.IQingDataProvider;
import kd.bos.entity.qing.QingData;
import kd.bos.entity.qing.QingLinkageInfo;
import kd.bos.entity.qing.QingMeta;
import kd.bos.entity.qing.model.Template;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.form.BindingContext;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.ICloseCallBack;
import kd.bos.form.IFormView;
import kd.bos.form.control.IFrame;
import kd.bos.form.control.IQingAnalysis;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.qing.IQingControl;
import kd.bos.qing.util.QingFormUtil;
import kd.sdk.annotation.SdkPublic;

@SdkPublic
public class QingAnalysis
extends IFrame
implements IQingAnalysis,
IQingControl,
ICloseCallBack {
    private String QingDatasourcePlugin;

    @Override
    @SimplePropertyAttribute(name="QingDatasourcePlugin")
    public String getQingDatasourcePlugin() {
        return this.QingDatasourcePlugin;
    }

    public void setQingDatasourcePlugin(String qingDatasourcePlugin) {
        this.QingDatasourcePlugin = qingDatasourcePlugin;
    }

    public void bindData(BindingContext ctx) {
        super.bindData(ctx);
        this.setUrl(this.createSrcUrl());
    }

    private String createSrcUrl() {
        String sUrl = QingFormUtil.getQingURL("/qing/qingControlEntrance.do");
        sUrl = QingFormUtil.appendParamToUrl(sUrl, "pageId", this.view.getPageId());
        sUrl = QingFormUtil.appendParamToUrl(sUrl, "ctrKey", this.key);
        sUrl = QingFormUtil.appendParamToUrl(sUrl, "billFormId", this.getBillFormId());
        sUrl = QingFormUtil.appendParamToUrl(sUrl, "schemaAdditionalTag", this.getSchemaAdditionalTag(this.view.getPageId()));
        sUrl = QingFormUtil.appendParamToUrl(sUrl, "appId", this.getView().getFormShowParameter().getServiceAppId());
        return sUrl;
    }

    private String getBillFormId() {
        IFormView view = this.getView();
        FormShowParameter parameter = view.getFormShowParameter();
        return parameter.getFormId();
    }

    private String getSchemaAdditionalTag(String pageId) {
        IQingDataProvider provider = this.getQingDataProvider();
        if (provider != null) {
            return provider.getSchemaAdditionalTag(pageId);
        }
        return null;
    }

    @Override
    public QingMeta getQingColumns(String pageId) {
        IQingDataProvider provider = this.getQingDataProvider();
        if (provider != null) {
            return provider.getMeta(pageId);
        }
        return null;
    }

    @Override
    public List<QingLinkageInfo> getLinkageData(String pageId, String ctrKey) {
        IQingDataProvider provider = this.getQingDataProvider();
        if (provider != null) {
            List linkageInfos = provider.getLinkageInfo(pageId, ctrKey);
            this.clientViewProxy.addAction("linkageInfos", (Object)linkageInfos);
            return linkageInfos;
        }
        return null;
    }

    @Override
    public void fireLinkageInfo(List<String> ids, String pageId, String formId, String appId) {
        IQingDataProvider provider = this.getQingDataProvider();
        if (provider != null) {
            provider.fireLinkageInfo(ids, pageId, formId, appId);
        }
    }

    @Override
    public QingData getQingData(String pageId, int startRow, int limit) {
        IQingDataProvider provider = this.getQingDataProvider();
        if (provider != null) {
            return provider.getData(pageId, startRow, limit);
        }
        return null;
    }

    @Override
    public void setFilterParameter(String filterParameter) {
        IQingDataProvider provider = this.getQingDataProvider();
        if (provider != null) {
            provider.setFilterParameter(filterParameter);
        }
    }

    @Override
    public String getFilterParameter() {
        IQingDataProvider provider = this.getQingDataProvider();
        if (provider != null) {
            return provider.getFilterParameter();
        }
        return null;
    }

    @Override
    public void refresh() {
        IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        proxy.invokeControlMethod(this.getKey(), "refresh", new Object[0]);
    }

    public void setUrl(String url) {
        IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        proxy.preInvokeControlMethod(this.getKey(), "setUrl", new Object[]{url});
    }

    @Override
    public Template newTemplate(String pageId) {
        IQingDataProvider provider = this.getQingDataProvider();
        if (provider != null) {
            return provider.getDefaultTemplate(pageId);
        }
        return null;
    }

    private IQingDataProvider getQingDataProvider() {
        if (!StringUtils.isEmpty((CharSequence)this.getQingDatasourcePlugin())) {
            try {
                Object newInstance = Class.forName(this.getQingDatasourcePlugin()).newInstance();
                if (newInstance instanceof IFormPlugin) {
                    ((IFormPlugin)newInstance).setView(this.getView());
                }
                return (IQingDataProvider)newInstance;
            }
            catch (Exception e) {
                throw new KDException((Throwable)e, BosErrorCode.cannotLoadBeanClass, new Object[]{e.toString()});
            }
        }
        return null;
    }

    @Override
    public void openTab(String params) {
        QingFormUtil.openQingIFramePageInTab(params, this.view);
    }

    @Override
    public void linkageJump(String params) {
        QingFormUtil.linkageJump(params, this.view);
    }

    @Override
    public void closeTab() {
        QingFormUtil.closeTab(this.view);
    }

    @Override
    public void openUserForm(String params) {
        QingFormUtil.openUserForm(params, this.view, this.getKey());
    }

    @Override
    public void openRoleForm(String params) {
        QingFormUtil.openRoleForm(params, this.view, this.getKey());
    }

    @Override
    public void openAppMenuForm() {
        QingFormUtil.openAppMenuForm(this.getKey(), this.view);
    }

    @Override
    public void openAppChooseForm() {
        QingFormUtil.openAppChooseForm(this.getKey(), this.view);
    }

    @Override
    public void addCardToHomepage(String params) {
        QingFormUtil.addCardToHomepage(params, this.view);
    }

    public void closedCallBack(ClosedCallBackEvent e) {
    }

    @Override
    public void setTabDirtyStatus(String params) {
    }

    @Override
    public void sendEditPublishResult(String params) {
    }
}

