/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.operate;

import java.util.concurrent.TimeUnit;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeCacheHAPolicy;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.form.IFormView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public class DuplicateSubmitHelper {
    private static final Log log = LogFactory.getLog(DuplicateSubmitHelper.class);
    private static final int TIMEOUT_MINUTES = 60;
    private static final String CACHE_KEY_TEMP = "checkDuplicateSubmitKey_%s_%s";
    private static final String ERR_MSG_TEMP = "entityType %s with pageId %s duplicate submit.";
    private static DistributeSessionlessCache cache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache(null, new DistributeCacheHAPolicy(true, true));

    private static String getCacheKey(String entryType, String lockId) {
        return String.format(CACHE_KEY_TEMP, entryType, lockId);
    }

    public static boolean check(IFormView formView) {
        String instanceId;
        DynamicObject dynamicObject = formView.getModel().getDataEntity();
        String entityType = dynamicObject.getDataEntityType().getName();
        String cacheKey = DuplicateSubmitHelper.getCacheKey(entityType, instanceId = String.valueOf(dynamicObject.getDataEntityState().getInstanceId()));
        if (cache.inc(cacheKey, 60, TimeUnit.MINUTES) <= 1L) {
            return true;
        }
        log.info(String.format(ERR_MSG_TEMP, entityType, instanceId));
        return false;
    }

    public static void clean(IFormView formView) {
        DynamicObject dynamicObject = formView.getModel().getDataEntity();
        String entityType = dynamicObject.getDataEntityType().getName();
        String instanceId = String.valueOf(dynamicObject.getDataEntityState().getInstanceId());
        String cacheKey = DuplicateSubmitHelper.getCacheKey(entityType, instanceId);
        cache.remove(cacheKey);
    }
}

