/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.operate;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.Map;
import kd.bos.bill.BillOperationStatus;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeCacheHAPolicy;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.context.RequestContext;
import kd.bos.data.BusinessDataReader;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.TypesContainer;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.trace.EntityTraceHint;
import kd.bos.dataentity.trace.EntityTraceSpan;
import kd.bos.dataentity.trace.EntityTracer;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.IMobileView;
import kd.bos.form.IPageCache;
import kd.bos.form.container.Container;
import kd.bos.form.control.Control;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.operate.IFormMutexService;
import kd.bos.form.operate.MutexInfo;
import kd.bos.form.operate.MutexResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mservice.form.FormService;
import kd.bos.mservice.sysparam.SystemParamService;
import kd.bos.mutex.AutoReleaseLock;
import kd.bos.mutex.DataMutex;
import kd.bos.mutex.impl.MutexLockInfo;
import kd.bos.pushservice.WebSocketIdReader;
import kd.bos.service.ServiceFactory;
import kd.sdk.annotation.SdkPublic;

@SdkPublic
public class MutexHelper {
    private static final Log log = LogFactory.getLog(MutexHelper.class);
    public static final String ENTITY_KEY = "MUTEX_ENTITY_KEY";
    public static final String OPERATION_KEY = "MUTEX_OPER_KEY";
    public static final String OBJ_PKID = "MUTEX_OBJ_ID";
    public static final String HENTITY_ID = "HMUTEX_ENTITY_ID";
    public static final String HOBJ_PKID = "HMUTEX_OBJ_ID";
    public static final String HYPERLINK = "HYPERLINK";
    private static final String MUTEX_REQUIRE_ERROR = "MUTEX_REQUIRE_ERROR";
    private static final String BOS_FORM_CORE = "bos-form-core";
    public static final String INTENT_KEY = "INTENTKEY_";
    private static String mobLockTimeOutMinute = System.getProperty("mutex.locktimeout.mob", "30");
    public static final String MUTEX_CALL_SOURCE = "default";
    private static DistributeSessionlessCache cache = null;

    private MutexHelper() {
    }

    @Deprecated
    public static boolean require(IFormView view, String entityId, Object pkId, String opKey, StringBuilder errMsg) {
        return MutexHelper.require(view, entityId, pkId, opKey, false, errMsg);
    }

    @Deprecated
    public static boolean requireMutex4BillController(IFormView view, String entityId, Object pkId, String opKey, StringBuilder errMsg) {
        return MutexHelper.requireMutex4BillController(view, entityId, pkId, opKey, true, errMsg);
    }

    @Deprecated
    public static boolean requireMutex4BillController(IFormView view, String entityId, Object pkId, String opKey, boolean isStrict, StringBuilder errMsg) {
        MutexLockInfo lockInfo = new MutexLockInfo(String.valueOf(pkId), null, null, entityId, opKey, isStrict, MUTEX_CALL_SOURCE);
        if (view instanceof IMobileView) {
            lockInfo.setStrict(false);
            return MutexHelper.requireMutex(view, lockInfo, errMsg, true);
        }
        return MutexHelper.requireMutex(view, lockInfo, errMsg, true);
    }

    public static boolean requireMutex4BillController(IFormView view, MutexLockInfo lockInfo, StringBuilder errMsg) {
        if (view instanceof IMobileView) {
            lockInfo.setStrict(false);
            return MutexHelper.requireMutex(view, lockInfo, errMsg, true);
        }
        return MutexHelper.requireMutex(view, lockInfo, errMsg, true);
    }

    @Deprecated
    public static boolean require(IFormView view, String entityId, Object pkId, String opKey, boolean isStrict, StringBuilder errMsg) {
        MutexLockInfo lockInfo = new MutexLockInfo(String.valueOf(pkId), null, null, entityId, opKey, isStrict, MUTEX_CALL_SOURCE);
        return MutexHelper.requireMutex(view, lockInfo, errMsg, false);
    }

    public static boolean require(IFormView view, MutexLockInfo lockInfo, StringBuilder errMsg) {
        return MutexHelper.requireMutex(view, lockInfo, errMsg, false);
    }

    private static boolean requireMutex(IFormView view, MutexLockInfo lockInfo, StringBuilder errMsg, boolean formBillController) {
        MutexResult result = MutexHelper.getServiceBySafeModel(view).require(lockInfo.getEntityNumber(), (Object)lockInfo.getDataObjId(), lockInfo.getOperationKey(), lockInfo.isStrict());
        if (result.isSuccess()) {
            return true;
        }
        if (formBillController) {
            MutexHelper.recordFailTip(errMsg, result.getLockInfo());
        } else {
            MutexHelper.recordFailInfo(errMsg, result.getLockInfo());
        }
        return false;
    }

    private static void throwMutexCreateException(Exception e) {
        ErrorCode ec = new ErrorCode(MUTEX_REQUIRE_ERROR, String.format(ResManager.loadKDString((String)"\u7533\u8bf7\u4e92\u65a5\u9501\u51fa\u9519;err:%s", (String)"MutexHelper_0", (String)BOS_FORM_CORE, (Object[])new Object[0]), e.getMessage()));
        throw new KDException((Throwable)e, ec, new Object[0]);
    }

    @Deprecated
    public static boolean require(String entityId, Object pkId, String opKey, boolean isStrict, StringBuilder errMsg) {
        MutexLockInfo lockInfo = new MutexLockInfo(String.valueOf(pkId), null, null, entityId, opKey, isStrict, null);
        return MutexHelper.require(lockInfo, errMsg);
    }

    public static boolean require(MutexLockInfo lockInfo, StringBuilder errMsg) {
        boolean isSuccess;
        block18: {
            isSuccess = true;
            String mutexGroupId = MutexHelper.getMutexGroupId(lockInfo.getEntityNumber(), lockInfo.getOperationKey());
            if (StringUtils.isNotBlank((CharSequence)mutexGroupId)) {
                try (DataMutex dataMutex = DataMutex.create();){
                    lockInfo.setGroupId(mutexGroupId);
                    isSuccess = dataMutex.require(lockInfo);
                    if (isSuccess) break block18;
                    MutexInfo info = new MutexInfo();
                    Map lockedInfo = dataMutex.getLockInfo();
                    if (lockedInfo != null && !lockedInfo.isEmpty()) {
                        try {
                            info.setUserId(Long.parseLong((String)lockedInfo.get("userid")));
                        }
                        catch (NumberFormatException e) {
                            log.error(String.format("FormMutex_error, locked userId is %s", lockedInfo.get("userid")));
                        }
                        info.setSessionId((String)lockedInfo.get("GLOBALSESSION"));
                        info.setClient((String)lockedInfo.get("client"));
                    }
                    MutexHelper.recordFailInfo(errMsg, info);
                }
                catch (IOException e) {
                    MutexHelper.throwMutexCreateException(e);
                }
            }
        }
        return isSuccess;
    }

    @Deprecated
    public static boolean require(String entityId, Object pkId, String opKey, StringBuilder errMsg) {
        return MutexHelper.require(entityId, pkId, opKey, false, errMsg);
    }

    private static void recordFailInfo(StringBuilder errMsg, MutexInfo lockInfo) {
        if (errMsg == null) {
            return;
        }
        if (lockInfo != null && StringUtils.isNotBlank((CharSequence)lockInfo.getDataObjId())) {
            String userIdStr = String.valueOf(lockInfo.getUserId());
            String sessionId = lockInfo.getSessionId();
            String client = lockInfo.getClient();
            if (userIdStr != null) {
                MainEntityType dt = EntityMetadataCache.getDataEntityType((String)"bos_user");
                long userId = Long.parseLong(userIdStr);
                Map cacheUserObjs = BusinessDataReader.loadFromCache((Object[])new Object[]{userId}, (DynamicObjectType)dt);
                DynamicObject userObj = (DynamicObject)cacheUserObjs.get(userId);
                if (userObj != null) {
                    errMsg.append(userObj.getString("name")).append(" ");
                }
            }
            if (StringUtils.isNotBlank((CharSequence)client)) {
                errMsg.append(MutexHelper.getClientDescription(client));
            } else {
                errMsg.append(ResManager.loadKDString((String)"\u6b63\u5728\u7f16\u8f91\u8be5\u8bb0\u5f55", (String)"MutexHelper_1", (String)BOS_FORM_CORE, (Object[])new Object[0]));
            }
            if (StringUtils.equals((CharSequence)userIdStr, (CharSequence)RequestContext.get().getUserId())) {
                if (StringUtils.equals((CharSequence)"modify", (CharSequence)lockInfo.getOperationKey())) {
                    errMsg.append("\uff0c");
                    errMsg.append(ResManager.loadKDString((String)"\u8bf7\u7a0d\u540e\u518d\u8bd5\u6216\u5f3a\u5236\u8e22\u51fa\u53e6\u4e00\u4e2a\u767b\u5f55\u7528\u6237\u3002", (String)"MutexHelper_13", (String)BOS_FORM_CORE, (Object[])new Object[0]));
                } else {
                    errMsg.delete(0, errMsg.length());
                    errMsg.append(ResManager.loadKDString((String)"\u5f53\u524d\u5355\u636e\u5df2\u5728\u5176\u4ed6\u9875\u7b7e\u4e2d\u6253\u5f00\uff0c\u5982\u9700\u7ee7\u7eed\u64cd\u4f5c\uff0c\u8bf7\u5173\u95ed\u5355\u636e\u540e\u91cd\u8bd5\uff0c\u6216\u91cd\u65b0\u767b\u5f55\u540e\uff0c\u518d\u6b21\u5c1d\u8bd5\u3002", (String)"MutexHelper_14", (String)BOS_FORM_CORE, (Object[])new Object[0]));
                }
            } else {
                errMsg.append("\uff0c");
                errMsg.append(ResManager.loadKDString((String)"\u8bf7\u7a0d\u540e\u518d\u8bd5\u6216\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458\u3002", (String)"MutexHelper_2", (String)BOS_FORM_CORE, (Object[])new Object[0]));
            }
        } else {
            errMsg.append(ResManager.loadKDString((String)"\u8be5\u5bf9\u8c61\u88ab\u9501\u5b9a\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\uff0c\u6216\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458\u3002", (String)"MutexHelper_3", (String)BOS_FORM_CORE, (Object[])new Object[0]));
        }
    }

    private static void recordFailTip(StringBuilder errMsg, MutexInfo lockInfo) {
        if (errMsg == null) {
            return;
        }
        if (lockInfo != null) {
            String userIdStr = String.valueOf(lockInfo.getUserId());
            if (userIdStr != null) {
                MainEntityType dt = EntityMetadataCache.getDataEntityType((String)"bos_user");
                long userId = Long.parseLong(userIdStr);
                Map cacheUserObjs = BusinessDataReader.loadFromCache((Object[])new Object[]{userId}, (DynamicObjectType)dt);
                DynamicObject userObj = (DynamicObject)cacheUserObjs.get(userId);
                if (userObj != null) {
                    errMsg.append(userObj.getString("name")).append(" ");
                }
            }
            errMsg.append(ResManager.loadKDString((String)"\u6b63\u5728\u7f16\u8f91\u8be5\u8bb0\u5f55\uff0c\u5f53\u524d\u4ee5\u67e5\u770b\u65b9\u5f0f\u6253\u5f00\u3002", (String)"MutexHelper_5", (String)BOS_FORM_CORE, (Object[])new Object[0]));
        } else {
            errMsg.append(ResManager.loadKDString((String)"\u8be5\u5bf9\u8c61\u88ab\u9501\u5b9a\uff0c\u5f53\u524d\u4ee5\u67e5\u770b\u65b9\u5f0f\u6253\u5f00\u3002", (String)"MutexHelper_6", (String)BOS_FORM_CORE, (Object[])new Object[0]));
        }
    }

    public static boolean release(IFormView view) {
        return MutexHelper.getServiceBySafeModel(view).releaseMutex().isSuccess();
    }

    public static boolean release(String entityKey, String operKey, String objId) {
        boolean releaseRet = true;
        if (StringUtils.isNotBlank((CharSequence)entityKey) && StringUtils.isNotBlank((CharSequence)operKey) && StringUtils.isNotBlank((CharSequence)objId)) {
            try (DataMutex dataMutex = DataMutex.create();){
                releaseRet = dataMutex.release(objId, entityKey, operKey);
                String group = MutexHelper.getMutexGroupId(entityKey, operKey);
                if (StringUtils.isNotBlank((CharSequence)group)) {
                    MutexHelper.getCache().remove(MutexHelper.getPageRelationKey(entityKey, group, objId));
                }
            }
            catch (IOException e) {
                ErrorCode ec = new ErrorCode(MUTEX_REQUIRE_ERROR, String.format(ResManager.loadKDString((String)"\u91ca\u653e\u6570\u636e\u5bf9\u8c61[%1$s]\u4e92\u65a5\u9501\u51fa\u9519:%2$s\u3002", (String)"MutexHelper_8", (String)BOS_FORM_CORE, (Object[])new Object[0]), objId, e.getMessage()));
                throw new KDException((Throwable)e, ec, new Object[0]);
            }
        }
        return releaseRet;
    }

    public static String getMutexGroupId(String entityId, String opKey) {
        if ("refresh".equals(opKey)) {
            return "default_netctrl";
        }
        String netGroupId = null;
        Map netCtrlConf = EntityMetadataCache.getDataEntityNetCtrlOperate((String)entityId);
        if (netCtrlConf != null) {
            block0: for (Map.Entry entry : netCtrlConf.entrySet()) {
                List operList = (List)netCtrlConf.get(entry.getKey());
                for (Map oper : operList) {
                    String operKey = (String)oper.get("operationKey");
                    if (!operKey.equals(opKey)) continue;
                    netGroupId = (String)entry.getKey();
                    continue block0;
                }
            }
        }
        return netGroupId;
    }

    public static boolean enableReentrant4ListViewOp(String entityId, Object pkId, String opKey, String pageId) {
        RequestContext rs = RequestContext.get();
        Map info = null;
        try (DataMutex dataMutex = DataMutex.create();){
            info = dataMutex.getLockInfo(String.valueOf(pkId), MutexHelper.getMutexGroupId(entityId, opKey), entityId);
        }
        catch (IOException e) {
            MutexHelper.throwMutexCreateException(e);
        }
        if (info == null || info.isEmpty()) {
            return false;
        }
        String lockSessionId = (String)info.get("GLOBALSESSION");
        return rs.getGlobalSessionId().equals(lockSessionId);
    }

    public static boolean enableReentrant(String entityId, Object pkId, String opKey) {
        RequestContext rs = RequestContext.get();
        Map info = null;
        try (DataMutex dataMutex = DataMutex.create();){
            info = dataMutex.getLockInfo(String.valueOf(pkId), MutexHelper.getMutexGroupId(entityId, opKey), entityId);
        }
        catch (IOException e) {
            MutexHelper.throwMutexCreateException(e);
        }
        if (info == null || info.isEmpty()) {
            return true;
        }
        String lockUserId = (String)info.get("userid");
        String lockSessionId = (String)info.get("GLOBALSESSION");
        String lockClient = (String)info.get("client");
        if (!rs.getUserId().equals(lockUserId) || rs.getGlobalSessionId().equals(lockSessionId) || !rs.getClient().equals(lockClient)) {
            return false;
        }
        List wsList = WebSocketIdReader.getWebSocketIds((String)rs.getAccountId(), (String)lockSessionId);
        return wsList.isEmpty();
    }

    public static void clearErrLockByWebSocket(String entityId, Object pkId, String opKey) {
        Map info = null;
        try (DataMutex dataMutex = DataMutex.create();){
            String group = MutexHelper.getMutexGroupId(entityId, opKey);
            info = dataMutex.getLockInfo(String.valueOf(pkId), group, entityId);
            if (info == null || info.isEmpty()) {
                return;
            }
            String lockSessionId = (String)info.get("GLOBALSESSION");
            String lockUserId = (String)info.get("userid");
            String lockOpkeySetString = (String)info.get("opkey");
            if (!RequestContext.get().getUserId().equals(lockUserId)) {
                return;
            }
            List socketIds = WebSocketIdReader.getWebSocketIds((String)RequestContext.get().getAccountId(), (String)lockSessionId);
            if (!socketIds.isEmpty()) {
                return;
            }
            if (StringUtils.isNotBlank((CharSequence)lockOpkeySetString)) {
                String[] opKeyArr;
                for (String op : opKeyArr = StringUtils.split((String)lockOpkeySetString, (String)",")) {
                    dataMutex.release(String.valueOf(pkId), entityId, op);
                }
            }
            FormService formService = (FormService)ServiceFactory.getService(FormService.class);
            String pageId = (String)MutexHelper.getCache().get(MutexHelper.getPageRelationKey(entityId, group, pkId.toString()), opKey);
            if (pageId != null && pageId.length() > 0) {
                log.info("releaseRootPage: {}", (Object)pageId);
                formService.releaseRootPage(pageId, false);
            } else {
                log.info("sessionEnd: {}, userId: {}", (Object)lockSessionId, (Object)RequestContext.get().getCurrUserId());
                formService.sessionEnd(lockSessionId);
            }
            dataMutex.release(String.valueOf(pkId), entityId, opKey);
        }
        catch (IOException e) {
            MutexHelper.throwMutexCreateException(e);
        }
    }

    private static String getClientDescription(String clientType) {
        if ("web".equals(clientType)) {
            return ResManager.loadKDString((String)"\u6b63\u5728PC\u7aef\u7f16\u8f91\u8be5\u8bb0\u5f55", (String)"MutexHelper_10", (String)BOS_FORM_CORE, (Object[])new Object[0]);
        }
        if ("mobile".equals(clientType)) {
            return ResManager.loadKDString((String)"\u6b63\u5728\u79fb\u52a8\u7aef\u7f16\u8f91\u8be5\u8bb0\u5f55", (String)"MutexHelper_11", (String)BOS_FORM_CORE, (Object[])new Object[0]);
        }
        if ("batch".equals(clientType) || "MQ".equals(clientType)) {
            return ResManager.loadKDString((String)"\u6b63\u5728\u540e\u53f0\u4efb\u52a1\u7f16\u8f91\u8be5\u8bb0\u5f55", (String)"MutexHelper_12", (String)BOS_FORM_CORE, (Object[])new Object[0]);
        }
        return ResManager.loadKDString((String)"\u6b63\u5728PC\u7aef\u7f16\u8f91\u8be5\u8bb0\u5f55", (String)"MutexHelper_10", (String)BOS_FORM_CORE, (Object[])new Object[0]);
    }

    public static String requireIntent(IFormView view, String entityId, Object pkId, StringBuilder errMsg) {
        return MutexHelper.getServiceBySafeModel(view).requireIntent(entityId, pkId).getIntentKey();
    }

    private static IFormMutexService getServiceBySafeModel(IFormView view) {
        IFormMutexService service = (IFormMutexService)view.getService(IFormMutexService.class);
        if (service == null) {
            try {
                Class classType = TypesContainer.getOrRegister((String)"kd.bos.mvc.form.FormMutexService");
                Constructor constructor = classType.getConstructor(IFormView.class);
                service = (IFormMutexService)constructor.newInstance(view);
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                throw new KDException("IFormMutexService not register");
            }
        }
        return service;
    }

    public static boolean releaseIntent(IFormView view, String intentKey, StringBuilder errMsg) {
        return MutexHelper.getServiceBySafeModel(view).releaseIntent(intentKey).isSuccess();
    }

    public static boolean releaseAndApplyIntent(IFormView view, StringBuilder errMsg) {
        boolean releaseIntent = MutexHelper.releaseIntent(view, null, errMsg);
        IPageCache pageCache = (IPageCache)view.getService(IPageCache.class);
        String entityId = pageCache.get(HENTITY_ID);
        Object pkValue = view.getModel().getDataEntity().getPkValue();
        String requireIntent = null;
        if (StringUtils.isNotBlank((Object)pkValue)) {
            requireIntent = MutexHelper.requireIntent(view, entityId, String.valueOf(pkValue), new StringBuilder());
        }
        return releaseIntent && StringUtils.isNotBlank(requireIntent);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean checkIntent(IFormView view) {
        try (DataMutex dataMutex = DataMutex.create();){
            String entityId = view.getEntityId();
            Object pkValue = view.getModel().getDataEntity().getPkValue();
            String intentKey = view.getPageCache().get(INTENT_KEY + String.valueOf(pkValue));
            if (StringUtils.isBlank((CharSequence)intentKey)) {
                boolean bl = true;
                return bl;
            }
            if (StringUtils.isNotBlank((CharSequence)entityId) && StringUtils.isNotBlank((Object)pkValue) && StringUtils.isNotBlank((CharSequence)intentKey)) {
                boolean bl = dataMutex.checkIntentExist(entityId, String.valueOf(pkValue), intentKey);
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        catch (IOException e) {
            log.error("\u68c0\u67e5\u610f\u5411\u9501\u662f\u5426\u5b58\u5728\u51fa\u9519,error: %s", (Object)e.getMessage());
            return false;
        }
    }

    public static String getIntentKey(String entityKey, String timestamp) {
        StringBuilder intentKey = new StringBuilder();
        intentKey.append(entityKey).append("_").append(timestamp);
        return intentKey.toString();
    }

    public static void removeIntentCache(IFormView view) {
        IPageCache pageCache = (IPageCache)view.getService(IPageCache.class);
        pageCache.remove(HENTITY_ID);
        pageCache.remove(HOBJ_PKID);
        pageCache.remove(HYPERLINK);
        pageCache.remove(INTENT_KEY);
    }

    public static boolean isOpenIntentLocks() {
        boolean intentlocks = false;
        try {
            SystemParamService paramService = (SystemParamService)ServiceFactory.getService(SystemParamService.class);
            intentlocks = Boolean.TRUE.equals(paramService.loadPublicParameterFromCache("intentlocks"));
        }
        catch (Exception e) {
            log.error("invoke isOpenIntentLocks error: %s", (Object)e.getMessage());
        }
        return intentlocks;
    }

    private static DistributeSessionlessCache getCache() {
        if (cache != null) {
            return cache;
        }
        cache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("mutexHelper_pageRelation", new DistributeCacheHAPolicy(true, true));
        return cache;
    }

    private static String getPageRelationKey(String entityKey, String group, String objId) {
        String accountId = RequestContext.get().getAccountId();
        return accountId + "_mutex_lastlockpage_" + entityKey + "_" + group + "_" + objId;
    }

    public static void register(IFormView view, String mutexObjId, String mutexEntityKey, String mutexOperationKey) {
        String group = MutexHelper.getMutexGroupId(mutexEntityKey, mutexOperationKey);
        MutexHelper.register(view, mutexObjId, mutexEntityKey, mutexOperationKey, group);
    }

    private static void register(IFormView view, String mutexObjId, String mutexEntityKey, String mutexOperationKey, String group) {
        AutoReleaseLock.create().register(mutexObjId, mutexEntityKey, mutexOperationKey);
        if (StringUtils.isNotBlank((CharSequence)group)) {
            MutexHelper.getCache().put(MutexHelper.getPageRelationKey(mutexEntityKey, group, mutexObjId), mutexOperationKey, view.getPageId(), MutexHelper.getPageRelationTimeOut().intValue());
        }
    }

    private static Integer getPageRelationTimeOut() {
        return Integer.parseInt(System.getProperty("mutex.maxkeeptime_h", "8")) * 60 * 60;
    }

    public static boolean allFieldWithRequiredLock(IClientViewProxy clientViewProxy, List<Control> controls, BillOperationStatus lockType, MainEntityType mainType) {
        int lockValue;
        switch (lockType) {
            case SUBMIT: {
                lockValue = 16;
                break;
            }
            case AUDIT: {
                lockValue = 32;
                break;
            }
            default: {
                lockValue = -1;
            }
        }
        if (lockValue < 0) {
            return true;
        }
        Tuple<Boolean, String> lock = MutexHelper.verifyLock(clientViewProxy, controls, lockValue, mainType);
        if (EntityTracer.isRealtime()) {
            try (EntityTraceSpan span = EntityTracer.create((String)"Mutex", (String)"MutexHelper.allFieldWithRequiredLock", (EntityTraceHint)EntityTraceHint.getHintDisLinkAPM());){
                span.addLocaleTag("lockType", (Object)lockType);
                span.addLocaleTag("allLock", lock.item1);
                span.addLocaleTag("unlockField", lock.item2);
            }
        }
        return (Boolean)lock.item1;
    }

    @Deprecated
    public static boolean allFieldWithSubmitLock(IClientViewProxy clientViewProxy, List<Control> controls) {
        return MutexHelper.allFieldWithRequiredLock(clientViewProxy, controls, BillOperationStatus.SUBMIT, null);
    }

    private static Tuple<Boolean, String> verifyLock(IClientViewProxy clientViewProxy, List<Control> controls, int lockValue, MainEntityType mainType) {
        Tuple result = new Tuple((Object)true, null);
        for (Control ctl : controls) {
            if (ctl instanceof Container) {
                boolean isLocked = MutexHelper.isRequiredLock(ctl, clientViewProxy, lockValue);
                if (isLocked) continue;
                result = MutexHelper.verifyLock(clientViewProxy, ((Container)ctl).getItems(), lockValue, mainType);
            } else if (ctl instanceof FieldEdit) {
                IDataEntityProperty property;
                FieldEdit fieldEdit = (FieldEdit)ctl;
                if (mainType != null && ((property = mainType.findProperty(fieldEdit.getFieldKey())) == null || StringUtils.isBlank((CharSequence)property.getAlias()))) continue;
                boolean isLocked = MutexHelper.isRequiredLock(ctl, clientViewProxy, lockValue);
                result = new Tuple((Object)isLocked, (Object)ctl.getKey());
            }
            if (((Boolean)result.item1).booleanValue()) continue;
            return result;
        }
        return result;
    }

    private static boolean isRequiredLock(Control ctl, IClientViewProxy clientViewProxy, int lockValue) {
        if (ctl == null) {
            return true;
        }
        boolean result = true;
        Integer lock = ctl.getLockIntegerVal();
        if (!ObjectUtils.isEmpty((Object)lock)) {
            boolean bl = result = (lock & lockValue) == lockValue;
            if (result) {
                return true;
            }
        }
        Map controlMetaState = null;
        if (clientViewProxy != null) {
            controlMetaState = clientViewProxy.getControlMetaState(ctl.getKey());
        }
        if (controlMetaState != null && controlMetaState.containsKey("l")) {
            boolean bl = result = ((Integer)controlMetaState.get("l") & lockValue) == lockValue;
            if (result) {
                return true;
            }
        }
        if (controlMetaState != null && controlMetaState.containsKey("lockControl")) {
            result = (Boolean)controlMetaState.get("lockControl") == false;
        }
        return result;
    }
}

