/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.plugin;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.DcJsonSerializer;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.property.GroupProp;
import kd.bos.entity.property.ParentBasedataProp;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.FormConfig;
import kd.bos.form.FormMetadataCache;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IPageCache;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.list.MobileListShowParameter;
import kd.bos.list.MobileTreeList;
import kd.bos.list.MulBdPermUtil;
import kd.bos.list.events.BackPressedEvent;
import kd.bos.list.events.EndSelectEvent;
import kd.bos.list.events.ItemSelectEvent;
import kd.bos.list.events.ListSelectedListener;
import kd.bos.list.events.SelectEvent;
import kd.bos.list.query.PageRowCacheUtils;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.parameter.MobileListParam;
import kd.bos.util.CollectionUtils;
import kd.bos.utils.DbTypeConverter;
import kd.sdk.annotation.SdkPublic;

@SdkPublic
public class MobileTreeListPlugin
extends AbstractFormPlugin
implements ListSelectedListener {
    private static final String ROOT_ID = "0";
    public static final String MOBILE_TREE_LIST = "mobiletreelist";
    private static final String MOBILETREELISTAP = "mobiletreelistap";
    private static final String CHILDREN = "children";
    private static final String ENABLE = "enable";
    private static final String PAGE_INDEX = "pageIndex";
    private static final String KD_BOS_FORM_PLUGIN_MOBILE_TREE_LIST_PLUGIN = "kd.bos.form.plugin.MobileTreeListPlugin";

    public void initialize() {
        MobileTreeList mobiletreeList = (MobileTreeList)this.getControl(MOBILETREELISTAP);
        String mobileListParamStr = (String)this.getView().getFormShowParameter().getCustomParam("mobileListParam");
        if (mobileListParamStr != null) {
            MobileListParam mobileListParam = this.getMobileListParam(mobileListParamStr);
            ListShowParameter listShowParameter = mobileListParam.getListShowParameter();
            if (listShowParameter != null) {
                mobiletreeList.setMulti(listShowParameter.isMultiSelect());
                mobiletreeList.setBillFormId(listShowParameter.getBillFormId());
                mobiletreeList.setListShowParameter(listShowParameter);
            }
            mobiletreeList.setPrimaryField(mobileListParam.getPrimaryField());
            mobiletreeList.setShowFrequent(mobileListParam.isShowFrequent());
            int pageRow = mobileListParam.getPageRow() == 0 ? 20 : mobileListParam.getPageRow();
            mobiletreeList.setPageRow(pageRow);
        }
        super.initialize();
    }

    public void registerListener(EventObject e) {
        MobileTreeList mobiletreeList = (MobileTreeList)this.getControl(MOBILETREELISTAP);
        mobiletreeList.addListSelectedListener(this);
        super.registerListener(e);
    }

    private MobileListParam getMobileListParam(String serializeString) {
        ArrayList<IDataEntityType> dataEntityTypes = new ArrayList<IDataEntityType>();
        dataEntityTypes.add(OrmUtils.getDataEntityType(ListShowParameter.class));
        dataEntityTypes.add(OrmUtils.getDataEntityType(MobileListShowParameter.class));
        dataEntityTypes.add(OrmUtils.getDataEntityType(ListSelectedRowCollection.class));
        dataEntityTypes.add(OrmUtils.getDataEntityType(ListSelectedRow.class));
        dataEntityTypes.add(OrmUtils.getDataEntityType(MobileListParam.class));
        DcJsonSerializer dcJsonSerializer = new DcJsonSerializer(dataEntityTypes);
        return (MobileListParam)dcJsonSerializer.deserializeFromString(serializeString, null);
    }

    @Override
    public void endSelect(EndSelectEvent event) {
        this.getView().returnDataToParent(event.getData());
        this.getView().close();
    }

    public Map<String, Object> packageData(Map<String, Object> map, boolean isContainConfig, boolean isNeedParent) {
        MobileTreeList mobiletreeList = (MobileTreeList)this.getControl(MOBILETREELISTAP);
        List children = (List)map.get(CHILDREN);
        if (CollectionUtils.isNotEmpty((Collection)children)) {
            List childrenCollect = children.stream().filter(x -> !x.isCheckable() && x.isLeaf()).collect(Collectors.toList());
            children.removeAll(childrenCollect);
        }
        TreeNode parentNode = (TreeNode)map.get("parentNode");
        HashMap<String, Object> listData = new HashMap<String, Object>();
        PageRowCacheUtils.clearPageRowcache((String)this.getView().getPageId(), (String)mobiletreeList.getKey());
        if (children == null) {
            return new HashMap<String, Object>();
        }
        List<Map<String, Object>> childrenDatas = this.getRowDatas(children, null);
        if (parentNode != null && isNeedParent) {
            HashMap<String, Object> data = new HashMap<String, Object>();
            data.put("id", parentNode.getId());
            data.put("mt", parentNode.getText());
            data.put("hp", !"".equals(parentNode.getParentid()));
            data.put("hc", !parentNode.isLeaf());
            data.put("ca", parentNode.isCheckable());
            data.put(CHILDREN, childrenDatas);
            listData.put("data", data);
        } else {
            listData.put("data", childrenDatas);
        }
        int pageIndex = Integer.parseInt(map.get(PAGE_INDEX).toString());
        int dataCount = Integer.parseInt(map.get("total").toString());
        IPageCache cache = (IPageCache)this.getView().getService(IPageCache.class);
        int first_pagerow = 0;
        if (cache.get(this.getView().getPageId() + mobiletreeList.getFirstPageKey()) != null) {
            first_pagerow = Integer.parseInt(cache.get(this.getView().getPageId() + mobiletreeList.getFirstPageKey()));
        }
        listData.put("hasMore", first_pagerow + (pageIndex - 1) * mobiletreeList.getPageRow() < dataCount);
        listData.put(PAGE_INDEX, pageIndex);
        if (isContainConfig) {
            HashMap<String, Object> configMap = new HashMap<String, Object>();
            ArrayList<Object> pkIds = new ArrayList<Object>();
            for (ListSelectedRow listSelectedRow : mobiletreeList.getListShowParameter().getListSelectedRowCollection()) {
                pkIds.add(listSelectedRow.getPrimaryKeyValue());
            }
            this.getView().getFormShowParameter().setCustomParam("originFieldKey", mobiletreeList.getListShowParameter().getCustomParam("originFieldKey"));
            String parentFormId = this.getView().getFormShowParameter().getParentFormId();
            if (parentFormId.endsWith("_mob")) {
                FormConfig mobileConfig = FormMetadataCache.getFormConfig((String)parentFormId);
                parentFormId = mobileConfig.getEntityTypeId();
            }
            this.getView().getFormShowParameter().setCustomParam("originUseOrg", (Object)mobiletreeList.getListShowParameter().getUseOrgId());
            this.getView().getFormShowParameter().setCustomParam("originFormId", (Object)parentFormId);
            MulBdPermUtil.setAuthorizedData(this.getView(), mobiletreeList.getKey(), pkIds);
            configMap.put("isMust", mobiletreeList.getListShowParameter().isMustInput());
            configMap.put("isMulti", mobiletreeList.isMulti());
            configMap.put("title", new LocaleString(this.getView().getFormShowParameter().getCaption()));
            Map<String, Object> selectData = this.getChildrenTreeNode(new QFilter(mobiletreeList.getEntityType().getPrimaryKey().getName(), "in", pkIds), 0, mobiletreeList.getListShowParameter().getListSelectedRowCollection().size(), null, mobiletreeList.isOnlySelectLeaf(), true);
            configMap.put("selected", this.getRowDatas((List)selectData.get(CHILDREN), pkIds));
            configMap.put("onlyEndNode", mobiletreeList.isOnlySelectLeaf());
            configMap.put("sft", mobiletreeList.isShowFrequent());
            listData.put("config", configMap);
        }
        return listData;
    }

    private List<Map<String, Object>> getRowDatas(List<TreeNode> children, List<Object> pkIds) {
        ArrayList<Map<String, Object>> rowdatas = new ArrayList<Map<String, Object>>(10);
        if (children == null) {
            return rowdatas;
        }
        if (pkIds != null && !pkIds.isEmpty()) {
            Map treeNodeMap = children.stream().collect(Collectors.toMap(TreeNode::getId, Function.identity()));
            for (Object pkId : pkIds) {
                this.addRowData(rowdatas, (TreeNode)treeNodeMap.get(pkId.toString()));
            }
        } else {
            for (TreeNode node : children) {
                this.addRowData(rowdatas, node);
            }
        }
        return rowdatas;
    }

    private void addRowData(List<Map<String, Object>> rowdatas, TreeNode node) {
        if (node == null) {
            return;
        }
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("id", node.getId());
        data.put("mt", node.getText());
        data.put("hp", !"".equals(node.getParentid()));
        data.put("hc", !node.isLeaf());
        data.put("ca", node.isCheckable());
        rowdatas.add(data);
    }

    private TreeNode getTreeNodeById(String currentid) {
        ORM orm = ORM.create();
        TreeNode node = null;
        String selectFields = "id,name,parent";
        MobileTreeList mobiletreeList = (MobileTreeList)this.getControl(MOBILETREELISTAP);
        BasedataEntityType entityType = (BasedataEntityType)mobiletreeList.getEntityType();
        ArrayList<QFilter> qfilters = new ArrayList<QFilter>();
        int dbType = entityType.getPrimaryKey().getDbType();
        QFilter idfilter = new QFilter("id", "=", DbTypeConverter.safeConvert((int)dbType, (Object)currentid));
        qfilters.add(idfilter);
        try (DataSet ds = orm.queryDataSet(KD_BOS_FORM_PLUGIN_MOBILE_TREE_LIST_PLUGIN, entityType.getName(), selectFields, qfilters.toArray(new QFilter[qfilters.size()]));){
            for (Row row : ds) {
                node = new TreeNode();
                node.setId(row.getString(0));
                String name = row.getString(1);
                node.setText(name);
                node.setParentid(row.getString(2));
            }
            ds.close();
            Iterator iterator = node;
            return iterator;
        }
    }

    public List<QFilter> getOtherFilters() {
        return null;
    }

    public Map<String, Object> getChildrenTreeNode(QFilter qFilter, int start, int limit, String currentid, boolean isOnlySelectLeaf, boolean isFromSelected) {
        DynamicProperty statusProp;
        MobileTreeList mobiletreeList = (MobileTreeList)this.getControl(MOBILETREELISTAP);
        HashMap<String, Object> map = new HashMap<String, Object>();
        ArrayList<TreeNode> children = new ArrayList<TreeNode>();
        TreeNode parentNode = null;
        BasedataEntityType entityType = (BasedataEntityType)mobiletreeList.getEntityType();
        DataEntityPropertyCollection properties = entityType.getProperties();
        GroupProp group = null;
        List<Object> qfilters = new ArrayList<QFilter>();
        List<QFilter> otherFilters = this.getOtherFilters();
        if (otherFilters != null && !isFromSelected) {
            qfilters.addAll(otherFilters);
        }
        if (qFilter != null) {
            qfilters.add(qFilter);
        }
        if (currentid != null && !isFromSelected) {
            int dbType = entityType.getPrimaryKey().getDbType();
            Object currentIdConvert = DbTypeConverter.safeConvert((int)dbType, (Object)currentid);
            QFilter parentfilter = new QFilter("parent", "=", currentIdConvert);
            if (StringUtils.equals((CharSequence)ROOT_ID, (CharSequence)currentid) && 12 == dbType || -9 == dbType || 1 == dbType) {
                parentfilter.or(new QFilter("parent", "=", (Object)Character.valueOf(' ')));
            }
            parentfilter.or(new QFilter("id", "=", currentIdConvert));
            qfilters.add(parentfilter);
        }
        for (IDataEntityProperty prop : properties) {
            if (!(prop instanceof ParentBasedataProp)) continue;
            group = (GroupProp)prop;
            break;
        }
        if (group == null) {
            return map;
        }
        if (!isFromSelected) {
            qfilters.addAll(mobiletreeList.getListShowParameter().getListFilterParameter().getQFilters());
        }
        DynamicProperty dynamicProperty = statusProp = StringUtils.isNotBlank((CharSequence)entityType.getBillStatus()) ? entityType.getProperty(entityType.getBillStatus()) : null;
        if (statusProp != null) {
            qfilters = qfilters.stream().filter(arg_0 -> MobileTreeListPlugin.lambda$getChildrenTreeNode$1((IDataEntityProperty)statusProp, arg_0)).collect(Collectors.toList());
            qfilters.add(new QFilter(statusProp.getName(), "=", (Object)"C"));
        } else {
            qfilters = qfilters.stream().filter(f -> !ENABLE.equals(f.getProperty())).collect(Collectors.toList());
        }
        qfilters.add(new QFilter(ENABLE, "=", (Object)"1"));
        ORM orm = ORM.create();
        String selectFields = "id, name, parent, longnumber, isleaf";
        String orderBy = "longnumber desc";
        ArrayList<Object> tempFilters = new ArrayList<Object>(qfilters.size());
        tempFilters.addAll(qfilters);
        tempFilters.removeAll(mobiletreeList.getListShowParameter().getListFilterParameter().getQFilters());
        ArrayList<String> tempList = new ArrayList<String>(10);
        HashMap<String, TreeNode> tempMap = new HashMap<String, TreeNode>(16);
        try (DataSet ds = orm.queryDataSet(KD_BOS_FORM_PLUGIN_MOBILE_TREE_LIST_PLUGIN, entityType.getName(), selectFields, qfilters.toArray(new QFilter[qfilters.size()]), orderBy, start, limit);
             DataSet tempDataSet = orm.queryDataSet(KD_BOS_FORM_PLUGIN_MOBILE_TREE_LIST_PLUGIN, entityType.getName(), selectFields, tempFilters.toArray(new QFilter[tempFilters.size()]), orderBy, start, limit);){
            TreeNode node;
            for (Row row : tempDataSet) {
                node = new TreeNode();
                node.setId(row.getString(0));
                String name = row.getString(1);
                node.setText(name);
                node.setParentid(row.getString(2));
                node.setLongNumber(row.getString(3));
                node.setLeaf(row.getBoolean(4).booleanValue());
                node.setCheckable(this.isNodeCkeckable(node));
                tempMap.put(row.getString(0), node);
            }
            for (Row row : ds) {
                tempList.add(row.getString(0));
            }
            for (Map.Entry entry : tempMap.entrySet()) {
                node = (TreeNode)entry.getValue();
                if (!tempList.contains(entry.getKey())) {
                    node.setCheckable(false);
                }
                if (currentid != null && currentid.equals(node.getId())) {
                    parentNode = node;
                    continue;
                }
                children.add(node);
            }
            if (parentNode == null && ROOT_ID.equals(currentid)) {
                parentNode = new TreeNode();
                parentNode.setId(ROOT_ID);
                parentNode.setText(ResManager.loadKDString((String)"\u5168\u90e8", (String)"MobileTreeListPlugin_0", (String)"bos-form-core", (Object[])new Object[0]));
                parentNode.setParentid("");
                parentNode.setLongNumber("");
                parentNode.setCheckable(false);
                parentNode.setLeaf(false);
            }
        }
        int total = orm.count(KD_BOS_FORM_PLUGIN_MOBILE_TREE_LIST_PLUGIN, entityType.getName(), qfilters.toArray(new QFilter[qfilters.size()]));
        map.put(PAGE_INDEX, start / mobiletreeList.getPageRow() + 1);
        if (start > 0) {
            IPageCache cache = (IPageCache)this.getView().getService(IPageCache.class);
            int first_pagerow = 0;
            if (cache.get(this.getView().getPageId() + mobiletreeList.getFirstPageKey()) != null) {
                first_pagerow = Integer.parseInt(cache.get(this.getView().getPageId() + mobiletreeList.getFirstPageKey()));
            }
            map.put(PAGE_INDEX, (start - first_pagerow) / mobiletreeList.getPageRow() + 2);
        }
        map.put("total", total);
        map.put(CHILDREN, children);
        if (parentNode != null) {
            map.put("parentNode", parentNode);
        }
        return map;
    }

    public Map<String, Object> getChildrenTreeNode(QFilter qFilter, int start, int limit, String currentid, boolean isOnlySelectLeaf) {
        return this.getChildrenTreeNode(qFilter, start, limit, currentid, isOnlySelectLeaf, false);
    }

    public boolean isNodeCkeckable(TreeNode node) {
        return true;
    }

    @Override
    public void itemSelect(ItemSelectEvent event) {
        String currentid = ROOT_ID;
        if (StringUtils.isNotBlank((Object)event.getData())) {
            currentid = event.getData().toString();
        }
        this.setPageData(currentid);
    }

    @Override
    public void backPressed(BackPressedEvent event) {
        if (StringUtils.isBlank((Object)event.getData())) {
            this.getView().close();
            return;
        }
        String currentId = event.getData().toString();
        if (ROOT_ID.equals(currentId)) {
            this.getView().close();
            return;
        }
        TreeNode node = this.getTreeNodeById(currentId);
        if (node == null) {
            this.getView().close();
            return;
        }
        this.setPageData(node.getParentid());
    }

    @Override
    public void select(SelectEvent event) {
        String currentId = ROOT_ID;
        if (StringUtils.isNotBlank((Object)event.getData())) {
            currentId = event.getData().toString();
        }
        this.setPageData(currentId);
    }

    private void setPageData(String currentid) {
        MobileTreeList mobiletreeList = (MobileTreeList)this.getControl(MOBILETREELISTAP);
        int pagesize = mobiletreeList.getPageRow() > mobiletreeList.getBaseTotal() ? mobiletreeList.getPageRow() : mobiletreeList.getBaseTotal();
        IPageCache cache = (IPageCache)this.getView().getService(IPageCache.class);
        cache.put(this.getView().getPageId() + mobiletreeList.getFirstPageKey(), String.valueOf(pagesize));
        Map<String, Object> dataMap = this.packageData(this.getChildrenTreeNode(null, 0, pagesize, currentid, mobiletreeList.isOnlySelectLeaf()), false, true);
        IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        proxy.invokeControlMethod(mobiletreeList.getKey(), "setPageData", new Object[]{dataMap});
    }

    private static /* synthetic */ boolean lambda$getChildrenTreeNode$1(IDataEntityProperty statusProp, QFilter f) {
        return !ENABLE.equals(f.getProperty()) && !statusProp.getName().equals(f.getProperty());
    }
}

