/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.list;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DefaultValueAttribute;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.entity.SimplePropertyAttribute;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.ApproverListField;
import kd.bos.entity.datamodel.ListField;
import kd.bos.list.AbstractListColumn;
import kd.bos.list.ListColumnCompareServiceHelper;
import kd.bos.list.ListColumnCompareType;
import kd.bos.list.column.ListColumnComboItem;
import kd.bos.list.column.ListColumnCompare;
import kd.bos.list.column.ListColumnCompares;
import kd.bos.list.column.ListColumnMeta;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.api.FieldControlRule;

public class ApproverListColumn
extends AbstractListColumn {
    private LocaleString approverColumnName;
    private static final String LIST_FIELD_KEY = "listFieldKey";
    private boolean columnFilter = false;

    @SimplePropertyAttribute
    public LocaleString getApproverColumnName() {
        return this.approverColumnName;
    }

    public void setApproverColumnName(LocaleString approverColumnName) {
        this.approverColumnName = approverColumnName;
    }

    @SimplePropertyAttribute(name="ColumnFilter")
    @DefaultValueAttribute(value="false")
    public boolean isColumnFilter() {
        return this.columnFilter;
    }

    public void setColumnFilter(boolean columnFilter) {
        this.columnFilter = columnFilter;
    }

    public void addFieldSet(Map<String, ListField> fieldSet, EntityType entityType, boolean withoutDetailEntry, boolean isListShowParameter, boolean isLookUp) {
        ApproverListField approverListField = new ApproverListField(this.getFieldKey());
        if (StringUtils.isBlank((CharSequence)this.getEntityName())) {
            this.setHeaderField(true);
            this.setEntityName(entityType.getName());
        }
        approverListField.setEntityName(this.getEntityName());
        fieldSet.put(this.getKey(), (ListField)approverListField);
    }

    public Map<String, Object> createColumn(MainEntityType entityType) {
        Map column = super.createColumn(entityType);
        column.put("ln", true);
        column.put("sort", false);
        column.put("filter", this.isColumnFilter());
        if (this.isColumnFilter()) {
            column.put("isBaseData", true);
            this.setColumnCompareOperators(column);
        }
        return column;
    }

    private void setColumnCompareOperators(Map<String, Object> column) {
        ListColumnCompares listColumnCompares = ListColumnCompareServiceHelper.getListColumnCompares(ListColumnMeta.ApproverListColumn);
        if (listColumnCompares != null && !CollectionUtils.isEmpty(listColumnCompares.getColumnComboItems())) {
            ArrayList<ListColumnCompareType> listColumnCompareTypes = new ArrayList<ListColumnCompareType>(listColumnCompares.getColumnComboItems().size());
            for (ListColumnComboItem columnComboItem : listColumnCompares.getColumnComboItems()) {
                ListColumnCompare listColumnCompare = (ListColumnCompare)columnComboItem;
                listColumnCompareTypes.add(new ListColumnCompareType(listColumnCompare.getId(), listColumnCompare.getName(), listColumnCompare.getValue(), listColumnCompare.getInputCtlType()));
            }
            column.put("filterItems", listColumnCompareTypes);
        }
    }

    public LocaleString getCaption() {
        return this.getApproverColumnName();
    }

    protected String getFieldKey() {
        return this.key;
    }

    public String getListFieldKey() {
        return this.getFieldKey();
    }

    public Map<String, Object> getListColumnConfigMap(MainEntityType entityType) {
        Map listColumnConfigMap = super.getListColumnConfigMap(entityType);
        listColumnConfigMap.put(LIST_FIELD_KEY, this.getFieldKey());
        return listColumnConfigMap;
    }

    public boolean isCanNotRead(FieldControlRule fieldControlRule) {
        return false;
    }

    public List<Map<String, Object>> getSortSetting(MainEntityType entityType) {
        return new ArrayList<Map<String, Object>>(0);
    }
}

